/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXConverter {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;

    public SAXConverter(ContentHandler contentHandler) {
        this.setContentHandler(contentHandler);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException("ContentHandler must be non-null.");
        }
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void convert(Document document) throws SAXException {
        this.contentHandler.startDocument();
        for (int i = 0; i < document.getChildCount(); ++i) {
            this.process(document.getChild(i));
        }
        this.contentHandler.endDocument();
    }

    private void process(Node node) throws SAXException {
        if (node instanceof Element) {
            this.convertElement((Element)node);
        } else if (node instanceof Text) {
            String string = node.getValue();
            this.contentHandler.characters(string.toCharArray(), 0, string.length());
        } else if (node instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            this.contentHandler.processingInstruction(processingInstruction.getTarget(), processingInstruction.getValue());
        } else if (node instanceof Comment && this.lexicalHandler != null) {
            String string = node.getValue();
            this.lexicalHandler.comment(string.toCharArray(), 0, string.length());
        } else if (node instanceof DocType && this.lexicalHandler != null) {
            DocType docType = (DocType)node;
            this.lexicalHandler.startDTD(docType.getRootElementName(), docType.getPublicID(), docType.getSystemID());
            this.lexicalHandler.endDTD();
        }
    }

    private void convertElement(Element element) throws SAXException {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            object3 = element.getNamespacePrefix(i);
            this.contentHandler.startPrefixMapping((String)object3, element.getNamespaceURI((String)object3));
        }
        ParentNode parentNode = element.getParent();
        if (parentNode instanceof Element) {
            object3 = (Element)parentNode;
            String string = element.getNamespacePrefix();
            if (!element.getNamespaceURI(string).equals(((Element)object3).getNamespaceURI(string))) {
                this.contentHandler.startPrefixMapping(string, element.getNamespaceURI(string));
            }
            for (n2 = 0; n2 < element.getAttributeCount(); ++n2) {
                object2 = element.getAttribute(n2);
                object = ((Attribute)object2).getNamespacePrefix();
                if (element.getNamespaceURI((String)object).equals(((Element)object3).getNamespaceURI((String)object)) || element.getNamespacePrefix().equals(object)) continue;
                this.contentHandler.startPrefixMapping((String)object, element.getNamespaceURI((String)object));
            }
        } else {
            object3 = element.getNamespacePrefix();
            if (!((String)object3).equals("")) {
                this.contentHandler.startPrefixMapping((String)object3, element.getNamespaceURI());
            }
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                Attribute attribute = element.getAttribute(i);
                object2 = attribute.getNamespacePrefix();
                if (((String)object2).equals("") || ((String)object2).equals(element.getNamespacePrefix())) continue;
                this.contentHandler.startPrefixMapping((String)object2, attribute.getNamespaceURI());
            }
        }
        object3 = new AttributesImpl();
        for (n = 0; n < element.getAttributeCount(); ++n) {
            Attribute attribute = element.getAttribute(n);
            ((AttributesImpl)object3).addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getQualifiedName(), SAXConverter.getSAXType(attribute), attribute.getValue());
        }
        this.contentHandler.startElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName(), (Attributes)object3);
        for (n = 0; n < element.getChildCount(); ++n) {
            this.process(element.getChild(n));
        }
        this.contentHandler.endElement(element.getNamespaceURI(), element.getLocalName(), element.getQualifiedName());
        for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
            String string = element.getNamespacePrefix(n);
            this.contentHandler.endPrefixMapping(string);
        }
        if (parentNode instanceof Element) {
            Element element2 = (Element)parentNode;
            String string = element.getNamespacePrefix();
            if (!element.getNamespaceURI(string).equals(element2.getNamespaceURI(string))) {
                this.contentHandler.endPrefixMapping(string);
            }
            for (int i = 0; i < element.getAttributeCount(); ++i) {
                object = element.getAttribute(i);
                String string2 = ((Attribute)object).getNamespacePrefix();
                if (element.getNamespaceURI(string2).equals(element2.getNamespaceURI(string2)) || element.getNamespacePrefix().equals(string2)) continue;
                this.contentHandler.endPrefixMapping(string2);
            }
        } else {
            String string = element.getNamespacePrefix();
            if (!string.equals("")) {
                this.contentHandler.endPrefixMapping(string);
            }
            for (n2 = 0; n2 < element.getAttributeCount(); ++n2) {
                object2 = element.getAttribute(n2);
                object = ((Attribute)object2).getNamespacePrefix();
                if (((String)object).equals("") || ((String)object).equals(element.getNamespacePrefix())) continue;
                this.contentHandler.endPrefixMapping((String)object);
            }
        }
    }

    private static String getSAXType(Attribute attribute) {
        Attribute.Type type = attribute.getType();
        if (type.equals(Attribute.Type.UNDECLARED)) {
            return "CDATA";
        }
        if (type.equals(Attribute.Type.CDATA)) {
            return "CDATA";
        }
        if (type.equals(Attribute.Type.ID)) {
            return "ID";
        }
        if (type.equals(Attribute.Type.IDREF)) {
            return "IDREF";
        }
        if (type.equals(Attribute.Type.IDREFS)) {
            return "IDREFS";
        }
        if (type.equals(Attribute.Type.NMTOKEN)) {
            return "NMTOKEN";
        }
        if (type.equals(Attribute.Type.NMTOKENS)) {
            return "NMTOKENS";
        }
        if (type.equals(Attribute.Type.ENTITY)) {
            return "ENTITY";
        }
        if (type.equals(Attribute.Type.ENTITIES)) {
            return "ENTITIES";
        }
        if (type.equals(Attribute.Type.NOTATION)) {
            return "NOTATION";
        }
        return "NMTOKEN";
    }
}

