/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.model;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import conector.eurobits.efactura.desktop.model.Settings;
import conector.eurobits.efactura.desktop.model.SettingsFactory;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.LookAndFeel;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class VisualSettings {
    private static VisualSettings visualSettings = null;
    private PlasticTheme selectedTheme = new DesertBlue();
    private Dimension windowSize = new Dimension(730, 560);
    private LookAndFeel selectedLookAndFeel = new Plastic3DLookAndFeel();
    protected String logo = SettingsFactory.BASIC_LOGO;
    private boolean useNarrowButtons = true;
    private boolean tabIconsEnabled = true;
    private String plasticTabStyle = "default";
    private boolean plasticHighContrastFocusEnabled = true;
    private Boolean popupDropShadowEnabled = null;
    private HeaderStyle menuBarHeaderStyle = null;
    private BorderStyle menuBarPlasticBorderStyle = null;
    private BorderStyle menuBarWindowsBorderStyle = null;
    private Boolean menuBar3DHint = null;
    private HeaderStyle toolBarHeaderStyle = null;
    private BorderStyle toolBarPlasticBorderStyle = null;
    private BorderStyle toolBarWindowsBorderStyle = null;
    private Boolean toolBar3DHint = null;

    public VisualSettings() {
        Settings.getSettings();
    }

    public VisualSettings(File input) throws DocumentException {
        Settings.getSettings();
        this.load(input);
    }

    public static VisualSettings getVisualSettings() {
        if (visualSettings == null) {
            visualSettings = new VisualSettings();
        }
        return visualSettings;
    }

    public static Settings getSettings() {
        if (visualSettings == null) {
            visualSettings = new VisualSettings();
        }
        return Settings.getSettings();
    }

    public File getConfigFile() {
        return Settings.getSettings().getConfigFile();
    }

    public File getApplicationInitConfigFile() {
        return Settings.getSettings().getApplicationInitConfigFile();
    }

    public void load(File applicationConfigFile) throws DocumentException {
        Settings settings = Settings.getSettings();
        Settings.getSettings().loadApplicationInitConfig();
        File configFile = Settings.getSettings().getConfigFile();
        Settings.getSettings().load();
        SAXReader reader = new SAXReader();
        Document document = null;
        document = configFile.getPath().indexOf("!") != -1 || !configFile.exists() ? reader.read(Settings.class.getResourceAsStream("/conector/eurobits/efactura/desktop/view/resources/config.xml")) : reader.read(configFile);
        Element root = document.getRootElement();
        Element swing = root.element("swing");
        if (swing != null) {
            Class<?> _class;
            Element item = swing.element("lookAndFeel");
            if (item != null && swing.getText() != null) {
                String lookAndFeelClass = item.getTextTrim();
                try {
                    _class = Class.forName(lookAndFeelClass);
                    this.selectedLookAndFeel = (LookAndFeel)_class.newInstance();
                }
                catch (Throwable e) {
                    this.selectedLookAndFeel = new Plastic3DLookAndFeel();
                }
            }
            if ((item = swing.element("theme")) != null && item.getText() != null) {
                String lookAndFeelTheme = item.getTextTrim();
                try {
                    _class = Class.forName(lookAndFeelTheme);
                    this.selectedTheme = (PlasticTheme)_class.newInstance();
                }
                catch (Throwable e) {
                    this.selectedTheme = new DesertBlue();
                }
            }
            if ((item = swing.element("logo")) != null && item.getText() != null) {
                this.logo = item.getTextTrim();
            }
            if ((item = swing.element("window-width")) != null && item.getText() != null && !item.getText().equals("")) {
                this.windowSize.setSize((double)((int)Double.parseDouble(item.getTextTrim())), this.windowSize.getHeight());
            }
            if ((item = swing.element("window-height")) != null && item.getText() != null && !item.getText().equals("")) {
                this.windowSize.setSize(this.windowSize.getWidth(), (double)((int)Double.parseDouble(item.getTextTrim())));
            }
        }
    }

    public boolean save() throws IOException {
        boolean isOk = Settings.getSettings().save();
        if (!isOk) {
            return false;
        }
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(Settings.getSettings().getConfigFile());
            ((Element)document.selectSingleNode("//config/swing/lookAndFeel")).setText(this.selectedLookAndFeel.getClass().getName());
            ((Element)document.selectSingleNode("//config/swing/theme")).setText(this.selectedTheme.getClass().getName());
            ((Element)document.selectSingleNode("//config/swing/logo")).setText(this.logo);
            ((Element)document.selectSingleNode("//config/swing/window-width")).setText(String.valueOf(this.windowSize.getWidth()));
            ((Element)document.selectSingleNode("//config/swing/window-height")).setText(String.valueOf(this.windowSize.getHeight()));
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(new FileOutputStream(Settings.getSettings().getConfigFile()), format);
            writer.write(document);
            return true;
        }
        catch (DocumentException e) {
            Settings.logger.info("El fichero de configuraci\u00f3n previamente generado no es correcto ...");
            return false;
        }
    }

    public Dimension getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(Dimension windowSize) {
        this.windowSize = windowSize;
    }

    public LookAndFeel getSelectedLookAndFeel() {
        return this.selectedLookAndFeel;
    }

    public void setSelectedLookAndFeel(LookAndFeel selectedLookAndFeel) {
        this.selectedLookAndFeel = selectedLookAndFeel;
    }

    public void setSelectedLookAndFeel(String selectedLookAndFeelClassName) {
        try {
            Class<?> theClass = Class.forName(selectedLookAndFeelClassName);
            this.setSelectedLookAndFeel((LookAndFeel)theClass.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PlasticTheme getSelectedTheme() {
        return this.selectedTheme;
    }

    public void setSelectedTheme(PlasticTheme selectedTheme) {
        this.selectedTheme = selectedTheme;
    }

    public Boolean getMenuBar3DHint() {
        return this.menuBar3DHint;
    }

    public void setMenuBar3DHint(Boolean menuBar3DHint) {
        this.menuBar3DHint = menuBar3DHint;
    }

    public HeaderStyle getMenuBarHeaderStyle() {
        return this.menuBarHeaderStyle;
    }

    public void setMenuBarHeaderStyle(HeaderStyle menuBarHeaderStyle) {
        this.menuBarHeaderStyle = menuBarHeaderStyle;
    }

    public BorderStyle getMenuBarPlasticBorderStyle() {
        return this.menuBarPlasticBorderStyle;
    }

    public void setMenuBarPlasticBorderStyle(BorderStyle menuBarPlasticBorderStyle) {
        this.menuBarPlasticBorderStyle = menuBarPlasticBorderStyle;
    }

    public BorderStyle getMenuBarWindowsBorderStyle() {
        return this.menuBarWindowsBorderStyle;
    }

    public void setMenuBarWindowsBorderStyle(BorderStyle menuBarWindowsBorderStyle) {
        this.menuBarWindowsBorderStyle = menuBarWindowsBorderStyle;
    }

    public Boolean isPopupDropShadowEnabled() {
        return this.popupDropShadowEnabled;
    }

    public void setPopupDropShadowEnabled(Boolean popupDropShadowEnabled) {
        this.popupDropShadowEnabled = popupDropShadowEnabled;
    }

    public boolean isPlasticHighContrastFocusEnabled() {
        return this.plasticHighContrastFocusEnabled;
    }

    public void setPlasticHighContrastFocusEnabled(boolean plasticHighContrastFocusEnabled) {
        this.plasticHighContrastFocusEnabled = plasticHighContrastFocusEnabled;
    }

    public String getPlasticTabStyle() {
        return this.plasticTabStyle;
    }

    public void setPlasticTabStyle(String plasticTabStyle) {
        this.plasticTabStyle = plasticTabStyle;
    }

    public boolean isTabIconsEnabled() {
        return this.tabIconsEnabled;
    }

    public void setTabIconsEnabled(boolean tabIconsEnabled) {
        this.tabIconsEnabled = tabIconsEnabled;
    }

    public Boolean getToolBar3DHint() {
        return this.toolBar3DHint;
    }

    public void setToolBar3DHint(Boolean toolBar3DHint) {
        this.toolBar3DHint = toolBar3DHint;
    }

    public HeaderStyle getToolBarHeaderStyle() {
        return this.toolBarHeaderStyle;
    }

    public void setToolBarHeaderStyle(HeaderStyle toolBarHeaderStyle) {
        this.toolBarHeaderStyle = toolBarHeaderStyle;
    }

    public BorderStyle getToolBarPlasticBorderStyle() {
        return this.toolBarPlasticBorderStyle;
    }

    public void setToolBarPlasticBorderStyle(BorderStyle toolBarPlasticBorderStyle) {
        this.toolBarPlasticBorderStyle = toolBarPlasticBorderStyle;
    }

    public BorderStyle getToolBarWindowsBorderStyle() {
        return this.toolBarWindowsBorderStyle;
    }

    public void setToolBarWindowsBorderStyle(BorderStyle toolBarWindowsBorderStyle) {
        this.toolBarWindowsBorderStyle = toolBarWindowsBorderStyle;
    }

    public boolean isUseNarrowButtons() {
        return this.useNarrowButtons;
    }

    public void setUseNarrowButtons(boolean useNarrowButtons) {
        this.useNarrowButtons = useNarrowButtons;
    }
}

