/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeFilter;

public class HexToUnicodeTransliterator
extends Transliterator {
    private static final String COPYRIGHT = "\u00a9 IBM Corporation 1999. All rights reserved.";
    static final String _ID = "Hex-Any";
    private static final String DEFAULT_PATTERN = "\\\\u0000;\\\\U0000;u+0000;U+0000";
    private static final char SEMICOLON = ';';
    private static final char ZERO = '0';
    private static final char POUND = '#';
    private static final char BACKSLASH = '\\';
    private String pattern;
    private char[] affixes;
    private int affixCount;

    public HexToUnicodeTransliterator() {
        super(_ID, null);
        this.applyPattern(DEFAULT_PATTERN);
    }

    public HexToUnicodeTransliterator(String thePattern) {
        this(thePattern, null);
    }

    public HexToUnicodeTransliterator(String thePattern, UnicodeFilter theFilter) {
        super(_ID, theFilter);
        this.applyPattern(thePattern);
    }

    public void applyPattern(String pattern) {
        StringBuffer affixes = new StringBuffer();
        this.affixCount = 0;
        int mode = 0;
        int prefixLen = 0;
        int suffixLen = 0;
        int minDigits = 0;
        int maxDigits = 0;
        int start = 0;
        char c = '\u0000';
        boolean isLiteral = false;
        int i = 0;
        while (i <= pattern.length()) {
            if (i == pattern.length()) {
                if (i <= 0 || c == ';' && !isLiteral) break;
                c = ';';
                isLiteral = false;
            } else {
                c = pattern.charAt(i);
                isLiteral = false;
            }
            if (c == '\\') {
                if (i + 1 < pattern.length()) {
                    isLiteral = true;
                    c = pattern.charAt(++i);
                } else {
                    throw new IllegalArgumentException("Trailing '\\'");
                }
            }
            if (!isLiteral) {
                switch (c) {
                    case '#': {
                        if (mode == 0) {
                            ++mode;
                        } else if (mode != 1) {
                            throw new IllegalArgumentException("Unquoted '#'");
                        }
                        ++maxDigits;
                        break;
                    }
                    case '0': {
                        if (mode < 2) {
                            mode = 2;
                        } else if (mode != 2) {
                            throw new IllegalArgumentException("Unquoted '0'");
                        }
                        ++minDigits;
                        ++maxDigits;
                        break;
                    }
                    case ';': {
                        if (minDigits < 1 || maxDigits > 4 || prefixLen > 65535 || suffixLen > 65535) {
                            throw new IllegalArgumentException("Suffix or prefix too long");
                        }
                        if (start == affixes.length()) {
                            affixes.append("AAAA");
                        }
                        affixes.setCharAt(start++, (char)prefixLen);
                        affixes.setCharAt(start++, (char)suffixLen);
                        affixes.setCharAt(start++, (char)minDigits);
                        affixes.setCharAt(start, (char)maxDigits);
                        start = affixes.length();
                        ++this.affixCount;
                        mode = 0;
                        maxDigits = 0;
                        minDigits = 0;
                        suffixLen = 0;
                        prefixLen = 0;
                        break;
                    }
                    default: {
                        isLiteral = true;
                    }
                }
            }
            if (isLiteral) {
                if (start == affixes.length()) {
                    affixes.append("AAAA");
                }
                affixes.append(c);
                if (mode == 0) {
                    ++prefixLen;
                } else {
                    mode = 3;
                    ++suffixLen;
                }
            }
            ++i;
        }
        this.pattern = pattern;
        int len = affixes.length();
        this.affixes = new char[len];
        Utility.getChars(affixes, 0, len, this.affixes, 0);
    }

    public String toPattern() {
        return this.pattern;
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean isIncremental) {
        int cursor = offsets.start;
        int limit = offsets.limit;
        block0: while (cursor < limit) {
            int j = 0;
            int ipat = 0;
            while (j < this.affixCount) {
                int prefixLen = this.affixes[ipat++];
                char suffixLen = this.affixes[ipat++];
                int minDigits = this.affixes[ipat++];
                char maxDigits = this.affixes[ipat++];
                int curs = cursor;
                boolean match2 = true;
                int i = 0;
                while (i < prefixLen) {
                    char c;
                    if (curs >= limit && i > 0) {
                        if (isIncremental) break block0;
                        match2 = false;
                        break;
                    }
                    if ((c = text.charAt(curs++)) != this.affixes[ipat + i]) {
                        match2 = false;
                        break;
                    }
                    ++i;
                }
                if (match2) {
                    char u = '\u0000';
                    int digitCount = 0;
                    do {
                        if (curs >= limit) {
                            if (curs <= cursor || !isIncremental) break;
                            break block0;
                        }
                        int digit = Character.digit(text.charAt(curs), 16);
                        if (digit < 0) break;
                        ++curs;
                        u = (char)(u << 4);
                        u = (char)(u | (char)digit);
                    } while (++digitCount != maxDigits);
                    boolean bl = match2 = digitCount >= minDigits;
                    if (match2) {
                        i = 0;
                        while (i < suffixLen) {
                            char c;
                            if (curs >= limit) {
                                if (curs > cursor && isIncremental) break block0;
                                match2 = false;
                                break;
                            }
                            if ((c = text.charAt(curs++)) != this.affixes[ipat + prefixLen + i]) {
                                match2 = false;
                                break;
                            }
                            ++i;
                        }
                        if (match2) {
                            text.replace(cursor, curs, String.valueOf(u));
                            limit -= curs - cursor - 1;
                            break;
                        }
                    }
                }
                ipat += prefixLen + suffixLen;
                ++j;
            }
            ++cursor;
        }
        offsets.contextLimit += limit - offsets.limit;
        offsets.limit = limit;
        offsets.start = cursor;
    }
}

