/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.model;

import conector.eurobits.efactura.desktop.controller.Constantes;
import conector.eurobits.efactura.desktop.controller.OperacionesWS;
import conector.eurobits.efactura.desktop.model.Settings;
import conector.eurobits.efactura.desktop.model.SettingsFactory;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class Planificador
extends Thread {
    private static final Logger loggerConector = Logger.getLogger(Planificador.class);
    private static final Logger loggerError = Logger.getLogger("Error");
    private final int TIME_REVIEW = 30000;
    private long timeUpdateEnvio = -1L;
    private long timeUpdateRecibir = -1L;
    private long initialTimeEnvio = -1L;
    private long initialTimeRecepcion = -1L;
    protected static final String BASE_DIRECTORY = System.getProperty("file.separator") + "SistemaeFactura";

    public static void main(String[] args) {
        Planificador plan = new Planificador();
        plan.ejecutar();
    }

    public void ejecutar() {
        try {
            Planificador.initSettings();
            loggerConector.info("Settings inicializados - Planificador");
            loggerConector.info("Inicio del planificador");
            Planificador plan = new Planificador();
            plan.run();
            plan.setDaemon(true);
        }
        catch (DocumentException de) {
            JOptionPane.showMessageDialog(null, "El fichero config.xml esta mal escrito. " + de.getMessage(), "Error en config.xml", 0);
            loggerError.error(Constantes.ERROR_XML_MAL_ESCRITO);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "No se puede leer el fichero de configuraci\u00f3n. " + e.getMessage(), "Error en config.xml", 0);
            loggerError.error(Constantes.ERROR_XML_NO_SE_PUEDE_LEER);
        }
        catch (SecurityException e1) {
            loggerError.error(Constantes.ERROR_CREAR_PLANIFICADOR + e1.getMessage());
        }
        catch (IllegalThreadStateException e2) {
            loggerError.error(Constantes.ERROR_CREAR_NUEVO_THREAD + e2.getMessage());
        }
        catch (Exception e) {
            loggerError.error(Constantes.ERROR_CRITICO + e.getMessage());
            JOptionPane.showMessageDialog(null, "Error Cr\u00edtico", "Error en config.xml", 0);
        }
        loggerConector.debug("Fin del planificador");
    }

    public void ejecutar(String rutaInicial) {
        Settings.getSettings().setBaseFolder(new File(rutaInicial + BASE_DIRECTORY));
        this.ejecutar();
    }

    public static Settings initSettings() throws DocumentException, IOException {
        Settings settings = SettingsFactory.loadGlobalSettingsFromPath();
        if (settings == null) {
            settings = SettingsFactory.loadGlobalSettingsFromClassPath();
            if (settings == null) {
                settings = Settings.getSettings();
            }
            SettingsFactory.save(settings);
            settings = SettingsFactory.loadGlobalSettingsFromPath();
        }
        return settings;
    }

    public void run() {
        loggerConector.debug("Inicio el Planificador");
        try {
            while (true) {
                if (Settings.getSettings().isAutoPlanificadorEnvio()) {
                    long newTimeUpdateEnvio = (long)Settings.getSettings().getTiempoEnvioEnMinutos() * 60000L;
                    if (this.timeUpdateEnvio < 0L) {
                        this.timeUpdateEnvio = newTimeUpdateEnvio;
                        this.initialTimeEnvio = newTimeUpdateEnvio;
                        OperacionesWS.getInstance().enviarFacturasPlanificador(Constantes.MODO_PLANIFICADOR);
                        this.timeUpdateEnvio -= 30000L;
                    } else if (newTimeUpdateEnvio != this.initialTimeEnvio) {
                        this.timeUpdateEnvio = newTimeUpdateEnvio;
                        this.initialTimeEnvio = newTimeUpdateEnvio;
                        this.timeUpdateEnvio -= 30000L;
                    } else {
                        this.timeUpdateEnvio -= 30000L;
                    }
                }
                if (Settings.getSettings().isAutoPlanificadorRecibir()) {
                    long newTimeUpdateRecibir = (long)Settings.getSettings().getTiempoRecepcionEnMinutos() * 60000L;
                    if (this.timeUpdateRecibir < 0L) {
                        this.timeUpdateRecibir = newTimeUpdateRecibir;
                        this.initialTimeRecepcion = newTimeUpdateRecibir;
                        OperacionesWS.getInstance().recibirFacturasPlanificador(Constantes.MODO_PLANIFICADOR);
                        this.timeUpdateRecibir -= 30000L;
                    } else if (newTimeUpdateRecibir != this.initialTimeRecepcion) {
                        this.timeUpdateRecibir = newTimeUpdateRecibir;
                        this.initialTimeRecepcion = newTimeUpdateRecibir;
                        this.timeUpdateRecibir -= 30000L;
                    } else {
                        this.timeUpdateRecibir -= 30000L;
                    }
                }
                loggerConector.debug("Se duerme el planificador");
                Planificador.sleep(30000L);
            }
        }
        catch (InterruptedException ie) {
            loggerConector.error("Este thread ha sido interrumpido. " + ie.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            loggerConector.error("No se han inicializado los settings correctamente. " + t.getMessage());
        }
    }
}

