/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.controller;

import conector.eurobits.efactura.desktop.controller.Base64;
import conector.eurobits.efactura.desktop.controller.Constantes;
import conector.eurobits.efactura.desktop.controller.LoginException;
import conector.eurobits.efactura.desktop.model.Settings;
import conector.eurobits.efactura.desktop.view.MainScreen;
import conector.eurobits.efactura.desktop.view.MenuBar;
import conector.eurobits.efactura.desktop.view.NombresMenus;
import conector.eurobits.efactura.desktop.view.VentanaInformacion;
import eurobits.efactura.ws.bean.AttachmentFileBeanSet;
import eurobits.efactura.ws.bean.DataHandlerBean;
import eurobits.efactura.ws.bean.GUIDFacturaBeanSet;
import eurobits.efactura.ws.bean.InvoiceReceivedBean;
import eurobits.efactura.ws.bean.InvoiceReceivedBeanSet;
import eurobits.efactura.ws.bean.InvoiceStatusDataBeanSet;
import eurobits.efactura.ws.bean.LoginBean;
import eurobits.efactura.ws.bean.SendFileBeanSet;
import eurobits.efactura.ws.bean.SendInvoicesWithAttachmentsBean;
import eurobits.efactura.ws.clients.erp.Client;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class OperacionesWS
extends Thread
implements NombresMenus {
    private static final Logger loggerConector = Logger.getLogger(MenuBar.class);
    private static final Logger loggerError = Logger.getLogger("Error");
    private static final int NUMERO_HORAS = 1752000;
    private static final String FICHERO_CONSULTA_ESTADOS = "conector/eurobits/efactura/desktop/view/resources/Fichero_Base_Consulta_Estado.xml";
    private static OperacionesWS operaciones = null;

    private OperacionesWS() {
    }

    public static synchronized OperacionesWS getInstance() {
        if (operaciones == null) {
            operaciones = new OperacionesWS();
        }
        return operaciones;
    }

    private void visualizaError(String modoDeEjecucion, String titulo, String error) {
        if (modoDeEjecucion.equals(Constantes.MODO_GRAFICO)) {
            new VentanaInformacion(titulo, error);
        }
    }

    private void visualizaError(String modoDeEjecucion, String titulo, String error, int retardo) {
        if (modoDeEjecucion.equals(Constantes.MODO_GRAFICO)) {
            new VentanaInformacion(titulo, error, retardo);
        }
    }

    public boolean recibirFacturas(String modoDeEjecucion) {
        double DAY_MILLIS = 8.64054E7;
        double MONTH_MILLIS = DAY_MILLIS * 30.43675;
        Date desde = new Date((long)((double)System.currentTimeMillis() - MONTH_MILLIS * 6.0));
        Date hasta = new Date(System.currentTimeMillis());
        this.actualizarEstados(modoDeEjecucion);
        return this.recibirFacturas(modoDeEjecucion, desde, hasta, Constantes.FACTURA_EMITIDA_COMO_PAGARDOR, true, false);
    }

    public boolean recibirFacturasPlanificador(String modoDeEjecucion) {
        double DAY_MILLIS = 8.64054E7;
        double MONTH_MILLIS = DAY_MILLIS * 30.43675;
        Date desde = new Date((long)((double)System.currentTimeMillis() - MONTH_MILLIS * 6.0));
        Date hasta = new Date(System.currentTimeMillis());
        return this.recibirFacturasPlanificador(modoDeEjecucion, desde, hasta, Constantes.FACTURA_EMITIDA_COMO_PAGARDOR, true);
    }

    public boolean recibirFacturasId(String modoDeEjecucion, String id, int emitidaComo) {
        loggerConector.info("Inicio de recibir facturas");
        boolean salida = true;
        try {
            String formato = Settings.getSettings().getTipoFacturaRecibir();
            loggerConector.info(Settings.getSettings().getUrl());
            Client client = this.login();
            if (this.bajarFacturasFormatoId(modoDeEjecucion, id, emitidaComo, formato, client)) {
                if (Settings.getSettings().isAutoPDFRecibir()) {
                    this.bajarFacturasFormatoId(modoDeEjecucion, id, emitidaComo, "PDF", client);
                }
                if (Settings.getSettings().isAutoFirmadaRecibir()) {
                    this.bajarFacturasFormatoId(modoDeEjecucion, id, emitidaComo, "COPIA", client);
                }
                loggerConector.info("Se han recibido las facturas correctamente");
                this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", "Se han recibido las facturas correctamente.");
            }
            client.logout();
            MainScreen.updateTree();
        }
        catch (LoginException e) {
            salida = false;
            loggerError.error("Error. Ha Habido un fallo en la conexion al servidor (al realizar el login) " + e.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error. Ha Habido un fallo en la conexion al servidor (al realizar el login).\n\n" + e.getLocalizedMessage());
        }
        catch (IOException e) {
            salida = false;
            loggerError.error("Problemas en guardar las facturas recibidas");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas en guardar las facturas recibidas\n" + e.getLocalizedMessage());
        }
        catch (SecurityException e) {
            salida = false;
            loggerError.error("Problemas en guardar las facturas recibidas");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas en guardar las facturas recibidas\n" + e.getLocalizedMessage());
        }
        catch (NullPointerException e) {
            salida = false;
            loggerError.error("Formato de factura erroneo");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas al recibir facturas\n" + e.getLocalizedMessage());
        }
        catch (Throwable e) {
            salida = false;
            loggerError.error("Otros errores en la recepcion de factura");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Errores al recibir facturas\n");
        }
        loggerConector.info("Fin de recibir facturas");
        return salida;
    }

    public boolean recibirFacturas(String modoDeEjecucion, Date desde, Date hasta, int emitidaComo, boolean descargarPendientes, boolean recuperar) {
        loggerConector.info("Inicio de recibir facturas");
        boolean salida = true;
        try {
            String formato = Settings.getSettings().getTipoFacturaRecibir();
            loggerConector.info(Settings.getSettings().getUrl());
            Client client = this.login();
            InvoiceReceivedBeanSet facturasRecibidas = this.getFacturasFecha(descargarPendientes, client, desde, hasta, emitidaComo);
            if (facturasRecibidas != null) {
                if (facturasRecibidas.getError()) {
                    loggerError.error("Error. Hubo un fallo en la recepci\u00f3n de facturas" + facturasRecibidas.getMessage());
                    this.visualizaError(modoDeEjecucion, "Error", "Error. Hubo un fallo en la recepci\u00f3n de facturas\n", 0);
                } else if (facturasRecibidas.getSize() > 0) {
                    loggerConector.info("Bajando Facturas en XML.");
                    if (this.bajarFacturasFormato(modoDeEjecucion, facturasRecibidas, client, formato, emitidaComo, recuperar)) {
                        loggerConector.info("Facturas en XML Bajadas.");
                        if (Settings.getSettings().isAutoPDFRecibir()) {
                            loggerConector.info("Bajando Facturas en PDF.");
                            if (!this.bajarFacturasFormato(modoDeEjecucion, facturasRecibidas, client, "PDF", emitidaComo, recuperar)) {
                                return false;
                            }
                            loggerConector.info("Facturas Bajadas en PDF.");
                        }
                        if (Settings.getSettings().isAutoFirmadaRecibir()) {
                            loggerConector.info("Bajando Facturas firmadas.");
                            if (!this.bajarFacturasFormato(modoDeEjecucion, facturasRecibidas, client, "COPIA", emitidaComo, recuperar)) {
                                return false;
                            }
                            loggerConector.info("Facturas firmadas Bajadas.");
                        }
                    } else {
                        loggerError.error("Problemas al descargar facturas");
                        return false;
                    }
                    loggerConector.info("Facturas Recibidas correctamente!");
                    this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", facturasRecibidas.getSize() + " Facturas Recibidas correctamente!", 0);
                    AttachmentFileBeanSet listaAdjuntos = null;
                    InvoiceReceivedBean factura = null;
                    File rutaAjuntos = null;
                    for (int i = 0; i < facturasRecibidas.getSize(); ++i) {
                        factura = facturasRecibidas.getInvoiceReceivedBeans()[i];
                        if (factura == null || (listaAdjuntos = client.listAttachments(factura.getGuid(), factura.getCifProveedor())) == null) continue;
                        rutaAjuntos = new File(Settings.getSettings().getPendingReceivedFolder() + File.separator + "Att-" + factura.getNameInvoice());
                        if (!rutaAjuntos.exists() && listaAdjuntos.getSize() > 0) {
                            rutaAjuntos.mkdir();
                        }
                        for (int j = 0; j < listaAdjuntos.getSize(); ++j) {
                            System.out.println("Id-Factura : " + factura.getNameInvoice() + "\nAdjunto : " + listaAdjuntos.getAttachmentFileBeans()[j].getNombre());
                            DataHandlerBean adjunto = client.downloadAttachment(factura.getGuid(), listaAdjuntos.getAttachmentFileBeans()[j].getIdAdjunto(), factura.getCifProveedor());
                            this.guardarAdjunto(adjunto.getDataHandler(), listaAdjuntos.getAttachmentFileBeans()[j].getNombre(), rutaAjuntos.getAbsolutePath());
                        }
                    }
                } else {
                    loggerConector.info("No hay facturas");
                    this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", "No hay facturas.", 0);
                }
            } else {
                loggerConector.info("No hab\u00eda ninguna factura en las fechas establecidas");
                this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", "No hab\u00eda ninguna factura en las fechas establecidas\n", 0);
            }
            client.logout();
            MainScreen.updateTree();
        }
        catch (LoginException e) {
            salida = false;
            loggerError.error("Error. Ha Habido un fallo en la conexion al servidor (al realizar el login) " + e.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error. Ha Habido un fallo en la conexion al servidor (al realizar el login).\n\n" + e.getLocalizedMessage());
        }
        catch (IOException e) {
            salida = false;
            loggerError.error("Problemas en guardar las facturas recibidas");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas en guardar las facturas recibidas\n" + e.getLocalizedMessage(), 0);
        }
        catch (SecurityException e) {
            salida = false;
            loggerError.error("Problemas en guardar las facturas recibidas");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas en guardar las facturas recibidas\n" + e.getLocalizedMessage(), 0);
        }
        catch (NullPointerException e) {
            salida = false;
            loggerError.error("Formato de factura erroneo");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas al recibir facturas\n" + e.getLocalizedMessage(), 0);
        }
        catch (Throwable e) {
            salida = false;
            loggerError.error("Otros errores en la recepcion de factura");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Errores al recibir facturas\n", 0);
        }
        loggerConector.info("Fin de recibir facturas");
        return salida;
    }

    public boolean recibirFacturasPlanificador(String modoDeEjecucion, Date desde, Date hasta, int emitidaComo, boolean descargarPendientes) {
        loggerConector.info("Inicio de recibir facturas desde el Planificador");
        boolean salida = true;
        try {
            String formato = Settings.getSettings().getTipoFacturaRecibir();
            loggerConector.info(Settings.getSettings().getUrl());
            Client client = this.login();
            InvoiceReceivedBeanSet facturasRecibidas = this.getFacturasFecha(descargarPendientes, client, desde, hasta, emitidaComo);
            if (facturasRecibidas != null) {
                if (facturasRecibidas.getError()) {
                    loggerError.error("Error. Hubo un fallo en la recepci\u00f3n de facturas desde el Planificador " + facturasRecibidas.getMessage());
                    this.visualizaError(modoDeEjecucion, "Error", "Error. Hubo un fallo en la recepci\u00f3n de facturas desde el Planificador\n");
                } else if (facturasRecibidas.getSize() > 0) {
                    loggerConector.info("Bajando Facturas en XML.");
                    if (this.bajarFacturasFormato(modoDeEjecucion, facturasRecibidas, client, formato, emitidaComo, false)) {
                        loggerConector.info("Facturas en XML Bajadas.");
                    }
                    if (Settings.getSettings().isAutoPDFRecibir()) {
                        loggerConector.info("Bajando Facturas en PDF.");
                        this.bajarFacturasFormato(modoDeEjecucion, facturasRecibidas, client, "PDF", emitidaComo, false);
                        loggerConector.info("Facturas Bajadas en PDF.");
                    }
                    if (Settings.getSettings().isAutoFirmadaRecibir()) {
                        loggerConector.info("Bajando Facturas firmadas.");
                        this.bajarFacturasFormato(modoDeEjecucion, facturasRecibidas, client, "COPIA", emitidaComo, false);
                        loggerConector.info("Facturas firmadas Bajadas.");
                    }
                    loggerConector.info("Facturas Recibidas correctamente desde el Planificador!");
                    this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", facturasRecibidas.getSize() + " Facturas Recibidas correctamente desde el Planificador!");
                } else {
                    loggerConector.info("No hay facturas");
                    this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", "No hay facturas que recibir, desde el Planificador");
                }
            } else {
                loggerError.info("No hab\u00eda ninguna factura en las fechas establecidas, desde el Planificador");
                this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", "No hab\u00eda ninguna factura en las fechas establecidas, desde el Planificador\n");
            }
            client.logout();
            MainScreen.updateTree();
        }
        catch (LoginException e) {
            salida = false;
            loggerError.error(" Hay un fallo en la conexion con servidor al realizar el login " + e.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error. Ha Habido un fallo en la conexion al servidor (al realizar el login).\n\n" + e.getLocalizedMessage() + "\ndesde el Planificador");
        }
        catch (IOException e) {
            salida = false;
            loggerError.error("Problemas en guardar las facturas recibidas");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas en guardar las facturas recibidas\n" + e.getLocalizedMessage() + "\ndesde el Planificador");
        }
        catch (SecurityException e) {
            salida = false;
            loggerError.error("Problemas en guardar las facturas recibidas");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas en guardar las facturas recibidas\n" + e.getLocalizedMessage() + "\ndesde el Planificador");
        }
        catch (NullPointerException e) {
            salida = false;
            loggerError.error("Formato de factura erroneo");
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas al recibir facturas\n" + e.getLocalizedMessage() + "\ndesde el Planificador");
        }
        catch (Throwable e) {
            salida = false;
            loggerError.error("Otros errores en la recepcion de factura");
            this.visualizaError(modoDeEjecucion, "Error", "Error al recibir facturas, desde el Planificador");
        }
        loggerConector.info("Fin de recibir facturas");
        return salida;
    }

    private boolean bajarFacturasFormatoId(String modoDeEjecucion, String id, int emitidaComo, String formato, Client client) throws Exception {
        boolean salida = true;
        String[] facturas = new String[]{id};
        String[] cifs = new String[]{Settings.getSettings().getCIF()};
        DataHandlerBean descarga = client.getInvoicesDataFilter(facturas, cifs, formato, emitidaComo);
        if (descarga.getError()) {
            String mensaje;
            String string = descarga.getMessage().endsWith("inexistentes") ? "No existe ninguna factura con el [C\u00f3digo Identificador = " + id + "] suministrado" : (mensaje = "Problemas al intentar descargar las facturas en formato " + (formato.equals("COPIA") ? "FIRMADA" : formato));
            String titulo = descarga.getMessage().endsWith("inexistentes") ? "Informaci\u00f3n" : "Error Descargando " + (formato.equals("COPIA") ? "FIRMADA" : formato);
            salida = false;
            loggerError.error(titulo + descarga.getMessage());
            this.visualizaError(modoDeEjecucion, titulo, mensaje, 0);
        } else {
            DataHandler data = descarga.getDataHandler();
            if (data != null) {
                String tipoAccion = emitidaComo == Constantes.FACTURA_EMITIDA_COMO_PAGARDOR ? Constantes.GUARDAR_FACTURA_RECIBIDA : Constantes.GUARDAR_FACTURA_EMITIDA;
                String path = this.averiguaPathDestino(formato, tipoAccion, true);
                loggerConector.info(path);
                this.guardarFacturas(data, formato, tipoAccion, path);
            }
        }
        return salida;
    }

    private boolean bajarFacturasFormato(String modoDeEjecucion, InvoiceReceivedBeanSet facturasRecibidas, Client client, String formato, int emitidaComo, boolean recuperar) throws Exception {
        boolean salida = true;
        DataHandlerBean descarga = this.getFacturas(facturasRecibidas, client, formato, emitidaComo);
        if (descarga.getError()) {
            salida = false;
            loggerError.error("Problemas al descargar las facturas " + descarga.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Problemas al descargar las facturas\n");
        } else {
            DataHandler data = descarga.getDataHandler();
            if (!facturasRecibidas.getError() && data != null) {
                String tipoAccion = emitidaComo == Constantes.FACTURA_EMITIDA_COMO_PAGARDOR ? Constantes.GUARDAR_FACTURA_RECIBIDA : Constantes.GUARDAR_FACTURA_EMITIDA;
                String path = this.averiguaPathDestino(formato, tipoAccion, recuperar);
                this.guardarFacturas(data, formato, tipoAccion, path);
            }
        }
        return salida;
    }

    private boolean bajarFacturasFormato(String modoDeEjecucion, GUIDFacturaBeanSet facturasEmitidas, Client client, String formato) throws Exception {
        boolean salida = true;
        DataHandlerBean descarga = this.getFacturas(facturasEmitidas, client, formato);
        if (descarga.getError()) {
            loggerError.error(descarga.getMessage());
            salida = false;
            this.visualizaError(modoDeEjecucion, "", "Error. Problemas al obtener las facturas\n");
        } else {
            DataHandler data = descarga.getDataHandler();
            if (!facturasEmitidas.getError() && data != null) {
                String path = this.averiguaPathDestino(formato, Constantes.GUARDAR_FACTURA_EMITIDA, false);
                loggerConector.info(path);
                this.guardarFacturas(data, formato, Constantes.GUARDAR_FACTURA_EMITIDA, path);
            }
        }
        return salida;
    }

    private void configurarProxy() throws LoginException {
        try {
            loggerConector.info("Entra a Configurar Proxy");
            System.setProperty("http.proxySet", Settings.getSettings().isNormalProxy() + "");
            loggerConector.info("Cambia propiedad: http.proxySet, con " + Settings.getSettings().isNormalProxy());
            if (Settings.getSettings().isNormalProxy()) {
                System.setProperty("http.proxyHost", Settings.getSettings().getIp());
                System.setProperty("http.proxyPort", Settings.getSettings().getPort());
                URL url = new URL(Settings.getSettings().getUrl().trim());
                URLConnection connection = url.openConnection();
                if (Settings.getSettings().isAdvancedProxy()) {
                    String password = Settings.getSettings().getUserProxy() + ":" + Settings.getSettings().getPasswordProxy();
                    String encoded = Base64.encodeObject((Serializable)((Object)password));
                    connection.setRequestProperty("Proxy-Authorization", encoded);
                }
                connection.setDoInput(true);
                connection.setDoOutput(true);
            }
        }
        catch (SecurityException se) {
            throw new LoginException("No hay permisos para modificar las opciones del Proxy.", true);
        }
        catch (NullPointerException npe) {
            throw new LoginException("Formato incorrecto de las opciones del Proxy, " + npe.getLocalizedMessage(), true);
        }
        catch (MalformedURLException murle) {
            throw new LoginException("La url del frontend es incorrecta, " + murle.getLocalizedMessage(), true);
        }
        catch (IOException ioe) {
            throw new LoginException("Error al establecer conexion al frontend , " + ioe.getLocalizedMessage(), true);
        }
        catch (Throwable t) {
            throw new LoginException("Error al crear el proxy, " + t.getLocalizedMessage(), true);
        }
    }

    private Client login() throws LoginException, FileNotFoundException {
        Client client = null;
        String pathKey = "";
        try {
            loggerConector.info("Inicio del login");
            if (Settings.getSettings().isNormalProxy()) {
                Properties propiedades = new Properties();
                propiedades.setProperty("http.proxyHost", Settings.getSettings().getIp());
                propiedades.setProperty("http.proxyPort", Settings.getSettings().getPort());
                if (Settings.getSettings().isAdvancedProxy()) {
                    propiedades.setProperty("http.proxyUser", Settings.getSettings().getUserProxy());
                    propiedades.setProperty("http.proxyPassword", Settings.getSettings().getPasswordProxy());
                }
                client = new Client(propiedades);
            } else {
                client = new Client();
            }
            if (Settings.getSettings().getUrl() == null || Settings.getSettings().getUrl().trim().length() == 0) {
                throw new LoginException("URL Incorrecta ", true);
            }
            File keyFile = Settings.getSettings().getFolder(Settings.getSettings().getKey());
            if (!keyFile.exists()) {
                throw new LoginException("No existe el fichero  " + keyFile.getAbsolutePath(), true);
            }
            byte[] bytesCifradosBase64 = new byte[(int)keyFile.length()];
            DataInputStream in = new DataInputStream(new FileInputStream(keyFile));
            in.readFully(bytesCifradosBase64);
            in.close();
            if (bytesCifradosBase64 == null || bytesCifradosBase64.length == 0) {
                throw new LoginException("El fichero de clave esta vacio", true);
            }
            LoginBean sale = client.login(Settings.getSettings().getUrl(), new String(bytesCifradosBase64), Settings.getSettings().getPassword());
            if (sale.getError()) {
                throw new LoginException("Error en la conexion a " + Settings.getSettings().getUrl() + " por: " + sale.getMessage(), true);
            }
            FileOutputStream fos = new FileOutputStream(keyFile);
            fos.write(sale.getLlaveCifrada().getBytes());
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("No encontrado el fichero de clave: '" + pathKey + "'");
        }
        catch (SecurityException e) {
            throw new LoginException("Problemas de permisos para leer/escribir en el fichero de clave, " + e.getLocalizedMessage(), true);
        }
        catch (IOException e) {
            throw new LoginException("Problemas en la lectura del fichero de clave, " + e.getLocalizedMessage(), true);
        }
        catch (Throwable t) {
            throw new LoginException("Error al crear el cliente " + t.getLocalizedMessage(), true);
        }
        loggerConector.info("Fin del login");
        return client;
    }

    private String averiguaPathDestino(String formato, String tipo, boolean recuperar) {
        String path = "";
        if (Constantes.GUARDAR_FACTURA_RECIBIDA.equals(tipo)) {
            path = formato.equals("PDF") ? Settings.getSettings().getPDFReceived() : (formato.equals("COPIA") ? Settings.getSettings().getSignedReceived() : (recuperar ? Settings.getSettings().getRecoveryReceivedFolder() : Settings.getSettings().getPendingReceivedFolder()));
        } else if (Constantes.GUARDAR_FACTURA_EMITIDA.equals(tipo)) {
            path = formato.equals("PDF") ? Settings.getSettings().getPDFSent() : (formato.equals("COPIA") ? Settings.getSettings().getSignedSent() : (recuperar ? Settings.getSettings().getRecoverySentFolder() : Settings.getSettings().getProcessedSentFolder()));
        }
        return path;
    }

    private void guardarFacturas(DataHandler data, String formato, String tipo, String path) throws IOException {
        ZipEntry entry;
        File archivoTemp = new File(path, "facturas.zip");
        int BUFFER = 102400;
        BufferedOutputStream salida = new BufferedOutputStream(new FileOutputStream(archivoTemp));
        data.writeTo(salida);
        salida.close();
        loggerConector.debug("Zip creado");
        BufferedOutputStream dest = null;
        FileInputStream fichzip = new FileInputStream(archivoTemp);
        ZipInputStream zipStream = new ZipInputStream(new BufferedInputStream(fichzip));
        int count = 0;
        byte[] datos = new byte[BUFFER];
        while ((entry = zipStream.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            loggerConector.info("Bajando factura " + entry.getName());
            File destFN = new File(path, entry.getName());
            FileOutputStream fos = new FileOutputStream(destFN);
            dest = new BufferedOutputStream(fos, BUFFER);
            while ((count = zipStream.read(datos, 0, BUFFER)) != -1) {
                dest.write(datos, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zipStream.close();
        if (!archivoTemp.delete()) {
            throw new IOException("Error al borrar el fichero");
        }
        loggerConector.info("Facturas guardadas");
    }

    private void guardarAdjunto(DataHandler data, String nombre, String path) throws IOException {
        File archivoTemp = new File(path, nombre);
        loggerConector.info("Inicia escritua de Adjunto " + nombre + " guardado");
        BufferedOutputStream salida = new BufferedOutputStream(new FileOutputStream(archivoTemp));
        data.writeTo(salida);
        salida.close();
        loggerConector.info("Adjunto " + nombre + " guardado");
    }

    private boolean isPDF(String name) {
        boolean esTipoPDF = false;
        if (this.generarNombreFichero(name).split("\\.")[1].equalsIgnoreCase("PDF")) {
            esTipoPDF = true;
        }
        return esTipoPDF;
    }

    private boolean isSigned(String name) {
        boolean esTipoSigned = false;
        if (this.generarNombreFichero(name).split("\\.")[1].equalsIgnoreCase(".p7b")) {
            esTipoSigned = true;
        }
        return esTipoSigned;
    }

    private String generarNombreFichero(String name) {
        String salida = System.currentTimeMillis() + "." + Settings.getSettings().getTipoFacturaRecibir();
        if (name != null && name.trim().length() > 0 && name.split("\\.").length == 2) {
            salida = System.currentTimeMillis() + "." + name.split("\\.")[1];
        }
        return salida;
    }

    private DataHandlerBean getFacturas(InvoiceReceivedBeanSet facturasRecibidas, Client client, String tipo, int emitidaComo) {
        if (tipo == null) {
            loggerError.error("Tipo de factura errroneo");
            tipo = "UBL10";
        }
        loggerConector.info("Descargando facturas");
        DataHandlerBean descarga = null;
        ArrayList<String> listaFacturas = new ArrayList<String>();
        ArrayList<String> listaCifs = new ArrayList<String>();
        for (int i = 0; i < facturasRecibidas.getSize(); ++i) {
            if (!facturasRecibidas.getInvoiceReceivedBeans()[i].getCodigoEstado().equals("30")) {
                loggerConector.debug(facturasRecibidas.getInvoiceReceivedBeans()[i].getGuid());
                listaFacturas.add(facturasRecibidas.getInvoiceReceivedBeans()[i].getGuid());
                listaCifs.add(facturasRecibidas.getInvoiceReceivedBeans()[i].getCifProveedor());
                continue;
            }
            loggerConector.debug(facturasRecibidas.getInvoiceReceivedBeans()[i].getGuid() + " en estado custodia");
        }
        String[] facturas = listaFacturas.toArray(new String[0]);
        String[] cifs = listaCifs.toArray(new String[0]);
        descarga = client.getInvoicesDataFilter(facturas, cifs, tipo, emitidaComo);
        return descarga;
    }

    private DataHandlerBean getFacturas(GUIDFacturaBeanSet facturasEmitidas, Client client, String tipo) {
        if (tipo == null) {
            loggerError.error("Tipo de factura errroneo");
            tipo = "UBL10";
        }
        loggerConector.info("Descargando facturas");
        DataHandlerBean descarga = null;
        String[] facturas = new String[facturasEmitidas.getGUIDFacturaBeans().length];
        String[] cifs = new String[facturasEmitidas.getGUIDFacturaBeans().length];
        for (int i = 0; i < facturasEmitidas.getSize(); ++i) {
            loggerConector.debug(facturasEmitidas.getGUIDFacturaBeans()[i].getGUID());
            facturas[i] = facturasEmitidas.getGUIDFacturaBeans()[i].getGUID();
            cifs[i] = "";
        }
        descarga = client.getInvoicesData(facturas, cifs, tipo);
        return descarga;
    }

    private InvoiceReceivedBeanSet getFacturasFecha(boolean descargarPendientes, Client client, Date desde, Date hasta, int emitidaComo) {
        loggerConector.debug("Desde:" + desde + ", Hasta:" + hasta);
        InvoiceReceivedBeanSet sale = client.getInvoicesReceivedFilter(desde, hasta, descargarPendientes, emitidaComo);
        if (sale.getError()) {
            loggerError.error("Error en la recepeci\u00f3n de datos");
            sale = null;
        } else {
            loggerConector.debug("Cuantos: " + sale.getInvoiceReceivedBeans().length);
            loggerConector.debug("Cuantos: " + sale);
        }
        return sale;
    }

    private void actualizarEstados(String modoDeEjecucion) {
        SAXReader saxReader = new SAXReader();
        File folder = Settings.getSettings().getFolder(Settings.getSettings().getStatusPendingReceived());
        String[] ficheros = folder.list();
        String ficheroStatus = null;
        Client client = null;
        if (ficheros.length > 0) {
            try {
                client = this.login();
            }
            catch (FileNotFoundException fe) {
                loggerError.error("Error al intentar ubicar el fichero de configuraciones " + fe.getMessage());
                this.visualizaError(modoDeEjecucion, "Error", "Error al intentar ubicar el fichero de configuraciones ", 0);
            }
            catch (LoginException le) {
                loggerError.error("Ha habido un fallo en la conexion al servidor (al realizar el login)" + le.getMessage());
                le.printStackTrace();
                this.visualizaError(modoDeEjecucion, "Error", "Error. Ha habido un fallo en la conexion al servidor (al realizar el login).\n\n", 0);
            }
            catch (Throwable t) {
                loggerError.error("Error al Actualizar Estados, " + t.getLocalizedMessage());
                this.visualizaError(modoDeEjecucion, "Error", "Error al Actualizar Estados\n", 0);
            }
            if (client != null) {
                boolean statusCode = false;
                ArrayList<String> ids = null;
                boolean todoOk = true;
                for (int i = 0; i < ficheros.length; ++i) {
                    ficheroStatus = folder.getAbsolutePath() + File.separator + ficheros[i];
                    try {
                        Document document = saxReader.read(ficheroStatus);
                        String cifEmisor = this.valorNodo(document, "//ApplicationResponse/cac:SenderParty/cac:PartyIdentification/cbc:ID");
                        String cifReceptor = this.valorNodo(document, "//ApplicationResponse/cac:ReceiverParty/cac:PartyIdentification/cbc:ID");
                        String idFiscal = this.valorNodo(document, "//ApplicationResponse/cac:DocumentResponse/cac:DocumentReference/cbc:ID");
                        String txtEstado = this.valorNodo(document, "//ApplicationResponse/cac:DocumentResponse/cac:Response/cbc:ResponseCode");
                        if (cifEmisor == null || "".equals(cifEmisor) || idFiscal == null || "".equals(idFiscal) || txtEstado == null || "".equals(txtEstado)) {
                            loggerConector.debug("El Cif del Proveedor, el IdFiscal o el c\u00f3digo de estado son blancos o nulos o no han sido reportados en el XML");
                            this.visualizaError(modoDeEjecucion, "Error", "El Cif del Proveedor, el IdFiscal o el c\u00f3digo de estado son blancons o nulos o no han sido reportados en el XML", 0);
                            todoOk = false;
                            continue;
                        }
                        ids = new ArrayList<String>();
                        ids.add(idFiscal);
                        loggerConector.info("Inicia Actualizaci\u00f3n de Estados ");
                        InvoiceStatusDataBeanSet resultado = client.setInvoicesDataStatus(new Integer(txtEstado), "ID_FISCAL", ids, cifEmisor);
                        if (resultado.getError() || resultado.getElement(0) != null && resultado.getElement(0).getError()) {
                            String mensaje = resultado.getMessage() != null && resultado.getMessage().length() > 0 ? resultado.getMessage() : resultado.getElement(0).getMessage();
                            loggerError.error("Error al Actualizar Estados " + mensaje);
                            this.visualizaError(modoDeEjecucion, "Error", "Problemas al actualizar Estados\n" + mensaje, 0);
                            todoOk = false;
                            continue;
                        }
                        loggerConector.info("Se han Actualizado " + ficheros.length + " facturas");
                        this.moverFactura(ficheroStatus, Settings.getSettings().getStatusProcessedReceived());
                        MainScreen.updateTree();
                        continue;
                    }
                    catch (DocumentException ex) {
                        loggerConector.debug("Error al Actualizar Estados " + ex.getLocalizedMessage());
                        this.visualizaError(modoDeEjecucion, "Error", "Error al Actualizar Estados\n", 0);
                        todoOk = false;
                        continue;
                    }
                    catch (Exception ex) {
                        loggerConector.debug("Error al Actualizar Estados " + ex.getLocalizedMessage());
                        this.visualizaError(modoDeEjecucion, "Error", "Error al Actualizar Estados\n", 0);
                        todoOk = false;
                    }
                }
                loggerConector.info("Fin de Actualizaci\u00f3n de Estados ");
                client.logout();
                if (todoOk) {
                    this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", "Se han Actualizado " + (ficheros.length > 1 ? "facturas" : "factura"), 0);
                }
            }
        }
    }

    private String valorNodo(Document document, String ruta) {
        Element element = this.getNodo(document, ruta);
        if (element != null) {
            return element.getText();
        }
        return null;
    }

    private Element getNodo(Document document, String ruta) {
        return (Element)document.selectSingleNode(ruta);
    }

    private void consultarCambioEstado(Client client, String modoDeEjecucion) {
        loggerConector.info("Inicio de consultas de cambio de estado de facturas");
        try {
            File folder = Settings.getSettings().getFolder(Settings.getSettings().getStatusPendingSent());
            InvoiceReceivedBeanSet resultado = client.getLatestUpdatedInvoicesByRol(Settings.getSettings().getFechaUltimaConsulta(), Constantes.FACTURA_EMITIDA_COMO_EMISOR);
            InvoiceReceivedBean[] facturas = resultado.getInvoiceReceivedBeans();
            File ficheroResultado = null;
            InvoiceReceivedBean invoiceReceivedBean = null;
            for (int i = 0; i < facturas.length; ++i) {
                invoiceReceivedBean = facturas[i];
                ficheroResultado = this.getFileStatus(folder.getAbsolutePath() + File.separator + invoiceReceivedBean.getGuid().replaceFirst("_", "") + "-status.xml");
                OperacionesWS.crearFicheroEstado(ficheroResultado, invoiceReceivedBean);
            }
            this.actualizarFechaConsulta();
            MainScreen.updateTree();
            loggerConector.info("Fin de la consultas de cambio de estado de facturas");
        }
        catch (Exception e) {
            loggerError.error("Error al consultar cambio de Estados " + e.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error al consultar cambio de Estados", 0);
        }
    }

    private void actualizarFechaConsulta() throws Exception {
        SAXReader saxReader = new SAXReader();
        try {
            loggerConector.info("Inicia Actualizaci\u00f3n de Fecha  de consultas de cambio de estado de facturas");
            File configFile = Settings.getSettings().getConfigFile();
            Document document = saxReader.read(configFile);
            Element root = document.getRootElement();
            Element persistenciaNode = root.element("persistencia");
            Calendar calendario = GregorianCalendar.getInstance();
            Date fecha = calendario.getTime();
            SimpleDateFormat formatoDeFecha = new SimpleDateFormat("yyyy-MM-dd");
            String fechaTxt = formatoDeFecha.format(fecha);
            persistenciaNode.element("parametros").element("ultimaFechaConsultaCambioEstados").setText(fechaTxt);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(new FileOutputStream(configFile), format);
            writer.write(document);
            loggerConector.info("Fecha de consulta de cambio de estados Actualizada Satisfatoriamente!");
        }
        catch (Exception e) {
            loggerError.error("Error al Actualizar cambio de Estados " + e.getMessage());
            throw new Exception("Problemas al intentar actualizar fecha de consulta de cambio de estados.");
        }
    }

    private static void crearFicheroEstado(File statusFile, InvoiceReceivedBean datosInvoiceReceivedBean) {
        SAXReader saxReader = new SAXReader();
        SimpleDateFormat formatoDeFecha = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Document document = saxReader.read(statusFile);
            String id = datosInvoiceReceivedBean.getGuid().hashCode() < 0 ? String.valueOf(datosInvoiceReceivedBean.getGuid().hashCode() * -1) : String.valueOf(datosInvoiceReceivedBean.getGuid().hashCode());
            Element element = (Element)document.selectSingleNode("//ApplicationResponse/cbc:ID");
            element.addText(id);
            element = (Element)document.selectSingleNode("//ApplicationResponse/cbc:IssueDate");
            element.addText(formatoDeFecha.format(datosInvoiceReceivedBean.getFechaEmision()));
            if (datosInvoiceReceivedBean.getDocumentType().equals("380")) {
                element = (Element)document.selectSingleNode("//ApplicationResponse/cac:SenderParty/cac:PartyIdentification/cbc:ID");
                element.addText(datosInvoiceReceivedBean.getCifPagador());
                element = (Element)document.selectSingleNode("//ApplicationResponse/cac:ReceiverParty/cac:PartyIdentification/cbc:ID");
                element.addText(datosInvoiceReceivedBean.getCifProveedor());
            } else {
                element = (Element)document.selectSingleNode("//ApplicationResponse/cac:SenderParty/cac:PartyIdentification/cbc:ID");
                element.addText(datosInvoiceReceivedBean.getCifProveedor());
                element = (Element)document.selectSingleNode("//ApplicationResponse/cac:ReceiverParty/cac:PartyIdentification/cbc:ID");
                element.addText(datosInvoiceReceivedBean.getCifPagador());
            }
            element = (Element)document.selectSingleNode("//ApplicationResponse/cac:DocumentResponse/cac:Response/cbc:ResponseCode");
            element.addText(datosInvoiceReceivedBean.getCodigoEstado());
            element = (Element)document.selectSingleNode("//ApplicationResponse/cac:DocumentResponse/cac:Response/cbc:Description");
            element.addText(datosInvoiceReceivedBean.getLiteralEstado());
            element = (Element)document.selectSingleNode("//ApplicationResponse/cac:DocumentResponse/cac:DocumentReference/cbc:ID");
            element.addText(datosInvoiceReceivedBean.getGuid().replaceFirst("_", ""));
            element = (Element)document.selectSingleNode("//ApplicationResponse/cac:DocumentResponse/cac:DocumentReference/cbc:DocumentType");
            element.addText(datosInvoiceReceivedBean.getDocumentType());
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(new FileOutputStream(statusFile), format);
            writer.write(document);
            loggerConector.info("Se ha generado fichero de actualzici\u00f3n de estado " + statusFile.getName());
        }
        catch (DocumentException e) {
            loggerError.error("Fallo al generar fichero de actualzici\u00f3n de estado " + statusFile.getName());
        }
        catch (IOException e) {
            loggerError.error("Error en operaci\u00f3n E/S con el fichero de actualzici\u00f3n de estado " + statusFile.getName());
        }
    }

    private File getFileStatus(String nombre) throws IOException {
        int c;
        InputStream in = MenuBar.class.getResourceAsStream("resources/Fichero_Base_Consulta_Estado.xml");
        File fichero = new File(nombre);
        FileOutputStream out = new FileOutputStream(fichero);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
        return fichero;
    }

    private String filesToZip(String pathFicheros, String pathFicheroFactura, String ficheroFactura) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        String[] ficheros = new File(pathFicheros).list();
        String ficheroZip = File.createTempFile("out", ".zip").getName();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(ficheroZip));
        FileInputStream in = null;
        for (int i = 0; i < ficheros.length; ++i) {
            int len2;
            if (new File(ficheros[i]).isHidden()) continue;
            in = new FileInputStream(pathFicheros + File.separator + ficheros[i]);
            out.putNextEntry(new ZipEntry(ficheros[i]));
            while ((len2 = in.read(buf)) > 0) {
                out.write(buf, 0, len2);
            }
            out.closeEntry();
            in.close();
        }
        in = new FileInputStream(pathFicheroFactura + File.separator + ficheroFactura);
        out.putNextEntry(new ZipEntry(ficheroFactura));
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.closeEntry();
        in.close();
        out.close();
        return ficheroZip;
    }

    public boolean enviarFacturas(String modoDeEjecucion) {
        HashMap<String, String> guidsBorrador = new HashMap<String, String>();
        boolean salida = true;
        loggerConector.info("Inicio de enviar facturas");
        try {
            Client client = this.login();
            File folder = Settings.getSettings().getFolder(Settings.getSettings().getPendingSent());
            String[] ficheros = folder.list();
            if (client != null) {
                this.consultarCambioEstado(client, modoDeEjecucion);
                for (int i = 0; i < ficheros.length; ++i) {
                    String factura = folder.getAbsolutePath() + File.separator + ficheros[i];
                    if (new File(factura).isDirectory()) continue;
                    String nombre = new File(factura).getName();
                    String nombreFichero = nombre.lastIndexOf(".") > 0 ? nombre.substring(0, nombre.lastIndexOf(".")) : nombre;
                    String rutaAjuntos = folder.getAbsolutePath() + File.separator + "Att-" + nombreFichero;
                    if (factura != null && factura.trim().length() > 0) {
                        int len;
                        if (new File(rutaAjuntos).exists()) {
                            loggerConector.debug("Enviando Factura " + factura + " con " + new File(rutaAjuntos).list().length + " adjuntos...");
                            String ficheroZip = this.filesToZip(rutaAjuntos, folder.getAbsolutePath(), new File(factura).getName());
                            DataHandler ficheroEntradaDH = new DataHandler(new FileDataSource(ficheroZip));
                            ByteArrayOutputStream salidaBAOS = new ByteArrayOutputStream();
                            ficheroEntradaDH.writeTo(salidaBAOS);
                            salidaBAOS.close();
                            String ficheroEntradaBase64 = org.apache.axis.encoding.Base64.encode(salidaBAOS.toByteArray());
                            SendInvoicesWithAttachmentsBean result = client.sendInvoicesWithAttachmentsBase64(ficheros[i], "380", Settings.getSettings().getTipoFacturaEnviar(), new Integer(102), new Boolean(false), new Boolean(Settings.getSettings().isPreservarIdFiscal()), null, ficheroEntradaBase64);
                            if (result != null && !result.getError() && result.getSendInvoiceBean() != null && result.getSendInvoiceBean().getEstadoImportacion().indexOf("Correcta") != -1) {
                                this.moverFactura(factura, Settings.getSettings().getProcessedSent());
                                this.moverFactura(rutaAjuntos, Settings.getSettings().getProcessedSent());
                                new File(ficheroZip).delete();
                                loggerConector.debug("Factura " + factura + " enviada");
                                guidsBorrador.put(result.getSendInvoiceBean().getCodExterno(), result.getSendInvoiceBean().getEstadoImportacion());
                                continue;
                            }
                            loggerError.error("Error al enviar la factura " + factura + "\n, mensaje Error " + result.getMessage());
                            salida = false;
                            continue;
                        }
                        File facturaOrigen = new File(factura);
                        File temp = File.createTempFile(ficheros[i], ".txt");
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(facturaOrigen));
                        FileOutputStream out = new FileOutputStream(temp);
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                        }
                        in.close();
                        ((OutputStream)out).close();
                        FileDataSource fds = new FileDataSource(temp);
                        DataHandler entrada = new DataHandler(fds);
                        SendFileBeanSet result = null;
                        result = this.sendInvoices(modoDeEjecucion, client, entrada, "380", Settings.getSettings().getTipoFacturaEnviar());
                        if (result != null && !result.getError() && result.getSize() != 0 && result.getElement(0).getEstadoImportacion().indexOf("Correcta") != -1) {
                            this.moverFactura(factura, Settings.getSettings().getProcessedSent());
                            loggerConector.debug("Factura " + factura + " enviada");
                            guidsBorrador.put(result.getElement(0).getGuidBorrador(), result.getElement(0).getEstadoImportacion());
                            continue;
                        }
                        salida = false;
                        loggerError.error("Error al enviar la factura " + factura + "\n, mensaje Error " + result.getMessage());
                        continue;
                    }
                    salida = false;
                    loggerError.error("Error al obtener la direcci\u00f3n de la factura");
                }
                if (guidsBorrador.size() != 0) {
                    MainScreen.updateTree();
                    Thread.sleep(10000L);
                    Set guidsBorradorSinDuplicados = guidsBorrador.keySet();
                    Iterator iterator = guidsBorradorSinDuplicados.iterator();
                    String[] guids = new String[guidsBorrador.size()];
                    int i = 0;
                    while (iterator.hasNext()) {
                        guids[i] = (String)iterator.next();
                        ++i;
                    }
                    GUIDFacturaBeanSet guidFacturaSet = client.getDefinitiveGUIDs(guids);
                    if (guidFacturaSet.getSize() != 0) {
                        if (Settings.getSettings().isAutoPDFEnvio()) {
                            loggerConector.info("Bajando Facturas enviadas en PDF.");
                            this.bajarFacturasFormato(modoDeEjecucion, guidFacturaSet, client, "PDF");
                        }
                        if (Settings.getSettings().isAutoFirmadaEnvio()) {
                            loggerConector.info("Bajando Facturas enviadas firmadas.");
                            this.bajarFacturasFormato(modoDeEjecucion, guidFacturaSet, client, "COPIA");
                        }
                        loggerConector.info("El proceso de env\u00edo de facturas finaliz\u00f3 correctamente.");
                        this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", "El proceso de env\u00edo de facturas finaliz\u00f3 correctamente.\n", 0);
                    }
                }
            }
            client.logout();
        }
        catch (FileNotFoundException fe) {
            salida = false;
            loggerError.error("Error al intentar ubicar el fichero de configuraciones" + fe.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error al intentar ubicar el fichero de configuraciones ", 0);
        }
        catch (LoginException le) {
            salida = false;
            loggerError.error("Error. Ha habido un fallo en la conexion al servidor (al realizar el login)" + le.getMessage());
            le.printStackTrace();
            this.visualizaError(modoDeEjecucion, "Error", "Error. Ha habido un fallo en la conexion al servidor (al realizar el login).\n\n", 0);
        }
        catch (SecurityException se) {
            salida = false;
            loggerError.error("Problemas de permisos al guardar/leer las facturas enviadas, " + se.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas en guardar las facturas recibidas\n", 0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            salida = false;
            loggerError.error("Error Cr\u00edtico en enviar factura, " + t.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error cr\u00edtico al enviar facturas\n", 0);
        }
        loggerConector.info("Fin de enviar facturas");
        return salida;
    }

    public boolean enviarFacturasPlanificador(String modoDeEjecucion) {
        HashMap<String, String> guidsBorrador = new HashMap<String, String>();
        boolean salida = true;
        loggerConector.info("Inicio de enviar facturas desde el Planificador");
        try {
            Client client = this.login();
            File folder = Settings.getSettings().getFolder(Settings.getSettings().getPendingSent());
            String[] ficheros = folder.list();
            if (client != null) {
                for (int i = 0; i < ficheros.length; ++i) {
                    String factura = folder.getAbsolutePath() + File.separator + ficheros[i];
                    if (factura != null && factura.trim().length() > 0) {
                        int len;
                        File facturaOrigen = new File(factura);
                        File temp = File.createTempFile(ficheros[i], ".txt");
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(facturaOrigen));
                        FileOutputStream out = new FileOutputStream(temp);
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                        }
                        in.close();
                        ((OutputStream)out).close();
                        FileDataSource fds = new FileDataSource(temp);
                        DataHandler entrada = new DataHandler(fds);
                        SendFileBeanSet result = this.sendInvoices(modoDeEjecucion, client, entrada, "380", Settings.getSettings().getTipoFacturaEnviar());
                        if (result.getSize() != 0 && result.getElement(0).getEstadoImportacion().indexOf("Correcta") != -1) {
                            this.moverFactura(factura, Settings.getSettings().getProcessedSent());
                            loggerConector.debug("Factura " + factura + " enviada desde el Planificador");
                            guidsBorrador.put(result.getElement(0).getGuidBorrador(), result.getElement(0).getEstadoImportacion());
                            continue;
                        }
                        salida = false;
                        loggerConector.debug("Error al enviar la factura " + factura + " desde el Planificador.");
                        continue;
                    }
                    salida = false;
                    loggerError.error("Error al obtener la direcci\u00f3n de la factura desde el planificador.");
                }
                if (guidsBorrador.size() != 0) {
                    Thread.sleep(10000L);
                    Set guidsBorradorSinDuplicados = guidsBorrador.keySet();
                    Iterator iterator = guidsBorradorSinDuplicados.iterator();
                    String[] guids = new String[guidsBorrador.size()];
                    int i = 0;
                    while (iterator.hasNext()) {
                        guids[i] = (String)iterator.next();
                        ++i;
                    }
                    GUIDFacturaBeanSet guidFacturaSet = client.getDefinitiveGUIDs(guids);
                    if (guidFacturaSet.getSize() != 0) {
                        if (Settings.getSettings().isAutoPDFEnvio()) {
                            loggerConector.info("Bajando Facturas enviadas en PDF desde del planificador.");
                            this.bajarFacturasFormato(modoDeEjecucion, guidFacturaSet, client, "PDF");
                        }
                        if (Settings.getSettings().isAutoFirmadaEnvio()) {
                            loggerConector.info("Bajando Facturas enviadas firmadas desde el planificador.");
                            this.bajarFacturasFormato(modoDeEjecucion, guidFacturaSet, client, "COPIA");
                        }
                    }
                    loggerConector.info("El proceso de env\u00edo de facturas finaliz\u00f3 correctamente.");
                    this.visualizaError(modoDeEjecucion, "Informaci\u00f3n", "El proceso de env\u00edo de facturas finaliz\u00f3 correctamente.\n");
                }
            }
            client.logout();
        }
        catch (FileNotFoundException fe) {
            salida = false;
            loggerError.error("Error al intentar ubicar el fichero de configuraciones " + fe.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error al intentar ubicar el fichero de configuraciones ");
        }
        catch (LoginException le) {
            salida = false;
            loggerError.error("Error. Ha habido un fallo en la conexion al servidor (al realizar el login). " + le.getMessage());
            le.printStackTrace();
            this.visualizaError(modoDeEjecucion, "Error", "Error. Ha habido un fallo en la conexion al servidor (al realizar el login).\n");
        }
        catch (SecurityException se) {
            salida = false;
            loggerError.error("Problemas de permisos al guardar/leer las facturas enviadas, " + se.getMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error. Problemas en guardar las facturas recibidas\n");
        }
        catch (Throwable t) {
            salida = false;
            loggerError.error("Error Cr\u00edtico en enviar factura, " + t.getLocalizedMessage());
            this.visualizaError(modoDeEjecucion, "Error", "Error cr\u00edtico al enviar facturas\n");
        }
        loggerConector.info("Fin de recibir facturas");
        return salida;
    }

    private String leerFactura(String factura) {
        String salida = "";
        try {
            String linea = "";
            BufferedReader br = new BufferedReader(new FileReader(factura));
            linea = br.readLine();
            while (linea != null) {
                salida = salida + linea;
                linea = br.readLine();
            }
            br.close();
        }
        catch (IOException ioe) {
            loggerError.error("Error en la lectura de la factura " + factura + " al enviar");
        }
        catch (Throwable t) {
            loggerError.error("Error al leer factura");
        }
        return salida;
    }

    public boolean moverFactura(String factura, String moverA) {
        boolean error = true;
        try {
            boolean out;
            File fileFactu = new File(factura);
            File direc = new File(moverA + File.separator + fileFactu.getName());
            if (direc.exists()) {
                loggerError.error("Factura " + factura + " ya existe en processed. Se borrara de pending");
                fileFactu.renameTo(direc);
                out = fileFactu.delete();
            } else {
                out = fileFactu.renameTo(direc);
            }
            System.out.println(factura);
            if (!out) {
                error = false;
                loggerError.error("Error moviendo el fichero");
            }
        }
        catch (SecurityException se) {
            error = false;
            loggerError.error("Error al mover la factura " + se.getLocalizedMessage());
        }
        catch (NullPointerException npe) {
            error = false;
            npe.printStackTrace();
            loggerError.error("Nombre erroneo " + npe.getLocalizedMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return error;
    }

    private SendFileBeanSet sendFile(Client client, DataHandler entrada, String tipoDoc, String formatoDoc) {
        SendFileBeanSet sale = null;
        try {
            sale = client.sendFile(entrada, tipoDoc, formatoDoc);
            loggerConector.info(sale.getElement(0).getEstadoImportacion());
            if (sale.getElement(0).getEstadoImportacion().indexOf("Incorrecta") != -1) {
                loggerError.error("Error de envio de facturas: " + sale.getElement(0).getEstadoImportacion());
            }
            if (sale.getError()) {
                loggerError.error("Error en el envio de facturas: " + sale.getError());
            }
        }
        catch (Throwable e) {
            loggerError.error("Error");
        }
        return sale;
    }

    private SendFileBeanSet sendInvoices(String modoDeEjecucion, Client client, DataHandler entrada, String tipoDoc, String formatoDoc) {
        SendFileBeanSet sale = null;
        try {
            ByteArrayOutputStream salidaBAOS = new ByteArrayOutputStream();
            entrada.writeTo(salidaBAOS);
            salidaBAOS.close();
            String entradaBase64 = org.apache.axis.encoding.Base64.encode(salidaBAOS.toByteArray());
            sale = client.sendInvoicesBase64(tipoDoc, formatoDoc, new Integer(102), new Boolean(false), new Boolean(Settings.getSettings().isPreservarIdFiscal()), null, entradaBase64);
            loggerConector.info(sale.getElement(0).getEstadoImportacion());
            if (sale.getElement(0).getEstadoImportacion().indexOf("Incorrecta") != -1) {
                loggerError.error("Error de envio de facturas: " + sale.getElement(0).getEstadoImportacion());
                this.visualizaError(modoDeEjecucion, "Error de envio de facturas", sale.getElement(0).getEstadoImportacion());
            }
            if (sale.getError()) {
                loggerError.error("Error en el envio de facturas: " + sale.getError());
                this.visualizaError(modoDeEjecucion, "Error de envio de facturas", sale.getMessage());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            loggerError.error("Error codificando la factura -> " + ioe.getMessage());
        }
        catch (Throwable e) {
            loggerError.error("Error");
        }
        return sale;
    }
}

