/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.TransliteratorIDParser;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.text.UnicodeSet;
import java.util.Vector;

public class CompoundTransliterator
extends Transliterator {
    private Transliterator[] trans;
    private int compoundRBTIndex;
    private static final String COPYRIGHT = "\u00a9 IBM Corporation 1999-2001. All rights reserved.";

    public CompoundTransliterator(Transliterator[] transliterators, UnicodeFilter filter) {
        super(CompoundTransliterator.joinIDs(transliterators), filter);
        this.trans = new Transliterator[transliterators.length];
        System.arraycopy(transliterators, 0, this.trans, 0, this.trans.length);
        this.computeMaximumContextLength();
    }

    public CompoundTransliterator(Transliterator[] transliterators) {
        this(transliterators, null);
    }

    public CompoundTransliterator(String ID, int direction, UnicodeFilter filter) {
        super(ID, filter);
        this.init(ID, direction, -1, null, true);
    }

    public CompoundTransliterator(String ID, int direction) {
        this(ID, direction, null);
    }

    public CompoundTransliterator(String ID) {
        this(ID, 0, null);
    }

    CompoundTransliterator(String ID, String idBlock, int idSplitPoint, Transliterator splitTrans) {
        super(ID, null);
        this.init(idBlock, 0, idSplitPoint, splitTrans, false);
    }

    CompoundTransliterator(Vector list) {
        super("", null);
        this.trans = null;
        this.compoundRBTIndex = -1;
        this.init(list, 0, false);
    }

    private void init(String id, int direction, int idSplitPoint, Transliterator splitTrans, boolean fixReverseID) {
        StringBuffer regenID = new StringBuffer();
        Vector list = new Vector();
        UnicodeSet[] compoundFilter = new UnicodeSet[1];
        if (!TransliteratorIDParser.parseCompoundID(id, direction, regenID, list, compoundFilter)) {
            throw new IllegalArgumentException("Invalid ID " + id);
        }
        this.compoundRBTIndex = TransliteratorIDParser.instantiateList(list, splitTrans, idSplitPoint);
        this.init(list, direction, fixReverseID);
        if (compoundFilter[0] != null) {
            this.setFilter(compoundFilter[0]);
        }
    }

    private void init(Vector list, int direction, boolean fixReverseID) {
        int count = list.size();
        this.trans = new Transliterator[count];
        int i = 0;
        while (i < count) {
            int j = direction == 0 ? i : count - 1 - i;
            this.trans[i] = (Transliterator)list.elementAt(j);
            ++i;
        }
        if (this.compoundRBTIndex >= 0 && direction == 1) {
            this.compoundRBTIndex = count - 1 - this.compoundRBTIndex;
        }
        if (direction == 1 && fixReverseID) {
            StringBuffer newID = new StringBuffer();
            i = 0;
            while (i < count) {
                if (i > 0) {
                    newID.append(';');
                }
                newID.append(this.trans[i].getID());
                ++i;
            }
            this.setID(newID.toString());
        }
        this.computeMaximumContextLength();
    }

    private static String joinIDs(Transliterator[] transliterators) {
        StringBuffer id = new StringBuffer();
        int i = 0;
        while (i < transliterators.length) {
            if (i > 0) {
                id.append(';');
            }
            id.append(transliterators[i].getID());
            ++i;
        }
        return id.toString();
    }

    public int getCount() {
        return this.trans.length;
    }

    public Transliterator getTransliterator(int index) {
        return this.trans[index];
    }

    private static void _smartAppend(StringBuffer buf, char c) {
        if (buf.length() != 0 && buf.charAt(buf.length() - 1) != c) {
            buf.append(c);
        }
    }

    public String toRules(boolean escapeUnprintable) {
        StringBuffer rulesSource = new StringBuffer();
        if (this.compoundRBTIndex >= 0 && this.getFilter() != null) {
            rulesSource.append("::").append(this.getFilter().toPattern(escapeUnprintable)).append(';');
        }
        int i = 0;
        while (i < this.trans.length) {
            String rule = i == this.compoundRBTIndex ? this.trans[i].toRules(escapeUnprintable) : this.trans[i].baseToRules(escapeUnprintable);
            CompoundTransliterator._smartAppend(rulesSource, '\n');
            rulesSource.append(rule);
            CompoundTransliterator._smartAppend(rulesSource, ';');
            ++i;
        }
        return rulesSource.toString();
    }

    protected UnicodeSet handleGetSourceSet() {
        UnicodeSet set = new UnicodeSet();
        int i = 0;
        while (i < this.trans.length) {
            set.addAll(this.trans[i].getSourceSet());
            if (!set.isEmpty()) break;
            ++i;
        }
        return set;
    }

    public UnicodeSet getTargetSet() {
        UnicodeSet set = new UnicodeSet();
        int i = 0;
        while (i < this.trans.length) {
            set.addAll(this.trans[i].getTargetSet());
            ++i;
        }
        return set;
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position index, boolean incremental) {
        if (this.trans.length < 1) {
            index.start = index.limit;
            return;
        }
        int compoundLimit = index.limit;
        int compoundStart = index.start;
        int delta = 0;
        Object log = null;
        int i = 0;
        while (i < this.trans.length) {
            index.start = compoundStart;
            int limit = index.limit;
            if (index.start == index.limit) break;
            this.trans[i].filteredTransliterate(text, index, incremental);
            if (!incremental && index.start != index.limit) {
                throw new RuntimeException("ERROR: Incomplete non-incremental transliteration by " + this.trans[i].getID());
            }
            delta += index.limit - limit;
            if (incremental) {
                index.limit = index.start;
            }
            ++i;
        }
        index.limit = compoundLimit += delta;
    }

    private void computeMaximumContextLength() {
        int max = 0;
        int i = 0;
        while (i < this.trans.length) {
            int len = this.trans[i].getMaximumContextLength();
            if (len > max) {
                max = len;
            }
            ++i;
        }
        this.setMaximumContextLength(max);
    }
}

