/*
 * Decompiled with CFR 0.152.
 */
package eurobits.efactura.ws.clients.erp;

import eurobits.efactura.util.RAPTripleDes;
import eurobits.efactura.ws.clients.erp.EFacturaXMLWSSoapBindingStub;
import eurobits.efactura.ws.clients.erp.ServiceXMLServiceLocator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.activation.DataHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClientXML {
    private static URL endpointURL;
    private static ServiceXMLServiceLocator service;
    private static EFacturaXMLWSSoapBindingStub eFacturaXMLWSSoapBindingStub;
    private static final String VERSION = "version";
    private static final String PETICIONERP = "peticionErp";
    private static final String LLAVE = "llave";
    private static final String CODBANCO = "codBanco";
    private static final String LOGIN = "login";
    private static final String CIFREPRESENTADA = "cifRepresentada";
    private static final String ALIASINDIVIDUO = "aliasIndividuo";
    private static final String DELEGACIONREPRESENTADA = "delegacionRepresentada";
    private static final String DELEGACIONGESTORA = "delegacionGestora";
    private static String ticket;
    private static DocumentBuilder builder;
    private static final String TICKET = "ticket";

    public ClientXML(String wsAddress) {
        try {
            endpointURL = new URL(wsAddress);
            service = new ServiceXMLServiceLocator();
            service.setMaintainSession(true);
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            eFacturaXMLWSSoapBindingStub = new EFacturaXMLWSSoapBindingStub(endpointURL, service);
            new RAPTripleDes();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setWsAddress(String wsAddressValue) {
        try {
            endpointURL = new URL(wsAddressValue);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getWsAddress() {
        return endpointURL.getHost();
    }

    private static DocumentBuilder getBuilder() {
        if (builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder;
    }

    private String getXMLTicket() throws Exception {
        Document dom = ClientXML.getBuilder().newDocument();
        Element e = dom.createElement(TICKET);
        e.appendChild(dom.createTextNode(ticket));
        dom.appendChild(e);
        return ClientXML.obtenerStringDoc(dom);
    }

    private void loadTicket(String xml) throws SAXException, IOException {
        Document dom = null;
        dom = ClientXML.getBuilder().parse(new InputSource(new StringReader(xml)));
        if (dom != null && dom.getElementsByTagName(TICKET) != null && dom.getElementsByTagName(TICKET).item(0) != null && dom.getElementsByTagName(TICKET).item(0).getFirstChild() != null) {
            ticket = dom.getElementsByTagName(TICKET).item(0).getFirstChild().getNodeValue();
        }
    }

    public String login(String urlParam, String llaveCifrada, String password, String version, String cifRepresentada, String aliasIndividuo, String delegacionRepresentada, String delegacionGestora) throws IOException, SAXException, Exception, Throwable {
        endpointURL = new URL(urlParam);
        String llave = null;
        llave = RAPTripleDes.descifra3DES(llaveCifrada, password);
        String xmlIn = null;
        Document dom = ClientXML.getBuilder().newDocument();
        Element peticionErp = dom.createElement(PETICIONERP);
        Element versionE = dom.createElement(VERSION);
        versionE.appendChild(dom.createTextNode(version));
        peticionErp.appendChild(versionE);
        Element login = dom.createElement(LOGIN);
        Element codBanco = dom.createElement(CODBANCO);
        Element llaveE = dom.createElement(LLAVE);
        Element cifRepresentadaE = dom.createElement(CIFREPRESENTADA);
        Element aliasIndividuoE = dom.createElement(ALIASINDIVIDUO);
        Element delegacionRE = dom.createElement(DELEGACIONREPRESENTADA);
        Element delegacionGE = dom.createElement(DELEGACIONGESTORA);
        dom.appendChild(peticionErp);
        peticionErp.appendChild(login);
        login.appendChild(codBanco);
        login.appendChild(llaveE);
        if (cifRepresentada != null && !cifRepresentada.equals("")) {
            login.appendChild(cifRepresentadaE);
            cifRepresentadaE.appendChild(dom.createTextNode(cifRepresentada));
        }
        if (aliasIndividuo != null && !aliasIndividuo.equals("")) {
            login.appendChild(aliasIndividuoE);
            aliasIndividuoE.appendChild(dom.createTextNode(aliasIndividuo));
        }
        if (delegacionRepresentada != null && !delegacionRepresentada.equals("")) {
            login.appendChild(delegacionRE);
            delegacionRE.appendChild(dom.createTextNode(delegacionRepresentada));
        }
        if (delegacionGestora != null && !delegacionGestora.equals("")) {
            login.appendChild(delegacionGE);
            delegacionGE.appendChild(dom.createTextNode(delegacionGestora));
        }
        llaveE.appendChild(dom.createTextNode(llave));
        xmlIn = ClientXML.obtenerStringDoc(dom);
        String str = eFacturaXMLWSSoapBindingStub.login(xmlIn);
        this.loadTicket(str);
        eFacturaXMLWSSoapBindingStub._getCall().getMessageContext().setUsername(str);
        return str;
    }

    public String logout() throws IOException, Exception, Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.logout(xmlTicketIn);
        eFacturaXMLWSSoapBindingStub._getCall().getMessageContext().setUsername(null);
        ticket = null;
        return str;
    }

    public String sendFile(String xmlIn, DataHandler ficheroEntrada) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.sendFile(xmlTicketIn, xmlIn, ficheroEntrada);
        return str;
    }

    public String sendInvoices(String xmlIn, String ficheroEntrada) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.sendInvoicesBase64(xmlTicketIn, xmlIn, ficheroEntrada);
        return str;
    }

    public String sendInvoices(String xmlIn, DataHandler ficheroEntrada) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.sendInvoices(xmlTicketIn, xmlIn, ficheroEntrada);
        return str;
    }

    public String getDefinitiveGUIDs(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getDefinitiveGUIDs(xmlTicketIn, xmlIn);
        return str;
    }

    public DataHandler getInvoicesData(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        return eFacturaXMLWSSoapBindingStub.getInvoicesData(xmlTicketIn, xmlIn);
    }

    public String getInvoicesDataBase64(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        return eFacturaXMLWSSoapBindingStub.getInvoicesDataBase64(xmlTicketIn, xmlIn);
    }

    public String getInvoicesReceived(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getInvoicesReceived(xmlTicketIn, xmlIn);
        return str;
    }

    public String getInvoicesStatus(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getInvoicesStatus(xmlTicketIn, xmlIn);
        return str;
    }

    public String setInvoicesStatus(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.setInvoicesStatus(xmlTicketIn, xmlIn);
        return str;
    }

    public String getLatestUpdatedInvoices(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getLatestUpdatedInvoices(xmlTicketIn, xmlIn);
        return str;
    }

    public String addAttachment(String xmlIn, DataHandler ficheroEntrada) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.addAttachment(xmlTicketIn, xmlIn, ficheroEntrada);
        return str;
    }

    public String listAttachments(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.listAttachments(xmlTicketIn, xmlIn);
        return str;
    }

    public String removeAttachment(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.removeAttachment(xmlTicketIn, xmlIn);
        return str;
    }

    public DataHandler downloadAttachment(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        return eFacturaXMLWSSoapBindingStub.downloadAttachment(xmlTicketIn, xmlIn);
    }

    public String downloadAttachmentBase64(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        return eFacturaXMLWSSoapBindingStub.downloadAttachmentBase64(xmlTicketIn, xmlIn);
    }

    public String sendFileWithAttachments(String xmlIn, DataHandler ficheroEntrada) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        return eFacturaXMLWSSoapBindingStub.sendFileWithAttachments(xmlTicketIn, xmlIn, ficheroEntrada);
    }

    public String sendInvoicesWithAttachments(String xmlIn, DataHandler ficheroEntrada) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        return eFacturaXMLWSSoapBindingStub.sendInvoicesWithAttachments(xmlTicketIn, xmlIn, ficheroEntrada);
    }

    public String sendInvoicesWithAttachmentsAndSeries(String xmlIn, DataHandler ficheroEntrada) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        return eFacturaXMLWSSoapBindingStub.sendInvoicesWithAttachmentsAndSeries(xmlTicketIn, xmlIn, ficheroEntrada);
    }

    public String sendInvoicesWithSeries(String xmlIn, DataHandler ficheroEntrada) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        return eFacturaXMLWSSoapBindingStub.sendInvoicesWithSeries(xmlTicketIn, xmlIn, ficheroEntrada);
    }

    public String getComments(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getComments(xmlTicketIn, xmlIn);
        return str;
    }

    public String setComments(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.setComments(xmlTicketIn, xmlIn);
        return str;
    }

    public static String obtenerStringDoc(Document doc) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        String xmlString = sw.toString();
        return xmlString;
    }

    public String getInvoicesBase64(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getInvoicesBase64(xmlTicketIn, xmlIn);
        return str;
    }

    public String getInvoicesDataFilterBase64(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getInvoicesDataFilterBase64(xmlTicketIn, xmlIn);
        return str;
    }

    public String getInvoicesDataStatus(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getInvoicesDataStatus(xmlTicketIn, xmlIn);
        return str;
    }

    public String getInvoicesReceivedFilter(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getInvoicesReceivedFilter(xmlTicketIn, xmlIn);
        return str;
    }

    public String getLatestUpdatedInvoicesByRol(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getLatestUpdatedInvoicesByRol(xmlTicketIn, xmlIn);
        return str;
    }

    public String getMetaData(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getMetaData(xmlTicketIn, xmlIn);
        return str;
    }

    public String getReceivedInvoicesBase64(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getReceivedInvoicesBase64(xmlTicketIn, xmlIn);
        return str;
    }

    public String getSentInvoicesBase64(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.getSentInvoicesBase64(xmlTicketIn, xmlIn);
        return str;
    }

    public String loginPWD(String xmlIn) throws Throwable {
        String str = eFacturaXMLWSSoapBindingStub.loginPWD(xmlIn);
        this.loadTicket(str);
        return str;
    }

    public String rejectInvoices(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.rejectInvoices(xmlTicketIn, xmlIn);
        return str;
    }

    public String removeMetaData(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.removeMetaData(xmlTicketIn, xmlIn);
        return str;
    }

    public String sendInvoicesForStorageBase64(String xmlIn, String ficheroEntrada) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.sendInvoicesForStorageBase64(xmlTicketIn, xmlIn, ficheroEntrada);
        return str;
    }

    public String setInvoicesDataStatus(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.setInvoicesDataStatus(xmlTicketIn, xmlIn);
        return str;
    }

    public String setMetaData(String xmlIn) throws Throwable {
        String xmlTicketIn = this.getXMLTicket();
        String str = eFacturaXMLWSSoapBindingStub.setMetaData(xmlTicketIn, xmlIn);
        return str;
    }
}

