/*
 * Decompiled with CFR 0.152.
 */
package eurobits.efactura.ws.clients;

import eurobits.efactura.ws.bean.AddAttachmentBean;
import eurobits.efactura.ws.bean.AttachmentFileBeanSet;
import eurobits.efactura.ws.bean.DataHandlerBean;
import eurobits.efactura.ws.bean.GUIDFacturaBeanSet;
import eurobits.efactura.ws.bean.InvoiceReceivedBeanSet;
import eurobits.efactura.ws.bean.InvoiceStatusBeanSet;
import eurobits.efactura.ws.bean.LoginBean;
import eurobits.efactura.ws.bean.LogoutBean;
import eurobits.efactura.ws.bean.RemoveAttachmentBean;
import eurobits.efactura.ws.bean.SendFileBean;
import eurobits.efactura.ws.bean.SendFileBeanSet;
import eurobits.efactura.ws.clients.erp.Client;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;

public class PruebaWS {
    protected static String url = "http://zaz-mainars.tb-solutions.com:8081/frontend/services/eFacturaWS";
    protected static String fichero = "/tmp/eblocal/llaveERP.txt";
    protected static String contrasena = "adios";
    protected static String cifUsuario = "29116004M";
    protected static String entorno = "";
    protected static int facturasPorZip = 1;
    protected static String facturaFile = "./xml/factura.xml";
    protected static int cuantasThread = 1;
    private static StringBuffer[] errorGlobal = new StringBuffer[]{new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer(), new StringBuffer()};
    protected static String facturaOrigen;
    private static final SimpleDateFormat fechaFacNoFormtd;

    protected static synchronized void error(int i) {
        errorGlobal[i].append("X");
    }

    protected static synchronized void ok(int i) {
        errorGlobal[i].append(".");
    }

    public static void main(String[] args) {
        System.out.println("================ Prueba WS: inicio  =======================");
        for (int i = 0; i < args.length - 1; i += 2) {
            String key = args[i];
            String value = args[i + 1];
            if ("-e".equalsIgnoreCase(key)) {
                entorno = value;
                if (entorno.equalsIgnoreCase("eflocal")) {
                    url = "http://localhost:7000/efactura/services/FacturaElectronica.cmjws";
                    cifUsuario = "72983659J";
                    fichero = "/tmp/eflocal/llaveERP.txt";
                    contrasena = "adios";
                } else if (entorno.equalsIgnoreCase("judith")) {
                    url = "http://judith:7003/integraweb_cm/services/FacturaElectronica.cmjws";
                    cifUsuario = "72983659J";
                    fichero = "/tmp/eflocal/llaveERP.txt";
                    contrasena = "adios";
                } else if (entorno.equalsIgnoreCase("eblocal")) {
                    url = "http://localhost/frontend/services/eFacturaWS";
                    cifUsuario = "25475237T";
                    fichero = "/tmp/eblocal/llaveERP.txt";
                    contrasena = "adios";
                } else if (entorno.equalsIgnoreCase("eurobits")) {
                    url = "http://frontend.efactura.eurobits.es:8980/frontend/services/eFacturaWS";
                    cifUsuario = "25483953E";
                    fichero = "/tmp/eurobits/llaveERP.txt";
                    contrasena = "adios";
                } else if (entorno.equalsIgnoreCase("pi")) {
                    url = "https://10.2.75.132:25001/oie-wl/services/FacturaElectronica.cmjws";
                    cifUsuario = "02604830B";
                    fichero = "/tmp/pi/llaveERP.txt";
                    contrasena = "adios";
                } else if (entorno.equalsIgnoreCase("cmpr")) {
                    url = "https://oie.cajamadridempresas.es/oie-wl/services/FacturaElectronica.cmjws";
                    cifUsuario = "B82917220";
                    fichero = "/tmp/cmpr/llaveERP.txt";
                    contrasena = "adios";
                } else if (entorno.equalsIgnoreCase("p54")) {
                    url = "https://10.53.0.54:115/oie-wl/services/FacturaElectronica.cmjws";
                    cifUsuario = "02604830B";
                    fichero = "/tmp/p54/llaveERP.txt";
                    contrasena = "adios";
                } else if (entorno.equalsIgnoreCase("lafuentej")) {
                    url = "http://zaz-mainars.tb-solutions.com:8081/frontend/services/eFacturaWS";
                    cifUsuario = "29116004M";
                    fichero = "/tmp/eflocal/llaveERP.txt";
                    contrasena = "adios";
                } else {
                    System.out.println("***** Configuracion de entornos para ejecutar *****");
                    System.out.println("*** efactura local : -e eflocal ***");
                    System.out.println("*** efactura judith : -e judith ***");
                    System.out.println("*** eurobits local : -e eblocal ***");
                    System.out.println("*** 54 local : -e p54 ***");
                    System.out.println("*** pi : -e pi ***");
                    System.out.println("*** caja madrid produccion : -e cmpr ***");
                    System.out.println("****************************************************");
                    System.out.println("Ejecutando entorno por defecto: EFACTURA JUDITH");
                    System.out.println("****************************************************");
                }
            }
            if ("-cif".equalsIgnoreCase(key)) {
                cifUsuario = value;
            }
            if ("-url".equalsIgnoreCase(key)) {
                url = value;
            }
            if ("-l".equalsIgnoreCase(key)) {
                fichero = value;
            }
            if ("-p".equalsIgnoreCase(key)) {
                contrasena = value;
            }
            if ("-n".equalsIgnoreCase(key)) {
                facturasPorZip = Integer.parseInt(value);
            }
            if ("-f".equalsIgnoreCase(key)) {
                facturaFile = value;
            }
            if (!"-t".equalsIgnoreCase(key)) continue;
            cuantasThread = Integer.parseInt(value);
        }
        System.out.println("  == URL a la que se conecta (-url)  : " + url);
        System.out.println("  == CIF del usuario (-cif)          : " + cifUsuario);
        System.out.println("  == Llave para el login (-l)        : " + fichero);
        System.out.println("  == Pass para el login (-p)         : " + contrasena);
        System.out.println("  == Facturas por zip (-n)           : " + facturasPorZip);
        System.out.println("  == Factura de ejemplo (-f)         : " + facturaFile);
        System.out.println("  == Threads concurrentes (-t)       : " + cuantasThread);
        try {
            FileInputStream origen = new FileInputStream(facturaFile);
            byte[] bytes = new byte[origen.available()];
            origen.read(bytes);
            facturaOrigen = new String(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        miThread[] miThreads = new miThread[cuantasThread];
        for (int i = 0; i < cuantasThread; ++i) {
            miThreads[i] = new miThread(i);
            miThreads[i].start();
        }
    }

    static {
        fechaFacNoFormtd = new SimpleDateFormat("yyyy-MM-dd");
    }

    static class miThread
    extends Thread {
        private int miNumero;
        private Client client;

        miThread(int cualSoy) {
            this.miNumero = cualSoy;
            this.setPriority(1 + cualSoy % 9);
        }

        @Override
        public void run() {
            this.client = new Client();
            this.pruebaLogin();
            String[] borradores = this.pruebaSendFile();
            this.pruebaLogout();
            this.sale();
        }

        private void pruebaLogin() {
            File f = new File(fichero);
            byte[] bytesCifradosBase64 = new byte[(int)f.length()];
            try {
                DataInputStream in = new DataInputStream(new FileInputStream(f));
                in.readFully(bytesCifradosBase64);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println(url);
            LoginBean sale = this.client.login(url, new String(bytesCifradosBase64), contrasena);
            this.log("pruebaLogin", "Resultado: " + sale);
            if (sale.getError()) {
                PruebaWS.error(0);
            } else {
                PruebaWS.ok(0);
                try {
                    FileOutputStream fos = new FileOutputStream(fichero);
                    fos.write(sale.getLlaveCifrada().getBytes());
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void pruebaLogout() {
            LogoutBean sale = this.client.logout();
            this.log("pruebaLogout", "Resultado: " + sale);
            if (sale.getError()) {
                PruebaWS.error(1);
            } else {
                PruebaWS.ok(1);
            }
        }

        private String[] pruebaSendFile() {
            String[] saleArray = null;
            String file = "paquete" + this.miNumero + ".zip";
            try {
                FileOutputStream dest = new FileOutputStream(file);
                ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
                int y = facturaOrigen.indexOf("########");
                String factura = facturaOrigen.substring(0, y) + cifUsuario + facturaOrigen.substring(y + 8);
                String fechaFac = miThread.getFormated(new Date());
                int f = factura.indexOf("##FECHA##");
                factura = factura.substring(0, f) + fechaFac + factura.substring(f + 9);
                String name = String.valueOf(System.currentTimeMillis());
                for (int i = 0; i < facturasPorZip; ++i) {
                    ZipEntry entry = new ZipEntry(name + "__" + i + ".xml");
                    int x = factura.indexOf("#####");
                    String estaFactura = factura.substring(0, x) + name + "__" + this.miNumero + "__" + i + factura.substring(x + 5);
                    out.putNextEntry(entry);
                    out.write(estaFactura.getBytes());
                }
                out.close();
                DataHandler entrada = new DataHandler(new FileDataSource(file));
                SendFileBeanSet sale = this.client.sendFile(entrada, "1", "UBL10");
                if (sale.getError()) {
                    PruebaWS.error(2);
                } else {
                    PruebaWS.ok(2);
                }
                this.log("pruebaSendFile", "Cuantos: " + sale.getSize());
                this.log("pruebaSendFile", "Resultado: " + sale);
                this.para(10000);
                if (sale.getSize() != -1) {
                    saleArray = new String[sale.getSize()];
                    for (int i = 0; i < sale.getSendFileBeans().length; ++i) {
                        SendFileBean bean = sale.getSendFileBeans()[i];
                        saleArray[i] = bean.getGuidBorrador();
                    }
                }
            }
            catch (Throwable e) {
                PruebaWS.error(2);
                e.printStackTrace();
            }
            return saleArray;
        }

        private String[] pruebaGetDefinitiveGUIDs(String[] borradores, String delegacion) {
            GUIDFacturaBeanSet sale = null;
            String[] saleArray = null;
            try {
                int i;
                for (i = 0; i < borradores.length; ++i) {
                    this.log("pruebaGetDefinitiveGUIDs", "borradores: " + borradores[i]);
                }
                sale = this.client.getDefinitiveGUIDs(borradores);
                if (sale.getError()) {
                    PruebaWS.error(3);
                } else {
                    PruebaWS.ok(3);
                }
                saleArray = new String[sale.getSize()];
                for (i = 0; i < saleArray.length; ++i) {
                    saleArray[i] = sale.getElement(i).getGUID();
                    this.log("pruebaGetDefinitiveGUIDs", "definitivos: " + saleArray[i]);
                }
            }
            catch (Exception e) {
                PruebaWS.error(3);
                e.printStackTrace();
            }
            this.log("pruebaGetDefinitiveGUIDs", "Resultado: " + sale);
            return saleArray;
        }

        private void pruebaGetInvoicesData(String[] definitivos) {
            String formato = "COPIA";
            String fileSale = "Salida.zip";
            DataHandlerBean sale = null;
            try {
                String[] cifs = new String[definitivos.length];
                for (int i = 0; i < cifs.length; ++i) {
                    cifs[i] = cifUsuario;
                }
                sale = this.client.getInvoicesData(definitivos, cifs, formato);
                if (sale.getError()) {
                    PruebaWS.error(4);
                } else {
                    PruebaWS.ok(4);
                }
                DataHandler data = sale.getDataHandler();
                if (!sale.getError() && data != null) {
                    File prueba = new File(fileSale);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(prueba));
                    data.writeTo(out);
                    out.close();
                }
            }
            catch (Exception e) {
                PruebaWS.error(4);
                e.printStackTrace();
            }
            this.log("pruebaGetInvoicesData", "Resultado: " + sale);
        }

        private void pruebaGetInvoicesStatus(String[] definitivos) {
            try {
                String[] cifs = new String[definitivos.length];
                for (int i = 0; i < cifs.length; ++i) {
                    cifs[i] = cifUsuario;
                    this.log("pruebaGetInvoicesStatus", "definitivos: " + definitivos[i]);
                }
                InvoiceStatusBeanSet sale = this.client.getInvoicesStatus(definitivos, cifs);
                if (sale.getError()) {
                    PruebaWS.error(5);
                } else {
                    PruebaWS.ok(5);
                }
                this.log("pruebaGetInvoicesStatus", "Resultado: " + sale);
            }
            catch (Exception e) {
                PruebaWS.error(5);
                e.printStackTrace();
            }
        }

        private void pruebaGetInvoicesReceived(boolean descargarPendientes) {
            try {
                Calendar c = Calendar.getInstance();
                c.set(10, 23);
                c.set(12, 59);
                c.set(13, 59);
                c.set(14, 0);
                Date hasta = c.getTime();
                c.add(13, 1);
                c.add(6, -1);
                c.add(2, -1);
                Date desde = c.getTime();
                this.log("pruebaGetInvoicesReceived", "Desde:" + desde + ", Hasta:" + hasta);
                InvoiceReceivedBeanSet sale = this.client.getInvoicesReceived(desde, hasta, descargarPendientes);
                if (sale.getError()) {
                    PruebaWS.error(6);
                } else {
                    PruebaWS.ok(6);
                }
                if (sale.getInvoiceReceivedBeans() != null) {
                    this.log("pruebaGetInvoicesReceived", "Cuantos: " + sale.getInvoiceReceivedBeans().length);
                    for (int i = 0; i < sale.getInvoiceReceivedBeans().length; ++i) {
                        this.log("pruebaGetInvoicesReceived", "tipo(" + i + ")=" + sale.getElement(i).getTipo());
                    }
                } else {
                    this.log("pruebaGetInvoicesReceived", "Resultado: " + sale);
                }
            }
            catch (Exception e) {
                PruebaWS.error(6);
                e.printStackTrace();
            }
        }

        private void pruebaSetInvoicesStatus(String[] definitivos) {
            try {
                String[] cifs = new String[definitivos.length];
                int[] estados = new int[definitivos.length];
                for (int i = 0; i < cifs.length; ++i) {
                    cifs[i] = cifUsuario;
                    estados[i] = 5;
                }
                InvoiceStatusBeanSet sale = this.client.setInvoicesStatus(definitivos, cifs, estados);
                if (sale.getError()) {
                    PruebaWS.error(7);
                } else {
                    PruebaWS.ok(7);
                }
                this.log("pruebaSetInvoicesStatus", "Resultado: " + sale);
            }
            catch (Exception e) {
                PruebaWS.error(7);
                e.printStackTrace();
            }
        }

        private void pruebaGetInvoicesUpdated() {
            try {
                Calendar c = Calendar.getInstance();
                c.add(6, -1);
                Date desde = c.getTime();
                this.log("pruebaGetInvoicesUpdated", "Desde:" + desde);
                InvoiceReceivedBeanSet sale = this.client.getLatestUpdatedInvoices(desde);
                if (sale.getError()) {
                    PruebaWS.error(9);
                } else {
                    PruebaWS.ok(9);
                }
                this.log("pruebaGetInvoicesUpdated", "Cuantos: " + sale.getInvoiceReceivedBeans().length);
            }
            catch (Exception e) {
                PruebaWS.error(9);
                e.printStackTrace();
            }
        }

        private void pruebalistAttachments() {
            try {
                this.log("pruebalistAttachments", "Inicio");
                String guidDefinitivo = "2038F07-000041";
                String CIFProveedor = "29116004M";
                AttachmentFileBeanSet ficherosAdjuntos = this.client.listAttachments(guidDefinitivo, CIFProveedor);
                if (ficherosAdjuntos.getError()) {
                    PruebaWS.error(10);
                } else {
                    PruebaWS.ok(10);
                }
                this.log("pruebalistAttachments", "Existen " + ficherosAdjuntos.getSize() + " archivos adjuntos para la factura: " + guidDefinitivo);
                this.log("pruebalistAttachments", "Resultado: " + ficherosAdjuntos);
            }
            catch (Exception e) {
                PruebaWS.error(10);
                e.printStackTrace();
            }
        }

        private void pruebaAddAttachment() {
            String file = "pruebaCrearAdjunto";
            try {
                String CIFProveedor;
                String nombreFichero;
                String descripcion;
                DataHandler entrada;
                String guidDefinitivo;
                AddAttachmentBean resultadoAddAttachment;
                this.log("pruebaAddAttachment", "Inicio");
                File fichero = new File(file);
                if (!fichero.exists()) {
                    file = file + ".txt";
                    FileWriter dest = new FileWriter(file);
                    BufferedWriter bw = new BufferedWriter(dest);
                    for (int i = 0; i < 10; ++i) {
                        bw.write(i + "");
                        bw.newLine();
                    }
                    bw.flush();
                    bw.close();
                }
                if ((resultadoAddAttachment = this.client.addAttachment(guidDefinitivo = "2038F07-000041", entrada = new DataHandler(new FileDataSource(file)), descripcion = "Fichero Adjuntado desde WS", nombreFichero = "adjuntoWS.txt", CIFProveedor = "29116004M")).getError()) {
                    PruebaWS.error(11);
                } else {
                    PruebaWS.ok(11);
                }
                this.log("pruebaAddAttachment", "Resultado: " + resultadoAddAttachment);
            }
            catch (Exception e) {
                PruebaWS.error(11);
                e.printStackTrace();
            }
        }

        private void pruebaRemoveAttachment() {
            try {
                this.log("pruebaRemoveAttachment", "Inicio");
                String guidDefinitivo = "2038F07-000041";
                String CIFProveedor = "29116004M";
                Long idAdjunto = new Long(108L);
                RemoveAttachmentBean resultadoRemoveAttachment = this.client.removeAttachment(guidDefinitivo, idAdjunto, CIFProveedor);
                if (resultadoRemoveAttachment.getError()) {
                    PruebaWS.error(12);
                } else {
                    PruebaWS.ok(12);
                }
                this.log("pruebaRemoveAttachment", "Resultado: " + resultadoRemoveAttachment);
            }
            catch (Exception e) {
                PruebaWS.error(12);
                e.printStackTrace();
            }
        }

        private void pruebaDownloadAttachment() {
            try {
                this.log("pruebaDownloadAttachment", "Inicio");
                String guidDefinitivo = "2038F07-000041";
                String CIFProveedor = "29116004M";
                Long idAdjunto = new Long(108L);
                DataHandlerBean attachment = this.client.downloadAttachment(guidDefinitivo, idAdjunto, CIFProveedor);
                String fileSale = "FicheroDescargado";
                this.log("pruebaDownloadAttachment", "Resultado: " + attachment);
                if (attachment.getError()) {
                    PruebaWS.error(13);
                } else {
                    PruebaWS.ok(13);
                }
                DataHandler data = attachment.getDataHandler();
                if (!attachment.getError() && data != null) {
                    File prueba = new File(fileSale);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(prueba));
                    data.writeTo(out);
                    out.flush();
                    out.close();
                }
            }
            catch (Exception e) {
                PruebaWS.error(13);
                e.printStackTrace();
            }
        }

        private void para(int tiempo) {
            try {
                this.log("para", "Nos paramos un rato: " + tiempo);
                Thread.sleep(tiempo);
                this.log("para", "Para: nos despertamos)");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void log(String metodo, String texto) {
            System.out.println("    ==== Thread: " + this.miNumero + "\t" + (metodo + " ______________________________").substring(0, 30) + ": " + texto);
        }

        private void sale() {
            if (--cuantasThread == 0) {
                System.out.println("================ Prueba WS       =======================");
                this.log("sale", "Numero de errores de cada WebService");
                this.log("sale", " Login:          " + errorGlobal[0]);
                this.log("sale", " Logout:         " + errorGlobal[1]);
                this.log("sale", " SendFile:       " + errorGlobal[2]);
                this.log("sale", " GetDefinitives: " + errorGlobal[3]);
                this.log("sale", " GetInvData:     " + errorGlobal[4]);
                this.log("sale", " GetInvStatus:   " + errorGlobal[5]);
                this.log("sale", " GetInvReceived: " + errorGlobal[6]);
                this.log("sale", " SetInvStatus:   " + errorGlobal[7]);
                this.log("sale", " GetPayments:    " + errorGlobal[8]);
                this.log("sale", " GetInvUpdated:  " + errorGlobal[9]);
                this.log("sale", " listAttachments:  " + errorGlobal[10]);
                this.log("sale", " AddAttachment:  " + errorGlobal[11]);
                this.log("sale", " RemoveAttachment:  " + errorGlobal[12]);
                this.log("sale", " DownloadAttachment:  " + errorGlobal[13]);
                System.out.println("================ Prueba WS: fin  =======================");
            }
        }

        public static String getFormated(Date d) {
            return d != null ? fechaFacNoFormtd.format(d) : "";
        }
    }
}

