/*
 * Decompiled with CFR 0.152.
 */
package eurobits.efactura.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;

public class RAPTripleDes {
    private static final String llaveInicial;
    private static final Random rand;
    private static final byte[] IVbytes;

    public RAPTripleDes() {
        String PROVIDER_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        try {
            Provider provider = (Provider)Class.forName(PROVIDER_NAME).newInstance();
            Security.addProvider(provider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SecretKey getKey(String infile) throws Exception {
        try {
            FileInputStream fis = new FileInputStream(infile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            SecretKey key = (SecretKey)ois.readObject();
            ois.close();
            return key;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SecretKey getKeyNoLog(String infile) throws Exception {
        try {
            FileInputStream fis = new FileInputStream(infile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            SecretKey key = (SecretKey)ois.readObject();
            ois.close();
            return key;
        }
        catch (FileNotFoundException e) {
            System.out.println("Error al leer la clave: " + infile + " (Fichero no encontrado)");
            return null;
        }
    }

    public Cipher getCipher() throws Exception {
        return Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
    }

    public byte[] encrypt(byte[] byte_array, SecretKey key) throws Exception {
        Cipher c = this.getCipher();
        c.init(1, (Key)key, new IvParameterSpec(IVbytes));
        return c.doFinal(byte_array);
    }

    public byte[] decrypt(byte[] byte_array, SecretKey key) throws Exception {
        Cipher c = this.getCipher();
        c.init(2, (Key)key, new IvParameterSpec(IVbytes));
        return c.doFinal(byte_array);
    }

    public String convertByteArrayToString(byte[] the_byte_array) {
        char[] char_array = new char[the_byte_array.length];
        for (int i = 0; i < the_byte_array.length; ++i) {
            char_array[i] = (char)the_byte_array[i];
        }
        return new String(char_array);
    }

    public byte[] convertStringToByteArray(String the_string) {
        byte[] byte_array = new byte[the_string.length()];
        for (int i = 0; i < the_string.length(); ++i) {
            byte_array[i] = (byte)the_string.charAt(i);
        }
        return byte_array;
    }

    public byte[] convertCharArrayToByteArray(char[] the_char_array) {
        byte[] byte_array = new byte[the_char_array.length];
        for (int i = 0; i < the_char_array.length; ++i) {
            byte_array[i] = (byte)the_char_array[i];
        }
        return byte_array;
    }

    public static String calculaLlave(String ticket, String clave) throws NoSuchAlgorithmException {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String random = String.valueOf(rand.nextLong());
        String llave = ticket + clave + timestamp + llaveInicial + random;
        byte[] bytesLlave = llave.getBytes();
        String sha1 = new String(RAPTripleDes.getSHA1(bytesLlave));
        String md5 = new String(RAPTripleDes.getMD5(bytesLlave));
        llave = new String(Base64.encode((sha1 + md5).getBytes()));
        return llave;
    }

    public static String cifra3DES(String cadenaLlave, byte[] contrasenaSHA1, byte[] contrasenaMD5) throws GeneralSecurityException {
        String llaveCifrada = null;
        byte[] llave = cadenaLlave.getBytes();
        byte[] bytesClave = new byte[]{contrasenaSHA1[0], contrasenaSHA1[1], contrasenaSHA1[2], contrasenaSHA1[3], contrasenaSHA1[4], contrasenaSHA1[5], contrasenaSHA1[6], contrasenaSHA1[7], contrasenaSHA1[8], contrasenaSHA1[9], contrasenaSHA1[10], contrasenaSHA1[11], contrasenaSHA1[12], contrasenaSHA1[13], contrasenaSHA1[14], contrasenaSHA1[15], contrasenaSHA1[16], contrasenaSHA1[17], contrasenaSHA1[18], contrasenaSHA1[19], contrasenaMD5[0], contrasenaMD5[1], contrasenaMD5[2], contrasenaMD5[3]};
        SecretKeySpec key = new SecretKeySpec(bytesClave, "DESede");
        byte[] vectorInicializacionClaroBytes = new byte[]{contrasenaMD5[4], contrasenaMD5[5], contrasenaMD5[6], contrasenaMD5[7], contrasenaMD5[8], contrasenaMD5[9], contrasenaMD5[10], contrasenaMD5[11]};
        IvParameterSpec vector = new IvParameterSpec(vectorInicializacionClaroBytes, 0, vectorInicializacionClaroBytes.length);
        String algoritmo = "DESede/CBC/PKCS5Padding";
        Cipher cipher = Cipher.getInstance(algoritmo);
        cipher.init(1, (Key)key, vector);
        byte[] bytesCifrados = cipher.doFinal(llave);
        byte[] bytesCifradosBase64 = Base64.encode(bytesCifrados);
        llaveCifrada = new String(bytesCifradosBase64);
        return llaveCifrada;
    }

    public static String descifra3DES(String cadenaLlaveCifrada, String cadenaContrasena) throws GeneralSecurityException {
        String llave = null;
        byte[] contrasena = cadenaContrasena.getBytes();
        byte[] contrasenaSHA1 = RAPTripleDes.getSHA1(contrasena);
        byte[] contrasenaMD5 = RAPTripleDes.getMD5(contrasena);
        byte[] bytesClave = new byte[]{contrasenaSHA1[0], contrasenaSHA1[1], contrasenaSHA1[2], contrasenaSHA1[3], contrasenaSHA1[4], contrasenaSHA1[5], contrasenaSHA1[6], contrasenaSHA1[7], contrasenaSHA1[8], contrasenaSHA1[9], contrasenaSHA1[10], contrasenaSHA1[11], contrasenaSHA1[12], contrasenaSHA1[13], contrasenaSHA1[14], contrasenaSHA1[15], contrasenaSHA1[16], contrasenaSHA1[17], contrasenaSHA1[18], contrasenaSHA1[19], contrasenaMD5[0], contrasenaMD5[1], contrasenaMD5[2], contrasenaMD5[3]};
        SecretKeySpec key = new SecretKeySpec(bytesClave, "DESede");
        byte[] vectorInicializacionClaroBytes = new byte[]{contrasenaMD5[4], contrasenaMD5[5], contrasenaMD5[6], contrasenaMD5[7], contrasenaMD5[8], contrasenaMD5[9], contrasenaMD5[10], contrasenaMD5[11]};
        IvParameterSpec vector = new IvParameterSpec(vectorInicializacionClaroBytes, 0, vectorInicializacionClaroBytes.length);
        String algoritmo = "DESede/CBC/PKCS5Padding";
        Cipher cipher = Cipher.getInstance(algoritmo);
        cipher.init(2, (Key)key, vector);
        byte[] bytesCifradosBase64 = cadenaLlaveCifrada.getBytes();
        byte[] bytesCifradosPlanos = Base64.decode(bytesCifradosBase64);
        byte[] bytesDescifrados = cipher.doFinal(bytesCifradosPlanos);
        llave = new String(bytesDescifrados);
        return llave;
    }

    public static byte[] getSHA1(byte[] contrasena) throws NoSuchAlgorithmException {
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        sha.update(contrasena);
        byte[] contrasenaSHA1 = sha.digest();
        return contrasenaSHA1;
    }

    public static byte[] getMD5(byte[] contrasena) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(contrasena);
        byte[] contrasenaMD5 = md5.digest();
        return contrasenaMD5;
    }

    public static void main(String[] args) throws GeneralSecurityException {
        System.out.println("LA LLAVE QUE TIENE PASTOR Y LA DESCIFRO");
        String llaveCifrada = "ODxcKmHUaYoAmVfDNCn3hJmfH/iloUoB7e35/ga22HyvnXTFxGGimPoUL5JE1TKc5G5T/+f26NQC+GD5TTidzVVLXCFTQLuqQ77UsVFJqRoGh7B7scr03L+ICgNOaJ229tygd9kl6wI=";
        String password = "bpastor1";
        String llaveDesCifrada = RAPTripleDes.descifra3DES(llaveCifrada, password);
        System.out.println("(" + llaveCifrada + "," + password + "): " + llaveDesCifrada);
        System.out.println("LA LLAVE QUE TIENE PASTOR EN BBDD Y LA CIFRO CON SU PWD DE BD. LA DESCIFRO CON SU PWD");
        byte[] sha1 = Base64.decode("dzN3qR7IpnIjmtMDPU4RLtwsteU=".getBytes());
        byte[] md5 = Base64.decode("c+UUQ3n9LBnp2Sl23c+1KA==".getBytes());
        String llavebd = "WSV6R++/vRwxEmsx77+9Kx8X77+977+977+9zqRJWO+/vXPvv73vv70C77+977+977+9R++/vXEL77+9Xxo=";
        String llaveNuevaCifrada = RAPTripleDes.cifra3DES(llavebd, sha1, md5);
        System.out.println("[" + llavebd + ", sha1md5]: " + llaveNuevaCifrada);
        llaveDesCifrada = RAPTripleDes.descifra3DES(llaveNuevaCifrada, password);
        System.out.println("(" + llaveNuevaCifrada + "," + password + "): " + llaveDesCifrada);
    }

    static {
        rand = new Random();
        llaveInicial = String.valueOf(rand.nextLong()) + String.valueOf(System.currentTimeMillis()) + String.valueOf(rand.nextLong());
        IVbytes = new byte[]{25, 26, 27, 28, 29, 30, 31, 32};
    }
}

