/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.model;

import conector.eurobits.efactura.desktop.model.Settings;
import conector.eurobits.efactura.desktop.view.MenuBar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class UpdateSettings {
    private static final String OS_NAME = System.getProperty("user.home");
    private static final String SLASH = System.getProperty("file.separator");
    private static String DATA_FOLDER = "";
    private static Logger logger = Logger.getLogger(Settings.class);

    private static void moveInFolderAndChangePath(Document document, String xPath) {
        String IN_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "In";
        String RECEIVED_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Received";
        Element element = (Element)document.selectSingleNode(xPath);
        if (element.getText().indexOf(IN_PATH) != -1) {
            File oldFolder = new File(IN_PATH);
            if (oldFolder.exists()) {
                File newFolder = new File(RECEIVED_PATH);
                oldFolder.renameTo(newFolder);
            }
            String oldPath = element.getText();
            String newPath = RECEIVED_PATH + oldPath.substring(IN_PATH.length(), oldPath.length());
            element.setText(newPath);
        }
    }

    private static void moveOutFolderAndChangePath(Document document, String xPath) {
        String OUT_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Out";
        String SENT_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Sent";
        Element element = (Element)document.selectSingleNode(xPath);
        if (element.getText().indexOf(OUT_PATH) != -1) {
            File oldFolder = new File(OUT_PATH);
            if (oldFolder.exists()) {
                File newFolder = new File(SENT_PATH);
                oldFolder.renameTo(newFolder);
            }
            String oldPath = element.getText();
            String newPath = SENT_PATH + oldPath.substring(OUT_PATH.length(), oldPath.length());
            element.setText(newPath);
        }
    }

    private static void updateVersion_1_0_8(File configFile) {
        String RECOVERY_RECEIVED_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Received" + SLASH + "Invoices" + SLASH + "Recovery";
        String RECOVERY_SENT_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Sent" + SLASH + "Invoices" + SLASH + "Recovery";
        SAXReader saxReader = new SAXReader();
        boolean hayCambios = false;
        try {
            Document document = saxReader.read(configFile);
            UpdateSettings.initLog(document, "//config/folders/log-folder");
            Element element = (Element)document.selectSingleNode("//config/folders/data/in");
            if (element != null) {
                element.setName("received");
                element.addElement("recovery-folder").addText(RECOVERY_RECEIVED_PATH);
                UpdateSettings.moveInFolderAndChangePath(document, "//config/folders/data/received/invoices-folder");
                UpdateSettings.moveInFolderAndChangePath(document, "//config/folders/data/received/pending-folder");
                UpdateSettings.moveInFolderAndChangePath(document, "//config/folders/data/received/pdf-folder");
                UpdateSettings.moveInFolderAndChangePath(document, "//config/folders/data/received/signed-folder");
                UpdateSettings.moveInFolderAndChangePath(document, "//config/folders/data/received/processed-folder");
                new File(RECOVERY_RECEIVED_PATH).mkdir();
                hayCambios = true;
            }
            if ((element = (Element)document.selectSingleNode("//config/folders/data/out")) != null) {
                element.setName("sent");
                element.addElement("recovery-folder").addText(RECOVERY_SENT_PATH);
                UpdateSettings.moveOutFolderAndChangePath(document, "//config/folders/data/sent/invoices-folder");
                UpdateSettings.moveOutFolderAndChangePath(document, "//config/folders/data/sent/pending-folder");
                UpdateSettings.moveOutFolderAndChangePath(document, "//config/folders/data/sent/pdf-folder");
                UpdateSettings.moveOutFolderAndChangePath(document, "//config/folders/data/sent/signed-folder");
                UpdateSettings.moveOutFolderAndChangePath(document, "//config/folders/data/sent/processed-folder");
                new File(RECOVERY_SENT_PATH).mkdir();
                hayCambios = true;
            }
            if (hayCambios) {
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter(new FileOutputStream(configFile), format);
                writer.write(document);
                logger.info("Se ha realizaco una actualizaci\u00f3n de la configuraci\u00f3n a la versi\u00f3n." + Settings.getSettings().getVersion());
            }
        }
        catch (DocumentException e) {
            logger.error("Fallo al actualizar cambios del fichero de configuraci\u00f3n para la versi\u00f3n " + Settings.getSettings().getVersion());
        }
        catch (IOException e) {
            logger.error("Error en operaci\u00f3n E/S con el fichero de configuraci\u00f3n en la actualizaci\u00f3n para la versi\u00f3n " + Settings.getSettings().getVersion());
        }
    }

    private static void updateVersion_1_0_9(File configFile) {
        SAXReader saxReader = new SAXReader();
        boolean hayCambios = false;
        try {
            Document document = saxReader.read(configFile);
            UpdateSettings.initLog(document, "//config/folders/log-folder");
            if (document.selectSingleNode("//config/version") == null) {
                Element element = (Element)document.selectSingleNode("//config");
                element.addElement("version").addText("1.0.9");
                hayCambios = true;
            }
            if (hayCambios) {
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter(new FileOutputStream(configFile), format);
                writer.write(document);
                logger.info("Se ha realizaco una actualizaci\u00f3n de la configuraci\u00f3n a la versi\u00f3n " + Settings.getSettings().getVersion());
            }
        }
        catch (DocumentException e) {
            logger.error("Fallo al actualizar cambios del fichero de configuraci\u00f3n para la versi\u00f3n " + Settings.getSettings().getVersion());
        }
        catch (IOException e) {
            logger.error("Error en operaci\u00f3n E/S con el fichero de configuraci\u00f3n en la actualizaci\u00f3n para la versi\u00f3n " + Settings.getSettings().getVersion());
        }
    }

    private static void updateVersion_2_0_0(File configFile) {
        SAXReader saxReader = new SAXReader();
        boolean hayCambios = false;
        String STATUS_RECEIVED_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Received" + SLASH + "Status";
        String STATUS_RECEIVED_PENDING_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Received" + SLASH + "Status" + SLASH + "Pending";
        String STATUS_RECEIVED_PROCESSED_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Received" + SLASH + "Status" + SLASH + "Processed";
        String STATUS_SENT_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Sent" + SLASH + "Status";
        String STATUS_SENT_PENDING_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Sent" + SLASH + "Status" + SLASH + "Pending";
        String STATUS_SENT_PROCESSED_PATH = DATA_FOLDER + SLASH + "DataExchange" + SLASH + "Sent" + SLASH + "Status" + SLASH + "Processed";
        try {
            Document document = saxReader.read(configFile);
            UpdateSettings.initLog(document, "//config/folders/log-folder");
            Element element = (Element)document.selectSingleNode("//config/folders/data/sent/status-folder");
            if (element == null) {
                element = (Element)document.selectSingleNode("//config/folders/data/sent");
                element.addElement("status-folder").addText(STATUS_SENT_PATH);
                new File(STATUS_SENT_PATH).mkdir();
                element.addElement("status-pending-folder").addText(STATUS_SENT_PENDING_PATH);
                new File(STATUS_SENT_PENDING_PATH).mkdir();
                element.addElement("status-processed-folder").addText(STATUS_SENT_PROCESSED_PATH);
                new File(STATUS_SENT_PROCESSED_PATH).mkdir();
                hayCambios = true;
            }
            if ((element = (Element)document.selectSingleNode("//config/folders/data/received/status-folder")) == null) {
                element = (Element)document.selectSingleNode("//config/folders/data/received");
                element.addElement("status-folder").addText(STATUS_RECEIVED_PATH);
                new File(STATUS_RECEIVED_PATH).mkdir();
                element.addElement("status-pending-folder").addText(STATUS_RECEIVED_PENDING_PATH);
                new File(STATUS_RECEIVED_PENDING_PATH).mkdir();
                element.addElement("status-processed-folder").addText(STATUS_RECEIVED_PROCESSED_PATH);
                new File(STATUS_RECEIVED_PROCESSED_PATH).mkdir();
                hayCambios = true;
            }
            if ((element = (Element)document.selectSingleNode("//config/persistencia")) == null) {
                element = (Element)document.selectSingleNode("//config");
                Calendar calendario = GregorianCalendar.getInstance();
                Date fecha = calendario.getTime();
                SimpleDateFormat formatoDeFecha = new SimpleDateFormat("yyyy-MM-dd");
                String fechaTxt = formatoDeFecha.format(fecha);
                element.addElement("persistencia").addElement("parametros").addElement("ultimaFechaConsultaCambioEstados").addText(fechaTxt);
                hayCambios = true;
            }
            if (hayCambios) {
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter(new FileOutputStream(configFile), format);
                writer.write(document);
                logger.info("Se ha realizado una actualizaci\u00f3n de la configuraci\u00f3n a la versi\u00f3n 2.0.0.");
            }
        }
        catch (DocumentException e) {
            logger.error("Fallo al actualizar cambios del fichero de configuraci\u00f3n para la versi\u00f3n 2.0.0");
        }
        catch (IOException e) {
            logger.error("Error en operaci\u00f3n E/S con el fichero de configuraci\u00f3n en la actualizaci\u00f3n para la versi\u00f3n 2.0.0");
        }
    }

    private static void initLog(Document document, String XPath2) {
        String LOG_PATH = DATA_FOLDER.replaceAll(SLASH + "DataExchange", "") + SLASH + "Config";
        String LOG_FILE_NAME = "log4j.xml";
        Element element = (Element)document.selectSingleNode("//config/folders/log/log-folder");
        if (element == null || element.getTextTrim().length() == 0) {
            System.out.println("Log cargado desde resources/log4j.xml ");
            DOMConfigurator.configure(MenuBar.class.getResource("resources/log4j.xml"));
        } else {
            String logPath = LOG_PATH.endsWith(".xml") ? LOG_PATH : LOG_PATH + File.separator + "log4j.xml";
            System.out.println("Log cargado desde el fichero: " + logPath);
            DOMConfigurator.configure(logPath);
        }
        logger.info("Log Inicializado ... comprobando si es necesaria una actualizaci\u00f3n.");
    }

    public static void updateToLastVersion(File configFile) {
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(configFile);
            Element element = (Element)document.selectSingleNode("//config/folders/data/data-folder");
            if (element != null) {
                DATA_FOLDER = element.getText();
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        UpdateSettings.updateVersion_1_0_8(configFile);
        UpdateSettings.updateVersion_1_0_9(configFile);
        UpdateSettings.updateVersion_2_0_0(configFile);
    }
}

