/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.model;

import conector.eurobits.efactura.desktop.model.Settings;
import conector.eurobits.efactura.desktop.model.UpdateSettings;
import conector.eurobits.efactura.desktop.model.VisualSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.dom4j.DocumentException;

public class SettingsFactory {
    public static final String BASIC_CONFIG = "conector/eurobits/efactura/desktop/view/resources/config.xml";
    public static final String BASIC_LOGO = "conector" + File.separator + "eurobits" + File.separator + "efactura" + File.separator + "desktop" + File.separator + "view" + File.separator + "resources" + File.separator + "logo.jpg";
    public static final String VISUAL_SETTINGS = "VISUAL";
    public static final String GLOBAL_SETTINGS = "GLOBAL";

    public static Settings loadGlobalSettingsFromPath() throws DocumentException, IOException {
        Settings result = Settings.getSettings();
        File applicationFile = result.getApplicationInitConfigFile();
        Settings.getSettings().save();
        Settings.getSettings().load();
        File configFile = result.getConfigFile();
        if (!configFile.exists()) {
            return null;
        }
        UpdateSettings.updateToLastVersion(configFile);
        return result;
    }

    public static Settings loadGlobalSettingsFromClassPath() throws DocumentException {
        URL configFile = SettingsFactory.class.getClassLoader().getResource(BASIC_CONFIG);
        if (configFile == null) {
            return Settings.getSettings();
        }
        Settings result = new Settings();
        return result;
    }

    public static VisualSettings loadVisualSettingsFromClassPath() throws DocumentException {
        URL configFile = SettingsFactory.class.getClassLoader().getResource(BASIC_CONFIG);
        if (configFile == null) {
            return VisualSettings.getVisualSettings();
        }
        VisualSettings result = new VisualSettings();
        return result;
    }

    public static VisualSettings loadVisualSettingsFromPath() throws FileNotFoundException, DocumentException {
        VisualSettings result = VisualSettings.getVisualSettings();
        File configFile = result.getApplicationInitConfigFile();
        if (!configFile.exists()) {
            return null;
        }
        result.load(configFile);
        return result;
    }

    public static boolean save(Settings config) throws IOException {
        return config.save();
    }

    public static boolean save(VisualSettings config) throws IOException {
        return config.save();
    }
}

