/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.controller;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Factura {
    private static final Logger logger = Logger.getLogger(Factura.class);
    private String path = "";

    public Factura(String path) {
        this.path = path;
    }

    public String procesarFichero() {
        StringWriter str = new StringWriter();
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fact.newDocumentBuilder();
            Document doc = builder.parse(this.path);
            OutputFormat format = new OutputFormat(doc);
            format.setLineWidth(65);
            format.setIndenting(true);
            format.setIndent(5);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLSerializer serializer = new XMLSerializer(bout, format);
            serializer.setOutputCharStream(str);
            serializer.serialize(doc);
            bout.close();
        }
        catch (FactoryConfigurationError e) {
            logger.error("Could not locate a JAXP factory class");
        }
        catch (ParserConfigurationException e) {
            logger.error("Could not locate a JAXP DocumentBuilder class");
        }
        catch (DOMException e) {
            logger.error("Problemas al procesar el fichero " + this.path);
            JOptionPane.showMessageDialog(null, "Problemas al procesar el fichero " + this.path, "Error en lectura", 0);
        }
        catch (IOException e) {
            logger.error("Problemas en la lectura del fichero " + this.path);
            JOptionPane.showMessageDialog(null, "Problemas al leer el fichero " + this.path, "Error en lectura", 0);
        }
        catch (SAXException e) {
            logger.error("Error en el procesado/lectura del fichero xml");
        }
        catch (Exception e) {
            logger.error("Error cr\u00edtico");
        }
        return str.toString();
    }
}

