/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.MalformedURIException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Text;
import nu.xom.xinclude.BadHTTPHeaderException;
import nu.xom.xinclude.BadHrefAttributeException;
import nu.xom.xinclude.BadParseAttributeException;
import nu.xom.xinclude.EncodingHeuristics;
import nu.xom.xinclude.InclusionLoopException;
import nu.xom.xinclude.MisplacedFallbackException;
import nu.xom.xinclude.NoIncludeLocationException;
import nu.xom.xinclude.XIncludeException;
import nu.xom.xinclude.XPointer;
import nu.xom.xinclude.XPointerResourceException;
import nu.xom.xinclude.XPointerSyntaxException;

public class XIncluder {
    private static String version = System.getProperty("java.version");
    public static final String XINCLUDE_NS = "http://www.w3.org/2001/XInclude";

    private XIncluder() {
    }

    public static Document resolve(Document document) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Builder builder = new Builder();
        return XIncluder.resolve(document, builder);
    }

    public static Document resolve(Document document, Builder builder) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Document document2 = new Document(document);
        XIncluder.resolveInPlace(document2, builder);
        return document2;
    }

    public static void resolveInPlace(Document document) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        XIncluder.resolveInPlace(document, new Builder());
    }

    public static void resolveInPlace(Document document, Builder builder) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Stack stack = new Stack();
        XIncluder.resolveInPlace(document, builder, stack);
    }

    private static void resolveInPlace(Document document, Builder builder, Stack stack) throws IOException, ParsingException, XIncludeException {
        String string = document.getBaseURI();
        if (string != null && string.startsWith("file:///")) {
            string = "file:/" + string.substring(8);
        }
        stack.push(string);
        Element element = document.getRootElement();
        XIncluder.resolve(element, builder, stack);
        stack.pop();
    }

    private static void resolve(Element element, Builder builder, Stack stack) throws IOException, ParsingException, XIncludeException {
        XIncluder.resolve(element, builder, stack, null);
    }

    private static void resolve(Element element, Builder builder, Stack stack, Document document) throws IOException, ParsingException, XIncludeException {
        block34: {
            if (XIncluder.isIncludeElement(element)) {
                String string = element.getAttributeValue("parse");
                if (string == null) {
                    string = "xml";
                }
                String string2 = element.getAttributeValue("xpointer");
                String string3 = element.getAttributeValue("encoding");
                String string4 = element.getAttributeValue("href");
                if ("".equals(string4)) {
                    string4 = null;
                }
                if (string4 == null && string2 == null) {
                    throw new NoIncludeLocationException("Missing href attribute", element.getDocument().getBaseURI());
                }
                if (string4 != null && (string4 = XIncluder.convertToURI(string4)).indexOf(35) > -1) {
                    throw new BadHrefAttributeException("fragment identifier in URI " + string4, (String)stack.peek());
                }
                XIncluder.testForForbiddenChildElements(element);
                ParentNode parentNode = element.getParent();
                String string5 = element.getBaseURI();
                URL uRL = null;
                try {
                    uRL = new URL(string5);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                URL uRL2 = null;
                try {
                    if (uRL != null && string4 != null) {
                        uRL2 = XIncluder.absolutize(uRL, string4);
                    } else if (string4 != null) {
                        XIncluder.testURISyntax(string4);
                        uRL2 = new URL(string4);
                    }
                    String string6 = element.getAttributeValue("accept");
                    XIncluder.checkHeader(string6);
                    String string7 = element.getAttributeValue("accept-language");
                    XIncluder.checkHeader(string7);
                    if (string.equals("xml")) {
                        Node node;
                        Node node2;
                        Object object;
                        int n;
                        Nodes nodes;
                        String string8 = "";
                        if (parentNode instanceof Element) {
                            string8 = XIncluder.getXMLLangValue((Element)parentNode);
                        }
                        if (uRL2 != null) {
                            nodes = XIncluder.downloadXMLDocument(uRL2, string2, builder, stack, string6, string7, string8);
                            for (n = 0; n < nodes.size(); ++n) {
                                object = nodes.get(n);
                                if (!(object instanceof Element)) continue;
                                String string9 = ((Node)object).getBaseURI();
                                if (string9.indexOf(35) >= 0) {
                                    string9 = string9.substring(0, string9.indexOf(35));
                                }
                                node2 = (Element)object;
                                node = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", string9);
                                ((Element)node2).addAttribute((Attribute)node);
                            }
                        } else {
                            Document document2 = element.getDocument();
                            if (document2 == null) {
                                document2 = document;
                            }
                            object = XPointer.query(document2, string2);
                            nodes = new Nodes();
                            for (int i = 0; i < ((Nodes)object).size(); ++i) {
                                node2 = ((Nodes)object).get(i);
                                if (node2 instanceof Element && XIncluder.contains((Element)node2, element)) {
                                    throw new InclusionLoopException("Element tried to include itself");
                                }
                                node = node2.copy();
                                nodes.append(node);
                            }
                            nodes = XIncluder.resolveXPointerSelection(nodes, builder, stack, document2);
                        }
                        if (parentNode instanceof Element) {
                            n = parentNode.indexOf(element);
                            for (int i = 0; i < nodes.size(); ++i) {
                                Node node3 = nodes.get(i);
                                parentNode.insertChild(node3, n + i);
                            }
                            element.detach();
                        } else {
                            Node node4;
                            Document document3 = (Document)parentNode;
                            int n2 = 0;
                            while (true) {
                                node4 = nodes.get(n2);
                                ++n2;
                                if (node4 instanceof Element) break;
                                document3.insertChild(node4, document3.indexOf(element));
                            }
                            document3.setRootElement((Element)node4);
                            node4 = document3.getRootElement();
                            int n3 = document3.indexOf(node4);
                            for (int i = n2; i < nodes.size(); ++i) {
                                document3.insertChild(nodes.get(i), n3 + 1 + i - n2);
                            }
                        }
                        break block34;
                    }
                    if (string.equals("text")) {
                        Nodes nodes = XIncluder.downloadTextDocument(uRL2, string3, builder, string6, string7);
                        for (int i = 0; i < nodes.size(); ++i) {
                            Node node = nodes.get(i);
                            if (node instanceof Attribute) {
                                ((Element)parentNode).addAttribute((Attribute)node);
                                continue;
                            }
                            parentNode.insertChild(node, parentNode.indexOf(element));
                        }
                        parentNode.removeChild(element);
                        break block34;
                    }
                    throw new BadParseAttributeException("Bad value for parse attribute: " + string, element.getDocument().getBaseURI());
                }
                catch (IOException iOException) {
                    XIncluder.processFallback(element, builder, stack, parentNode, iOException);
                }
                catch (XPointerSyntaxException xPointerSyntaxException) {
                    XIncluder.processFallback(element, builder, stack, parentNode, xPointerSyntaxException);
                }
                catch (XPointerResourceException xPointerResourceException) {
                    XIncluder.processFallback(element, builder, stack, parentNode, xPointerResourceException);
                }
            } else {
                if (XIncluder.isFallbackElement(element)) {
                    throw new MisplacedFallbackException("Fallback element outside include element", element.getDocument().getBaseURI());
                }
                Elements elements = element.getChildElements();
                for (int i = 0; i < elements.size(); ++i) {
                    XIncluder.resolve(elements.get(i), builder, stack);
                }
            }
        }
    }

    private static URL absolutize(URL uRL, String string) throws MalformedURLException {
        Element element = new Element("c");
        element.setBaseURI(uRL.toExternalForm());
        Element element2 = new Element("c");
        element.appendChild(element2);
        element2.addAttribute(new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", string));
        return new URL(element2.getBaseURI());
    }

    private static void testURISyntax(String string) throws BadHrefAttributeException {
        try {
            Element element = new Element("e");
            element.setNamespaceURI(string);
        }
        catch (MalformedURIException malformedURIException) {
            throw new BadHrefAttributeException("Illegal IRI in href attribute", string);
        }
    }

    private static String getXMLLangValue(Element element) {
        Attribute attribute;
        while ((attribute = element.getAttribute("lang", "http://www.w3.org/XML/1998/namespace")) == null) {
            ParentNode parentNode = element.getParent();
            if (parentNode == null) {
                return "";
            }
            if (parentNode instanceof Document) {
                return "";
            }
            element = (Element)parentNode;
        }
        return attribute.getValue();
    }

    private static void resolveInPlace(Nodes nodes, Builder builder, Stack stack) throws IOException, ParsingException, XIncludeException {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                if (XIncluder.isIncludeElement(element)) {
                    Nodes nodes2 = XIncluder.resolveSilently(element, builder, stack);
                    nodes.remove(i);
                    for (int j = 0; j < nodes2.size(); ++j) {
                        nodes.insert(nodes2.get(j), i++);
                    }
                    continue;
                }
                XIncluder.resolve((Element)node, builder, stack);
                continue;
            }
            if (!(node instanceof Document)) continue;
            XIncluder.resolveInPlace((Document)node, builder, stack);
        }
    }

    private static Nodes resolveXPointerSelection(Nodes nodes, Builder builder, Stack stack, Document document) throws IOException, ParsingException, XIncludeException {
        if (nodes.size() == 0) {
            return new Nodes();
        }
        Element element = (Element)nodes.get(0);
        return XIncluder.resolveSilently(element, builder, stack, document);
    }

    private static boolean contains(ParentNode parentNode, Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getParent()) {
            if (node2 != parentNode) continue;
            return true;
        }
        return false;
    }

    private static Nodes resolveSilently(Element element, Builder builder, Stack stack) throws IOException, ParsingException, XIncludeException {
        return XIncluder.resolveSilently(element, builder, stack, null);
    }

    private static Nodes resolveSilently(Element element, Builder builder, Stack stack, Document document) throws IOException, ParsingException, XIncludeException {
        if (XIncluder.isIncludeElement(element)) {
            String string = element.getAttributeValue("parse");
            if (string == null) {
                string = "xml";
            }
            String string2 = element.getAttributeValue("xpointer");
            String string3 = element.getAttributeValue("encoding");
            String string4 = element.getAttributeValue("href");
            String string5 = element.getAttributeValue("accept");
            String string6 = element.getAttributeValue("accept-language");
            if ("".equals(string4)) {
                string4 = null;
            }
            if (string4 == null && string2 == null) {
                throw new NoIncludeLocationException("Missing href attribute", element.getDocument().getBaseURI());
            }
            if (string4 != null) {
                string4 = XIncluder.convertToURI(string4);
            }
            XIncluder.testForForbiddenChildElements(element);
            String string7 = element.getBaseURI();
            URL uRL = null;
            try {
                uRL = new URL(string7);
            }
            catch (Exception exception) {
                // empty catch block
            }
            URL uRL2 = null;
            try {
                if (uRL != null && string4 != null) {
                    uRL2 = new URL(uRL, string4);
                } else if (string4 != null) {
                    uRL2 = new URL(string4);
                }
                if (string.equals("xml")) {
                    Nodes nodes;
                    if (uRL2 != null) {
                        ParentNode parentNode = element.getParent();
                        String string8 = "";
                        if (parentNode != null && parentNode instanceof Element) {
                            string8 = XIncluder.getXMLLangValue((Element)parentNode);
                        }
                        nodes = XIncluder.downloadXMLDocument(uRL2, string2, builder, stack, string5, string6, string8);
                        for (int i = 0; i < nodes.size(); ++i) {
                            Node node = nodes.get(i);
                            if (!(node instanceof Element)) continue;
                            String string9 = uRL2.toExternalForm();
                            if (string9.indexOf(35) >= 0) {
                                string9 = string9.substring(0, string9.indexOf(35));
                            }
                            Element element2 = (Element)node;
                            Attribute attribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", string9);
                            element2.addAttribute(attribute);
                        }
                    } else {
                        Document document2 = element.getDocument();
                        if (document2 == null) {
                            document2 = document;
                        }
                        Nodes nodes2 = XPointer.query(document2, string2);
                        nodes = new Nodes();
                        for (int i = 0; i < nodes2.size(); ++i) {
                            Node node = nodes2.get(i);
                            if (node instanceof Element && XIncluder.contains((Element)node, element)) {
                                throw new InclusionLoopException("Element tried to include itself");
                            }
                            nodes.append(node.copy());
                        }
                        nodes = XIncluder.resolveXPointerSelection(nodes, builder, stack, document2);
                    }
                    return nodes;
                }
                if (string.equals("text")) {
                    return XIncluder.downloadTextDocument(uRL2, string3, builder, string5, string6);
                }
                throw new BadParseAttributeException("Bad value for parse attribute: " + string, element.getDocument().getBaseURI());
            }
            catch (IOException iOException) {
                return XIncluder.processFallbackSilently(element, builder, stack, iOException);
            }
            catch (XPointerSyntaxException xPointerSyntaxException) {
                return XIncluder.processFallbackSilently(element, builder, stack, xPointerSyntaxException);
            }
            catch (XPointerResourceException xPointerResourceException) {
                return XIncluder.processFallbackSilently(element, builder, stack, xPointerResourceException);
            }
        }
        if (XIncluder.isFallbackElement(element)) {
            throw new MisplacedFallbackException("Fallback element outside include element", element.getDocument().getBaseURI());
        }
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            XIncluder.resolve(elements.get(i), builder, stack, document);
        }
        return new Nodes(element);
    }

    private static void testForForbiddenChildElements(Element element) throws XIncludeException {
        Elements elements = element.getChildElements("fallback", XINCLUDE_NS);
        if (elements.size() > 1) {
            throw new XIncludeException("Multiple fallback elements", element.getDocument().getBaseURI());
        }
        Elements elements2 = element.getChildElements();
        for (int i = 0; i < elements2.size(); ++i) {
            Element element2 = elements2.get(i);
            if (!XINCLUDE_NS.equals(element2.getNamespaceURI()) || "fallback".equals(element2.getLocalName())) continue;
            throw new XIncludeException("Include element contains an include child", element.getDocument().getBaseURI());
        }
    }

    private static void processFallback(Element element, Builder builder, Stack stack, ParentNode parentNode, Exception exception) throws XIncludeException, IOException, ParsingException {
        Element element2 = element.getFirstChildElement("fallback", XINCLUDE_NS);
        if (element2 == null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            XIncludeException xIncludeException = new XIncludeException(exception.getMessage(), element.getDocument().getBaseURI());
            xIncludeException.initCause(exception);
            throw xIncludeException;
        }
        while (element2.getChildCount() > 0) {
            Node node = element2.getChild(0);
            if (node instanceof Element) {
                XIncluder.resolve((Element)node, builder, stack);
            }
            node = element2.getChild(0);
            node.detach();
            parentNode.insertChild(node, parentNode.indexOf(element));
        }
        element.detach();
    }

    private static Nodes processFallbackSilently(Element element, Builder builder, Stack stack, Exception exception) throws XIncludeException, IOException, ParsingException {
        Element element2 = element.getFirstChildElement("fallback", XINCLUDE_NS);
        if (element2 == null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            XIncludeException xIncludeException = new XIncludeException(exception.getMessage(), element.getDocument().getBaseURI());
            xIncludeException.initCause(exception);
            throw xIncludeException;
        }
        Nodes nodes = new Nodes();
        for (int i = 0; i < element2.getChildCount(); ++i) {
            Node node = element2.getChild(i);
            if (node instanceof Element) {
                Nodes nodes2 = XIncluder.resolveSilently((Element)node, builder, stack);
                for (int j = 0; j < nodes2.size(); ++j) {
                    nodes.append(nodes2.get(j));
                }
                continue;
            }
            nodes.append(node);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Nodes downloadXMLDocument(URL uRL, String string, Builder builder, Stack stack, String string2, String string3, String string4) throws IOException, ParsingException, XIncludeException, XPointerSyntaxException, XPointerResourceException {
        Object object;
        Node node;
        int n;
        Nodes nodes;
        Document document;
        String string5 = uRL.toExternalForm();
        if (string == null && stack.indexOf(string5) != -1) {
            throw new InclusionLoopException("Tried to include the already included document " + string5 + " from " + stack.peek(), (String)stack.peek());
        }
        URLConnection uRLConnection = uRL.openConnection();
        XIncluder.setHeaders(uRLConnection, string2, string3);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            document = builder.build(bufferedInputStream, uRL.toExternalForm());
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        if (string != null && string.length() != 0) {
            nodes = XPointer.query(document, string);
            for (n = 0; n < nodes.size(); ++n) {
                String string6;
                Attribute attribute;
                node = nodes.get(n);
                if (!(node instanceof Element) || (attribute = ((Element)(object = (Element)node)).getAttribute("lang", "http://www.w3.org/XML/1998/namespace")) != null || string4.equals(string6 = XIncluder.getXMLLangValue((Element)object))) continue;
                ((Element)object).addAttribute(new Attribute("xml:lang", "http://www.w3.org/XML/1998/namespace", string6));
            }
            XIncluder.resolveInPlace(nodes, builder, stack);
        } else {
            XIncluder.resolveInPlace(document, builder, stack);
            nodes = new Nodes();
            for (n = 0; n < document.getChildCount(); ++n) {
                node = document.getChild(n);
                if (node instanceof DocType) continue;
                nodes.append(node);
            }
        }
        document.setRootElement(new Element("f"));
        for (n = 0; n < nodes.size(); ++n) {
            node = nodes.get(n);
            object = node.getBaseURI();
            node.detach();
            if (!(node instanceof Element)) continue;
            ((Element)node).setBaseURI((String)object);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Nodes downloadTextDocument(URL uRL, String string, Builder builder, String string2, String string3) throws IOException, XIncludeException {
        if (string == null || string.length() == 0) {
            string = "UTF-8";
        }
        URLConnection uRLConnection = uRL.openConnection();
        XIncluder.setHeaders(uRLConnection, string2, string3);
        String string4 = uRLConnection.getContentEncoding();
        String string5 = uRLConnection.getContentType();
        int n = uRLConnection.getContentLength();
        if (n < 0) {
            n = 1024;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            int n2;
            if (string4 != null) {
                string = string4;
            } else if (string5 != null && ((string5 = string5.toLowerCase()).equals("text/xml") || string5.equals("application/xml") || string5.startsWith("text/") && string5.endsWith("+xml") || string5.startsWith("application/") && string5.endsWith("+xml"))) {
                string = EncodingHeuristics.readEncodingFromStream(bufferedInputStream);
            }
            if (version.startsWith("1.2") || version.startsWith("1.1")) {
                if (string.equalsIgnoreCase("UTF-16")) {
                    ((InputStream)bufferedInputStream).mark(2);
                    int n3 = ((InputStream)bufferedInputStream).read();
                    string = n3 == 255 ? "UnicodeLittle" : "UnicodeBig";
                    ((InputStream)bufferedInputStream).reset();
                } else if (string.equalsIgnoreCase("UnicodeBigUnmarked")) {
                    string = "UnicodeBig";
                } else if (string.equalsIgnoreCase("UnicodeLittleUnmarked")) {
                    string = "UnicodeLittle";
                }
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, string));
            StringBuffer stringBuffer = new StringBuffer(n);
            while ((n2 = ((Reader)bufferedReader).read()) != -1) {
                stringBuffer.append((char)n2);
            }
            NodeFactory nodeFactory = builder.getNodeFactory();
            if (nodeFactory != null) {
                Nodes nodes = nodeFactory.makeText(stringBuffer.toString());
                return nodes;
            }
            Nodes nodes = new Nodes(new Text(stringBuffer.toString()));
            return nodes;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    private static void setHeaders(URLConnection uRLConnection, String string, String string2) throws BadHTTPHeaderException {
        if (string != null) {
            XIncluder.checkHeader(string);
            uRLConnection.setRequestProperty("accept", string);
        }
        if (string2 != null) {
            XIncluder.checkHeader(string2);
            uRLConnection.setRequestProperty("accept-language", string2);
        }
    }

    private static void checkHeader(String string) throws BadHTTPHeaderException {
        if (string == null) {
            return;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            throw new BadHTTPHeaderException("Header contains illegal character 0x" + Integer.toHexString(c).toUpperCase());
        }
    }

    private static boolean isIncludeElement(Element element) {
        return element.getLocalName().equals("include") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }

    private static boolean isFallbackElement(Element element) {
        return element.getLocalName().equals("fallback") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }

    private static String convertToURI(String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                if (XIncluder.needsEscaping(byArray[i])) {
                    stringBuffer.append(XIncluder.hexEscape(byArray[i]));
                    continue;
                }
                stringBuffer.append((char)byArray[i]);
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("VM is broken. It does not support UTF-8.");
        }
    }

    private static boolean needsEscaping(byte by) {
        switch (by) {
            case 33: {
                return false;
            }
            case 34: {
                return true;
            }
            case 35: {
                return false;
            }
            case 36: {
                return false;
            }
            case 37: {
                return false;
            }
            case 38: {
                return false;
            }
            case 39: {
                return false;
            }
            case 40: {
                return false;
            }
            case 41: {
                return false;
            }
            case 42: {
                return false;
            }
            case 43: {
                return false;
            }
            case 44: {
                return false;
            }
            case 45: {
                return false;
            }
            case 46: {
                return false;
            }
            case 47: {
                return false;
            }
            case 48: {
                return false;
            }
            case 49: {
                return false;
            }
            case 50: {
                return false;
            }
            case 51: {
                return false;
            }
            case 52: {
                return false;
            }
            case 53: {
                return false;
            }
            case 54: {
                return false;
            }
            case 55: {
                return false;
            }
            case 56: {
                return false;
            }
            case 57: {
                return false;
            }
            case 58: {
                return false;
            }
            case 59: {
                return false;
            }
            case 60: {
                return true;
            }
            case 61: {
                return false;
            }
            case 62: {
                return true;
            }
            case 63: {
                return false;
            }
            case 64: {
                return false;
            }
            case 65: {
                return false;
            }
            case 66: {
                return false;
            }
            case 67: {
                return false;
            }
            case 68: {
                return false;
            }
            case 69: {
                return false;
            }
            case 70: {
                return false;
            }
            case 71: {
                return false;
            }
            case 72: {
                return false;
            }
            case 73: {
                return false;
            }
            case 74: {
                return false;
            }
            case 75: {
                return false;
            }
            case 76: {
                return false;
            }
            case 77: {
                return false;
            }
            case 78: {
                return false;
            }
            case 79: {
                return false;
            }
            case 80: {
                return false;
            }
            case 81: {
                return false;
            }
            case 82: {
                return false;
            }
            case 83: {
                return false;
            }
            case 84: {
                return false;
            }
            case 85: {
                return false;
            }
            case 86: {
                return false;
            }
            case 87: {
                return false;
            }
            case 88: {
                return false;
            }
            case 89: {
                return false;
            }
            case 90: {
                return false;
            }
            case 91: {
                return false;
            }
            case 92: {
                return true;
            }
            case 93: {
                return false;
            }
            case 94: {
                return true;
            }
            case 95: {
                return false;
            }
            case 96: {
                return true;
            }
            case 97: {
                return false;
            }
            case 98: {
                return false;
            }
            case 99: {
                return false;
            }
            case 100: {
                return false;
            }
            case 101: {
                return false;
            }
            case 102: {
                return false;
            }
            case 103: {
                return false;
            }
            case 104: {
                return false;
            }
            case 105: {
                return false;
            }
            case 106: {
                return false;
            }
            case 107: {
                return false;
            }
            case 108: {
                return false;
            }
            case 109: {
                return false;
            }
            case 110: {
                return false;
            }
            case 111: {
                return false;
            }
            case 112: {
                return false;
            }
            case 113: {
                return false;
            }
            case 114: {
                return false;
            }
            case 115: {
                return false;
            }
            case 116: {
                return false;
            }
            case 117: {
                return false;
            }
            case 118: {
                return false;
            }
            case 119: {
                return false;
            }
            case 120: {
                return false;
            }
            case 121: {
                return false;
            }
            case 122: {
                return false;
            }
            case 123: {
                return false;
            }
            case 124: {
                return false;
            }
            case 125: {
                return false;
            }
            case 126: {
                return false;
            }
        }
        return true;
    }

    private static String hexEscape(byte by) {
        StringBuffer stringBuffer = new StringBuffer(3);
        stringBuffer.append('%');
        if (by <= 15) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(by));
        return stringBuffer.toString();
    }
}

