/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jpedal.PdfDecoder;

public class JPanelPDF
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(JPanelPDF.class);
    private PdfDecoder pdfDecoder;
    private int currentPage = 1;
    private String currentFile = null;
    private final JLabel pageCounter1 = new JLabel("P\u00e1gina ");
    private JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3 = new JLabel("de");

    public JPanelPDF(String name, int i) {
        this.pdfDecoder = new PdfDecoder();
        this.currentFile = name;
        this.pageCounter2.setText("1");
        try {
            this.pdfDecoder.openPdfFile(this.currentFile);
            this.pdfDecoder.decodePage(this.currentPage);
            this.pdfDecoder.setPageParameters(1.0f, 1);
            this.initializeViewer();
        }
        catch (Exception e) {
            logger.error("Error al abrir/cerrar el fichero");
        }
    }

    public int getNumberPages() {
        int number = 0;
        try {
            number = this.pdfDecoder.getPageCount();
        }
        catch (Exception e) {
            logger.error("Error al ver el n\u00famero de p\u00e1ginas del fichero PDF");
        }
        return number;
    }

    private void initializeViewer() {
        this.setLayout(new BorderLayout());
        Component[] itemsToAdd = this.initChangerPanel();
        JPanel topBar = new JPanel();
        topBar.setLayout(new FlowLayout(3, 0, 0));
        for (int i = 0; i < itemsToAdd.length; ++i) {
            topBar.add(itemsToAdd[i]);
        }
        this.add((Component)topBar, "North");
        JScrollPane display = this.initPDFDisplay();
        this.add((Component)display, "Center");
        this.add(this.pdfDecoder);
        this.repaint();
        this.setVisible(true);
    }

    private Component[] initChangerPanel() {
        Component[] list = new Component[11];
        JButton start = new JButton();
        start.setBorderPainted(false);
        URL startImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/start.gif");
        start.setIcon(new ImageIcon(startImage));
        start.setToolTipText("Primera P\u00e1gina");
        list[0] = start;
        start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelPDF.this.currentFile != null && JPanelPDF.this.currentPage != 1) {
                    JPanelPDF.this.currentPage = 1;
                    try {
                        JPanelPDF.this.pdfDecoder.decodePage(JPanelPDF.this.currentPage);
                        JPanelPDF.this.pdfDecoder.invalidate();
                        JPanelPDF.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("back to page 1");
                        e1.printStackTrace();
                    }
                    JPanelPDF.this.pageCounter2.setText(String.valueOf(JPanelPDF.this.currentPage));
                }
            }
        });
        JButton fback = new JButton();
        fback.setBorderPainted(false);
        fback.setSize(new Dimension(34, 24));
        URL fbackImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fback.gif");
        fback.setIcon(new ImageIcon(fbackImage));
        fback.setToolTipText("Retroceso R\u00e1pido 5 P\u00e1ginas");
        list[1] = fback;
        fback.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelPDF.this.currentFile != null && JPanelPDF.this.currentPage > 5) {
                    JPanelPDF.this.currentPage -= 5;
                    try {
                        JPanelPDF.this.pdfDecoder.decodePage(JPanelPDF.this.currentPage);
                        JPanelPDF.this.pdfDecoder.invalidate();
                        JPanelPDF.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("back 5 pages");
                        e1.printStackTrace();
                    }
                    JPanelPDF.this.pageCounter2.setText(String.valueOf(JPanelPDF.this.currentPage));
                }
            }
        });
        JButton back = new JButton();
        back.setBorderPainted(false);
        URL backImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/back.gif");
        back.setIcon(new ImageIcon(backImage));
        back.setToolTipText("Retroceder una P\u00e1gina");
        list[2] = back;
        back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelPDF.this.currentFile != null && JPanelPDF.this.currentPage > 1) {
                    JPanelPDF.this.currentPage -= 1;
                    try {
                        JPanelPDF.this.pdfDecoder.decodePage(JPanelPDF.this.currentPage);
                        JPanelPDF.this.pdfDecoder.invalidate();
                        JPanelPDF.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("back 1 page");
                        e1.printStackTrace();
                    }
                    JPanelPDF.this.pageCounter2.setText(String.valueOf(JPanelPDF.this.currentPage));
                }
            }
        });
        this.pageCounter2.setEditable(true);
        this.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                String value = JPanelPDF.this.pageCounter2.getText().trim();
                try {
                    int newPage = Integer.parseInt(value);
                    if (newPage > JPanelPDF.this.pdfDecoder.getPageCount() | newPage < 1) {
                        return;
                    }
                    JPanelPDF.this.currentPage = newPage;
                    try {
                        JPanelPDF.this.pdfDecoder.decodePage(JPanelPDF.this.currentPage);
                        JPanelPDF.this.pdfDecoder.invalidate();
                        JPanelPDF.this.repaint();
                    }
                    catch (Exception e) {
                        System.err.println("page number entered");
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, '>' + value + "< is Not a valid Value.\nPlease enter a number between 1 and " + JPanelPDF.this.pdfDecoder.getPageCount());
                }
            }
        });
        list[3] = this.pageCounter1;
        list[4] = new JPanel();
        list[5] = this.pageCounter2;
        list[6] = new JPanel();
        list[7] = this.pageCounter3;
        JButton forward = new JButton();
        forward.setBorderPainted(false);
        URL fowardImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/forward.gif");
        forward.setIcon(new ImageIcon(fowardImage));
        forward.setToolTipText("Avanzar una P\u00e1gina");
        list[8] = forward;
        forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelPDF.this.currentFile != null && JPanelPDF.this.currentPage < JPanelPDF.this.pdfDecoder.getPageCount()) {
                    JPanelPDF.this.currentPage += 1;
                    try {
                        JPanelPDF.this.pdfDecoder.decodePage(JPanelPDF.this.currentPage);
                        JPanelPDF.this.pdfDecoder.invalidate();
                        JPanelPDF.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("forward 1 page");
                        e1.printStackTrace();
                    }
                    JPanelPDF.this.pageCounter2.setText(String.valueOf(JPanelPDF.this.currentPage));
                }
            }
        });
        JButton fforward = new JButton();
        fforward.setBorderPainted(false);
        URL ffowardImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fforward.gif");
        fforward.setIcon(new ImageIcon(ffowardImage));
        fforward.setToolTipText("Avance r\u00e1pido 5 P\u00e1ginas");
        list[9] = fforward;
        fforward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelPDF.this.currentFile != null && JPanelPDF.this.currentPage < JPanelPDF.this.pdfDecoder.getPageCount() - 4) {
                    JPanelPDF.this.currentPage += 5;
                    try {
                        JPanelPDF.this.pdfDecoder.decodePage(JPanelPDF.this.currentPage);
                        JPanelPDF.this.pdfDecoder.invalidate();
                        JPanelPDF.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("forward 10 pages");
                        e1.printStackTrace();
                    }
                    JPanelPDF.this.pageCounter2.setText(String.valueOf(JPanelPDF.this.currentPage));
                }
            }
        });
        JButton end = new JButton();
        end.setBorderPainted(false);
        URL endImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/end.gif");
        end.setIcon(new ImageIcon(endImage));
        end.setToolTipText("Ultima P\u00e1gina");
        list[10] = end;
        end.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPanelPDF.this.currentFile != null && JPanelPDF.this.currentPage < JPanelPDF.this.pdfDecoder.getPageCount()) {
                    JPanelPDF.this.currentPage = JPanelPDF.this.pdfDecoder.getPageCount();
                    try {
                        JPanelPDF.this.pdfDecoder.decodePage(JPanelPDF.this.currentPage);
                        JPanelPDF.this.pdfDecoder.invalidate();
                        JPanelPDF.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("forward to last page");
                        e1.printStackTrace();
                    }
                    JPanelPDF.this.pageCounter2.setText(String.valueOf(JPanelPDF.this.currentPage));
                }
            }
        });
        return list;
    }

    private JScrollPane initPDFDisplay() {
        JScrollPane currentScroll = new JScrollPane();
        currentScroll.setHorizontalScrollBarPolicy(30);
        currentScroll.setVerticalScrollBarPolicy(20);
        currentScroll.setViewportView(this.pdfDecoder);
        return currentScroll;
    }
}

