/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.TestFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMethodFactory
extends TestFactory {
    private final String _testMethodName;
    static /* synthetic */ Class class$java$lang$String;

    public TestMethodFactory(Class clazz, String string) {
        super(clazz);
        this._testMethodName = string;
    }

    protected TestSuite makeTestSuite() {
        TestSuite testSuite = new TestSuite();
        Constructor constructor = null;
        try {
            constructor = this.getConstructor(this._testClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            testSuite.addTest(this.warning("Class " + this._testClass.getName() + " has no public constructor TestCase(String name)"));
            return testSuite;
        }
        if (!Modifier.isPublic(this._testClass.getModifiers())) {
            testSuite.addTest(this.warning("Class " + this._testClass.getName() + " is not public"));
            return testSuite;
        }
        this.addTestMethod(testSuite, constructor, this._testMethodName);
        if (testSuite.testCount() == 0) {
            testSuite.addTest(this.warning("No tests found in " + this._testClass.getName()));
        }
        return testSuite;
    }

    private void addTestMethod(TestSuite testSuite, Constructor constructor, String string) {
        Object[] objectArray = new Object[]{string};
        try {
            testSuite.addTest((Test)constructor.newInstance(objectArray));
        }
        catch (InstantiationException instantiationException) {
            testSuite.addTest(this.warning("Cannot instantiate test case: " + string + " (" + this.toString(instantiationException) + ")"));
        }
        catch (InvocationTargetException invocationTargetException) {
            testSuite.addTest(this.warning("Exception in constructor: " + string + " (" + this.toString(invocationTargetException.getTargetException()) + ")"));
        }
        catch (IllegalAccessException illegalAccessException) {
            testSuite.addTest(this.warning("Cannot access test case: " + string + " (" + this.toString(illegalAccessException) + ")"));
        }
    }

    private Constructor getConstructor(Class clazz) throws NoSuchMethodException {
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TestMethodFactory.class$("java.lang.String")) : class$java$lang$String};
        return clazz.getConstructor(classArray);
    }

    private Test warning(final String string) {
        return new TestCase("warning"){

            protected void runTest() {
                Assert.fail(string);
            }
        };
    }

    private String toString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

