/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.UnsupportedEncodingException;
import nu.xom.CDATASection;
import nu.xom.Node;
import nu.xom.Verifier;

public class Text
extends Node {
    private byte[] data;

    public Text(String string) {
        this._setValue(string);
    }

    public Text(Text text) {
        this.data = text.data;
    }

    private Text() {
    }

    static Text build(String string) {
        Text text = new Text();
        try {
            text.data = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
        return text;
    }

    public void setValue(String string) {
        this._setValue(string);
    }

    private void _setValue(String string) {
        if (string == null) {
            string = "";
        } else {
            Verifier.checkPCDATA(string);
        }
        try {
            this.data = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
    }

    public final String getValue() {
        try {
            return new String(this.data, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Bad VM! Does not support UTF-8");
        }
    }

    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public Node copy() {
        if (this.isCDATASection()) {
            return new CDATASection(this);
        }
        return new Text(this);
    }

    public final String toXML() {
        return Text.escapeText(this.getValue());
    }

    private static String escapeText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\r': {
                    stringBuffer.append("&#x0D;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    boolean isText() {
        return true;
    }

    public final String toString() {
        String string = this.getValue();
        if (string.length() <= 40) {
            return "[" + this.getClass().getName() + ": " + string + "]";
        }
        return "[" + this.getClass().getName() + ": " + string.substring(0, 35) + "...]";
    }

    boolean isCDATASection() {
        return false;
    }
}

