/*
 * Decompiled with CFR 0.152.
 */
package eurobits.efactura.server.util;

import eurobits.efactura.server.util.MaskingThread;
import eurobits.efactura.util.RAPTripleDes;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.security.Provider;
import java.security.Security;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAPCrypto {
    private static final Logger logger = LoggerFactory.getLogger(RAPCrypto.class);
    private static final String Usage = "Usage: RAPCrypto.sh [-S seedfile | -E seedfile outfile | -D seedfile outfile]";

    public static String decrypt(String seedFile, String passwdFile) {
        String descifrada = "";
        try {
            FileInputStream fis = new FileInputStream(passwdFile);
            byte[] array = null;
            array = new byte[fis.available()];
            fis.read(array);
            RAPTripleDes des = new RAPTripleDes();
            array = des.decrypt(array, des.getKey(seedFile));
            descifrada = new String(array);
        }
        catch (FileNotFoundException e) {
            logger.trace("Fichero no encontrado: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            logger.trace("Excepcion IO: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            logger.trace("Excepcion: " + e.getLocalizedMessage());
        }
        return descifrada;
    }

    public static void main(String[] args) {
        block24: {
            if (!(args.length == 3 && args[0].equals("-E") || args.length == 3 && args[0].equals("-D") || args.length == 2 && args[0].equals("-S"))) {
                System.err.println(Usage);
                System.exit(-1);
            }
            if (args[0].equals("-E")) {
                try {
                    String passConf;
                    String pass;
                    RAPTripleDes des = new RAPTripleDes();
                    SecretKey myKey = des.getKeyNoLog(args[1]);
                    if (myKey == null) {
                        System.exit(-1);
                    }
                    InputStreamReader isr = new InputStreamReader(System.in);
                    BufferedReader br = new BufferedReader(isr);
                    MaskingThread maskingthread = new MaskingThread();
                    Thread thread = new Thread(maskingthread);
                    thread.start();
                    do {
                        System.out.println("Introduzca la contrase\u00f1a :");
                        pass = br.readLine();
                        System.out.println("Confirme la contrase\u00f1a :");
                        passConf = br.readLine();
                    } while (pass.equals("") || !pass.equals(passConf));
                    maskingthread.stopMasking();
                    byte[] array = null;
                    array = des.convertCharArrayToByteArray(pass.toCharArray());
                    if (array != null) {
                        byte[] cipherArray = null;
                        System.out.println("Cifrando...");
                        cipherArray = des.encrypt(array, myKey);
                        FileOutputStream fos = new FileOutputStream(args[2] + ".3ds");
                        fos.write(cipherArray);
                        fos.close();
                        System.out.println("Fichero cifrado generado: " + args[2] + ".3ds");
                        break block24;
                    }
                    System.err.println("String retrieved from file is null");
                    System.exit(-1);
                }
                catch (FileNotFoundException e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
                catch (IOException e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
                catch (Exception e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
            } else if (args[0].equals("-S")) {
                String PROVIDER_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
                try {
                    Provider provider = (Provider)Class.forName(PROVIDER_NAME).newInstance();
                    Security.addProvider(provider);
                }
                catch (Exception e) {
                    System.out.println("Error al cargar proveedor: " + PROVIDER_NAME + " : " + e.getLocalizedMessage());
                }
                try {
                    KeyGenerator keyGen = KeyGenerator.getInstance("DESede", "BC");
                    keyGen.init(168);
                    System.out.println("Generando semilla...");
                    SecretKey desKey = keyGen.generateKey();
                    FileOutputStream fos = new FileOutputStream(args[1] + ".3ds");
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(desKey);
                    oos.flush();
                    oos.close();
                    System.out.println("Fichero de semilla generado: " + args[1] + ".3ds");
                }
                catch (Exception e) {
                    System.out.println("Error generando clave: " + e.toString());
                }
            } else if (args[0].equals("-D")) {
                try {
                    RAPTripleDes des = new RAPTripleDes();
                    SecretKey myKey = des.getKeyNoLog(args[1]);
                    if (myKey == null) {
                        System.exit(-1);
                    }
                    FileInputStream fis = new FileInputStream(args[2]);
                    byte[] array = null;
                    array = new byte[fis.available()];
                    fis.read(array);
                    fis.close();
                    if (array != null) {
                        byte[] cipherArray = null;
                        cipherArray = des.decrypt(array, myKey);
                        String cipherText = des.convertByteArrayToString(cipherArray);
                        System.out.println("Output string is : " + cipherText);
                    } else {
                        System.err.println("String retrieved from file is null");
                        System.exit(-1);
                    }
                }
                catch (FileNotFoundException e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
                catch (IOException e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
                catch (Exception e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
            }
        }
    }
}

