/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.SBChooser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class TinySliderUI
extends MetalSliderUI {
    private static BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    protected boolean isDragging = false;
    protected BasicSliderUI.TrackListener trackListener;

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new MyTrackListener();
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 1) {
            return Theme.sliderVertSize[Theme.derivedStyle[Theme.style]];
        }
        return Theme.sliderHorzSize[Theme.derivedStyle[Theme.style]];
    }

    protected int getTrackWidth() {
        return 4;
    }

    public void paintThumb(Graphics g) {
        ColorUIResource c = null;
        c = !this.slider.isEnabled() ? Theme.sliderThumbDisabledColor[Theme.style].getColor() : (this.isDragging ? Theme.sliderThumbPressedColor[Theme.style].getColor() : (this.isRollover && Theme.sliderRolloverEnabled[Theme.style] ? (Theme.derivedStyle[Theme.style] == 2 ? Theme.sliderThumbColor[Theme.style].getColor() : Theme.sliderThumbRolloverColor[Theme.style].getColor()) : Theme.sliderThumbColor[Theme.style].getColor()));
        g.setColor(c);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyThumb(g, c);
                break;
            }
            case 1: {
                this.drawWinThumb(g, c);
                break;
            }
            case 2: {
                this.drawXpThumb(g);
            }
        }
    }

    private void drawTinyThumb(Graphics g, Color c) {
        int x1 = this.thumbRect.x;
        int y1 = this.thumbRect.y;
        int x2 = x1 + this.thumbRect.width - 1;
        int y2 = y1 + this.thumbRect.height - 1;
        g.fillRect(x1 + 1, y1 + 1, this.thumbRect.width - 2, this.thumbRect.height - 2);
    }

    private void drawWinThumb(Graphics g, Color c) {
        int x1 = this.thumbRect.x;
        int y1 = this.thumbRect.y;
        int x2 = x1 + this.thumbRect.width - 1;
        int y2 = y1 + this.thumbRect.height - 1;
        if (this.slider.getOrientation() == 0) {
            g.fillRect(x1 + 1, y1 + 1, this.thumbRect.width - 2, 15);
            g.drawLine(x1 + 2, y1 + 16, x1 + 7, y1 + 16);
            g.drawLine(x1 + 3, y1 + 17, x1 + 6, y1 + 17);
            g.drawLine(x1 + 4, y1 + 18, x1 + 5, y1 + 18);
            if (this.isDragging && this.slider.isEnabled()) {
                g.setColor(Theme.sliderThumbColor[Theme.style].getColor());
                g.drawLine(x1 + 1, y1 + 1, x2 - 2, y1 + 1);
                g.drawLine(x1 + 1, y1 + 2, x1 + 1, y1 + 16);
            }
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderLightDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderLightColor[Theme.style].getColor());
            }
            g.drawLine(x1, y1, x1, y1 + 15);
            g.drawLine(x1 + 1, y1, x2 - 1, y1);
            g.drawLine(x1 + 1, y1 + 16, x1 + 1, y1 + 16);
            g.drawLine(x1 + 2, y1 + 17, x1 + 2, y1 + 17);
            g.drawLine(x1 + 3, y1 + 18, x1 + 3, y1 + 18);
            g.drawLine(x1 + 4, y1 + 19, x1 + 4, y1 + 19);
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderDarkDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderDarkColor[Theme.style].getColor());
            }
            g.drawLine(x2 - 1, y1 + 1, x2 - 1, y1 + 15);
            g.drawLine(x1 + 8, y1 + 16, x1 + 8, y1 + 16);
            g.drawLine(x1 + 7, y1 + 17, x1 + 7, y1 + 17);
            g.drawLine(x1 + 6, y1 + 18, x1 + 6, y1 + 18);
            g.drawLine(x1 + 5, y1 + 19, x1 + 5, y1 + 19);
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderBorderDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderBorderColor[Theme.style].getColor());
            }
            g.drawLine(x2, y1, x2, y1 + 15);
            g.drawLine(x1 + 9, y1 + 16, x1 + 9, y1 + 16);
            g.drawLine(x1 + 8, y1 + 17, x1 + 8, y1 + 17);
            g.drawLine(x1 + 7, y1 + 18, x1 + 7, y1 + 18);
            g.drawLine(x1 + 6, y1 + 19, x1 + 6, y1 + 19);
            g.drawLine(x1 + 5, y1 + 20, x1 + 5, y1 + 20);
        } else {
            g.fillRect(x1 + 2, y1 + 1, this.thumbRect.width - 2, this.thumbRect.height - 2);
            if (this.isDragging && this.slider.isEnabled()) {
                g.setColor(Theme.sliderThumbColor[Theme.style].getColor());
                g.drawLine(x1 + 2, y1 + 1, x2 - 2, y1 + 1);
                g.drawLine(x1 + 2, y1 + 2, x1 + 2, y2 - 2);
            }
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderLightDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderLightColor[Theme.style].getColor());
            }
            g.drawLine(x1 + 1, y1, x1 + 1, y2 - 1);
            g.drawLine(x1 + 1, y1, x2 - 1, y1);
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderDarkDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderDarkColor[Theme.style].getColor());
            }
            g.drawLine(x1 + 2, y1 + 9, x2 - 1, y1 + 9);
            g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 2);
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderBorderDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderBorderColor[Theme.style].getColor());
            }
            g.drawLine(x1 + 1, y2, x2, y2);
            g.drawLine(x2, y1, x2, y2);
        }
    }

    private void drawXpThumb(Graphics g) {
        int x1 = this.thumbRect.x;
        int y1 = this.thumbRect.y;
        int x2 = x1 + this.thumbRect.width - 1;
        int y2 = y1 + this.thumbRect.height - 1;
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                g.fillRect(x1 + 1, y1 + 4, this.thumbRect.width - 4, this.thumbRect.height - 8);
                g.drawLine(x1 + 5, y2 - 3, x1 + 5, y2 - 3);
                Color c = g.getColor();
                g.setColor(ColorRoutines.darken(c, 10));
                g.drawLine(x2 - 2, y1 + 4, x2 - 2, y2 - 6);
                g.setColor(ColorRoutines.darken(c, 20));
                g.drawLine(x2 - 1, y1 + 4, x2 - 1, y2 - 7);
                ColorUIResource bc = null;
                bc = !this.slider.isEnabled() ? Theme.sliderBorderDisabledColor[Theme.style].getColor() : Theme.sliderBorderColor[Theme.style].getColor();
                g.setColor(bc);
                g.drawLine(x1 + 1, y1, x2 - 1, y1);
                g.drawLine(x1, y1 + 1, x1, y2 - 5);
                g.drawLine(x1 + 1, y2 - 4, x1 + 1, y2 - 4);
                g.drawLine(x1 + 2, y2 - 3, x1 + 2, y2 - 3);
                g.drawLine(x1 + 3, y2 - 2, x1 + 3, y2 - 2);
                g.drawLine(x1 + 4, y2 - 1, x1 + 4, y2 - 1);
                g.setColor(Theme.sliderDarkColor[Theme.style].getColor());
                g.drawLine(x2, y1 + 1, x2, y2 - 5);
                g.drawLine(x2 - 1, y2 - 4, x2 - 1, y2 - 4);
                g.drawLine(x2 - 2, y2 - 3, x2 - 2, y2 - 3);
                g.drawLine(x2 - 3, y2 - 2, x2 - 3, y2 - 2);
                g.drawLine(x2 - 4, y2 - 1, x2 - 4, y2 - 1);
                g.drawLine(x2 - 5, y2, x2 - 5, y2);
                ColorUIResource col = null;
                if (!this.slider.isEnabled()) {
                    col = Theme.sliderBorderDisabledColor[Theme.style].getColor();
                    g.setColor(col);
                } else {
                    col = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled[Theme.style] ? Theme.sliderThumbRolloverColor[Theme.style].getColor() : Theme.sliderLightColor[Theme.style].getColor();
                }
                Color c2 = SBChooser.getAdjustedColor(col, 67, 39);
                if (this.slider.isEnabled()) {
                    g.setColor(c2);
                }
                g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
                g.drawLine(x1 + 1, y2 - 6, x1 + 1, y2 - 6);
                g.drawLine(x1 + 2, y2 - 5, x1 + 2, y2 - 5);
                g.drawLine(x1 + 3, y2 - 4, x1 + 3, y2 - 4);
                if (this.slider.isEnabled()) {
                    g.setColor(ColorRoutines.getAverage(bc, c2));
                }
                g.drawLine(x1 + 1, y2 - 5, x1 + 1, y2 - 5);
                g.drawLine(x1 + 2, y2 - 4, x1 + 2, y2 - 4);
                g.drawLine(x1 + 3, y2 - 3, x1 + 3, y2 - 3);
                Color c3 = ColorRoutines.getAverage(col, c2);
                if (this.slider.isEnabled()) {
                    g.setColor(c3);
                }
                g.drawLine(x1 + 1, y1 + 2, x2 - 1, y1 + 2);
                g.drawLine(x1 + 4, y2 - 3, x1 + 4, y2 - 3);
                g.drawLine(x1 + 5, y2 - 2, x1 + 5, y2 - 2);
                g.drawLine(x1 + 6, y2 - 3, x1 + 6, y2 - 3);
                if (this.slider.isEnabled()) {
                    g.setColor(ColorRoutines.getAverage(bc, c3));
                }
                g.drawLine(x1 + 4, y2 - 2, x1 + 4, y2 - 2);
                g.drawLine(x1 + 5, y2 - 1, x1 + 5, y2 - 1);
                g.drawLine(x1 + 6, y2 - 2, x1 + 6, y2 - 2);
                if (this.slider.isEnabled()) {
                    g.setColor(col);
                }
                g.drawLine(x1 + 1, y1 + 3, x2 - 1, y1 + 3);
                g.drawLine(x1 + 9, y2 - 6, x1 + 9, y2 - 6);
                g.drawLine(x1 + 8, y2 - 5, x1 + 8, y2 - 5);
                g.drawLine(x1 + 7, y2 - 4, x1 + 7, y2 - 4);
                if (this.slider.isEnabled()) {
                    g.setColor(ColorRoutines.getAverage(bc, col));
                }
                g.drawLine(x1 + 9, y2 - 5, x1 + 9, y2 - 5);
                g.drawLine(x1 + 8, y2 - 4, x1 + 8, y2 - 4);
                g.drawLine(x1 + 7, y2 - 3, x1 + 7, y2 - 3);
            } else {
                g.fillRect(x1 + 4, y1 + 1, this.thumbRect.width - 8, this.thumbRect.height - 4);
                g.drawLine(x2 - 3, y1 + 5, x2 - 3, y1 + 5);
                Color c = g.getColor();
                g.setColor(ColorRoutines.darken(c, 10));
                g.drawLine(x1 + 4, y2 - 2, x2 - 6, y2 - 2);
                g.setColor(ColorRoutines.darken(c, 20));
                g.drawLine(x1 + 4, y2 - 1, x2 - 7, y2 - 1);
                ColorUIResource bc = null;
                bc = !this.slider.isEnabled() ? Theme.sliderBorderDisabledColor[Theme.style].getColor() : Theme.sliderBorderColor[Theme.style].getColor();
                g.setColor(bc);
                g.drawLine(x1, y1 + 1, x1, y2 - 1);
                g.drawLine(x1 + 1, y1, x2 - 5, y1);
                g.drawLine(x2 - 4, y1 + 1, x2 - 4, y1 + 1);
                g.drawLine(x2 - 3, y1 + 2, x2 - 3, y1 + 2);
                g.drawLine(x2 - 2, y1 + 3, x2 - 2, y1 + 3);
                g.drawLine(x2 - 1, y1 + 4, x2 - 1, y1 + 4);
                g.setColor(Theme.sliderDarkColor[Theme.style].getColor());
                g.drawLine(x1 + 1, y2, x2 - 5, y2);
                g.drawLine(x2 - 4, y2 - 1, x2 - 4, y2 - 1);
                g.drawLine(x2 - 3, y2 - 2, x2 - 3, y2 - 2);
                g.drawLine(x2 - 2, y2 - 3, x2 - 2, y2 - 3);
                g.drawLine(x2 - 1, y2 - 4, x2 - 1, y2 - 4);
                g.drawLine(x2, y2 - 5, x2, y2 - 5);
                ColorUIResource col = null;
                if (!this.slider.isEnabled()) {
                    col = Theme.sliderBorderDisabledColor[Theme.style].getColor();
                    g.setColor(col);
                } else {
                    col = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled[Theme.style] ? Theme.sliderThumbRolloverColor[Theme.style].getColor() : Theme.sliderLightColor[Theme.style].getColor();
                }
                Color c2 = SBChooser.getAdjustedColor(col, 67, 39);
                if (this.slider.isEnabled()) {
                    g.setColor(c2);
                }
                g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 1);
                g.drawLine(x2 - 6, y1 + 1, x2 - 6, y1 + 1);
                g.drawLine(x2 - 5, y1 + 2, x2 - 5, y1 + 2);
                g.drawLine(x2 - 4, y1 + 3, x2 - 4, y1 + 3);
                if (this.slider.isEnabled()) {
                    g.setColor(ColorRoutines.getAverage(bc, c2));
                }
                g.drawLine(x2 - 5, y1 + 1, x2 - 5, y1 + 1);
                g.drawLine(x2 - 4, y1 + 2, x2 - 4, y1 + 2);
                g.drawLine(x2 - 3, y1 + 3, x2 - 3, y1 + 3);
                Color c3 = ColorRoutines.getAverage(col, c2);
                if (this.slider.isEnabled()) {
                    g.setColor(c3);
                }
                g.drawLine(x1 + 2, y1 + 1, x1 + 2, y2 - 1);
                g.drawLine(x2 - 3, y1 + 4, x2 - 3, y1 + 4);
                g.drawLine(x2 - 2, y1 + 5, x2 - 2, y1 + 5);
                g.drawLine(x2 - 3, y1 + 6, x2 - 3, y1 + 6);
                if (this.slider.isEnabled()) {
                    g.setColor(ColorRoutines.getAverage(bc, c3));
                }
                g.drawLine(x2 - 2, y1 + 4, x2 - 2, y1 + 4);
                g.drawLine(x2 - 1, y1 + 5, x2 - 1, y1 + 5);
                g.drawLine(x2 - 2, y1 + 6, x2 - 2, y1 + 6);
                if (this.slider.isEnabled()) {
                    g.setColor(col);
                }
                g.drawLine(x1 + 3, y1 + 1, x1 + 3, y2 - 1);
                g.drawLine(x2 - 6, y1 + 9, x2 - 6, y1 + 9);
                g.drawLine(x2 - 5, y1 + 8, x2 - 5, y1 + 8);
                g.drawLine(x2 - 4, y1 + 7, x2 - 4, y1 + 7);
                if (this.slider.isEnabled()) {
                    g.setColor(ColorRoutines.getAverage(bc, col));
                }
                g.drawLine(x2 - 5, y1 + 9, x2 - 5, y1 + 9);
                g.drawLine(x2 - 4, y1 + 8, x2 - 4, y1 + 8);
                g.drawLine(x2 - 3, y1 + 7, x2 - 3, y1 + 7);
            }
        } else if (this.slider.getOrientation() == 0) {
            g.fillRect(x1 + 1, y1 + 1, this.thumbRect.width - 4, this.thumbRect.height - 4);
            Color c = g.getColor();
            g.setColor(ColorRoutines.darken(c, 10));
            g.drawLine(x2 - 2, y1 + 3, x2 - 2, y2 - 3);
            g.setColor(ColorRoutines.darken(c, 20));
            g.drawLine(x2 - 1, y1 + 3, x2 - 1, y2 - 3);
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderBorderDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderBorderColor[Theme.style].getColor());
            }
            g.drawLine(x1, y1 + 1, x1, y2 - 1);
            g.drawLine(x1 + 1, y1, x2 - 1, y1);
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderDarkDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderDarkColor[Theme.style].getColor());
            }
            g.drawLine(x1 + 1, y2, x2 - 1, y2);
            g.drawLine(x2, y1 + 1, x2, y2 - 1);
            ColorUIResource col = null;
            if (!this.slider.isEnabled()) {
                col = Theme.sliderBorderDisabledColor[Theme.style].getColor();
                g.setColor(col);
            } else {
                col = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled[Theme.style] ? Theme.sliderThumbRolloverColor[Theme.style].getColor() : Theme.sliderLightColor[Theme.style].getColor();
            }
            Color c2 = SBChooser.getAdjustedColor(col, 67, 39);
            if (this.slider.isEnabled()) {
                g.setColor(c2);
            }
            g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
            if (this.slider.isEnabled()) {
                g.setColor(ColorRoutines.getAverage(col, c2));
            }
            g.drawLine(x1 + 1, y1 + 2, x2 - 1, y1 + 2);
            g.drawLine(x1 + 1, y2 - 2, x2 - 1, y2 - 2);
            if (this.slider.isEnabled()) {
                g.setColor(col);
            }
            g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
        } else {
            g.fillRect(x1 + 1, y1 + 1, this.thumbRect.width - 4, this.thumbRect.height - 4);
            Color c = g.getColor();
            g.setColor(ColorRoutines.darken(c, 10));
            g.drawLine(x1 + 3, y2 - 2, x2 - 3, y2 - 2);
            g.setColor(ColorRoutines.darken(c, 20));
            g.drawLine(x1 + 3, y2 - 1, x2 - 3, y2 - 1);
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderBorderDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderBorderColor[Theme.style].getColor());
            }
            g.drawLine(x1 + 1, y1, x2 - 1, y1);
            g.drawLine(x1, y1 + 1, x1, y2 - 1);
            if (!this.slider.isEnabled()) {
                g.setColor(Theme.sliderDarkDisabledColor[Theme.style].getColor());
            } else {
                g.setColor(Theme.sliderDarkColor[Theme.style].getColor());
            }
            g.drawLine(x2, y1 + 1, x2, y2 - 1);
            g.drawLine(x1 + 1, y2, x2 - 1, y2);
            ColorUIResource col = null;
            if (!this.slider.isEnabled()) {
                col = Theme.sliderBorderDisabledColor[Theme.style].getColor();
                g.setColor(col);
            } else {
                col = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled[Theme.style] ? Theme.sliderThumbRolloverColor[Theme.style].getColor() : Theme.sliderLightColor[Theme.style].getColor();
            }
            Color c2 = SBChooser.getAdjustedColor(col, 67, 39);
            if (this.slider.isEnabled()) {
                g.setColor(c2);
            }
            g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 1);
            if (this.slider.isEnabled()) {
                g.setColor(ColorRoutines.getAverage(col, c2));
            }
            g.drawLine(x1 + 2, y1 + 1, x1 + 2, y2 - 1);
            g.drawLine(x2 - 2, y1 + 1, x2 - 2, y2 - 1);
            if (this.slider.isEnabled()) {
                g.setColor(col);
            }
            g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 1);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new TinySliderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    protected int getThumbOverhang() {
        if (this.slider.getOrientation() == 1) {
            return (int)(this.getThumbSize().getWidth() - (double)this.getTrackWidth()) / 2;
        }
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    public void paintTrack(Graphics g) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyTrack(g);
                break;
            }
            case 1: {
                this.drawWinTrack(g);
                break;
            }
            case 2: {
                this.drawXpTrack(g);
            }
        }
    }

    public void paintFocus(Graphics g) {
        if (!Theme.sliderFocusEnabled[Theme.style]) {
            return;
        }
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Stroke memStroke = g2d.getStroke();
        g2d.setStroke(focusStroke);
        g2d.setColor(Theme.sliderFocusColor[Theme.style].getColor());
        g2d.drawRect(0, 0, this.slider.getWidth() - 1, this.slider.getHeight() - 1);
        g2d.setStroke(memStroke);
    }

    private void drawTinyTrack(Graphics g) {
        int x1 = this.trackRect.x;
        int x2 = x1 + this.trackRect.width;
        int y1 = this.trackRect.y;
        int y2 = y1 + this.trackRect.height;
        if (this.slider.getOrientation() == 0) {
            int y = y1 + (this.trackRect.height - 7) / 2;
            g.setColor(new Color(170, 170, 170));
            g.drawLine(x1, y + 1, x1, y + 4);
            g.drawLine(x2 - 1, y + 1, x2 - 1, y + 1);
            g.fillRect(x1 + 1, y, this.trackRect.width - 2, 5);
            g.setColor(new Color(34, 34, 34));
            g.drawLine(x1 + 1, y + 2, x1 + 1, y + 4);
            g.drawLine(x2 - 1, y + 2, x2 - 1, y + 4);
            g.drawLine(x1 + 2, y + 1, x2 - 2, y + 1);
            g.drawLine(x1 + 2, y + 5, x2 - 2, y + 5);
            g.setColor(Color.WHITE);
            g.drawLine(x1 + 1, y + 5, x1 + 1, y + 5);
            g.drawLine(x1 + 2, y + 6, x2 - 1, y + 6);
            g.drawLine(x2 - 1, y + 5, x2 - 1, y + 5);
            g.drawLine(x2, y + 2, x2, y + 4);
        } else {
            int x = x1 + (this.trackRect.width - 7) / 2 + 1;
            g.setColor(new Color(170, 170, 170));
            g.drawLine(x + 1, y1 + 1, x + 1, y1 + 1);
            g.drawLine(x + 1, y2, x + 4, y2);
            g.fillRect(x, y1 + 2, 5, this.trackRect.height - 2);
            g.setColor(new Color(34, 34, 34));
            g.drawLine(x + 2, y1 + 1, x + 4, y1 + 1);
            g.drawLine(x + 2, y2 - 1, x + 4, y2 - 1);
            g.drawLine(x + 1, y1 + 2, x + 1, y2 - 2);
            g.drawLine(x + 5, y1 + 2, x + 5, y2 - 2);
            g.setColor(Color.WHITE);
            g.drawLine(x + 2, y1, x + 5, y1);
            g.drawLine(x + 5, y1 + 1, x + 5, y1 + 1);
            g.drawLine(x + 6, y1 + 1, x + 6, y2 - 2);
            g.drawLine(x + 5, y2 - 1, x + 5, y2 - 1);
        }
    }

    private void drawWinTrack(Graphics g) {
        int x1 = this.trackRect.x;
        int x2 = x1 + this.trackRect.width;
        int y1 = this.trackRect.y;
        int y2 = y1 + this.trackRect.height;
        if (this.slider.getOrientation() == 0) {
            int y = y1 + (this.trackRect.height - 4) / 2;
            g.setColor(Theme.sliderTrackColor[Theme.style].getColor());
            g.drawLine(x1 + 1, y + 2, x2 - 1, y + 2);
            g.drawLine(x2 - 1, y + 1, x2 - 1, y + 1);
            g.setColor(Theme.sliderTrackDarkColor[Theme.style].getColor());
            g.drawLine(x1, y, x1, y + 3);
            g.drawLine(x1 + 1, y, x2, y);
            g.setColor(Theme.sliderTrackBorderColor[Theme.style].getColor());
            g.drawLine(x1 + 1, y + 1, x2 - 2, y + 1);
            g.setColor(Theme.sliderTrackLightColor[Theme.style].getColor());
            g.drawLine(x2, y + 1, x2, y + 2);
            g.drawLine(x1 + 1, y + 3, x2, y + 3);
        } else {
            int x = x1 + (this.trackRect.width - 4) / 2 + 1;
            g.setColor(Theme.sliderTrackColor[Theme.style].getColor());
            g.drawLine(x + 2, y1 + 1, x + 2, y2 - 1);
            g.drawLine(x + 1, y2 - 1, x + 1, y2 - 1);
            g.setColor(Theme.sliderTrackDarkColor[Theme.style].getColor());
            g.drawLine(x, y1, x + 3, y1);
            g.drawLine(x, y1 + 1, x, y2);
            g.setColor(Theme.sliderTrackBorderColor[Theme.style].getColor());
            g.drawLine(x + 1, y1 + 1, x + 1, y2 - 2);
            g.setColor(Theme.sliderTrackLightColor[Theme.style].getColor());
            g.drawLine(x + 3, y1 + 1, x + 3, y2);
            g.drawLine(x + 1, y2, x + 2, y2);
        }
    }

    private void drawXpTrack(Graphics g) {
        int x1 = this.trackRect.x;
        int x2 = x1 + this.trackRect.width;
        int y1 = this.trackRect.y;
        int y2 = y1 + this.trackRect.height;
        if (this.slider.getOrientation() == 0) {
            int y = y1 + (this.trackRect.height - 4) / 2;
            g.setColor(Theme.sliderTrackColor[Theme.style].getColor());
            g.drawLine(x1 + 1, y + 2, x2 - 2, y + 2);
            g.setColor(Theme.sliderTrackDarkColor[Theme.style].getColor());
            g.drawLine(x1 + 1, y + 1, x2 - 2, y + 1);
            g.drawLine(x2 - 1, y + 1, x2 - 1, y + 2);
            g.drawLine(x1, y, x1, y);
            g.drawLine(x1, y + 3, x1, y + 3);
            g.setColor(Theme.sliderTrackLightColor[Theme.style].getColor());
            g.drawLine(x1 + 1, y + 3, x2 - 1, y + 3);
            g.drawLine(x2, y + 1, x2, y + 3);
            g.setColor(Theme.sliderTrackBorderColor[Theme.style].getColor());
            g.drawLine(x1 + 1, y, x2, y);
            g.setColor(ColorRoutines.lighten(Theme.sliderTrackBorderColor[Theme.style].getColor(), 20));
            g.drawLine(x1, y + 1, x1, y + 2);
        } else {
            int x = x1 + (this.trackRect.width - 4) / 2;
            g.setColor(Theme.sliderTrackBorderColor[Theme.style].getColor());
            g.drawLine(x, y1 + 2, x, y2 - 2);
            g.setColor(ColorRoutines.lighten(Theme.sliderTrackBorderColor[Theme.style].getColor(), 20));
            g.drawLine(x, y1 + 1, x + 2, y1 + 1);
            g.drawLine(x, y2 - 1, x + 2, y2 - 1);
            g.setColor(Theme.sliderTrackDarkColor[Theme.style].getColor());
            g.drawLine(x, y1, x + 3, y1);
            g.drawLine(x + 1, y1 + 2, x + 1, y2 - 2);
            g.drawLine(x, y2, x + 3, y2);
            g.setColor(Theme.sliderTrackLightColor[Theme.style].getColor());
            g.drawLine(x + 3, y1 + 1, x + 3, y2 - 1);
            g.setColor(Theme.sliderTrackColor[Theme.style].getColor());
            g.drawLine(x + 2, y1 + 2, x + 2, y2 - 2);
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? Theme.sliderTickColor[Theme.style].getColor() : Theme.sliderTickDisabledColor[Theme.style].getColor());
        g.drawLine(x, 0, x, tickBounds.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? Theme.sliderTickColor[Theme.style].getColor() : Theme.sliderTickDisabledColor[Theme.style].getColor());
        g.drawLine(x, 0, x, tickBounds.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? Theme.sliderTickColor[Theme.style].getColor() : Theme.sliderTickDisabledColor[Theme.style].getColor());
        g.drawLine(0, y, tickBounds.width / 2 - 1, y);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? Theme.sliderTickColor[Theme.style].getColor() : Theme.sliderTickDisabledColor[Theme.style].getColor());
        g.drawLine(0, y, tickBounds.width - 2, y);
    }

    class MyTrackListener
    extends BasicSliderUI.TrackListener {
        MyTrackListener() {
            super(TinySliderUI.this);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            TinySliderUI.this.isDragging = false;
            TinySliderUI.this.slider.repaint();
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (TinySliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                TinySliderUI.this.isDragging = true;
            }
            TinySliderUI.this.slider.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            TinySliderUI.this.isRollover = false;
            TinySliderUI.this.wasRollover = false;
            if (TinySliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                TinySliderUI.this.isRollover = true;
            }
        }

        public void mouseExited(MouseEvent e) {
            TinySliderUI.this.isRollover = false;
            if (TinySliderUI.this.isRollover != TinySliderUI.this.wasRollover) {
                TinySliderUI.this.slider.repaint();
                TinySliderUI.this.wasRollover = TinySliderUI.this.isRollover;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (TinySliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                TinySliderUI.this.isRollover = true;
            }
            super.mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            if (TinySliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                TinySliderUI.this.isRollover = true;
                if (TinySliderUI.this.isRollover != TinySliderUI.this.wasRollover) {
                    TinySliderUI.this.slider.repaint();
                    TinySliderUI.this.wasRollover = TinySliderUI.this.isRollover;
                }
            } else {
                TinySliderUI.this.isRollover = false;
                if (TinySliderUI.this.isRollover != TinySliderUI.this.wasRollover) {
                    TinySliderUI.this.slider.repaint();
                    TinySliderUI.this.wasRollover = TinySliderUI.this.isRollover;
                }
            }
        }
    }
}

