/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.model;

import conector.eurobits.efactura.desktop.view.MenuBar;
import conector.eurobits.efactura.desktop.view.NombresMenus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Settings
implements NombresMenus {
    public static final String LOG_PATH = "Config";
    public static final String LOG_FILE_NAME = "log4j.xml";
    public static final String CONFIG_FILE_NAME = "config.xml";
    public static final String APPLICATION_CONFIG_FILE_NAME = "application_config.xml";
    public static final String KEY_FILE_NAME = "llaveERP.txt";
    private String version = "2.0-r8596";
    private static Settings settings = null;
    protected static final Logger logger = Logger.getLogger(Settings.class);
    protected static final String BASE_DIRECTORY = "SistemaeFactura";
    protected static final String KEY_PATH = "AccessKey";
    protected static final String CONFIG_PATH = "Config";
    protected static final String DATA_PATH = "DataExchange";
    protected static final String RECEIVED_PATH = "Received";
    protected static final String SENT_PATH = "Sent";
    protected static final String INVOICE_RECEIVED_PATH = "Invoices";
    protected static final String PDF_RECEIVED_PATH = "PDF";
    protected static final String SIGNED_RECEIVED_PATH = "Signed";
    protected static final String PENDING_RECEIVED_PATH = "Pending";
    protected static final String PROCESSED_RECEIVED_PATH = "Processed";
    protected static final String RECOVERY_RECEIVED_PATH = "Recovery";
    protected static final String INVOICE_SENT_PATH = "Invoices";
    protected static final String PDF_SENT_PATH = "PDF";
    protected static final String SIGNED_SENT_PATH = "Signed";
    protected static final String PENDING_SENT_PATH = "Pending";
    protected static final String STATUS_RECEIVED_PATH = "Status";
    protected static final String STATUS_PENDING_RECEIVED_PATH = "Pending";
    protected static final String STATUS_PROCESSED_RECEIVED_PATH = "Processed";
    protected static final String STATUS_SENT_PATH = "Status";
    protected static final String STATUS_PENDING_SENT_PATH = "Pending";
    protected static final String STATUS_PROCESSED_SENT_PATH = "Processed";
    private Date fechaUltimaConsulta;
    protected File baseFolder = null;
    protected static final String PROCESSED_SENT_PATH = "Processed";
    protected String url = "http://frontend.efactura.eurobits.es:8780/frontend/services/eFacturaWS";
    protected String password = "eurobits";
    protected String port = "";
    protected String ip = "";
    protected boolean normalProxy = false;
    protected boolean advancedProxy = false;
    protected String userProxy = "";
    protected String passwordProxy = "";
    protected boolean autoPlanificadorEnvio = false;
    protected int tiempoPlanificadorEnvio = 300;
    protected boolean autoPlanificadorRecibir = false;
    protected int tiempoPlanificadorRecibir = 300;
    protected String tipoFacturaEnviar = "UBL10";
    protected boolean autoFirmadaEnvio = false;
    protected boolean autoPDFEnvio = false;
    protected String tipoFacturaRecibir = "UBL10";
    protected boolean autoFirmadaRecibir = false;
    protected boolean preservarIdFiscal = false;
    protected String magnitudPlanificadorEnvio = "Minutos";
    protected String magnitudPlanificadorRecepcion = "Minutos";
    protected boolean autoPDFRecibir = false;
    protected String cif = "";
    protected String keyFolder = null;
    protected String dataFolder = null;
    protected String logFolder = null;
    protected String configFolder = null;
    protected String pdfReceivedFolder = null;
    protected String inFolder = null;
    protected String outFolder = null;
    protected String signedReceivedFolder = null;
    protected String invoiceReceivedFolder = null;
    protected String pendingReceivedFolder = null;
    protected String processedReceivedFolder = null;
    protected String recoveryReceivedFolder = null;
    private String statusReceivedFolder = null;
    private String statusPendingReceivedFolder = null;
    private String statusProcessedReceivedFolder = null;
    private String statusSentFolder = null;
    private String statusPendingSentFolder = null;
    private String statusProcessedSentFolder = null;
    protected String pdfSentFolder = null;
    protected String signedSentFolder = null;
    protected String invoiceSentFolder = null;
    protected String pendingSentFolder = null;
    protected String processedSentFolder = null;
    protected String recoverySentFolder = null;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isAutoFirmadaRecibir() {
        return this.autoFirmadaRecibir;
    }

    public boolean isAutoFirmadaEnvio() {
        return this.autoFirmadaEnvio;
    }

    public void setAutoFirmadaRecibir(boolean autoFirmadaRecibir) {
        this.autoFirmadaRecibir = autoFirmadaRecibir;
    }

    public void setAutoFirmadaEnvio(boolean autoFirmadaEnvio) {
        this.autoFirmadaEnvio = autoFirmadaEnvio;
    }

    public boolean isAutoPDFRecibir() {
        return this.autoPDFRecibir;
    }

    public boolean isAutoPDFEnvio() {
        return this.autoPDFEnvio;
    }

    public void setAutoPDFRecibir(boolean autoPDFRecibir) {
        this.autoPDFRecibir = autoPDFRecibir;
    }

    public void setAutoPDFEnvio(boolean autoPDFEnvio) {
        this.autoPDFEnvio = autoPDFEnvio;
    }

    public String getTipoFacturaRecibir() {
        return this.tipoFacturaRecibir;
    }

    public void setTipoFacturaRecibir(String tipoFactura) {
        this.tipoFacturaRecibir = tipoFactura;
    }

    public String getTipoFacturaEnviar() {
        return this.tipoFacturaEnviar;
    }

    public void setTipoFacturaEnviar(String tipoFactura) {
        this.tipoFacturaEnviar = tipoFactura;
    }

    public Date getFechaUltimaConsulta() {
        return this.fechaUltimaConsulta;
    }

    public void setFechaUltimaConsulta(Date fechaUltimaConsulta) {
        this.fechaUltimaConsulta = fechaUltimaConsulta;
    }

    public int getTiempoPlanificadorRecibir() {
        int tiempo = this.tiempoPlanificadorRecibir;
        if ("Horas".equals(this.magnitudPlanificadorRecepcion)) {
            tiempo /= 60;
        } else if ("Dias".equals(this.magnitudPlanificadorRecepcion) || "D\u00edas".equals(this.magnitudPlanificadorRecepcion)) {
            tiempo /= 1440;
        }
        return tiempo;
    }

    public int getTiempoRecepcionEnMinutos() {
        return this.tiempoPlanificadorRecibir;
    }

    public int getTiempoPlanificadorEnvio() {
        int tiempo = this.tiempoPlanificadorEnvio;
        if ("Horas".equals(this.magnitudPlanificadorEnvio)) {
            tiempo /= 60;
        } else if ("D\u00edas".equals(this.magnitudPlanificadorEnvio) || "D\u00edas".equals(this.magnitudPlanificadorEnvio)) {
            tiempo /= 1440;
        }
        return tiempo;
    }

    public int getTiempoEnvioEnMinutos() {
        return this.tiempoPlanificadorEnvio;
    }

    public void setTiempoPlanificadorRecibir(int tiempoPlanificadorRecibir) {
        int tiempo = tiempoPlanificadorRecibir;
        if ("Horas".equals(this.magnitudPlanificadorRecepcion)) {
            tiempo *= 60;
        } else if ("Dias".equals(this.magnitudPlanificadorRecepcion) || "D\u00edas".equals(this.magnitudPlanificadorRecepcion)) {
            tiempo *= 1440;
        }
        this.tiempoPlanificadorRecibir = tiempo;
    }

    public void setTiempoPlanificadorEnvio(int tiempoPlanificadorEnvio) {
        int tiempo = tiempoPlanificadorEnvio;
        if ("Horas".equals(this.magnitudPlanificadorEnvio)) {
            tiempo *= 60;
        } else if ("Dias".equals(this.magnitudPlanificadorEnvio) || "D\u00edas".equals(this.magnitudPlanificadorEnvio)) {
            tiempo *= 1440;
        }
        this.tiempoPlanificadorEnvio = tiempo;
    }

    public void setAutoPlanificadorRecibir(boolean autoPlanificadorRecibir) {
        this.autoPlanificadorRecibir = autoPlanificadorRecibir;
    }

    public void setAutoPlanificadorEnvio(boolean autoPlanificadorEnvio) {
        this.autoPlanificadorEnvio = autoPlanificadorEnvio;
    }

    protected Settings() {
    }

    public static Settings getSettings() {
        if (settings == null) {
            settings = new Settings();
        }
        return settings;
    }

    protected boolean comprobarTipoFactura(String factura) {
        boolean valido = false;
        if (factura != null) {
            for (int i = 0; i < TIPOS_FACTURA.length; ++i) {
                if (!factura.equalsIgnoreCase(TIPOS_FACTURA[i])) continue;
                valido = true;
            }
        }
        return valido;
    }

    public Settings(File configFile) throws DocumentException {
        this.load();
    }

    public boolean isAutoPlanificadorRecibir() {
        return this.autoPlanificadorRecibir;
    }

    public boolean isAutoPlanificadorEnvio() {
        return this.autoPlanificadorEnvio;
    }

    public boolean isNormalProxy() {
        return this.normalProxy;
    }

    public void setNormalProxy(boolean normal_proxy) {
        this.normalProxy = normal_proxy;
    }

    public boolean isAdvancedProxy() {
        return this.advancedProxy;
    }

    public void setAdvancedProxy(boolean advanced_proxy) {
        this.advancedProxy = advanced_proxy;
    }

    public String getUserProxy() {
        return this.userProxy;
    }

    public void setUserProxy(String user_proxy) {
        this.userProxy = user_proxy;
    }

    public String getPasswordProxy() {
        return this.passwordProxy;
    }

    public void setPasswordProxy(String password_proxy) {
        this.passwordProxy = password_proxy;
    }

    public void loadApplicationInitConfig() throws DocumentException {
        Element item;
        Settings settings = Settings.getSettings();
        File applicationConfigFile = this.getApplicationInitConfigFile();
        SAXReader reader = new SAXReader();
        Document document = null;
        document = applicationConfigFile.getPath().indexOf("!") != -1 ? reader.read(Settings.class.getResourceAsStream("/conector/eurobits/efactura/desktop/view/resources/config.xml")) : reader.read(applicationConfigFile);
        Element root = document.getRootElement();
        if (root != null && (item = root.element("application_directory")) != null && item.getText() != null && this.baseFolder == null) {
            this.baseFolder = new File(item.getTextTrim());
        }
    }

    public void load() throws DocumentException {
        Element folders;
        Element factura;
        Element planificador;
        Element proxy;
        Element item;
        Settings.getSettings().loadApplicationInitConfig();
        File configFile = Settings.getSettings().getConfigFile();
        SAXReader reader = new SAXReader();
        Document document = null;
        document = configFile.getPath().indexOf("!") != -1 || !configFile.exists() ? reader.read(Settings.class.getResourceAsStream("/conector/eurobits/efactura/desktop/view/resources/config.xml")) : reader.read(configFile);
        Element root = document.getRootElement();
        Element versionNode = root.element("version");
        this.version = versionNode != null ? versionNode.getText() : this.getVersion();
        Element persistenciaNode = root.element("persistencia");
        if (persistenciaNode != null) {
            String fechaTxt = persistenciaNode.element("parametros").element("ultimaFechaConsultaCambioEstados").getText();
            if (fechaTxt != null && fechaTxt.length() > 0) {
                SimpleDateFormat formatoDelTexto = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    this.fechaUltimaConsulta = formatoDelTexto.parse(fechaTxt);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.fechaUltimaConsulta = this.getCurrentDate();
            }
        } else {
            this.fechaUltimaConsulta = this.getCurrentDate();
        }
        Element server = root.element("efactura-server");
        if (server != null) {
            item = server.element("url");
            if (item != null && item.getText() != null) {
                this.url = item.getTextTrim();
            }
            if ((item = server.element("password")) != null && item.getText() != null) {
                this.password = item.getTextTrim();
            }
        }
        if ((proxy = root.element("proxy")) != null) {
            String acti;
            item = proxy.element("normal-proxy");
            if (item != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("True")) {
                    this.normalProxy = true;
                } else if (acti.equalsIgnoreCase("False")) {
                    this.normalProxy = false;
                } else {
                    throw new DocumentException("Error en config.xml, en los datos de proxy (normal)");
                }
            }
            if ((item = proxy.element("ip")) != null && item.getText() != null) {
                this.ip = item.getTextTrim();
            }
            if ((item = proxy.element("port")) != null && item.getText() != null) {
                this.port = item.getTextTrim();
            }
            if ((item = proxy.element("advanced-proxy")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("True")) {
                    this.advancedProxy = true;
                } else if (acti.equalsIgnoreCase("False")) {
                    this.advancedProxy = false;
                } else {
                    throw new DocumentException("Error en config.xml, en los datos de proxy (advanced)");
                }
            }
            if ((item = proxy.element("user")) != null && item.getText() != null) {
                this.userProxy = item.getTextTrim();
            }
            if ((item = proxy.element("password")) != null && item.getText() != null) {
                this.passwordProxy = item.getTextTrim();
            }
        }
        if ((planificador = root.element("planificador")) != null) {
            String acti;
            item = planificador.element("activo-envio");
            if (item != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("True")) {
                    this.autoPlanificadorEnvio = true;
                } else if (acti.equalsIgnoreCase("False")) {
                    this.autoPlanificadorEnvio = false;
                } else {
                    throw new DocumentException("Error en los datos del planificador");
                }
            }
            if ((item = planificador.element("magnitud-envio")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("Minutos")) {
                    this.magnitudPlanificadorEnvio = "Minutos";
                } else if (acti.equalsIgnoreCase("Horas")) {
                    this.magnitudPlanificadorEnvio = "Horas";
                } else if (acti.equalsIgnoreCase("Dias")) {
                    this.magnitudPlanificadorEnvio = "D\u00edas";
                } else {
                    throw new DocumentException("Error en los datos del planificador");
                }
            }
            if ((item = planificador.element("tiempo-envio")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                try {
                    if (acti != null && acti.length() > 0) {
                        this.tiempoPlanificadorEnvio = Integer.parseInt(acti);
                        if (this.tiempoPlanificadorEnvio <= 0) {
                            throw new DocumentException("El tiempo de actualizacion del planificador debe ser mayor que 0");
                        }
                    }
                }
                catch (NumberFormatException e) {
                    throw new DocumentException("Error en los datos del planificador");
                }
            }
            if ((item = planificador.element("activo-recibir")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("True")) {
                    this.autoPlanificadorRecibir = true;
                } else if (acti.equalsIgnoreCase("False")) {
                    this.autoPlanificadorRecibir = false;
                } else {
                    throw new DocumentException("Error en los datos del planificador");
                }
            }
            if ((item = planificador.element("magnitud-recibir")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("Minutos")) {
                    this.magnitudPlanificadorRecepcion = "Minutos";
                } else if (acti.equalsIgnoreCase("Horas")) {
                    this.magnitudPlanificadorRecepcion = "Horas";
                } else if (acti.equalsIgnoreCase("Dias")) {
                    this.magnitudPlanificadorRecepcion = "D\u00edas";
                } else {
                    throw new DocumentException("Error en los datos del planificador");
                }
            }
            if ((item = planificador.element("tiempo-recibir")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                try {
                    if (acti != null && acti.length() > 0) {
                        this.tiempoPlanificadorRecibir = Integer.parseInt(acti);
                        if (this.tiempoPlanificadorRecibir <= 0) {
                            throw new DocumentException("El tiempo de actualizacion del planificador debe ser mayor que 0");
                        }
                    }
                }
                catch (NumberFormatException e) {
                    throw new DocumentException("Error en los datos del planificador");
                }
            }
        }
        if ((factura = root.element("factura")) != null) {
            String tipoDeFactura;
            String acti;
            item = factura.element("autoFirmadaEnvio");
            if (item != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("True")) {
                    this.autoFirmadaEnvio = true;
                } else if (acti.equalsIgnoreCase("False")) {
                    this.autoFirmadaEnvio = false;
                } else {
                    throw new DocumentException("Error en los datos de descargar factura automaticamente");
                }
            }
            if ((item = factura.element("autoPDFEnvio")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("True")) {
                    this.autoPDFEnvio = true;
                } else if (acti.equalsIgnoreCase("False")) {
                    this.autoPDFEnvio = false;
                } else {
                    throw new DocumentException("Error en los datos de descargar factura automaticamente");
                }
            }
            if ((item = factura.element("preservarIdFiscalEnvio")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("True")) {
                    this.preservarIdFiscal = true;
                } else if (acti.equalsIgnoreCase("False")) {
                    this.preservarIdFiscal = false;
                } else {
                    throw new DocumentException("Error en los datos de descargar factura automaticamente");
                }
            }
            if ((item = factura.element("autoFirmadaRecibir")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("True")) {
                    this.autoFirmadaRecibir = true;
                } else if (acti.equalsIgnoreCase("False")) {
                    this.autoFirmadaRecibir = false;
                } else {
                    throw new DocumentException("Error en los datos de descargar factura automaticamente");
                }
            }
            if ((item = factura.element("autoPDFRecibir")) != null && item.getText() != null) {
                acti = item.getTextTrim();
                if (acti.equalsIgnoreCase("True")) {
                    this.autoPDFRecibir = true;
                } else if (acti.equalsIgnoreCase("False")) {
                    this.autoPDFRecibir = false;
                } else {
                    throw new DocumentException("Error en los datos de descargar factura automaticamente");
                }
            }
            if ((item = factura.element("tipoSend")) != null && item.getText() != null && this.comprobarTipoFactura(tipoDeFactura = item.getTextTrim())) {
                this.tipoFacturaEnviar = tipoDeFactura;
            }
            if ((item = factura.element("tipoReceive")) != null && item.getText() != null && this.comprobarTipoFactura(tipoDeFactura = item.getTextTrim())) {
                this.tipoFacturaRecibir = tipoDeFactura;
            }
        }
        if ((server = root.element("cif-empresa")) != null && (item = server.element("cif")) != null && item.getText() != null) {
            this.cif = item.getTextTrim();
        }
        if ((folders = root.element("folders")) != null) {
            Element data;
            Element key = folders.element("key");
            if (key != null && (item = key.element("key-folder")) != null && item.getText() != null) {
                this.keyFolder = item.getTextTrim();
            }
            if ((item = folders.element("log")) != null && item.getText() != null && (item = item.element("log-folder")) != null && item.getText() != null) {
                this.logFolder = item.getTextTrim();
            }
            if ((data = folders.element("data")) != null) {
                Element miniF;
                item = data.element("data-folder");
                if (item != null && item.getText() != null) {
                    this.dataFolder = item.getTextTrim();
                }
                if ((miniF = data.element("received")) != null) {
                    item = miniF.element("pdf-folder");
                    if (item != null && item.getText() != null) {
                        this.pdfReceivedFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("signed-folder")) != null && item.getText() != null) {
                        this.signedReceivedFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("invoices-folder")) != null && item.getText() != null) {
                        this.invoiceReceivedFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("pending-folder")) != null && item.getText() != null) {
                        this.pendingReceivedFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("processed-folder")) != null && item.getText() != null) {
                        this.processedReceivedFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("recovery-folder")) != null && item.getText() != null) {
                        this.recoveryReceivedFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("status-folder")) != null && item.getText() != null) {
                        this.setStatusReceivedFolder(item.getTextTrim());
                    }
                    if ((item = miniF.element("status-pending-folder")) != null && item.getText() != null) {
                        this.setStatusPendingReceivedFolder(item.getTextTrim());
                    }
                    if ((item = miniF.element("status-processed-folder")) != null && item.getText() != null) {
                        this.setStatusProcessedReceivedFolder(item.getTextTrim());
                    }
                }
                if ((miniF = data.element("sent")) != null) {
                    item = miniF.element("pdf-folder");
                    if (item != null && item.getText() != null) {
                        this.pdfSentFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("signed-folder")) != null && item.getText() != null) {
                        this.signedSentFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("invoices-folder")) != null && item.getText() != null) {
                        this.invoiceSentFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("pending-folder")) != null && item.getText() != null) {
                        this.pendingSentFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("processed-folder")) != null && item.getText() != null) {
                        this.processedSentFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("recovery-folder")) != null && item.getText() != null) {
                        this.recoverySentFolder = item.getTextTrim();
                    }
                    if ((item = miniF.element("status-folder")) != null && item.getText() != null) {
                        this.setStatusSentFolder(item.getTextTrim());
                    }
                    if ((item = miniF.element("status-pending-folder")) != null && item.getText() != null) {
                        this.setStatusPendingSentFolder(item.getTextTrim());
                    }
                    if ((item = miniF.element("status-processed-folder")) != null && item.getText() != null) {
                        this.setStatusProcessedSentFolder(item.getTextTrim());
                    }
                }
            }
        }
        this.setConfigPathLogFile();
        if (this.logFolder == null || this.logFolder.length() == 0) {
            System.out.println("Log cargado desde resources/log4j.xml ");
            DOMConfigurator.configure(MenuBar.class.getResource("resources/log4j.xml"));
        } else {
            System.out.println("Log cargado desde el fichero: " + this.getLog());
            DOMConfigurator.configure(this.getLog().endsWith(".xml") ? this.getLog() : this.getLog() + File.separator + LOG_FILE_NAME);
        }
        logger.info("Log Inicializado");
    }

    private Date getCurrentDate() {
        return Calendar.getInstance().getTime();
    }

    private void setConfigPathLogFile() {
        String logpath = "";
        try {
            logpath = new File(this.getSystemBaseFolder(), "log").getCanonicalPath();
            boolean isCreateFile = this.makeFile(logpath);
            System.out.println("Creada carpeta de logs. " + isCreateFile);
        }
        catch (IOException e) {
            System.out.println("Could not get canonical path for " + logpath);
        }
        System.setProperty("log.home", logpath);
        System.out.println("Cargado carpeta de logs. " + logpath);
    }

    public void setConfigFolder(String configFolder) {
        this.configFolder = configFolder;
    }

    public String getConfigFolder() {
        return this.configFolder;
    }

    public File getConfigFile() {
        return new File(this.getConfig(), CONFIG_FILE_NAME);
    }

    public File getApplicationInitConfigFile() {
        return new File(this.getSystemBaseFolder(), APPLICATION_CONFIG_FILE_NAME);
    }

    public File getLogsFile() {
        if (!this.getLogs().getAbsolutePath().endsWith("xml")) {
            return new File(this.getLogs(), LOG_FILE_NAME);
        }
        return this.getLogs();
    }

    private boolean saveSystemApplicationConfig() throws IOException {
        if (!this.makeConfigurationDir()) {
            return false;
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("config");
        Element version = root.addElement("version");
        if (this.version != null) {
            version.addText(this.version);
        }
        Element applicationDirectory = root.addElement("application_directory");
        applicationDirectory.addText(this.getBaseFolder().getAbsolutePath());
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter(new FileOutputStream(this.getApplicationInitConfigFile()), format);
        writer.write(document);
        return true;
    }

    public boolean save() throws IOException {
        this.saveSystemApplicationConfig();
        if (!this.makeDirs()) {
            return false;
        }
        File archivoLogs = this.getLogsFile();
        if (!archivoLogs.exists()) {
            try {
                int c;
                InputStream in = MenuBar.class.getResourceAsStream("resources/log4j.xml");
                FileOutputStream out = new FileOutputStream(archivoLogs);
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                in.close();
                out.close();
                logger.info("Fichero de Configuraci\u00f3n de Logs Generado satisfactoriamente...");
            }
            catch (IOException e) {
                logger.error("Hubo un error de entrada/salida creando el Archivo de Logs!!!");
            }
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("config");
        Element version = root.addElement("version");
        version.addText(this.version);
        Element swing = root.addElement("swing");
        swing.addElement("lookAndFeel").addText("");
        swing.addElement("theme").addText("");
        swing.addElement("logo").addText("");
        swing.addElement("window-width").addText("");
        swing.addElement("window-height").addText("");
        Element server = root.addElement("efactura-server");
        server.addElement("url").addText(this.url);
        server.addElement("password").addText(this.password);
        Element proxy = root.addElement("proxy");
        proxy.addElement("normal-proxy").addText(this.normalProxy + "");
        proxy.addElement("ip").addText(this.ip);
        proxy.addElement("port").addText(this.port);
        proxy.addElement("advanced-proxy").addText(this.advancedProxy + "");
        proxy.addElement("user").addText(this.userProxy);
        proxy.addElement("password").addText(this.passwordProxy);
        Element planificador = root.addElement("planificador");
        planificador.addElement("activo-envio").addText(this.autoPlanificadorEnvio + "");
        planificador.addElement("activo-recibir").addText(this.autoPlanificadorRecibir + "");
        planificador.addElement("tiempo-envio").addText(this.tiempoPlanificadorEnvio + "");
        planificador.addElement("tiempo-recibir").addText(this.tiempoPlanificadorRecibir + "");
        planificador.addElement("magnitud-envio").addText(this.magnitudPlanificadorEnvio);
        planificador.addElement("magnitud-recibir").addText(this.magnitudPlanificadorRecepcion);
        Element factura = root.addElement("factura");
        factura.addElement("autoFirmadaEnvio").addText(this.autoFirmadaEnvio + "");
        factura.addElement("autoPDFEnvio").addText(this.autoPDFEnvio + "");
        factura.addElement("preservarIdFiscalEnvio").addText(this.preservarIdFiscal + "");
        factura.addElement("autoFirmadaRecibir").addText(this.autoFirmadaRecibir + "");
        factura.addElement("autoPDFRecibir").addText(this.autoPDFRecibir + "");
        factura.addElement("tipoSend").addText(this.tipoFacturaEnviar);
        factura.addElement("tipoReceive").addText(this.tipoFacturaRecibir);
        Element empresa = root.addElement("cif-empresa");
        empresa.addElement("cif").addText(this.cif);
        Element folders = root.addElement("folders");
        if (this.getLog() != null && this.getLog().trim().length() != 0 && !"resources/log4j.xml".equalsIgnoreCase(this.getLog().trim())) {
            Element log = folders.addElement("log");
            log.addElement("log-folder").addText(this.getFolder(this.getLog().endsWith("xml") ? this.getLog() : this.getLog() + File.separator + LOG_FILE_NAME).getAbsolutePath());
        }
        Element key = folders.addElement("key");
        key.addElement("key-folder").addText(this.getFolder(this.getKey()).getAbsolutePath());
        Element data = folders.addElement("data");
        data.addElement("data-folder").addText(this.getFolder(this.getData()).getAbsolutePath());
        Element received = data.addElement("received");
        received.addElement("invoices-folder").addText(this.getFolder(this.getInvoiceReceived()).getAbsolutePath());
        received.addElement("pending-folder").addText(this.getFolder(this.getPendingReceived()).getAbsolutePath());
        received.addElement("pdf-folder").addText(this.getFolder(this.getPDFReceived()).getAbsolutePath());
        received.addElement("signed-folder").addText(this.getFolder(this.getSignedReceived()).getAbsolutePath());
        received.addElement("processed-folder").addText(this.getFolder(this.getProcessedReceived()).getAbsolutePath());
        received.addElement("recovery-folder").addText(this.getFolder(this.getRecoveryReceived()).getAbsolutePath());
        received.addElement("status-folder").addText(this.getFolder(this.getStatusReceived()).getAbsolutePath());
        received.addElement("status-pending-folder").addText(this.getFolder(this.getStatusPendingReceived()).getAbsolutePath());
        received.addElement("status-processed-folder").addText(this.getFolder(this.getStatusProcessedReceived()).getAbsolutePath());
        Element sent = data.addElement("sent");
        sent.addElement("invoices-folder").addText(this.getFolder(this.getInvoiceSent()).getAbsolutePath());
        sent.addElement("pending-folder").addText(this.getFolder(this.getPendingSent()).getAbsolutePath());
        sent.addElement("pdf-folder").addText(this.getFolder(this.getPDFSent()).getAbsolutePath());
        sent.addElement("signed-folder").addText(this.getFolder(this.getSignedSent()).getAbsolutePath());
        sent.addElement("processed-folder").addText(this.getFolder(this.getProcessedSent()).getAbsolutePath());
        sent.addElement("recovery-folder").addText(this.getFolder(this.getRecoverySent()).getAbsolutePath());
        sent.addElement("status-folder").addText(this.getFolder(this.getStatusSent()).getAbsolutePath());
        sent.addElement("status-pending-folder").addText(this.getFolder(this.getStatusPendingSent()).getAbsolutePath());
        sent.addElement("status-processed-folder").addText(this.getFolder(this.getStatusProcessedSent()).getAbsolutePath());
        Element persistencia = root.addElement("persistencia");
        if (persistencia != null) {
            Element parametros = persistencia.addElement("parametros");
            SimpleDateFormat formatoDelTexto = new SimpleDateFormat("yyyy-MM-dd");
            String strFecha = "";
            strFecha = this.getFechaUltimaConsulta() == null ? formatoDelTexto.format(this.getCurrentDate()) : formatoDelTexto.format(this.getFechaUltimaConsulta());
            parametros.addElement("ultimaFechaConsultaCambioEstados").addText(strFecha);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter(new FileOutputStream(this.getConfigFile()), format);
        writer.write(document);
        return true;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public File getFolder(String folder) {
        String path = folder;
        try {
            if (new File(folder).isAbsolute()) {
                return new File(folder);
            }
            if (path.startsWith(File.separator)) {
                return new File(path);
            }
            return new File(this.getBaseFolder(), path);
        }
        catch (NullPointerException e) {
            logger.error("Ruta de directorio no valida");
            return new File("");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCIF() {
        return this.cif;
    }

    public void setCIF(String cif) {
        this.cif = cif;
    }

    public String getKeyFolder() {
        return this.keyFolder;
    }

    public String getDataFolder() {
        return this.dataFolder;
    }

    public void setDataFolder(String dataFolder) {
        this.dataFolder = dataFolder;
    }

    public String getLogFolder() {
        return this.logFolder;
    }

    public void setLogFolder(String logFolder) {
        this.logFolder = logFolder;
    }

    public String getPdfReceivedFolder() {
        return this.pdfReceivedFolder;
    }

    public void setPdfReceivedFolder(String pdfReceivedFolder) {
        this.pdfReceivedFolder = pdfReceivedFolder;
    }

    public String getSignedReceivedFolder() {
        return this.signedReceivedFolder;
    }

    public void setSignedReceivedFolder(String signedReceivedFolder) {
        this.signedReceivedFolder = signedReceivedFolder;
    }

    public String getInvoiceReceivedFolder() {
        return this.invoiceReceivedFolder;
    }

    public void setInvoiceReceivedFolder(String invoiceReceivedFolder) {
        this.invoiceReceivedFolder = invoiceReceivedFolder;
    }

    public String getPendingReceivedFolder() {
        return this.pendingReceivedFolder;
    }

    public String getRecoveryReceivedFolder() {
        return this.recoveryReceivedFolder;
    }

    public void setPendingReceivedFolder(String pendingReceivedFolder) {
        this.pendingReceivedFolder = pendingReceivedFolder;
    }

    public void setRecoveryReceivedFolder(String recoveryReceivedFolder) {
        this.recoveryReceivedFolder = recoveryReceivedFolder;
    }

    public String getProcessedReceivedFolder() {
        return this.processedReceivedFolder;
    }

    public void setProcessedReceivedFolder(String processedReceivedFolder) {
        this.processedReceivedFolder = processedReceivedFolder;
    }

    public String getPdfSentFolder() {
        return this.pdfSentFolder;
    }

    public void setPdfSentFolder(String pdfSentFolder) {
        this.pdfSentFolder = pdfSentFolder;
    }

    public String getSignedSentFolder() {
        return this.signedSentFolder;
    }

    public void setSignedSentFolder(String signedSentFolder) {
        this.signedSentFolder = signedSentFolder;
    }

    public String getInvoiceSentFolder() {
        return this.invoiceSentFolder;
    }

    public void setInvoiceSentFolder(String invoiceSentFolder) {
        this.invoiceSentFolder = invoiceSentFolder;
    }

    public String getPendingSentFolder() {
        return this.pendingSentFolder;
    }

    public void setPendingSentFolder(String pendingSentFolder) {
        this.pendingSentFolder = pendingSentFolder;
    }

    public String getProcessedSentFolder() {
        return this.processedSentFolder;
    }

    public void setProcessedSentFolder(String processedSentFolder) {
        this.processedSentFolder = processedSentFolder;
    }

    public String getRecoverySentFolder() {
        return this.recoverySentFolder;
    }

    public void setRecoverySentFolder(String recoverySentFolder) {
        this.recoverySentFolder = recoverySentFolder;
    }

    public String getReceivedFolder() {
        return this.inFolder;
    }

    public void setReceivedFolder(String inFolder) {
        this.inFolder = inFolder;
    }

    public String getSentFolder() {
        return this.outFolder;
    }

    public void setSentFolder(String outFolder) {
        this.outFolder = outFolder;
    }

    public File getKeyFile() {
        return this.getFolder(this.getKey() + File.separator + KEY_FILE_NAME);
    }

    public void setKeyFolder(String keyFolder) {
        this.keyFolder = keyFolder;
    }

    public String getKey() {
        String folder = this.keyFolder;
        String defaultFolder = this.getBaseFolder() + File.separator + KEY_PATH;
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getConfigLogs() {
        String folder = this.logFolder;
        String defaultFolder = this.getBaseFolder() + File.separator + "Config";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public File getConfig() {
        String folder = this.configFolder;
        String defaultFolder = this.getBaseFolder() + File.separator + "Config";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return this.getFolder(folder);
    }

    public File getLogs() {
        String folder = this.logFolder;
        String defaultFolder = this.getBaseFolder() + File.separator + "Config";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return this.getFolder(folder);
    }

    public String getData() {
        String folder = this.dataFolder;
        String defaultFolder = this.getBaseFolder() + File.separator + DATA_PATH;
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getReceived() {
        String defaultFolder = RECEIVED_PATH;
        defaultFolder = this.getDataFolder() == null || this.getDataFolder().trim().length() == 0 ? this.getBaseFolder() + File.separator + DATA_PATH + File.separator + defaultFolder : this.getDataFolder() + File.separator + defaultFolder;
        return defaultFolder;
    }

    public String getSent() {
        String defaultFolder = SENT_PATH;
        defaultFolder = this.getDataFolder() == null || this.getDataFolder().trim().length() == 0 ? this.getBaseFolder() + File.separator + DATA_PATH + File.separator + defaultFolder : this.getDataFolder() + File.separator + defaultFolder;
        return defaultFolder;
    }

    public String getInvoiceReceived() {
        String folder = this.invoiceReceivedFolder;
        String defaultFolder = this.getReceived() + File.separator + "Invoices";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getStatusReceived() {
        String folder = this.statusReceivedFolder;
        String defaultFolder = this.getReceived() + File.separator + "Status";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getStatusPendingReceived() {
        String folder = this.statusPendingReceivedFolder;
        String defaultFolder = this.getStatusReceived() + File.separator + "Pending";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getStatusProcessedReceived() {
        String folder = this.statusProcessedReceivedFolder;
        String defaultFolder = this.getStatusReceived() + File.separator + "Processed";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getPDFReceived() {
        String folder = this.pdfReceivedFolder;
        String defaultFolder = this.getInvoiceReceived() + File.separator + "PDF";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getSignedReceived() {
        String folder = this.signedReceivedFolder;
        String defaultFolder = this.getInvoiceReceived() + File.separator + "Signed";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getPendingReceived() {
        String folder = this.pendingReceivedFolder;
        String defaultFolder = this.getInvoiceReceived() + File.separator + "Pending";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getProcessedReceived() {
        String folder = this.processedReceivedFolder;
        String defaultFolder = this.getInvoiceReceived() + File.separator + "Processed";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getRecoveryReceived() {
        String folder = this.recoveryReceivedFolder;
        String defaultFolder = this.getInvoiceReceived() + File.separator + RECOVERY_RECEIVED_PATH;
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getPDFSent() {
        String folder = this.pdfSentFolder;
        String defaultFolder = this.getInvoiceSent() + File.separator + "PDF";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getSignedSent() {
        String folder = this.signedSentFolder;
        String defaultFolder = this.getInvoiceSent() + File.separator + "Signed";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getInvoiceSent() {
        String folder = this.invoiceSentFolder;
        String defaultFolder = this.getSent() + File.separator + "Invoices";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getStatusSent() {
        String folder = this.statusSentFolder;
        String defaultFolder = this.getSent() + File.separator + "Status";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getStatusPendingSent() {
        String folder = this.statusPendingSentFolder;
        String defaultFolder = this.getStatusSent() + File.separator + "Pending";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getStatusProcessedSent() {
        String folder = this.statusProcessedSentFolder;
        String defaultFolder = this.getStatusSent() + File.separator + "Processed";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getPendingSent() {
        String folder = this.pendingSentFolder;
        String defaultFolder = this.getInvoiceSent() + File.separator + "Pending";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getProcessedSent() {
        String folder = this.processedSentFolder;
        String defaultFolder = this.getInvoiceSent() + File.separator + "Processed";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getRecoverySent() {
        String folder = this.recoverySentFolder;
        String defaultFolder = this.getInvoiceSent() + File.separator + RECOVERY_RECEIVED_PATH;
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public String getLog() {
        String folder = this.logFolder;
        String defaultFolder = this.getBaseFolder() + File.separator + "Config";
        folder = folder == null || folder.trim().length() == 0 ? defaultFolder : folder;
        return folder;
    }

    public File getSystemBaseFolder() {
        String userHome = System.getProperty("user.home");
        return new File(new File(userHome), BASE_DIRECTORY);
    }

    public File getBaseFolder() {
        if (this.baseFolder == null) {
            return this.getSystemBaseFolder();
        }
        return this.baseFolder;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    protected boolean makeFile(String file) {
        boolean result = true;
        try {
            if (!this.getFolder(file).exists()) {
                result = this.getFolder(file).mkdirs();
            }
        }
        catch (NullPointerException e) {
            logger.error("Nombre de directorio no valido");
        }
        return result;
    }

    public boolean makeConfigurationDir() {
        boolean result = true;
        logger.info("Creando Directorio donde se almacena la configuraci\u00f3n del conector gen\u00e9rico: path de configuraci\u00f3n.");
        try {
            result = this.makeFile(this.getSystemBaseFolder().getAbsolutePath());
        }
        catch (SecurityException e) {
            logger.error("No se tienen permisos para crear el directorio base de configuraci\u00f3n y almacenar el path de configuraci\u00f3n.");
            result = false;
        }
        logger.info("Fin de la creaci\u00f3n del direcgtorio que contiene el path de configuraci\u00f3n del conector gen\u00e9rico.");
        return result;
    }

    public boolean makeDirs() {
        boolean result = true;
        logger.info("Creando Sistema de archivos");
        try {
            String[] files = new String[]{this.getKey(), this.getConfigLogs(), this.getData(), this.getReceived(), this.getSent(), this.getInvoiceReceived(), this.getInvoiceSent(), this.getRecoverySent(), this.getProcessedReceived(), this.getSignedReceived(), this.getPendingReceived(), this.getPDFReceived(), this.getRecoveryReceived(), this.getProcessedSent(), this.getSignedSent(), this.getPendingSent(), this.getPDFSent(), this.getStatusReceived(), this.getStatusPendingReceived(), this.getStatusProcessedReceived(), this.getStatusSent(), this.getStatusPendingSent(), this.getStatusProcessedSent()};
            for (int i = 0; i < files.length; ++i) {
                result &= this.makeFile(files[i]);
            }
            if (!this.getConfig().exists()) {
                result &= this.getConfig().mkdirs();
            }
        }
        catch (SecurityException e) {
            logger.error("No se tienen permisos para crear el sistema de ficheros");
            result = false;
        }
        logger.info("Fin de la creaci\u00f3n del sistema de directorios");
        return result;
    }

    public boolean isPreservarIdFiscal() {
        return this.preservarIdFiscal;
    }

    public void setPreservarIdFiscal(boolean preservarIdFiscal) {
        this.preservarIdFiscal = preservarIdFiscal;
    }

    public String getMagnitudPlanificadorEnvio() {
        if (this.magnitudPlanificadorEnvio.equals("Dias")) {
            return "D\u00edas";
        }
        return this.magnitudPlanificadorEnvio;
    }

    public void setMagnitudPlanificadorEnvio(String magnitudPlanificadorEnvio) {
        this.magnitudPlanificadorEnvio = magnitudPlanificadorEnvio.equals("D\u00edas") ? "Dias" : magnitudPlanificadorEnvio;
    }

    public String getMagnitudPlanificadorRecepcion() {
        if (this.magnitudPlanificadorRecepcion.equals("Dias")) {
            return "D\u00edas";
        }
        return this.magnitudPlanificadorRecepcion;
    }

    public void setMagnitudPlanificadorRecepcion(String magnitudPlanificadorRecepcion) {
        this.magnitudPlanificadorRecepcion = magnitudPlanificadorRecepcion.equals("D\u00edas") ? "Dias" : magnitudPlanificadorRecepcion;
    }

    public void setStatusReceivedFolder(String statusReceivedFolder) {
        this.statusReceivedFolder = statusReceivedFolder;
    }

    public void setStatusPendingReceivedFolder(String statusPendingReceivedFolder) {
        this.statusPendingReceivedFolder = statusPendingReceivedFolder;
    }

    public void setStatusProcessedReceivedFolder(String statusProcessedReceivedFolder) {
        this.statusProcessedReceivedFolder = statusProcessedReceivedFolder;
    }

    public void setStatusSentFolder(String statusSentFolder) {
        this.statusSentFolder = statusSentFolder;
    }

    public void setStatusPendingSentFolder(String statusPendingSentFolder) {
        this.statusPendingSentFolder = statusPendingSentFolder;
    }

    public void setStatusProcessedSentFolder(String statusProcessedSentFolder) {
        this.statusProcessedSentFolder = statusProcessedSentFolder;
    }

    public void setBaseFolder(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    public void saveConfigPath(String ruta) {
        File archivoLogs = this.getLogsFile();
        if (!archivoLogs.exists()) {
            try {
                int c;
                InputStream in = MenuBar.class.getResourceAsStream("resources/log4j.xml");
                FileOutputStream out = new FileOutputStream(archivoLogs);
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                in.close();
                out.close();
                logger.info("Fichero de Configuraci\u00f3n de Logs Generado satisfactoriamente...");
            }
            catch (IOException e) {
                logger.error("Hubo un error de entrada/salida creando el Archivo de Logs!!!");
            }
        }
    }
}

