/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.model;

import conector.eurobits.efactura.desktop.controller.Constantes;
import conector.eurobits.efactura.desktop.model.Planificador;
import conector.eurobits.efactura.desktop.model.Settings;
import conector.eurobits.efactura.desktop.model.SettingsFactory;
import conector.eurobits.efactura.desktop.model.VisualSettings;
import conector.eurobits.efactura.desktop.view.MainScreen;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class Main {
    private static final Logger loggerError = Logger.getLogger("Error");
    private static final Logger loggerConector = Logger.getLogger(Main.class);

    public static void main(String[] args) {
        Main ma = new Main();
        ma.ejecutar();
    }

    public void ejecutar() {
        try {
            Main.initSettings();
            loggerConector.info("Settings inicializados - Main");
            loggerConector.info("Inicio del conector generico (Modo gr\u00e1fico)");
            MainScreen ms = new MainScreen();
            ms.build();
            Planificador plan = new Planificador();
            plan.ejecutar();
        }
        catch (DocumentException e) {
            JOptionPane.showMessageDialog(null, "El fichero config.xml esta mal escrito. ", "Error en config.xml", 0);
            System.err.println(e.getMessage());
            loggerError.error(Constantes.ERROR_XML_MAL_ESCRITO);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "No se puede leer el fichero de configuraci\u00f3n", "Error en config.xml", 0);
            System.err.println(e.getMessage());
            loggerError.error(Constantes.ERROR_XML_NO_SE_PUEDE_LEER);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error al crear la interfaz: " + e.getMessage(), "Error", 0);
            loggerError.error(Constantes.ERROR_CREAR_INTERFAZ);
        }
        loggerConector.info("Fin del conector generico (Modo gr\u00e1fico)");
    }

    public void ejecutar(String rutaInicial) {
        Settings.getSettings().setBaseFolder(new File(rutaInicial));
        this.ejecutar();
    }

    public static VisualSettings initSettings() throws DocumentException, IOException {
        VisualSettings settings = SettingsFactory.loadVisualSettingsFromPath();
        if (settings == null) {
            settings = SettingsFactory.loadVisualSettingsFromClassPath();
            if (settings == null) {
                settings = VisualSettings.getVisualSettings();
            }
            SettingsFactory.save(settings);
            settings = SettingsFactory.loadVisualSettingsFromPath();
        }
        return settings;
    }

    public static Logger getLoggerConector() {
        return loggerConector;
    }
}

