/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.ConstantTimer;
import com.clarkware.junitperf.LoadTest;
import com.clarkware.junitperf.MockTest;
import com.clarkware.junitperf.TimedTest;
import com.clarkware.junitperf.Timer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TimedTestTest
extends TestCase {
    private Test _oneSecondTest = new MockTest("testOneSecondExecutionTime");
    private Test _oneSecondFailedTest = new MockTest("testOneSecondExecutionTimeWithFailure");
    private Timer _twoSecondDelayTimer = new ConstantTimer(2000L);
    public static final long tolerance = 100L;
    static /* synthetic */ Class class$com$clarkware$junitperf$TimedTestTest;

    public TimedTestTest(String string) {
        super(string);
    }

    public void testOneSecondResponseDefault() {
        TimedTest timedTest = new TimedTest(this._oneSecondTest, 1100L);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testOneSecondResponseNoWaitForCompletion() {
        TimedTest timedTest = new TimedTest(this._oneSecondTest, 1100L, false);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testOneSecondResponseWaitForCompletion() {
        TimedTest timedTest = new TimedTest(this._oneSecondTest, 1100L, true);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testOneSecondResponseFailure() {
        TimedTest timedTest = new TimedTest(this._oneSecondTest, 900L);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testOneSecondResponseOneUserLoadSuccess() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 1);
        TimedTest timedTest = new TimedTest(loadTest, 1100L);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testOneSecondResponseOneUserLoadFailure() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 1);
        TimedTest timedTest = new TimedTest(loadTest, 900L);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testOneSecondResponseMultiUserLoadSuccess() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 2);
        TimedTest timedTest = new TimedTest(loadTest, 1500L);
        Assert.assertEquals(2, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(2, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testOneSecondResponseMultiUserLoadFailure() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 2);
        TimedTest timedTest = new TimedTest(loadTest, 1000L);
        Assert.assertEquals(2, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(2, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testOneSecondResponseMultiUserLoadTwoSecondDelaySuccess() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 2, this._twoSecondDelayTimer);
        TimedTest timedTest = new TimedTest(loadTest, 4100L);
        Assert.assertEquals(2, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(2, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testOneSecondResponseMultiUserLoadTwoSecondDelayFailure() {
        LoadTest loadTest = new LoadTest(this._oneSecondTest, 2, this._twoSecondDelayTimer);
        TimedTest timedTest = new TimedTest(loadTest, 3800L);
        Assert.assertEquals(2, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(2, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testInfiniteNoWaitForCompletion() {
        MockTest mockTest = new MockTest("testInfiniteExecutionTime");
        TimedTest timedTest = new TimedTest(mockTest, 1100L, false);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testLongResponseNoWaitForCompletion() {
        MockTest mockTest = new MockTest("testLongExecutionTime");
        TimedTest timedTest = new TimedTest(mockTest, 2100L, false);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testOneSecondResponseSuccessWaiting() {
        TimedTest timedTest = new TimedTest(this._oneSecondFailedTest, 1100L, true);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testOneSecondResponseSuccessNonWaiting() {
        TimedTest timedTest = new TimedTest(this._oneSecondFailedTest, 1100L, false);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testOneSecondResponseFailureWaiting() {
        TimedTest timedTest = new TimedTest(this._oneSecondFailedTest, 900L, true);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(2, testResult.failureCount());
    }

    public void testOneSecondResponseNonWaitingWithAmbiguousFailure() {
        TimedTest timedTest = new TimedTest(this._oneSecondFailedTest, 900L, false);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testOneSecondResponseNonWaitingWithTimeFailure() {
        TimedTest timedTest = new TimedTest(this._oneSecondFailedTest, 900L, false);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        if (!timedTest.outOfTime()) {
            Assert.fail("Max elapsed time exceeded!");
        }
    }

    public void testOneSecondResponseNonWaitingWithTestFailure() {
        TimedTest timedTest = new TimedTest(this._oneSecondFailedTest, 1100L, false);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        if (timedTest.outOfTime()) {
            Assert.fail("Should never get here!");
        } else {
            Assert.assertEquals(1, testResult.runCount());
            Assert.assertEquals(0, testResult.errorCount());
            Assert.assertEquals(1, testResult.failureCount());
        }
    }

    public static Test suite() {
        return new TestSuite(class$com$clarkware$junitperf$TimedTestTest == null ? (class$com$clarkware$junitperf$TimedTestTest = TimedTestTest.class$("com.clarkware.junitperf.TimedTestTest")) : class$com$clarkware$junitperf$TimedTestTest);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(TimedTestTest.suite());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

