/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;

public class TimedTest
extends TestDecorator {
    private final long _maxElapsedTime;
    private final boolean _waitForCompletion;
    private boolean _maxElapsedTimeExceeded;
    private boolean _isQuiet;

    public TimedTest(Test test, long l) {
        this(test, l, true);
    }

    public TimedTest(Test test, long l, boolean bl) {
        super(test);
        this._maxElapsedTime = l;
        this._waitForCompletion = bl;
        this._maxElapsedTimeExceeded = false;
        this._isQuiet = false;
    }

    public void setQuiet() {
        this._isQuiet = true;
    }

    public int countTestCases() {
        return super.countTestCases();
    }

    public boolean outOfTime() {
        return this._maxElapsedTimeExceeded;
    }

    public void run(TestResult testResult) {
        if (this._waitForCompletion) {
            this.runUntilTestCompletion(testResult);
        } else {
            this.runUntilTimeExpires(testResult);
        }
    }

    protected void runUntilTestCompletion(TestResult testResult) {
        long l = System.currentTimeMillis();
        super.run(testResult);
        long l2 = this.getElapsedTime(l);
        this.printElapsedTime(l2);
        if (l2 > this._maxElapsedTime) {
            this._maxElapsedTimeExceeded = true;
            testResult.addFailure(this.fTest, new AssertionFailedError("Maximum elapsed time exceeded! Expected " + this._maxElapsedTime + "ms, but was " + l2 + "ms."));
        }
    }

    protected void runUntilTimeExpires(final TestResult testResult) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                TimedTest.super.run(testResult);
            }
        });
        long l = System.currentTimeMillis();
        thread.start();
        try {
            thread.join(this._maxElapsedTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.printElapsedTime(this.getElapsedTime(l));
        if (thread.isAlive()) {
            this._maxElapsedTimeExceeded = true;
            testResult.addFailure(this.fTest, new AssertionFailedError("Maximum elapsed time (" + this._maxElapsedTime + " ms) exceeded!"));
        }
    }

    protected long getElapsedTime(long l) {
        long l2 = System.currentTimeMillis();
        return l2 - l;
    }

    protected void printElapsedTime(long l) {
        if (!this._isQuiet) {
            System.out.println(this.toString() + ": " + l + " ms");
            System.out.flush();
        }
    }

    public String toString() {
        if (this._waitForCompletion) {
            return "TimedTest (WAITING): " + super.toString();
        }
        return "TimedTest (NON-WAITING): " + super.toString();
    }
}

