/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class TinyMenuItemUI
extends MenuItemUI {
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = true;
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected static int defaultTextIconGap;
    protected static int defaultIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    static final String MAX_ICON_WIDTH = "maxIconWidth";
    static Rectangle zeroRect;
    static Rectangle iconRect;
    static Rectangle textRect;
    static Rectangle acceleratorRect;
    static Rectangle checkIconRect;
    static Rectangle arrowIconRect;
    static Rectangle viewRect;
    static Rectangle r;

    static {
        zeroRect = new Rectangle(0, 0, 0, 0);
        iconRect = new Rectangle();
        textRect = new Rectangle();
        acceleratorRect = new Rectangle();
        checkIconRect = new Rectangle();
        arrowIconRect = new Rectangle();
        viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        r = new Rectangle();
    }

    public void installUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent p = (JComponent)parent;
            p.putClientProperty(MAX_ACC_WIDTH, null);
            p.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    ActionMap getActionMap() {
        String propertyPrefix = this.getPropertyPrefix();
        String uiKey = String.valueOf(propertyPrefix) + ".actionMap";
        ActionMap am = (ActionMap)UIManager.get(uiKey);
        if (am == null) {
            am = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(uiKey, am);
        }
        return am;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("doClick", new ClickAction());
        return map;
    }

    InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (accelerator != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(accelerator, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, defaultTextIconGap);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            if (Theme.derivedStyle[Theme.style] == 1) {
                if (menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu()) {
                    g.setColor(Theme.menuBarColor[Theme.style].getColor().darker());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                } else {
                    g.setColor(Theme.menuIconShadowColor[Theme.style].getColor());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                    g.setColor(Theme.menuIconDisabledColor[Theme.style].getColor());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
                }
            } else {
                g.setColor(Theme.menuDisabledFgColor[Theme.style].getColor());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        } else {
            if (this.isTopLevelMenu()) {
                if (menuItem.getClientProperty("rollover") == Boolean.TRUE && Theme.menuRollover[Theme.style] && !model.isSelected()) {
                    g.setColor(Theme.menuRolloverFgColor[Theme.style].getColor());
                } else if (!(menuItem.getForeground() instanceof ColorUIResource)) {
                    g.setColor(menuItem.getForeground());
                } else {
                    g.setColor(Theme.menuFontColor[Theme.style].getColor());
                }
            } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(Theme.menuSelectedTextColor[Theme.style].getColor());
            } else {
                g.setColor(menuItem.getForeground());
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, defaultTextIconGap);
    }

    private boolean isTopLevelMenu() {
        return this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu();
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            int j = oldPath.length - 1;
            while (j >= 0) {
                if (oldPath[j].getComponent() == parent) break;
                --j;
            }
            newPath = new MenuElement[j + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j + 1);
            newPath[j + 1] = this.menuItem;
        }
        return newPath;
    }

    protected void doClick(MenuSelectionManager msm) {
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        msm.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String actionCommand = this.menuItem.getActionCommand();
        return actionCommand == "Close" || actionCommand == "Minimize" || actionCommand == "Restore" || actionCommand == "Maximize";
    }

    public static ComponentUI createUI(JComponent c) {
        return new TinyMenuItemUI();
    }

    protected void installDefaults() {
        String prefix = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(String.valueOf(prefix) + ".margin"));
        }
        LookAndFeel.installBorder(this.menuItem, String.valueOf(prefix) + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(String.valueOf(prefix) + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, String.valueOf(prefix) + ".background", String.valueOf(prefix) + ".foreground", String.valueOf(prefix) + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(String.valueOf(prefix) + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(String.valueOf(prefix) + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(String.valueOf(prefix) + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(String.valueOf(prefix) + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(String.valueOf(prefix) + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(String.valueOf(prefix) + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(String.valueOf(prefix) + ".checkIcon");
        }
        defaultTextIconGap = 8;
        defaultIconGap = 4;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Container parent;
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? String.valueOf(acceleratorText) + KeyEvent.getKeyText(keyCode) : String.valueOf(acceleratorText) + accelerator.getKeyChar();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(TinyMenuItemUI.iconRect.x, TinyMenuItemUI.iconRect.y, TinyMenuItemUI.iconRect.width, TinyMenuItemUI.iconRect.height, r);
        if (icon != null || checkIcon != null) {
            TinyMenuItemUI.r.width -= 3 * TinyMenuItemUI.defaultTextIconGap;
        }
        if (!((parent = this.menuItem.getParent()) == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int maxIconValue;
            JComponent p = (JComponent)parent;
            Integer maxTextWidth = (Integer)p.getClientProperty(MAX_TEXT_WIDTH);
            Integer maxAccWidth = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
            Integer maxIconWidth = (Integer)p.getClientProperty(MAX_ICON_WIDTH);
            int maxTextValue = maxTextWidth != null ? maxTextWidth : 0;
            int maxAccValue = maxAccWidth != null ? maxAccWidth : 0;
            int n = maxIconValue = maxIconWidth != null ? maxIconWidth : 0;
            if (TinyMenuItemUI.r.width < maxTextValue) {
                TinyMenuItemUI.r.width = maxTextValue;
            } else {
                p.putClientProperty(MAX_TEXT_WIDTH, new Integer(TinyMenuItemUI.r.width));
            }
            if (TinyMenuItemUI.acceleratorRect.width > maxAccValue) {
                maxAccValue = TinyMenuItemUI.acceleratorRect.width;
                p.putClientProperty(MAX_ACC_WIDTH, new Integer(TinyMenuItemUI.acceleratorRect.width));
            }
            if (icon != null && icon.getIconWidth() > maxIconValue) {
                maxIconValue = icon.getIconWidth();
                p.putClientProperty(MAX_ICON_WIDTH, new Integer(maxIconValue));
            }
            if (maxAccValue > 0) {
                TinyMenuItemUI.r.width += maxAccValue;
                TinyMenuItemUI.r.width += defaultTextIconGap;
            }
        }
        if (!this.isTopLevelMenu()) {
            TinyMenuItemUI.r.width += TinyMenuItemUI.checkIconRect.width;
            TinyMenuItemUI.r.width += defaultTextIconGap;
            TinyMenuItemUI.r.width += defaultTextIconGap;
            TinyMenuItemUI.r.width += TinyMenuItemUI.arrowIconRect.width;
        }
        TinyMenuItemUI.r.width += 2 * defaultTextIconGap;
        Insets insets = b.getInsets();
        if (insets != null) {
            TinyMenuItemUI.r.width += insets.left + insets.right;
            TinyMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (TinyMenuItemUI.r.width % 2 == 0) {
            ++TinyMenuItemUI.r.width;
        }
        if (TinyMenuItemUI.r.height % 2 == 0) {
            ++TinyMenuItemUI.r.height;
        }
        return r.getSize();
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        JComponent p = (JComponent)b.getParent();
        Integer maxValueInt = (Integer)p.getClientProperty(MAX_ICON_WIDTH);
        int maxValue = maxValueInt == null ? 16 : maxValueInt;
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        TinyMenuItemUI.viewRect.x += 0;
        TinyMenuItemUI.viewRect.y += i.top;
        TinyMenuItemUI.viewRect.width -= i.right + TinyMenuItemUI.viewRect.x;
        TinyMenuItemUI.viewRect.height -= i.bottom + TinyMenuItemUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? String.valueOf(acceleratorText) + KeyEvent.getKeyText(keyCode) : String.valueOf(acceleratorText) + accelerator.getKeyChar();
        }
        int offset = 0;
        Icon ic = b.getIcon();
        Icon iCheck = checkIcon;
        Icon paintIcon = ic;
        if (!this.isTopLevelMenu()) {
            if (c instanceof JCheckBoxMenuItem || c instanceof JRadioButtonMenuItem) {
                ic = checkIcon;
                if (checkIcon.getIconWidth() < maxValue) {
                    ic = new EmptyIcon(maxValue, checkIcon.getIconHeight());
                    offset = (maxValue - checkIcon.getIconWidth()) / 2;
                }
                paintIcon = null;
            } else if (c instanceof JMenuItem && (ic == null || ic.getIconWidth() < maxValue)) {
                int height = ic == null ? 2 : b.getIcon().getIconHeight();
                int width = ic == null ? 2 : b.getIcon().getIconWidth();
                offset = (maxValue - width) / 2;
                ic = new EmptyIcon(maxValue, height);
            }
        }
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, ic, null, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultIconGap);
        this.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if (checkIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (!this.isTopLevelMenu()) {
                checkIcon.paintIcon(c, g, TinyMenuItemUI.iconRect.x + offset, TinyMenuItemUI.iconRect.y);
            }
            g.setColor(holdc);
        }
        if (paintIcon != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
                if (icon != null) {
                    icon.paintIcon(c, g, TinyMenuItemUI.iconRect.x + offset, TinyMenuItemUI.iconRect.y);
                }
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
                if (icon != null) {
                    icon.paintIcon(c, g, TinyMenuItemUI.iconRect.x + offset, TinyMenuItemUI.iconRect.y);
                }
            } else if (model.isArmed() || model.isSelected()) {
                icon = b.getIcon();
                if (icon != null) {
                    icon.paintIcon(c, g, TinyMenuItemUI.iconRect.x + offset, TinyMenuItemUI.iconRect.y);
                }
            } else {
                icon = b.getIcon();
                if (icon != null) {
                    icon.paintIcon(c, g, TinyMenuItemUI.iconRect.x + offset, TinyMenuItemUI.iconRect.y);
                }
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            g.setColor(Theme.menuItemFontColor[Theme.style].getColor());
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                Integer amaxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int amaxValue = amaxValueInt != null ? amaxValueInt : TinyMenuItemUI.acceleratorRect.width;
                accOffset = amaxValue - TinyMenuItemUI.acceleratorRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                g.setColor(Theme.menuIconShadowColor[Theme.style].getColor());
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, TinyMenuItemUI.acceleratorRect.x - accOffset, TinyMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                g.setColor(Theme.menuIconDisabledColor[Theme.style].getColor());
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, TinyMenuItemUI.acceleratorRect.x - accOffset - 1, TinyMenuItemUI.acceleratorRect.y + fmAccel.getAscent() - 1);
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(Theme.menuSelectedTextColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.menuItemFontColor[Theme.style].getColor());
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, TinyMenuItemUI.acceleratorRect.x - accOffset, TinyMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (!this.isTopLevelMenu()) {
                arrowIcon.paintIcon(c, g, TinyMenuItemUI.arrowIconRect.x, TinyMenuItemUI.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        boolean armed;
        if (!menuItem.isOpaque()) {
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        boolean bl = armed = model.isArmed() || menuItem instanceof JMenu && model.isSelected();
        if (menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu()) {
            if (model.isSelected()) {
                g.setColor(Theme.menuBarColor[Theme.style].getColor());
                g.fillRect(0, 0, menuWidth, menuHeight);
                switch (Theme.derivedStyle[Theme.style]) {
                    case 0: {
                        this.drawTinyTopMenuBorder(g, 0, 0, menuWidth, menuHeight, true);
                        break;
                    }
                    case 1: {
                        this.drawWinTopMenuBorder(g, 0, 0, menuWidth, menuHeight, true);
                        break;
                    }
                    case 2: {
                        this.drawXpTopMenuBorder(g, 0, 0, menuWidth, menuHeight, true);
                    }
                }
            } else if (menuItem.getClientProperty("rollover") == Boolean.TRUE && Theme.menuRollover[Theme.style]) {
                g.setColor(Theme.menuRolloverBgColor[Theme.style].getColor());
                g.fillRect(0, 0, menuWidth - 8, menuHeight);
                g.setColor(Theme.menuBarColor[Theme.style].getColor());
                g.fillRect(menuWidth - 8, 0, 8, menuHeight);
                switch (Theme.derivedStyle[Theme.style]) {
                    case 0: {
                        this.drawTinyTopMenuBorder(g, 0, 0, menuWidth, menuHeight, false);
                        break;
                    }
                    case 1: {
                        this.drawWinTopMenuBorder(g, 0, 0, menuWidth, menuHeight, false);
                        break;
                    }
                    case 2: {
                        this.drawXpTopMenuBorder(g, 0, 0, menuWidth, menuHeight, false);
                    }
                }
            } else {
                if (menuItem.getBackground() instanceof ColorUIResource) {
                    g.setColor(Theme.menuBarColor[Theme.style].getColor());
                } else {
                    g.setColor(menuItem.getBackground());
                }
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
        } else if (armed) {
            g.setColor(Theme.menuItemRolloverColor[Theme.style].getColor());
            g.fillRect(0, 0, menuWidth, menuHeight);
        } else {
            if (menuItem.getBackground() instanceof ColorUIResource) {
                g.setColor(Theme.menuPopupColor[Theme.style].getColor());
            } else {
                g.setColor(menuItem.getBackground());
            }
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        g.setColor(oldColor);
    }

    private void drawTinyTopMenuBorder(Graphics g, int x, int y, int w, int h, boolean selected) {
    }

    private void drawWinTopMenuBorder(Graphics g, int x, int y, int w, int h, boolean selected) {
        if (!selected) {
            g.setColor(Theme.menuDarkColor[Theme.style].getColor());
            g.drawLine(x, y + h - 2, x + w - 8, y + h - 2);
            g.drawLine(x + w - 8, y, x + w - 8, y + h - 3);
            g.setColor(Theme.menuLightColor[Theme.style].getColor());
            g.drawLine(x, y, x + w - 8, y);
            g.drawLine(x, y + 1, x, y + h - 2);
        } else {
            g.setColor(Theme.menuLightColor[Theme.style].getColor());
            g.drawLine(x, y + h - 2, x + w - 8, y + h - 2);
            g.drawLine(x + w - 8, y, x + w - 8, y + h - 3);
            g.setColor(Theme.menuDarkColor[Theme.style].getColor());
            g.drawLine(x, y, x + w - 8, y);
            g.drawLine(x, y + 1, x, y + h - 2);
            g.translate(1, 1);
        }
    }

    private void drawXpTopMenuBorder(Graphics g, int x, int y, int w, int h, boolean selected) {
        g.setColor(Theme.menuBorderColor[Theme.style].getColor());
        if (selected) {
            g.drawLine(x, y, x + w - 8, y);
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x + w - 8, y, x + w - 8, y + h - 1);
            this.drawXpShadow(g, ColorRoutines.darken(Theme.menuBorderColor[Theme.style].getColor(), 15), Theme.menuBarColor[Theme.style].getColor(), x + w - 7, y + 6, 6, h - 6);
        } else {
            g.drawRect(x, y, w - 8, h - 1);
        }
    }

    private void drawXpShadow(Graphics g, Color c1, Color c2, int x1, int y1, int w, int h) {
        int x = 0;
        while (x < w) {
            Color c = ColorRoutines.getGradient(c1, c2, w, x);
            g.setColor(c);
            g.drawLine(x1 + x, y1, x1 + x, y1 + h);
            int index = 0;
            int y = y1 - 1;
            while (y >= y1 - 6) {
                g.setColor(ColorRoutines.getGradient(c, c2, 5, index++));
                g.drawLine(x1 + x, y, x1 + x, y);
                --y;
            }
            ++x;
        }
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (!this.isTopLevelMenu()) {
            if (checkIcon != null) {
                checkIconRect.height = checkIcon.getIconHeight();
                checkIconRect.width = checkIcon.getIconWidth();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        } else {
            checkIconRect.height = 0;
            checkIconRect.width = 0;
            arrowIconRect.height = 0;
            arrowIconRect.width = 0;
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (checkIcon != null) {
            checkIconRect.x += menuItemGap;
        } else {
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;
        }
        acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (!this.isTopLevelMenu()) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
            arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
        }
        return text;
    }

    private static class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }

    public static class EmptyIcon
    implements Icon {
        int width;
        int height;

        public EmptyIcon(int width, int height) {
            this.height = height;
            this.width = width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < TinyMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < TinyMenuItemUI.this.menuItem.getHeight()) {
                TinyMenuItemUI.this.doClick(manager);
            } else {
                manager.clearSelectedPath();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < TinyMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < TinyMenuItemUI.this.menuItem.getHeight()) {
                TinyMenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(TinyMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int i = 0;
                    int c = path.length - 1;
                    while (i < c) {
                        newPath[i] = path[i];
                        ++i;
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("labelFor") || name.equals("displayedMnemonic") || name.equals("accelerator")) {
                TinyMenuItemUI.this.updateAcceleratorBinding();
            } else if (name.equals("text") || "font".equals(name) || "foreground".equals(name)) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            }
        }
    }
}

