/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalCheckBoxIcon;

public class TinyCheckBoxIcon
extends MetalCheckBoxIcon {
    static HashMap cache = new HashMap();
    static final int[][] a;

    static {
        int[][] nArrayArray = new int[11][];
        nArrayArray[0] = new int[]{255, 255, 255, 242, 228, 209, 187, 165, 142, 120, 104};
        nArrayArray[1] = new int[]{255, 255, 242, 228, 209, 187, 165, 142, 120, 104, 86};
        nArrayArray[2] = new int[]{255, 242, 228, 209, 187, 165, 142, 120, 104, 86, 72};
        nArrayArray[3] = new int[]{242, 228, 209, 187, 165, 142, 120, 104, 86, 72, 56};
        nArrayArray[4] = new int[]{228, 209, 187, 165, 142, 120, 104, 86, 72, 56, 42};
        nArrayArray[5] = new int[]{209, 187, 165, 142, 120, 104, 86, 72, 56, 42, 28};
        nArrayArray[6] = new int[]{187, 165, 142, 120, 104, 86, 72, 56, 42, 28, 17};
        nArrayArray[7] = new int[]{165, 142, 120, 104, 86, 72, 56, 42, 28, 17, 9};
        int[] nArray = new int[11];
        nArray[0] = 142;
        nArray[1] = 120;
        nArray[2] = 104;
        nArray[3] = 86;
        nArray[4] = 72;
        nArray[5] = 56;
        nArray[6] = 42;
        nArray[7] = 28;
        nArray[8] = 17;
        nArray[9] = 9;
        nArrayArray[8] = nArray;
        int[] nArray2 = new int[11];
        nArray2[0] = 120;
        nArray2[1] = 104;
        nArray2[2] = 86;
        nArray2[3] = 72;
        nArray2[4] = 56;
        nArray2[5] = 42;
        nArray2[6] = 28;
        nArray2[7] = 17;
        nArray2[8] = 9;
        nArrayArray[9] = nArray2;
        int[] nArray3 = new int[11];
        nArray3[0] = 104;
        nArray3[1] = 86;
        nArray3[2] = 72;
        nArray3[3] = 56;
        nArray3[4] = 42;
        nArray3[5] = 28;
        nArray3[6] = 17;
        nArray3[7] = 9;
        nArrayArray[10] = nArray3;
        a = nArrayArray;
    }

    protected int getControlSize() {
        return this.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton button = (AbstractButton)c;
        ColorUIResource col = null;
        col = !button.isEnabled() ? Theme.buttonDisabledColor[Theme.style].getColor() : (button.getModel().isPressed() ? (button.getModel().isRollover() ? Theme.buttonPressedColor[Theme.style].getColor() : Theme.buttonNormalColor[Theme.style].getColor()) : (button.getModel().isRollover() && Theme.buttonRollover[Theme.style] ? Theme.buttonRolloverBgColor[Theme.style].getColor() : Theme.buttonNormalColor[Theme.style].getColor()));
        g.setColor(col);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyCheck(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
                break;
            }
            case 1: {
                this.drawWinCheck(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
                break;
            }
            case 2: {
                if (TinyLookAndFeel.controlPanelInstantiated) {
                    this.drawXpCheckNoCache(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
                    break;
                }
                this.drawXpCheck(g, button, col, x, y, this.getIconWidth(), this.getIconHeight());
            }
        }
        if (!button.isSelected()) {
            return;
        }
        if (!button.isEnabled()) {
            g.setColor(Theme.buttonCheckDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonCheckColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyCheckMark(g, button, col, x, y);
                break;
            }
            case 1: {
                this.drawWinCheckMark(g, x, y);
                break;
            }
            case 2: {
                this.drawXpCheckMark(g, x, y);
            }
        }
    }

    private void drawTinyCheck(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
    }

    private void drawWinCheck(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonLightColor[Theme.style].getColor());
        }
        if (b.getModel().isPressed() && b.getModel().isRollover()) {
            g.drawLine(x + 0, y + 12, x + 12, y + 12);
            g.drawLine(x + 12, y + 0, x + 12, y + 11);
        } else {
            g.fillRect(x, y, w, h);
        }
        if (!b.isEnabled()) {
            g.setColor(ColorRoutines.getAverage(c, Theme.buttonDarkDisabledColor[Theme.style].getColor()));
        } else {
            g.setColor(ColorRoutines.getAverage(c, Theme.buttonDarkColor[Theme.style].getColor()));
        }
        g.drawLine(x + 0, y + 0, x + 11, y + 0);
        g.drawLine(x + 0, y + 1, x + 0, y + 11);
        if (!b.isEnabled()) {
            g.setColor(Theme.buttonDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.buttonDarkColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y + 1, x + 10, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + 10);
        g.setColor(Theme.backColor[Theme.style].getColor());
        g.drawLine(x + 1, y + 11, x + 11, y + 11);
        g.drawLine(x + 11, y + 1, x + 11, y + 10);
    }

    private void drawXpCheck(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        boolean focused;
        boolean rollover;
        boolean pressed = b.getModel().isPressed();
        boolean armed = b.getModel().isArmed();
        boolean enabled = b.isEnabled();
        CheckKey key = new CheckKey(c, pressed, enabled, (rollover = b.getModel().isRollover()) || armed, focused = Theme.buttonFocusBorder[Theme.style] && !rollover && b.isFocusOwner());
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, x, y, b);
            return;
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        int spread1 = Theme.buttonSpreadLight[Theme.style];
        int spread2 = Theme.buttonSpreadDark[Theme.style];
        if (!b.isEnabled()) {
            spread1 = Theme.buttonSpreadLightDisabled[Theme.style];
            spread2 = Theme.buttonSpreadDarkDisabled[Theme.style];
        }
        int spreadStep1 = spread1 * 5;
        int spreadStep2 = spread2 * 4;
        if (pressed && (rollover || armed)) {
            spreadStep2 *= 2;
        }
        c = ColorRoutines.lighten(c, spreadStep1);
        imgGraphics.setColor(ColorRoutines.darken(c, spreadStep2));
        imgGraphics.fillRect(1, 1, w - 2, h - 2);
        int row = 0;
        while (row < 11) {
            int col = 0;
            while (col < 11) {
                Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - a[col][row]);
                imgGraphics.setColor(color);
                imgGraphics.drawLine(col + 1, row + 1, col + 1, row + 1);
                ++col;
            }
            ++row;
        }
        if (!b.isEnabled()) {
            imgGraphics.setColor(Theme.buttonBorderDisabledColor[Theme.style].getColor());
            imgGraphics.drawRect(0, 0, w - 1, h - 1);
        } else {
            imgGraphics.setColor(Theme.buttonBorderColor[Theme.style].getColor());
            imgGraphics.drawRect(0, 0, w - 1, h - 1);
            if (rollover && Theme.buttonRollover[Theme.style] && !pressed) {
                DrawRoutines.drawRolloverCheckBorder(imgGraphics, Theme.buttonRolloverColor[Theme.style].getColor(), 0, 0, w, h);
            } else if (focused && !pressed) {
                DrawRoutines.drawRolloverCheckBorder(imgGraphics, Theme.buttonDefaultColor[Theme.style].getColor(), 0, 0, w, h);
            }
        }
        imgGraphics.dispose();
        g.drawImage(img, x, y, b);
        cache.put(key, img);
    }

    private void drawXpCheckNoCache(Graphics g, AbstractButton b, Color c, int x, int y, int w, int h) {
        boolean pressed = b.getModel().isPressed();
        boolean armed = b.getModel().isArmed();
        boolean enabled = b.isEnabled();
        boolean rollover = b.getModel().isRollover();
        boolean focused = Theme.buttonFocusBorder[Theme.style] && !rollover && b.isFocusOwner();
        boolean useCachedImage = !pressed && !armed && !rollover && !focused;
        BufferedImage img = null;
        Object key = null;
        if (useCachedImage) {
            key = enabled ? new EnabledCheckKey(c, Theme.buttonBorderColor[Theme.style].getColor()) : new DisabledCheckKey(c, Theme.buttonBorderDisabledColor[Theme.style].getColor());
            Object value = cache.get(key);
            if (value != null) {
                g.drawImage((Image)value, x, y, b);
                return;
            }
            img = new BufferedImage(w, h, 2);
        }
        int spread1 = Theme.buttonSpreadLight[Theme.style];
        int spread2 = Theme.buttonSpreadDark[Theme.style];
        if (!enabled) {
            spread1 = Theme.buttonSpreadLightDisabled[Theme.style];
            spread2 = Theme.buttonSpreadDarkDisabled[Theme.style];
        }
        int spreadStep1 = spread1 * 5;
        int spreadStep2 = spread2 * 4;
        if (pressed && (rollover || armed)) {
            spreadStep2 *= 2;
        }
        c = ColorRoutines.lighten(c, spreadStep1);
        Graphics graphics = null;
        int bx = x;
        int by = y;
        if (img != null) {
            graphics = ((Image)img).getGraphics();
            Color bg = b.getBackground();
            if (!b.isOpaque()) {
                Container parent = b.getParent();
                bg = parent.getBackground();
                while (parent != null && !parent.isOpaque()) {
                    parent = parent.getParent();
                    bg = parent.getBackground();
                }
            }
            graphics.setColor(bg);
            graphics.fillRect(0, 0, w - 1, h - 1);
            bx = 0;
            by = 0;
        } else {
            graphics = g;
            graphics.translate(x, y);
        }
        graphics.setColor(ColorRoutines.darken(c, spreadStep2));
        graphics.fillRect(1, 1, w - 2, h - 2);
        int row = 0;
        while (row < 11) {
            int col = 0;
            while (col < 11) {
                Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - a[col][row]);
                graphics.setColor(color);
                graphics.drawLine(col + 1, row + 1, col + 1, row + 1);
                ++col;
            }
            ++row;
        }
        if (img == null) {
            graphics.translate(-x, -y);
        }
        if (!enabled) {
            graphics.setColor(Theme.buttonBorderDisabledColor[Theme.style].getColor());
            graphics.drawRect(bx, by, w - 1, h - 1);
        } else {
            graphics.setColor(Theme.buttonBorderColor[Theme.style].getColor());
            graphics.drawRect(bx, by, w - 1, h - 1);
            if (rollover && Theme.buttonRollover[Theme.style] && !pressed) {
                DrawRoutines.drawRolloverCheckBorder(graphics, Theme.buttonRolloverColor[Theme.style].getColor(), bx, by, w, h);
            } else if (focused && !pressed) {
                DrawRoutines.drawRolloverCheckBorder(graphics, Theme.buttonDefaultColor[Theme.style].getColor(), bx, by, w, h);
            }
        }
        if (img != null) {
            graphics.dispose();
            g.drawImage(img, x, y, b);
            cache.put(key, img);
        }
    }

    private void drawTinyCheckMark(Graphics g, AbstractButton b, Color c, int x, int y) {
        g.drawLine(x + 2, y + 5, x + 3, y + 5);
        g.drawLine(x + 3, y + 6, x + 4, y + 6);
        g.drawLine(x + 4, y + 7, x + 6, y + 7);
        g.drawLine(x + 5, y + 8, x + 5, y + 8);
        g.drawLine(x + 6, y + 6, x + 7, y + 6);
        g.drawLine(x + 7, y + 5, x + 8, y + 5);
        g.drawLine(x + 8, y + 4, x + 9, y + 4);
        g.drawLine(x + 9, y + 3, x + 10, y + 3);
        g.drawLine(x + 10, y + 2, x + 10, y + 2);
        g.drawLine(x + 12, y + 1, x + 12, y + 1);
        if (!b.isEnabled()) {
            g.setColor(ColorRoutines.darken(c, 10));
        } else {
            g.setColor(ColorRoutines.darken(c, 20));
        }
        g.drawLine(x + 3, y + 7, x + 3, y + 7);
        g.drawLine(x + 4, y + 8, x + 4, y + 8);
        g.drawLine(x + 6, y + 9, x + 6, y + 9);
        g.drawLine(x + 7, y + 8, x + 7, y + 8);
        g.drawLine(x + 8, y + 7, x + 8, y + 7);
        g.drawLine(x + 9, y + 6, x + 9, y + 6);
        g.drawLine(x + 12, y + 3, x + 12, y + 3);
        g.drawLine(x + 13, y + 2, x + 13, y + 2);
        if (!b.isEnabled()) {
            g.setColor(ColorRoutines.darken(c, 20));
        } else {
            g.setColor(ColorRoutines.darken(c, 40));
        }
        g.drawLine(x + 5, y + 9, x + 5, y + 9);
        g.drawLine(x + 6, y + 8, x + 6, y + 8);
        g.drawLine(x + 7, y + 7, x + 7, y + 7);
        g.drawLine(x + 8, y + 6, x + 8, y + 6);
        g.drawLine(x + 9, y + 5, x + 9, y + 5);
        g.drawLine(x + 12, y + 2, x + 12, y + 2);
    }

    private void drawWinCheckMark(Graphics g, int x, int y) {
        g.drawLine(x + 3, y + 5, x + 3, y + 7);
        g.drawLine(x + 4, y + 6, x + 4, y + 8);
        g.drawLine(x + 5, y + 7, x + 5, y + 9);
        g.drawLine(x + 6, y + 6, x + 6, y + 8);
        g.drawLine(x + 7, y + 5, x + 7, y + 7);
        g.drawLine(x + 8, y + 4, x + 8, y + 6);
        g.drawLine(x + 9, y + 3, x + 9, y + 5);
    }

    private void drawXpCheckMark(Graphics g, int x, int y) {
        g.drawLine(x + 3, y + 5, x + 3, y + 7);
        g.drawLine(x + 4, y + 6, x + 4, y + 8);
        g.drawLine(x + 5, y + 7, x + 5, y + 9);
        g.drawLine(x + 6, y + 6, x + 6, y + 8);
        g.drawLine(x + 7, y + 5, x + 7, y + 7);
        g.drawLine(x + 8, y + 4, x + 8, y + 6);
        g.drawLine(x + 9, y + 3, x + 9, y + 5);
    }

    public int getIconWidth() {
        return Theme.checkSize[Theme.derivedStyle[Theme.style]].width;
    }

    public int getIconHeight() {
        return Theme.checkSize[Theme.derivedStyle[Theme.style]].height;
    }

    static class CheckKey {
        private Color c;
        private boolean pressed;
        private boolean enabled;
        private boolean rollover;
        private boolean focused;

        CheckKey(Color c, boolean pressed, boolean enabled, boolean rollover, boolean focused) {
            this.c = c;
            this.pressed = pressed;
            this.enabled = enabled;
            this.rollover = rollover;
            this.focused = focused;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof CheckKey)) {
                return false;
            }
            CheckKey other = (CheckKey)o;
            return this.pressed == other.pressed && this.enabled == other.enabled && this.rollover == other.rollover && this.focused == other.focused && this.c.equals(other.c);
        }

        public int hashCode() {
            return this.c.hashCode() * (this.pressed ? 1 : 2) * (this.enabled ? 4 : 8) * (this.rollover ? 16 : 32);
        }
    }

    static class DisabledCheckKey {
        int spread1 = Theme.buttonSpreadLightDisabled[Theme.style];
        int spread2 = Theme.buttonSpreadDarkDisabled[Theme.style];
        Color c;
        Color back;

        DisabledCheckKey(Color c, Color back) {
            this.c = c;
            this.back = back;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof DisabledCheckKey)) {
                return false;
            }
            DisabledCheckKey other = (DisabledCheckKey)o;
            return this.c.equals(other.c) && this.back.equals(other.back) && this.spread1 == other.spread1 && this.spread2 == other.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }

    static class EnabledCheckKey {
        int spread1 = Theme.buttonSpreadLight[Theme.style];
        int spread2 = Theme.buttonSpreadDark[Theme.style];
        Color c;
        Color back;

        EnabledCheckKey(Color c, Color back) {
            this.c = c;
            this.back = back;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof EnabledCheckKey)) {
                return false;
            }
            EnabledCheckKey other = (EnabledCheckKey)o;
            return this.c.equals(other.c) && this.back.equals(other.back) && this.spread1 == other.spread1 && this.spread2 == other.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }
}

