/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.controller;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Hashtable;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.LogWriter;

public class PDFPrint {
    private static boolean debugCode = false;
    private final String separator = System.getProperty("file.separator");
    private PdfDecoder decode_pdf = null;
    private int copiesToPrint = 1;
    private static String printer = PrinterJob.lookupPrintServices()[0].getName();
    private String tray = null;
    public static boolean customSetting = false;
    public static int pageMark = 1;
    public static PrinterJob printJob = null;

    public PDFPrint() {
    }

    public PDFPrint(String file_name) {
        if (file_name.toLowerCase().endsWith(".pdf")) {
            this.decodeAndPrintFile(file_name);
        } else {
            String[] files = null;
            File inputFiles = null;
            if (!file_name.endsWith(this.separator)) {
                file_name = file_name + this.separator;
            }
            try {
                inputFiles = new File(file_name);
                if (!inputFiles.isDirectory()) {
                    System.err.println(file_name + " is not a directory. Exiting program");
                } else {
                    files = inputFiles.list();
                }
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception trying to access file " + ee.getMessage());
            }
            long fileCount = files.length;
            int i = 0;
            while ((long)i < fileCount) {
                if (files[i].toLowerCase().endsWith(".pdf")) {
                    PDFPrint.logMessage(file_name + files[i]);
                    this.decodeAndPrintFile(file_name + files[i]);
                }
                ++i;
            }
        }
    }

    private void decodeAndPrintFile(String file_name) {
        try {
            PDFPrint.logMessage("Opening file :" + file_name + " to print.");
            this.decode_pdf = new PdfDecoder(true);
            this.decode_pdf.openPdfFile(file_name);
            this.decode_pdf.getPageCount();
        }
        catch (Exception e) {
            PDFPrint.reportError("Exception " + e + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isExtractionAllowed()) {
            PDFPrint.logMessage("Encrypted settings");
        } else {
            String[] aliases1 = new String[]{"helvetica", "arial"};
            this.decode_pdf.setSubstitutedFontAliases("arial", aliases1);
            String[] aliases2 = new String[]{"Helvetica-Bold"};
            this.decode_pdf.setSubstitutedFontAliases("Arial-BoldMT", aliases2);
            String[] aliases3 = new String[]{"Times-Bold", "Times-Roman"};
            this.decode_pdf.setSubstitutedFontAliases("timesbd", aliases3);
            String[] aliases4 = new String[]{"Courier"};
            this.decode_pdf.setSubstitutedFontAliases("Cour", aliases4);
            String[] aliases5 = new String[]{"Courier-Bold"};
            this.decode_pdf.setSubstitutedFontAliases("courbd", aliases5);
            String[] aliases6 = new String[]{"acarialunicodems__cn"};
            this.decode_pdf.setSubstitutedFontAliases("adobeheitistd-regular", aliases6);
            PdfDecoder.setFontDirs(new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/System/Library/Fonts/", "/Library/Fonts/"});
            this.printAllCopies();
        }
        this.decode_pdf.closePdfFile();
    }

    private final void printAllCopies() {
        for (int currentCopy = 0; currentCopy < this.copiesToPrint; ++currentCopy) {
            PDFPrint.logMessage("========================");
            PDFPrint.logMessage("\nPrinting copy " + (currentCopy + 1));
            PDFPrint.logMessage("========================");
            this.printPages();
        }
    }

    public void printPages() {
        try {
            printJob = PrinterJob.getPrinterJob();
            PageFormat pf = printJob.defaultPage();
            HashPrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
            boolean matchFound = PDFPrint.validatePrinter(printer);
            if (matchFound) {
                if (this.tray != null) {
                    boolean hasTrayValues = printJob.getPrintService().isAttributeCategorySupported(Media.class);
                    if (hasTrayValues) {
                        Hashtable<String, Object> possibleValues = new Hashtable<String, Object>();
                        Class<Media> category = Media.class;
                        Object o = printJob.getPrintService().getSupportedAttributeValues(category, null, null);
                        if (o == null) {
                            PDFPrint.logMessage("Attribute " + category + " not supported");
                        } else if (o.getClass().isArray()) {
                            for (int i = 0; i < Array.getLength(o); ++i) {
                                Object v = Array.get(o, i);
                                possibleValues.put(v.toString(), v);
                                PDFPrint.logMessage("Atribute values " + v.toString());
                            }
                        }
                        Object trayValue = possibleValues.get(this.tray);
                        if (trayValue != null) {
                            attributeSet.add((Attribute)trayValue);
                        }
                    } else {
                        PDFPrint.logMessage("Tray " + this.tray + " not implemented");
                        PDFPrint.logMessage("Atributes implemented are ");
                        Class<?>[] c = printJob.getPrintService().getSupportedAttributeCategories();
                        for (int j = 0; j < c.length; ++j) {
                            PDFPrint.logMessage(">>" + c[j].getName());
                        }
                    }
                }
                if (debugCode) {
                    Attribute[] attribs = attributeSet.toArray();
                    int count1 = attribs.length;
                    for (int i = 0; i < count1; ++i) {
                        PDFPrint.logMessage(i + " " + attribs[i].getName() + ' ' + attribs[i].toString());
                    }
                }
                Paper paper = new Paper();
                paper.setSize(595.0, 842.0);
                paper.setImageableArea(1.0, 1.0, 570.0, 822.0);
                pf.setPaper(paper);
                printJob.setCopies(1);
                this.decode_pdf.setPrintPageScalingMode(1);
                this.decode_pdf.setCenterOnScaling(true);
                this.decode_pdf.setPrintAutoRotateAndCenter(true);
                this.decode_pdf.setPageFormat(pf);
                if (customSetting) {
                    this.decode_pdf.setPagePrintRange(pageMark, pageMark);
                    System.out.println("Pagemark set to: " + pageMark);
                } else {
                    this.decode_pdf.setPagePrintRange(1, this.decode_pdf.getPageCount());
                }
                printJob.setPageable(this.decode_pdf);
                printJob.print();
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception " + ee + " printing");
        }
        catch (Error err) {
            LogWriter.writeLog("Error " + err + " printing");
        }
    }

    private static boolean validatePrinter(String newPrinter) throws PrinterException {
        boolean matchFound = false;
        printJob = PrinterJob.getPrinterJob();
        PrintService[] service = PrinterJob.lookupPrintServices();
        int count = service.length;
        for (int i = 0; i < count; ++i) {
            if (service[i].getName().indexOf(newPrinter) == -1) continue;
            printJob.setPrintService(service[i]);
            i = count;
            matchFound = true;
            printer = newPrinter;
        }
        if (!matchFound) {
            String list = "";
            for (int i = 0; i < count; ++i) {
                list = list + '\"' + service[i].getName() + "\",";
            }
            PDFPrint.reportError("Printer " + newPrinter + " not supported. Options=" + list);
        }
        return matchFound;
    }

    private static void logMessage(String message) {
        if (debugCode) {
            System.out.println(message);
            LogWriter.writeLog(message);
        }
    }

    private static void reportError(String message) {
        System.err.println(message);
        LogWriter.writeLog(message);
    }

    public static void main(String[] args) {
        PDFPrint.logMessage("Simple demo to print pages");
        if (args.length != 2) {
            PDFPrint.logMessage("Printing needs 2 paramters");
            PDFPrint.logMessage("Parameter 1 - File name or directory (put in quotes if it contains spaces");
            PDFPrint.logMessage("Parameter 2- a printer name");
            PDFPrint.logMessage("If the printer name is not valid a list will be supplied of valid printers");
        }
        String file_name = "C:" + File.separator + "B.pdf";
        String printerName = PrinterJob.lookupPrintServices()[0].getName();
        PDFPrint.logMessage("File :" + file_name);
        PDFPrint.logMessage("Printer :" + printerName);
        boolean validPrinter = false;
        try {
            validPrinter = PDFPrint.validatePrinter(printerName);
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            PDFPrint.logMessage("File " + file_name + " not found");
        } else if (!validPrinter) {
            PDFPrint.logMessage("Printer " + printerName + " not found");
        } else {
            PDFPrint images1 = new PDFPrint(file_name);
            images1.printPages();
        }
        System.out.println("End " + PrinterJob.lookupPrintServices()[0].getName());
    }
}

