/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import p12d.exe.pasarelapagos.exceptions.P12DPaymentRequestException;
import p12d.exe.pasarelapagos.services.P12DPaymentManagerBaseAPI;
import p12d.exe.pasarelapagos.services.P12DPaymentManagerBzd;
import p12f.exe.pasarelapagos.helpers.SenderHelper;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.pasarelapagos.objects.Pago;
import p12f.exe.pasarelapagos.objects.PaymentStateData;
import p12f.exe.pasarelapagos.paymentrequest.InitializeCSBPaymentResult;
import p12f.exe.pasarelapagos.paymentrequest.PaymentGatewayData;
import p12f.exe.pasarelapagos.paymentrequest.PaymentRequestData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.transformer.ObjectTransformer;
import p12f.exe.pasarelapagos.transformer.ObjectTransformerException;

public class P12DPaymentManagerAPI
extends P12DPaymentManagerBaseAPI {
    P12DPaymentManagerAPI(String newOid) {
        super(newOid);
    }

    public OperationResult initializeCSBPayment(PeticionPago peticionPago) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.initializeCSBPayment <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            InitializeCSBPaymentResult initializeCSBPaymentResult = paymentManagerBzd.doExecInitializeCSBPayment(peticionPago);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = initializeCSBPaymentResult.toXML();
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult initializePayment(PaymentRequestData paymentRequest) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.initializePayment <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentRequestData paymentRequestInitialized = paymentManagerBzd.doExecInitializePayment(paymentRequest);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentRequestInitialized.toXML();
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult updatePayment(PaymentRequestData paymentRequest) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.updatePayment <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentRequestData paymentRequestInitialized = paymentManagerBzd.doExecUpdatePayment(paymentRequest);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentRequestInitialized.toXML();
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult initializePayment(PaymentGatewayData gatewayData) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.initializePayment <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentGatewayData paymentRequestInitialized = paymentManagerBzd.doExecInitializePayment(gatewayData);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentRequestInitialized.toXML();
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            e.printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult sendUsingPost(PaymentGatewayData gatewayData, HttpServletRequest request, HttpServletResponse response) {
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "sendByPost";
        try {
            response.setHeader("expires", "0");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            PrintWriter out = response.getWriter();
            String paymentGatewayURI = XMLProperties.get((String)"p12d", (String)"urls/urlPasarela");
            String code = SenderHelper.getHTMLPostCode((PaymentGatewayData)gatewayData, (String)paymentGatewayURI);
            out.println(code);
            out.flush();
            out.close();
            operationResult.resultado.resultadoOK = true;
        }
        catch (IOException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult sendUsingGet(PaymentGatewayData gatewayData, HttpServletRequest request, HttpServletResponse response) {
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "sendByGet";
        try {
            String gatewayVersion = null;
            if (XMLProperties.getPropertyNode((String)"p12d", (String)"urls/@gatewayVersion") != null) {
                gatewayVersion = XMLProperties.getPropertyNode((String)"p12d", (String)"urls/@gatewayVersion").getNodeValue();
            }
            if (gatewayVersion != null && gatewayVersion.equalsIgnoreCase("1")) {
                String url = XMLProperties.get((String)"p12d", (String)"urls/urlPasarela");
                String oidVersion2 = (String)gatewayData.paymentRequestData.peticionesPago.keySet().iterator().next();
                String oidVersion1 = new ObjectTransformer().getOldOIDFormat(oidVersion2);
                url = String.valueOf(url) + "?module=ia&pagoID=" + oidVersion1;
                response.sendRedirect(url);
            } else {
                String oids = "";
                Iterator it = gatewayData.paymentRequestData.peticionesPago.keySet().iterator();
                while (it.hasNext()) {
                    oids = String.valueOf(oids) + it.next() + ",";
                }
                String url = XMLProperties.get((String)"p12d", (String)"urls/urlPasarela");
                url = String.valueOf(url) + "?module=IU";
                url = String.valueOf(url) + "&p12iOidsPago=" + oids;
                url = String.valueOf(url) + "&p12iPresentationRequestData=" + gatewayData.presentationData.toXML();
                url = String.valueOf(url) + "&p12iProtocolData=" + gatewayData.protocolData.toXML();
                response.sendRedirect(url);
            }
            operationResult.resultado.resultadoOK = true;
        }
        catch (IOException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (ObjectTransformerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult beginPayment(String[] oids) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest("\n>>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.beginPayment ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentRequestData paymentRequestData = paymentManagerBzd.doExecBeginPayment(oids);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentRequestData.toXML();
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult cancelPayment(PaymentRequestData paymentRequest) throws P12DPaymentRequestException {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(">>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DPaymentManagerAPI.cancelPayment ::::::::::::");
        OperationResult operationResult = new OperationResult();
        P12DPaymentManagerBzd paymentManagerBzd = null;
        try {
            paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            paymentManagerBzd.doExecCancelPayment(paymentRequest);
            operationResult.resultado.resultadoOK = true;
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult getPaymentStateData(String paymentID) throws P12DPaymentRequestException {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.getPaymentStateData ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentStateData paymentStateData = paymentManagerBzd.doExecGetPaymentStateData(paymentID);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentStateData.toXML();
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (NullPointerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = ((Throwable)e).getMessage();
        }
        return operationResult;
    }

    public OperationResult getPaymentStateDataLazy(String paymentID) throws P12DPaymentRequestException {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.getPaymentStateDataLazy ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            String paymentStateData = paymentManagerBzd.getPaymentStateDataLazy(paymentID);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentStateData;
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (NullPointerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = ((Throwable)e).getMessage();
        }
        return operationResult;
    }

    public OperationResult setPaymentONLineOK(PaymentStateData paymentStateData) throws P12DPaymentRequestException {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DPaymentManagerAPI.setPaymentONLineOK ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            paymentManagerBzd.doExecSetPaymentONLineOK(paymentStateData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult setPaymentOnLineNOOK(PaymentStateData paymentStateData) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.setPaymentOnLineNOOK ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            paymentManagerBzd.doExecSetPaymentONLineNOOK(paymentStateData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult payONLine(String[] oids) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.pagarONLine ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            paymentManagerBzd.doExecPayONLine(oids);
            operationResult.resultado.resultadoOK = true;
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult payONLine(String[] oids, String finantialOrgID) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.pagarONLine ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            paymentManagerBzd.doExecPayONLine(oids, finantialOrgID);
            operationResult.resultado.resultadoOK = true;
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult payOFFLine(String[] oids) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DPaymentManagerAPI.pagarOFFLine ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            paymentManagerBzd.doExecPayOFFLine(oids);
            operationResult.resultado.resultadoOK = true;
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public String[] validatePayment(Pago pago) throws P12DPaymentRequestException {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DPaymentManagerAPI.validatePayment ::::::::::::");
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            return paymentManagerBzd.doExecValidatePayment(pago);
        }
        catch (P12DPaymentRequestException e) {
            ((Throwable)((Object)e)).printStackTrace();
            throw new P12DPaymentRequestException("No se ha podido instanciar la clase implementadora del Interfaz P12DPaymentManagerBzd");
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            throw new P12DPaymentRequestException("No se ha podido instanciar la clase implementadora del Interfaz P12DPaymentManagerBzd");
        }
    }

    public OperationResult getPaymentRequest(String paymentId) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DPaymentManagerAPI.getPayment ::::::::::::");
        OperationResult operationResult = new OperationResult();
        PeticionPago peticionPago = null;
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            peticionPago = paymentManagerBzd.doExecGetPaymentRequest(paymentId);
            if (peticionPago == null) {
                R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DPaymentManagerAPI.getPaymentRequestByCSB :: El Proceso de Consulta ha sido correcto, pero no existe ningun Pago de csb:" + paymentId);
            }
            operationResult.resultado.returnValue = peticionPago == null ? null : peticionPago.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (P12DPaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult getPaymentRequestByNRC(String paymentNRC) {
        R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DPaymentManagerAPI.getPaymentRequestByNRC ::::::::::::");
        OperationResult operationResult = new OperationResult();
        PeticionPago peticionPago = null;
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            peticionPago = paymentManagerBzd.doExecGetPaymentRequestByNRC(paymentNRC);
            if (peticionPago == null) {
                R01FLog.to((String)"p12d.clientPaymentAPI").finest(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DPaymentManagerAPI.getPaymentRequestByNRC :: El Proceso de Consulta ha sido correcto, pero no existe ningun Pago de NRC:" + paymentNRC);
            }
            operationResult.resultado.returnValue = peticionPago == null ? null : peticionPago.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (P12DPaymentRequestException e) {
            ((Throwable)((Object)e)).printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            e.printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }
}

