/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.metal.MetalComboBoxEditor;

public class TinyComboBoxEditor
extends MetalComboBoxEditor {
    public TinyComboBoxEditor() {
        this.editor = new JTextField("", 9){

            public void setText(String s) {
                if (this.getText().equals(s)) {
                    return;
                }
                super.setText(s);
            }
        };
        this.editor.setBorder(new EditorBorder());
    }

    private void drawTinyBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (!c.isEnabled()) {
            g.setColor(Theme.textBorderDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.textBorderColor[Theme.style].getColor());
        }
        g.drawRect(x + 1, y + 1, w - 3, h - 3);
        if (!c.isEnabled()) {
            g.setColor(Theme.textBorderDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.textBorderDarkColor[Theme.style].getColor());
        }
        g.drawLine(x, y, x + w - 2, y);
        g.drawLine(x, y + 1, x, y + h - 2);
        if (!c.isEnabled()) {
            g.setColor(Theme.textBorderLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.textBorderLightColor[Theme.style].getColor());
        }
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 2);
    }

    private void drawWinBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (!c.isEnabled()) {
            g.setColor(Theme.textBorderDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.textBorderColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y + 1, x + w - 1, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + h - 3);
        if (!c.isEnabled()) {
            g.setColor(Theme.textBorderDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.textBorderDarkColor[Theme.style].getColor());
        }
        g.drawLine(x, y, x + w - 1, y);
        g.drawLine(x, y + 1, x, y + h - 2);
        g.setColor(Theme.backColor[Theme.style].getColor());
        g.drawLine(x + 1, y + h - 2, x + w - 1, y + h - 2);
        if (!c.isEnabled()) {
            g.setColor(Theme.textBorderLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.textBorderLightColor[Theme.style].getColor());
        }
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
    }

    private void drawXpBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Color bg = c.getParent().getParent().getBackground();
        g.setColor(bg);
        g.drawLine(x, y, x + w - 1, y);
        g.drawLine(x, y, x, y + h - 1);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        if (!c.isEnabled()) {
            DrawRoutines.drawEditableComboBorder(g, Theme.comboBorderDisabledColor[Theme.style].getColor(), 0, 0, w, h);
        } else {
            DrawRoutines.drawEditableComboBorder(g, Theme.comboBorderColor[Theme.style].getColor(), 0, 0, w, h);
        }
    }

    class EditorBorder
    extends AbstractBorder {
        EditorBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, Theme.comboInsets[Theme.style].left + 1, 1, 0);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JComponent combo = (JComponent)TinyComboBoxEditor.this.editor.getParent();
            if (combo.getBorder() == null) {
                return;
            }
            switch (Theme.derivedStyle[Theme.style]) {
                case 0: {
                    TinyComboBoxEditor.this.drawTinyBorder(c, g, x, y, w, h);
                    break;
                }
                case 1: {
                    TinyComboBoxEditor.this.drawWinBorder(c, g, x, y, w, h);
                    break;
                }
                case 2: {
                    TinyComboBoxEditor.this.drawXpBorder(c, g, x, y, w, h);
                }
            }
        }
    }

    public static class UIResource
    extends TinyComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }
}

