/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyScrollBarUI;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicArrowButton;

public class TinyScrollButton
extends BasicArrowButton {
    static HashMap cache = new HashMap();
    private boolean isRollover;
    private TinyScrollBarUI scrollbarUI;
    protected static Dimension[] size = new Dimension[3];

    static {
        TinyScrollButton.size[0] = new Dimension(15, 15);
        TinyScrollButton.size[1] = new Dimension(16, 16);
        TinyScrollButton.size[2] = new Dimension(17, 17);
    }

    public TinyScrollButton(int direction, TinyScrollBarUI scrollbarUI) {
        super(direction);
        this.scrollbarUI = scrollbarUI;
        this.setBorder(null);
        this.setRolloverEnabled(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setSize(size[Theme.derivedStyle[Theme.style]]);
    }

    public void paint(Graphics g) {
        this.isRollover = false;
        ColorUIResource c = null;
        if (!this.scrollbarUI.isThumbVisible()) {
            c = Theme.scrollButtDisabledColor[Theme.style].getColor();
        } else if (this.getModel().isPressed()) {
            c = Theme.scrollButtPressedColor[Theme.style].getColor();
        } else if (this.getModel().isRollover() && Theme.scrollRollover[Theme.style]) {
            c = Theme.scrollButtRolloverColor[Theme.style].getColor();
            this.isRollover = true;
        } else {
            c = Theme.scrollButtColor[Theme.style].getColor();
        }
        g.setColor(c);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyButton(g, this.getSize());
                break;
            }
            case 1: {
                this.drawWinButton(g, this.getSize());
                break;
            }
            case 2: {
                if (TinyLookAndFeel.controlPanelInstantiated) {
                    this.drawXpButtonNoCache(g, this.getSize(), c);
                    break;
                }
                this.drawXpButton(g, this.getSize(), c);
            }
        }
        if (!this.scrollbarUI.isThumbVisible()) {
            g.setColor(Theme.scrollArrowDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.scrollArrowColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyArrow(g, this.getSize());
                break;
            }
            case 1: {
                this.drawWinArrow(g, this.getSize());
                break;
            }
            case 2: {
                this.drawXpArrow(g, this.getSize());
            }
        }
    }

    private void drawTinyButton(Graphics g, Dimension size) {
    }

    private void drawWinButton(Graphics g, Dimension size) {
        g.fillRect(1, 1, size.width - 2, size.height - 2);
        g.drawLine(0, 0, size.width - 1, 0);
        g.drawLine(0, 0, 0, size.height - 1);
        if (this.getModel().isPressed() && this.scrollbarUI.isThumbVisible()) {
            g.setColor(Theme.scrollBorderColor[Theme.style].getColor());
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        } else {
            g.setColor(Theme.scrollLightColor[Theme.style].getColor());
            g.drawLine(1, 1, size.width - 3, 1);
            g.drawLine(1, 1, 1, size.height - 3);
            g.setColor(Theme.scrollDarkColor[Theme.style].getColor());
            g.drawLine(size.width - 2, 1, size.width - 2, size.height - 3);
            g.drawLine(1, size.height - 2, size.width - 2, size.height - 2);
            g.setColor(Theme.scrollBorderColor[Theme.style].getColor());
            g.drawLine(size.width - 1, 0, size.width - 1, size.height - 2);
            g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
        }
    }

    private void drawXpButton(Graphics g, Dimension size, Color c) {
        boolean rollover;
        boolean pressed;
        boolean enabled = this.scrollbarUI.isThumbVisible();
        ScrollButtonKey key = new ScrollButtonKey(this.direction == 1 || this.direction == 5, c, pressed = this.getModel().isPressed(), enabled, rollover = this.getModel().isRollover() && Theme.scrollRollover[Theme.style]);
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, 0, 0, this);
            return;
        }
        BufferedImage img = new BufferedImage(17, 17, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        int spread1 = Theme.scrollSpreadLight[Theme.style];
        int spread2 = Theme.scrollSpreadDark[Theme.style];
        if (!this.scrollbarUI.isThumbVisible()) {
            spread1 = Theme.scrollSpreadLightDisabled[Theme.style];
            spread2 = Theme.scrollSpreadDarkDisabled[Theme.style];
        }
        switch (this.direction) {
            case 1: 
            case 5: {
                int h = 17;
                float spreadStep1 = 10.0f * (float)spread1 / 11.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 11.0f;
                int halfY = 6;
                int y = 1;
                while (y < h - 1) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        imgGraphics.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        imgGraphics.setColor(c);
                    } else {
                        yd = y - halfY;
                        imgGraphics.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    imgGraphics.drawLine(3, y, 14, y);
                    ++y;
                }
                imgGraphics.setColor(Theme.scrollTrackBorderColor[Theme.style].getColor());
                imgGraphics.drawLine(0, 0, 0, 16);
                c = !this.scrollbarUI.isThumbVisible() ? Theme.scrollLightDisabledColor[Theme.style].getColor() : Theme.scrollLightColor[Theme.style].getColor();
                imgGraphics.setColor(c);
                imgGraphics.drawLine(2, 1, 2, 15);
                imgGraphics.drawLine(15, 1, 15, 15);
                Color lightAlpha = new Color(c.getRed(), c.getGreen(), c.getBlue(), 92);
                c = !this.scrollbarUI.isThumbVisible() ? Theme.scrollBorderDisabledColor[Theme.style].getColor() : Theme.scrollBorderColor[Theme.style].getColor();
                imgGraphics.setColor(c);
                imgGraphics.drawRect(1, 0, 15, 16);
                imgGraphics.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 92));
                imgGraphics.drawLine(2, 1, 2, 1);
                imgGraphics.drawLine(15, 1, 15, 1);
                imgGraphics.drawLine(2, 15, 2, 15);
                imgGraphics.drawLine(15, 15, 15, 15);
                imgGraphics.setColor(lightAlpha);
                imgGraphics.drawLine(1, 0, 1, 0);
                imgGraphics.drawLine(1, 16, 1, 16);
                imgGraphics.drawLine(16, 0, 16, 0);
                imgGraphics.drawLine(16, 16, 16, 16);
                break;
            }
            case 3: 
            case 7: {
                float spreadStep1 = 10.0f * (float)spread1 / 10.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 10.0f;
                int halfY = 6;
                int y = 1;
                while (y < 15) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        imgGraphics.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        imgGraphics.setColor(c);
                    } else {
                        yd = y - halfY;
                        imgGraphics.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    imgGraphics.drawLine(2, y + 1, 14, y + 1);
                    ++y;
                }
                imgGraphics.setColor(Theme.scrollTrackBorderColor[Theme.style].getColor());
                imgGraphics.drawLine(0, 0, 16, 0);
                c = !this.scrollbarUI.isThumbVisible() ? Theme.scrollLightDisabledColor[Theme.style].getColor() : Theme.scrollLightColor[Theme.style].getColor();
                imgGraphics.setColor(c);
                imgGraphics.drawLine(1, 2, 1, 15);
                imgGraphics.drawLine(15, 2, 15, 15);
                Color lightAlpha = new Color(c.getRed(), c.getGreen(), c.getBlue(), 92);
                c = !this.scrollbarUI.isThumbVisible() ? Theme.scrollBorderDisabledColor[Theme.style].getColor() : Theme.scrollBorderColor[Theme.style].getColor();
                imgGraphics.setColor(c);
                imgGraphics.drawRect(0, 1, 16, 15);
                imgGraphics.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 92));
                imgGraphics.drawLine(1, 2, 1, 2);
                imgGraphics.drawLine(15, 2, 15, 2);
                imgGraphics.drawLine(1, 15, 1, 15);
                imgGraphics.drawLine(15, 15, 15, 15);
                imgGraphics.setColor(lightAlpha);
                imgGraphics.drawLine(0, 1, 0, 1);
                imgGraphics.drawLine(16, 1, 16, 1);
                imgGraphics.drawLine(0, 16, 0, 16);
                imgGraphics.drawLine(16, 16, 16, 16);
            }
        }
        imgGraphics.dispose();
        g.drawImage(img, 0, 0, this);
        cache.put(key, img);
    }

    private void drawXpButtonNoCache(Graphics g, Dimension size, Color c) {
        int spread1 = Theme.scrollSpreadLight[Theme.style];
        int spread2 = Theme.scrollSpreadDark[Theme.style];
        if (!this.scrollbarUI.isThumbVisible()) {
            spread1 = Theme.scrollSpreadLightDisabled[Theme.style];
            spread2 = Theme.scrollSpreadDarkDisabled[Theme.style];
        }
        switch (this.direction) {
            case 1: 
            case 5: {
                int h = 17;
                float spreadStep1 = 10.0f * (float)spread1 / 11.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 11.0f;
                int halfY = 6;
                int y = 1;
                while (y < h - 1) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        g.setColor(c);
                    } else {
                        yd = y - halfY;
                        g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    g.drawLine(3, y, 14, y);
                    ++y;
                }
                g.setColor(Theme.scrollTrackBorderColor[Theme.style].getColor());
                g.drawLine(0, 0, 0, 16);
                c = !this.scrollbarUI.isThumbVisible() ? Theme.scrollLightDisabledColor[Theme.style].getColor() : Theme.scrollLightColor[Theme.style].getColor();
                g.setColor(c);
                g.drawLine(2, 1, 2, 15);
                g.drawLine(15, 1, 15, 15);
                Color lightAlpha = new Color(c.getRed(), c.getGreen(), c.getBlue(), 92);
                c = !this.scrollbarUI.isThumbVisible() ? Theme.scrollBorderDisabledColor[Theme.style].getColor() : Theme.scrollBorderColor[Theme.style].getColor();
                g.setColor(c);
                g.drawRect(1, 0, 15, 16);
                g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 92));
                g.drawLine(2, 1, 2, 1);
                g.drawLine(15, 1, 15, 1);
                g.drawLine(2, 15, 2, 15);
                g.drawLine(15, 15, 15, 15);
                g.setColor(lightAlpha);
                g.drawLine(1, 0, 1, 0);
                g.drawLine(1, 16, 1, 16);
                g.drawLine(16, 0, 16, 0);
                g.drawLine(16, 16, 16, 16);
                break;
            }
            case 3: 
            case 7: {
                float spreadStep1 = 10.0f * (float)spread1 / 10.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 10.0f;
                int halfY = 6;
                int y = 1;
                while (y < 15) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        g.setColor(c);
                    } else {
                        yd = y - halfY;
                        g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    g.drawLine(2, y + 1, 14, y + 1);
                    ++y;
                }
                g.setColor(Theme.scrollTrackBorderColor[Theme.style].getColor());
                g.drawLine(0, 0, 16, 0);
                c = !this.scrollbarUI.isThumbVisible() ? Theme.scrollLightDisabledColor[Theme.style].getColor() : Theme.scrollLightColor[Theme.style].getColor();
                g.setColor(c);
                g.drawLine(1, 2, 1, 15);
                g.drawLine(15, 2, 15, 15);
                Color lightAlpha = new Color(c.getRed(), c.getGreen(), c.getBlue(), 92);
                c = !this.scrollbarUI.isThumbVisible() ? Theme.scrollBorderDisabledColor[Theme.style].getColor() : Theme.scrollBorderColor[Theme.style].getColor();
                g.setColor(c);
                g.drawRect(0, 1, 16, 15);
                g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 92));
                g.drawLine(1, 2, 1, 2);
                g.drawLine(15, 2, 15, 2);
                g.drawLine(1, 15, 1, 15);
                g.drawLine(15, 15, 15, 15);
                g.setColor(lightAlpha);
                g.drawLine(0, 1, 0, 1);
                g.drawLine(16, 1, 16, 1);
                g.drawLine(0, 16, 0, 16);
                g.drawLine(16, 16, 16, 16);
            }
        }
    }

    private void drawTinyArrow(Graphics g, Dimension size) {
    }

    private void drawWinArrow(Graphics g, Dimension size) {
        int x = 4;
        if (this.getModel().isPressed() && this.scrollbarUI.isThumbVisible()) {
            x = 5;
        }
        switch (this.direction) {
            case 1: {
                g.drawLine(x + 3, x + 2, x + 3, x + 2);
                g.drawLine(x + 2, x + 3, x + 4, x + 3);
                g.drawLine(x + 1, x + 4, x + 5, x + 4);
                g.drawLine(x, x + 5, x + 6, x + 5);
                if (this.scrollbarUI.isThumbVisible()) break;
                g.setColor(Color.WHITE);
                g.drawLine(x + 1, x + 6, x + 7, x + 6);
                break;
            }
            case 5: {
                g.drawLine(x, x + 2, x + 6, x + 2);
                g.drawLine(x + 1, x + 3, x + 5, x + 3);
                g.drawLine(x + 2, x + 4, x + 4, x + 4);
                g.drawLine(x + 3, x + 5, x + 3, x + 5);
                if (this.scrollbarUI.isThumbVisible()) break;
                g.setColor(Color.WHITE);
                g.drawLine(x + 4, x + 6, x + 4, x + 6);
                g.drawLine(x + 4, x + 5, x + 5, x + 5);
                g.drawLine(x + 5, x + 4, x + 6, x + 4);
                g.drawLine(x + 6, x + 3, x + 7, x + 3);
                break;
            }
            case 3: {
                g.drawLine(x + 5, x + 3, x + 5, x + 3);
                g.drawLine(x + 4, x + 2, x + 4, x + 4);
                g.drawLine(x + 3, x + 1, x + 3, x + 5);
                g.drawLine(x + 2, x, x + 2, x + 6);
                if (this.scrollbarUI.isThumbVisible()) break;
                g.setColor(Color.WHITE);
                g.drawLine(x + 3, x + 7, x + 3, x + 7);
                g.drawLine(x + 3, x + 6, x + 4, x + 6);
                g.drawLine(x + 4, x + 5, x + 5, x + 5);
                g.drawLine(x + 5, x + 4, x + 6, x + 4);
                break;
            }
            case 7: {
                g.drawLine(x + 1, x + 3, x + 1, x + 3);
                g.drawLine(x + 2, x + 2, x + 2, x + 4);
                g.drawLine(x + 3, x + 1, x + 3, x + 5);
                g.drawLine(x + 4, x, x + 4, x + 6);
                if (this.scrollbarUI.isThumbVisible()) break;
                g.setColor(Color.WHITE);
                g.drawLine(x + 5, x + 1, x + 5, x + 7);
            }
        }
    }

    private void drawXpArrow(Graphics g, Dimension size) {
        switch (this.direction) {
            case 1: {
                g.drawLine(8, 5, 8, 5);
                g.drawLine(7, 6, 9, 6);
                g.drawLine(6, 7, 10, 7);
                g.drawLine(5, 8, 7, 8);
                g.drawLine(9, 8, 11, 8);
                g.drawLine(4, 9, 6, 9);
                g.drawLine(10, 9, 12, 9);
                g.drawLine(5, 10, 5, 10);
                g.drawLine(11, 10, 11, 10);
                break;
            }
            case 5: {
                g.drawLine(5, 6, 5, 6);
                g.drawLine(11, 6, 11, 6);
                g.drawLine(4, 7, 6, 7);
                g.drawLine(10, 7, 12, 7);
                g.drawLine(5, 8, 7, 8);
                g.drawLine(9, 8, 11, 8);
                g.drawLine(6, 9, 10, 9);
                g.drawLine(7, 10, 9, 10);
                g.drawLine(8, 11, 8, 11);
                break;
            }
            case 3: {
                g.drawLine(6, 5, 6, 5);
                g.drawLine(6, 11, 6, 11);
                g.drawLine(7, 4, 7, 6);
                g.drawLine(7, 10, 7, 12);
                g.drawLine(8, 5, 8, 7);
                g.drawLine(8, 9, 8, 11);
                g.drawLine(9, 6, 9, 10);
                g.drawLine(10, 7, 10, 9);
                g.drawLine(11, 8, 11, 8);
                break;
            }
            case 7: {
                g.drawLine(4, 8, 4, 8);
                g.drawLine(5, 7, 5, 9);
                g.drawLine(6, 6, 6, 10);
                g.drawLine(7, 5, 7, 7);
                g.drawLine(7, 9, 7, 11);
                g.drawLine(8, 4, 8, 6);
                g.drawLine(8, 10, 8, 12);
                g.drawLine(9, 5, 9, 5);
                g.drawLine(9, 11, 9, 11);
            }
        }
    }

    public Dimension getPreferredSize() {
        return size[Theme.derivedStyle[Theme.style]];
    }

    static class ScrollButtonKey {
        private boolean vertical;
        private Color c;
        private boolean pressed;
        private boolean enabled;
        private boolean rollover;

        ScrollButtonKey(boolean vertical, Color c, boolean pressed, boolean enabled, boolean rollover) {
            this.vertical = vertical;
            this.c = c;
            this.pressed = pressed;
            this.enabled = enabled;
            this.rollover = rollover;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ScrollButtonKey)) {
                return false;
            }
            ScrollButtonKey other = (ScrollButtonKey)o;
            return this.vertical == other.vertical && this.pressed == other.pressed && this.enabled == other.enabled && this.rollover == other.rollover && this.c.equals(other.c);
        }

        public int hashCode() {
            return this.c.hashCode() * (this.pressed ? 1 : 2) * (this.enabled ? 4 : 8) * (this.rollover ? 16 : 32) * (this.vertical ? 64 : 128);
        }
    }
}

