/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.ThreadBarrier;
import junit.framework.Test;
import junit.framework.TestResult;

public class ThreadedTest
implements Test {
    private final Test _test;
    private final ThreadGroup _group;
    private final ThreadBarrier _barrier;

    public ThreadedTest(Test test) {
        this(test, null, new ThreadBarrier(1));
    }

    public ThreadedTest(Test test, ThreadGroup threadGroup, ThreadBarrier threadBarrier) {
        this._test = test;
        this._group = threadGroup;
        this._barrier = threadBarrier;
    }

    public int countTestCases() {
        return this._test.countTestCases();
    }

    public void run(TestResult testResult) {
        Thread thread = new Thread(this._group, new TestRunner(testResult));
        thread.start();
    }

    public String toString() {
        return "ThreadedTest: " + this._test.toString();
    }

    class TestRunner
    implements Runnable {
        private TestResult _result;

        public TestRunner(TestResult testResult) {
            this._result = testResult;
        }

        public void run() {
            ThreadedTest.this._test.run(this._result);
            ThreadedTest.this._barrier.onCompletion(Thread.currentThread());
        }
    }
}

