/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.view;

import conector.eurobits.efactura.desktop.controller.Factura;
import conector.eurobits.efactura.desktop.model.VisualSettings;
import conector.eurobits.efactura.desktop.view.FileNode;
import conector.eurobits.efactura.desktop.view.JPanelPDF;
import conector.eurobits.efactura.desktop.view.MenuBar;
import conector.eurobits.efactura.desktop.view.ToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;

public final class MainScreen {
    private static final Logger loggerConector = Logger.getLogger(MainScreen.class);
    private static final Logger loggerError = Logger.getLogger("Error");
    private static JFrame frame = null;
    private static JTree mTree = null;
    private static FileNode root;
    private JPanel editor = null;
    private static final String IMAGES_PATH;
    private static String ficheroVisualizado;

    public void build() {
        MainScreen main = new MainScreen();
        main.configureUI();
        loggerConector.info("Interfaz principal configurada");
        main.buildInterface();
        loggerConector.info("Interfaz principal creada");
    }

    private void configureUI() {
        try {
            UIManager.setLookAndFeel("de.muntjak.tinylookandfeel.TinyLookAndFeel");
        }
        catch (Exception e) {
            loggerError.error("No se puede cambiar el look & feel " + e);
        }
    }

    private void buildInterface() {
        try {
            frame = new JFrame();
            frame.setJMenuBar(this.buildMenuBar());
            frame.setContentPane(this.buildContentPane());
            frame.setSize(VisualSettings.getVisualSettings().getWindowSize());
            this.locateOnScreen(frame);
            frame.setTitle("Conector Sistema eFactura EUROBITS - " + VisualSettings.getSettings().getCIF());
            frame.setIconImage(MainScreen.readImageIcon("Eurobits.PNG").getImage());
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        }
        catch (HeadlessException e) {
            loggerError.info("Sistema no soporta una aplicaci\u00f3n gr\u00e1fica");
            System.exit(-1);
        }
    }

    private void locateOnScreen(Frame frame) {
        Dimension paneSize = frame.getSize();
        Dimension screenSize = frame.getToolkit().getScreenSize();
        frame.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    private JMenuBar buildMenuBar() {
        MenuBar menu = new MenuBar(frame);
        return menu.build();
    }

    private JComponent buildContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new ToolBar().buildToolBar(), "North");
        panel.add(this.buildSplitPane(), "Center");
        panel.add(this.buildStatusBar(), "South");
        return panel;
    }

    public static String getFicheroVisualizado() {
        return ficheroVisualizado;
    }

    private Component buildSplitPane() {
        JSplitPane splitPane = new JSplitPane(1, this.buildSideBar(), this.buildMainPanel());
        MainScreen.expandTree(mTree);
        return splitPane;
    }

    public static void updateTree() {
        root.remove(0);
        root.remove(0);
        MainScreen.crearEstructura(root);
        ((DefaultTreeModel)mTree.getModel()).reload();
        MainScreen.expandTree(mTree);
    }

    public static void setFicheroVisualizado(String ficheroVisualizado) {
        MainScreen.ficheroVisualizado = ficheroVisualizado;
    }

    public static void changeCursor() {
        loggerConector.debug("Cambio en la forma del cursor");
        if (frame.getCursor().getType() == 0) {
            frame.setCursor(new Cursor(3));
        } else {
            frame.setCursor(new Cursor(0));
        }
    }

    public static void changeCursor(int type) {
        try {
            Cursor newCursor = new Cursor(type);
            frame.setCursor(newCursor);
        }
        catch (Exception e) {
            loggerError.error("Error al cambiar el tipo de cursor");
        }
    }

    private Component buildSideBar() {
        mTree = MainScreen.createTreeModel();
        mTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent arg0) {
                FileNode node = (FileNode)mTree.getLastSelectedPathComponent();
                MainScreen.this.editor.removeAll();
                if (node != null && node.isLeaf()) {
                    MainScreen.changeCursor();
                    try {
                        if (node.getPathReal().substring(node.getPathReal().length() - 3).equalsIgnoreCase("pdf")) {
                            loggerConector.debug("PDF");
                            JPanelPDF pdf = new JPanelPDF(node.getPathReal(), 1);
                            MainScreen.this.editor.add(pdf);
                            MainScreen.setFicheroVisualizado(node.getPathReal());
                        } else {
                            MainScreen.setFicheroVisualizado("");
                            loggerConector.debug("HTML/XML");
                            if (node.toString().endsWith("txt")) {
                                loggerConector.debug("HTML");
                                JTextPane jtex = new JTextPane();
                                MainScreen.this.editor.add(jtex);
                                jtex.setContentType("text/html");
                                BufferedReader br = new BufferedReader(new FileReader(node.getPathReal()));
                                String cadena = br.readLine();
                                String texto = "";
                                while (cadena != null) {
                                    texto = texto + cadena + "<br>";
                                    cadena = br.readLine();
                                }
                                br.close();
                                jtex.setText(texto);
                                jtex.setEnabled(false);
                                jtex.repaint();
                                jtex.setCaretPosition(0);
                            } else {
                                loggerConector.debug("XML");
                                MainScreen.this.crearZonaXML(node.getPathReal());
                            }
                        }
                    }
                    catch (IOException e1) {
                        loggerError.error("No se puede leer el fichero " + node.getPathReal());
                    }
                    catch (SecurityException e1) {
                        loggerError.error("No esta permitido leer el fichero " + node.getPathReal());
                    }
                    catch (Exception e) {
                        loggerError.error("Error Generico en la visualizacion");
                    }
                    MainScreen.changeCursor();
                }
                MainScreen.this.editor.validate();
                MainScreen.this.editor.repaint();
                frame.validate();
                frame.repaint();
            }
        });
        return this.createStrippedScrollPane(mTree);
    }

    private void crearZonaXML(String xmlPath) {
        block5: {
            try {
                if (xmlPath != null && xmlPath.trim().length() != 0) {
                    JTextPane textXML = new JTextPane();
                    try {
                        textXML.setText(new Factura(xmlPath).procesarFichero());
                        textXML.setEnabled(false);
                        textXML.setCaretPosition(0);
                    }
                    catch (NullPointerException e) {
                        loggerError.error("Error en la lectura del XML");
                    }
                    this.editor.add(textXML);
                    break block5;
                }
                loggerError.error("Error en la lectura del fichero XML");
                JOptionPane.showMessageDialog(null, "Error en la lectura del fichero XML", "Error en el fichero XML", 0);
            }
            catch (Exception e) {
                loggerConector.error("Error fatal al interpretar el xml");
                JOptionPane.showMessageDialog(null, "Error en el procesado del fichero XML", "Error al procesar el fichero XML", 0);
            }
        }
    }

    private static void expandTree(JTree tree) {
        int rows = 0;
        for (int levels = 0; levels <= 40; ++levels) {
            rows = tree.getRowCount();
            for (int i = 0; i < rows; ++i) {
                tree.expandRow(i);
            }
        }
    }

    private static JTree createTreeModel() {
        root = new FileNode("DataExchange");
        root.setPathReal(VisualSettings.getSettings().getData());
        JTree tree = new JTree(root);
        tree.getSelectionModel().setSelectionMode(1);
        MainScreen.crearEstructura(root);
        loggerConector.debug("Creado Tree de la interfaz");
        return tree;
    }

    private static void crearEstructura(FileNode root) {
        FileNode inOut = new FileNode("Received");
        inOut.setPathReal(VisualSettings.getSettings().getReceived());
        root.add(inOut);
        FileNode invoice = new FileNode("Invoices");
        invoice.setPathReal(VisualSettings.getSettings().getInvoiceReceived());
        inOut.add(invoice);
        FileNode folder = new FileNode("Pending");
        folder.setPathReal(VisualSettings.getSettings().getPendingReceived());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getPendingReceived())));
        folder = new FileNode("Processed");
        folder.setPathReal(VisualSettings.getSettings().getProcessedReceived());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getProcessedReceived())));
        folder = new FileNode("Signed");
        folder.setPathReal(VisualSettings.getSettings().getSignedReceived());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getSignedReceived())));
        folder = new FileNode("PDF");
        folder.setPathReal(VisualSettings.getSettings().getPDFReceived());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getPDFReceived())));
        folder = new FileNode("Recovery");
        folder.setPathReal(VisualSettings.getSettings().getRecoveryReceived());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getRecoveryReceived())));
        invoice = new FileNode("Status");
        invoice.setPathReal(VisualSettings.getSettings().getStatusReceived());
        inOut.add(invoice);
        folder = new FileNode("Pending");
        folder.setPathReal(VisualSettings.getSettings().getStatusPendingReceived());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getStatusPendingReceived())));
        folder = new FileNode("Processed");
        folder.setPathReal(VisualSettings.getSettings().getStatusProcessedReceived());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getStatusProcessedReceived())));
        inOut = new FileNode("Sent");
        inOut.setPathReal(VisualSettings.getSettings().getSent());
        root.add(inOut);
        invoice = new FileNode("Invoices");
        invoice.setPathReal(VisualSettings.getSettings().getInvoiceSent());
        inOut.add(invoice);
        folder = new FileNode("Pending");
        folder.setPathReal(VisualSettings.getSettings().getPendingSent());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getPendingSent())));
        folder = new FileNode("Processed");
        folder.setPathReal(VisualSettings.getSettings().getProcessedSent());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getProcessedSent())));
        folder = new FileNode("Signed");
        folder.setPathReal(VisualSettings.getSettings().getSignedSent());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getSignedSent())));
        folder = new FileNode("PDF");
        folder.setPathReal(VisualSettings.getSettings().getPDFSent());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getPDFSent())));
        folder = new FileNode("Recovery");
        folder.setPathReal(VisualSettings.getSettings().getRecoverySent());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getRecoverySent())));
        invoice = new FileNode("Status");
        invoice.setPathReal(VisualSettings.getSettings().getStatusSent());
        inOut.add(invoice);
        folder = new FileNode("Pending");
        folder.setPathReal(VisualSettings.getSettings().getStatusPendingSent());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getStatusPendingSent())));
        folder = new FileNode("Processed");
        folder.setPathReal(VisualSettings.getSettings().getStatusProcessedSent());
        invoice.add(MainScreen.importFiles(folder, VisualSettings.getSettings().getFolder(VisualSettings.getSettings().getStatusProcessedSent())));
    }

    private static FileNode importFiles(FileNode node, File path) {
        String[] fich = path.list();
        File fichero = null;
        FileNode nodoHijo = null;
        for (int i = 0; fich != null && i < fich.length; ++i) {
            fichero = new File(node.getPathReal() + File.separator + fich[i]);
            if (fichero.isFile()) {
                if (fichero.isHidden()) continue;
                nodoHijo = new FileNode(fich[i]);
                nodoHijo.setPathReal(node.getPathReal() + File.separator + fich[i]);
                node.add(nodoHijo);
                continue;
            }
            nodoHijo = new FileNode(fich[i]);
            nodoHijo.setPathReal(node.getPathReal() + File.separator + fich[i]);
            node.add(MainScreen.importFiles(nodoHijo, fichero));
        }
        return node;
    }

    private Component buildMainPanel() {
        this.editor = new JPanel();
        loggerConector.debug("Creada parte visual");
        return this.createStrippedScrollPane(this.editor);
    }

    private Component buildStatusBar() {
        JPanel statusBar = new JPanel(new BorderLayout());
        statusBar.add(this.createCenteredLabel(""));
        return statusBar;
    }

    public void actionPerformed(ActionEvent e) {
    }

    private JScrollPane createStrippedScrollPane(Component c) {
        JScrollPane scrollPane = new JScrollPane(c);
        scrollPane.setBorder(null);
        return scrollPane;
    }

    private Component createCenteredLabel(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(0);
        label.setBorder(new EmptyBorder(3, 3, 3, 3));
        return label;
    }

    public static ImageIcon readImageIcon(String filename) {
        URL url = MainScreen.getResource("images/" + filename);
        return new ImageIcon(url);
    }

    protected static URL getResource(String filename) {
        URL url = MenuBar.class.getResource("resources/" + filename);
        return url;
    }

    public static String getIMAGES_PATH() {
        return IMAGES_PATH;
    }

    static {
        IMAGES_PATH = "conector" + File.separator + "eurobits" + File.separator + "efactura" + File.separator + "desktop" + File.separator + "view" + File.separator + "resources" + File.separator + "images";
        ficheroVisualizado = "";
    }
}

