/*
 * Decompiled with CFR 0.152.
 */
package conector.eurobits.efactura.desktop.model;

import conector.eurobits.efactura.desktop.controller.Constantes;
import conector.eurobits.efactura.desktop.controller.OperacionesWS;
import conector.eurobits.efactura.desktop.controller.PDFPrint;
import conector.eurobits.efactura.desktop.model.VisualSettings;
import conector.eurobits.efactura.desktop.view.ControlPanel;
import conector.eurobits.efactura.desktop.view.MainScreen;
import conector.eurobits.efactura.desktop.view.NombresMenus;
import conector.eurobits.efactura.desktop.view.ParametrosForm;
import conector.eurobits.efactura.desktop.view.RecuperarFacturasTramitadas;
import conector.eurobits.efactura.desktop.view.VentanaInformacion;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class GestorEventos
extends Thread
implements ActionListener,
NombresMenus {
    private static final Logger loggerConector = Logger.getLogger(GestorEventos.class);
    private static final Logger loggerError = Logger.getLogger("Error");
    private String operacion = "";
    private static boolean enMenu = false;
    private static JFrame frame;

    public GestorEventos() {
    }

    public GestorEventos(String o) {
        this.operacion = o;
    }

    public GestorEventos(JFrame frame) {
        GestorEventos.frame = frame;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae != null && ae.toString() != null && ae.toString().trim().length() > 0) {
            if (ae.getActionCommand().equals("Salir")) {
                loggerConector.info("Fin de la aplicaci\u00f3n");
                System.exit(0);
            } else if (ae.getActionCommand().equals("Acerca de")) {
                JOptionPane.showMessageDialog(null, "Conector Sistema eFactura EUROBITS v" + VisualSettings.getSettings().getVersion() + "\n Sistema eFactura Eurobits", "Acerca de...", 1);
            } else if (ae.getActionCommand().equals("Imprimir")) {
                if (!MainScreen.getFicheroVisualizado().equalsIgnoreCase("")) {
                    loggerConector.info("Imprimiendo factura " + MainScreen.getFicheroVisualizado());
                    String file_name = MainScreen.getFicheroVisualizado();
                    String printerName = PrinterJob.lookupPrintServices()[0].getName();
                    loggerConector.debug("File :" + file_name);
                    loggerConector.debug("Printer :" + printerName);
                    PDFPrint images1 = new PDFPrint(file_name);
                    images1.printPages();
                    System.out.println("End " + PrinterJob.lookupPrintServices()[0].getName());
                }
            } else if (ae.getActionCommand().equals("Actualizar")) {
                MainScreen.updateTree();
            } else if (ae.getActionCommand().equals("Par\u00e1metros") && !enMenu) {
                loggerConector.info("Inicio Configuracion");
                ParametrosForm conf = new ParametrosForm(frame);
                conf.setIconImage(MainScreen.readImageIcon("Eurobits.PNG").getImage());
                conf.show();
                loggerConector.info("Fin Configuracion");
            } else if (ae.getActionCommand().equals("Personalizar Interfaz") && !enMenu) {
                ControlPanel.main(null);
            }
            if (!enMenu) {
                GestorEventos ges = new GestorEventos(ae.getActionCommand());
                ges.start();
            } else {
                loggerError.error("Operacion no disponible en este momento");
                JOptionPane.showMessageDialog(null, "Operacion no disponible en este momento . " + ae.getActionCommand() + " en curso", "No disponible", 0);
            }
        }
    }

    private void visualizaError(String modoDeEjecucion, String titulo, String error, int retardo) {
        if (modoDeEjecucion.equals(Constantes.MODO_GRAFICO)) {
            new VentanaInformacion(titulo, error, retardo);
        }
    }

    public void run() {
        enMenu = true;
        try {
            MainScreen.changeCursor(3);
            if (this.operacion.equals("Tramitar emisi\u00f3n y recepci\u00f3n de facturas")) {
                loggerConector.info("Inicio de Emisi\u00f3n y recepeci\u00f3n de facturas");
                if (!OperacionesWS.getInstance().enviarFacturas(Constantes.MODO_GRAFICO)) {
                    loggerError.error("Problemas en el proceso de env\u00edo de facturas, verificar el Log.");
                    this.visualizaError(Constantes.MODO_GRAFICO, "Error", "Problemas en el proceso de env\u00edo de facturas, verificar el Log.\n", 0);
                }
                if (!OperacionesWS.getInstance().recibirFacturas(Constantes.MODO_GRAFICO)) {
                    loggerError.error("Problemas en el proceso de recepeci\u00f3n de facturas, verificar el Log.");
                    this.visualizaError(Constantes.MODO_GRAFICO, "Error", "Problemas en el proceso de recepeci\u00f3n de facturas, verificar el Log.\n", 0);
                }
                loggerConector.info("Fin de Emisi\u00f3n y recepeci\u00f3n de facturas");
            } else if (this.operacion.equals("Tramitar emisi\u00f3n de facturas")) {
                loggerConector.info("Inicio de Tramitar emisi\u00f3n de facturas");
                if (!OperacionesWS.getInstance().enviarFacturas(Constantes.MODO_GRAFICO)) {
                    loggerError.error("Problemas en el proceso de env\u00edo de facturas, verificar el Log.");
                    this.visualizaError(Constantes.MODO_GRAFICO, "Error", "Problemas en el proceso de envio de facturas, verificar el Log.\n", 0);
                }
                loggerConector.info("Fin de Tramitar emisi\u00f3n de facturas");
            } else if (this.operacion.equals("Tramitar recepci\u00f3n de facturas")) {
                loggerConector.info("Inicio de Tramitar recepci\u00f3n de facturas");
                OperacionesWS.getInstance().recibirFacturas(Constantes.MODO_GRAFICO);
                loggerConector.info("Fin de Tramitar recepci\u00f3n de facturas");
            } else if (this.operacion.equals("Recuperar facturas ya tramitadas")) {
                loggerConector.info("Inicio de Recuperar facturas");
                new RecuperarFacturasTramitadas();
                loggerConector.info("Fin de Recuperar facturas");
            }
            MainScreen.changeCursor(0);
        }
        catch (Throwable t) {
            loggerError.error("Error irrecuperable en al realizar, " + this.operacion);
            JOptionPane.showMessageDialog(null, "Error irrecuperable en al realizar, " + this.operacion, "Error Cr\u00edtico", 0);
            loggerConector.error("Error al solicitar una operaci\u00f3n:" + t.getMessage());
            loggerConector.debug(t.getStackTrace());
            loggerConector.error(t.getCause().getMessage());
            loggerConector.debug(t.getCause().getStackTrace());
            MainScreen.changeCursor(0);
            enMenu = false;
        }
        enMenu = false;
        MainScreen.changeCursor(0);
    }
}

