/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.io.PdfReader;
import org.jpedal.objects.raw.PdfObject;

public class PdfKeyPairsIterator {
    private byte[][] keys;
    private byte[][] values;
    private PdfObject[] objs;
    int maxCount;
    int current = 0;

    public PdfKeyPairsIterator(byte[][] byArray, byte[][] byArray2, PdfObject[] pdfObjectArray) {
        this.keys = byArray;
        this.values = byArray2;
        this.objs = pdfObjectArray;
        if (byArray != null) {
            this.maxCount = byArray.length;
        }
        this.current = 0;
    }

    public int getTokenCount() {
        return this.maxCount;
    }

    public void nextPair() {
        if (this.current < this.maxCount) {
            ++this.current;
        } else {
            throw new RuntimeException("No keys left in PdfKeyPairsIterator");
        }
    }

    public String getNextKeyAsString() {
        return new String(this.keys[this.current]);
    }

    public int getNextKeyAsNumber() {
        int n = this.keys[this.current].length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            byte by = this.keys[this.current][i];
            if (by >= 48 && by <= 57) continue;
            bl = true;
            i = n;
        }
        if (bl) {
            if (this.keys[this.current].length == 1) {
                return this.keys[this.current][0] & 0xFF;
            }
        } else {
            return PdfReader.parseInt(0, n, this.keys[this.current]);
        }
        System.out.println("Unexpected value in getNextKeyAsNumber >" + new String(this.keys[this.current]) + "<");
        System.exit(1);
        return -1;
    }

    public boolean hasMorePairs() {
        return this.current < this.maxCount;
    }

    public String getNextValueAsString() {
        return new String(this.values[this.current]);
    }

    public PdfObject getNextValueAsDictionary() {
        return this.objs[this.current];
    }
}

