/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.decoding;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.acroforms.decoding.FormStream;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class AnnotStream
extends FormStream {
    protected AnnotStream() {
    }

    public AnnotStream(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        this.type = 1;
        this.init();
    }

    protected void parseStream(FormObject formObject) {
        block80: {
            Object object;
            block86: {
                block85: {
                    block84: {
                        block83: {
                            block82: {
                                block81: {
                                    block79: {
                                        formObject.setBorder(null);
                                        this.currentField.remove("P");
                                        object = this.currentPdfFile.resolveToMapOrString("Subtype", this.currentField.get("Subtype"));
                                        if (object == null) {
                                            return;
                                        }
                                        if (!((String)object).startsWith("/")) {
                                            object = "/" + object;
                                        }
                                        if (!object.equals("/Text")) break block79;
                                        formObject.setCharacteristic(4);
                                        formObject.setCharacteristic(5);
                                        formObject.setType(11);
                                        this.createOrderedCommandArray();
                                        for (int i = 0; i < this.commands.length; ++i) {
                                            boolean bl;
                                            Object object2 = this.commands[i];
                                            Object object3 = this.currentPdfFile.resolveToMapOrString(object2, this.currentField.get(object2));
                                            if (object2.equals("Type")) {
                                                if (!object3.equals("/Annot")) continue;
                                                continue;
                                            }
                                            if (object2.equals("Subtype")) continue;
                                            if (object2.equals("Rect")) {
                                                this.createBoundsRectangle((String)object3, formObject);
                                                continue;
                                            }
                                            if (object2.equals("AP")) {
                                                bl = this.commandAP((Map)object3, formObject);
                                                if (bl) continue;
                                            }
                                            if (object2.equals("C")) {
                                                bl = this.commandC(formObject, object3);
                                                if (bl) continue;
                                            }
                                            if (object2.equals("Contents")) {
                                                bl = this.commandContents(formObject, object3);
                                                if (bl) continue;
                                            }
                                            if (object2.equals("Popup")) {
                                                formObject.setActionFlag(1);
                                                formObject.setPopupObj(object3);
                                                continue;
                                            }
                                            if (object2.equals("Open")) {
                                                formObject.setOpenState(Boolean.valueOf((String)object3));
                                                continue;
                                            }
                                            if (object2.equals("Name") || object2.equals("M") || object2.equals("CreationDate")) continue;
                                            if (object2.equals("RC")) {
                                                this.commandRC(object3, formObject);
                                                continue;
                                            }
                                            if (object2.equals("F")) {
                                                this.workOutCharachteristic((String)object3, formObject);
                                                continue;
                                            }
                                            if (object2.equals("T")) {
                                                formObject.setPopupTitle((String)object3);
                                                continue;
                                            }
                                            if (object2.equals("NM")) {
                                                this.commandNM(formObject, object3);
                                                continue;
                                            }
                                            if (object2.equals("Subj")) continue;
                                            if (object2.equals("PageNumber")) {
                                                formObject.setPageNumber(object3);
                                                continue;
                                            }
                                            if (!object2.equals("BS")) continue;
                                            formObject.setBorder(object3);
                                        }
                                        break block80;
                                    }
                                    if (object.equals("/Popup")) break block80;
                                    if (!object.equals("/Ink")) break block81;
                                    formObject.setType(13);
                                    this.createOrderedCommandArray();
                                    for (int i = 0; i < this.commands.length; ++i) {
                                        boolean bl;
                                        Object object4 = this.commands[i];
                                        Object object5 = this.currentPdfFile.resolveToMapOrString(object4, this.currentField.get(object4));
                                        if (object4.equals("Type")) {
                                            if (!object5.equals("/Annot")) continue;
                                            continue;
                                        }
                                        if (object4.equals("Subtype")) continue;
                                        if (object4.equals("Rect")) {
                                            this.createBoundsRectangle((String)object5, formObject);
                                            continue;
                                        }
                                        if (object4.equals("AP")) {
                                            if (!formObject.hasNormalOff() && (bl = this.commandAP((Map)object5, formObject))) continue;
                                        }
                                        if (object4.equals("C")) {
                                            bl = this.commandC(formObject, object5);
                                            if (bl) continue;
                                        }
                                        if (object4.equals("F")) {
                                            this.workOutCharachteristic((String)object5, formObject);
                                            continue;
                                        }
                                        if (object4.equals("T")) {
                                            formObject.setPopupTitle((String)object5);
                                            continue;
                                        }
                                        if (object4.equals("M") || object4.equals("CreationDate")) continue;
                                        if (object4.equals("NM")) {
                                            this.commandNM(formObject, object5);
                                            continue;
                                        }
                                        if (object4.equals("Subj")) continue;
                                        if (object4.equals("PageNumber")) {
                                            formObject.setPageNumber(object5);
                                            continue;
                                        }
                                        if (object4.equals("InkList")) {
                                            if (this.currentField.containsKey("AP")) {
                                                this.commandAP((Map)this.currentPdfFile.resolveToMapOrString("AP", this.currentField.get("AP")), formObject);
                                            }
                                            if (formObject.hasNormalOff()) continue;
                                            this.commandInkList(object5, formObject);
                                            continue;
                                        }
                                        if (!object4.equals("Popup")) continue;
                                        formObject.setActionFlag(1);
                                        formObject.setPopupObj(object5);
                                    }
                                    break block80;
                                }
                                if (!object.equals("/Square")) break block82;
                                formObject.setType(12);
                                this.createOrderedCommandArray();
                                for (int i = 0; i < this.commands.length; ++i) {
                                    boolean bl;
                                    Object object6 = this.commands[i];
                                    Object object7 = this.currentPdfFile.resolveToMapOrString(object6, this.currentField.get(object6));
                                    if (object6.equals("Type")) {
                                        if (!object7.equals("/Annot")) continue;
                                        continue;
                                    }
                                    if (object6.equals("Subtype")) continue;
                                    if (object6.equals("Rect")) {
                                        this.createBoundsRectangle((String)object7, formObject);
                                        continue;
                                    }
                                    if (object6.equals("AP")) {
                                        bl = this.commandAP((Map)object7, formObject);
                                        if (bl) continue;
                                    }
                                    if (object6.equals("C")) {
                                        bl = this.commandC(formObject, object7);
                                        if (bl) continue;
                                    }
                                    if (object6.equals("F")) {
                                        this.workOutCharachteristic((String)object7, formObject);
                                        continue;
                                    }
                                    if (object6.equals("T")) {
                                        formObject.setPopupTitle((String)object7);
                                        continue;
                                    }
                                    if (object6.equals("M") || object6.equals("CreationDate")) continue;
                                    if (object6.equals("NM")) {
                                        this.commandNM(formObject, object7);
                                        continue;
                                    }
                                    if (object6.equals("Subj")) continue;
                                    if (object6.equals("PageNumber")) {
                                        formObject.setPageNumber(object7);
                                        continue;
                                    }
                                    if (object6.equals("Popup")) {
                                        formObject.setActionFlag(1);
                                        formObject.setPopupObj(object7);
                                        continue;
                                    }
                                    if (object6.equals("RD")) {
                                        this.commandRD(object7, formObject);
                                        continue;
                                    }
                                    if (object6.equals("Contents") && object7 != null && object7.equals("")) continue;
                                }
                                break block80;
                            }
                            if (!object.equals("/FreeText")) break block83;
                            formObject.setType(14);
                            this.createOrderedCommandArray();
                            for (int i = 0; i < this.commands.length; ++i) {
                                Object object8 = this.commands[i];
                                Object object9 = this.currentPdfFile.resolveToMapOrString(object8, this.currentField.get(object8));
                                if (object8.equals("Type")) {
                                    if (!object9.equals("/Annot")) continue;
                                    continue;
                                }
                                if (object8.equals("Subtype")) continue;
                                if (object8.equals("Rect")) {
                                    this.createBoundsRectangle((String)object9, formObject);
                                    continue;
                                }
                                if (object8.equals("AP")) {
                                    boolean bl = this.commandAP((Map)object9, formObject);
                                    if (bl) continue;
                                }
                                if (object8.equals("C")) {
                                    boolean bl = this.commandC(formObject, object9);
                                    if (bl) continue;
                                }
                                if (object8.equals("F")) {
                                    this.workOutCharachteristic((String)object9, formObject);
                                    continue;
                                }
                                if (object8.equals("T")) {
                                    formObject.setPopupTitle((String)object9);
                                    continue;
                                }
                                if (object8.equals("M") || object8.equals("CreationDate")) continue;
                                if (object8.equals("NM")) {
                                    this.commandNM(formObject, object9);
                                    continue;
                                }
                                if (object8.equals("Subj")) continue;
                                if (object8.equals("PageNumber")) {
                                    formObject.setPageNumber(object9);
                                    continue;
                                }
                                if (object8.equals("DS")) continue;
                                if (object8.equals("Contents")) {
                                    boolean bl = this.commandContents(formObject, object9);
                                    if (bl) continue;
                                }
                                if (object8.equals("RC")) {
                                    this.commandRC(object9, formObject);
                                    continue;
                                }
                                if (object8.equals("DA")) {
                                    formObject.setDefaultValue((String)object9);
                                    continue;
                                }
                                if (object8.equals("Open")) {
                                    formObject.setOpenState(Boolean.valueOf((String)object9));
                                    continue;
                                }
                                if (object8.equals("BS")) {
                                    formObject.setBorder(object9);
                                    continue;
                                }
                                if (object8.equals("IT") || !object8.equals("RD")) continue;
                                StringTokenizer stringTokenizer = new StringTokenizer((String)object9, "[ ]");
                                int n = new Double(stringTokenizer.nextToken()).intValue();
                                int n2 = new Double(stringTokenizer.nextToken()).intValue();
                                int n3 = new Double(stringTokenizer.nextToken()).intValue();
                                int n4 = new Double(stringTokenizer.nextToken()).intValue();
                                Rectangle rectangle = formObject.getBoundingRectangle();
                                rectangle.x += n;
                                rectangle.y += n2;
                                rectangle.width += n + n3;
                                rectangle.height += n2 + n4;
                                formObject.setBoundingRectangle(rectangle);
                            }
                            break block80;
                        }
                        if (!object.equals("/Link")) break block84;
                        formObject.setType(15);
                        this.createOrderedCommandArray();
                        for (int i = 0; i < this.commands.length; ++i) {
                            Object object10 = this.commands[i];
                            Object object11 = this.currentPdfFile.resolveToMapOrString(object10, this.currentField.get(object10));
                            if (object10.equals("Type")) {
                                if (object11.equals("/Annot") || !object11.equals("/Action")) continue;
                                continue;
                            }
                            if (object10.equals("Subtype")) continue;
                            if (object10.equals("Rect")) {
                                this.createBoundsRectangle((String)object11, formObject);
                                continue;
                            }
                            if (object10.equals("PageNumber")) {
                                formObject.setPageNumber(object11);
                                continue;
                            }
                            if (object10.equals("StructParent")) continue;
                            if (object10.equals("A")) {
                                this.commandA(object11, formObject);
                                continue;
                            }
                            if (object10.equals("H")) {
                                this.commandH(object11, formObject);
                                continue;
                            }
                            if (object10.equals("Border")) {
                                this.commandBorder(object11);
                                continue;
                            }
                            if (object10.equals("BS")) {
                                formObject.setBorder(object11);
                                continue;
                            }
                            if (object10.equals("C")) {
                                this.commandC(formObject, object11);
                                continue;
                            }
                            if (object10.equals("Dest") && object11 != null) {
                                HashMap hashMap = new HashMap();
                                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                                if (object11 instanceof Map) {
                                    object11 = ((Map)object11).get("D");
                                }
                                StringTokenizer stringTokenizer = new StringTokenizer((String)object11, "[ ]", true);
                                StringBuffer stringBuffer = new StringBuffer(5);
                                Rectangle rectangle = null;
                                int n = 0;
                                while (stringTokenizer.hasMoreTokens()) {
                                    String string = stringTokenizer.nextToken();
                                    if (string.equals("[") || string.equals("]")) continue;
                                    if (string.equals(" ")) {
                                        if (++n >= 3) continue;
                                        stringBuffer.append(string);
                                        continue;
                                    }
                                    if (n < 3) {
                                        stringBuffer.append(string);
                                        continue;
                                    }
                                    if (!string.equals("/XYZ")) continue;
                                    float f = 0.0f;
                                    float f2 = 0.0f;
                                    String string2 = " ";
                                    String string3 = " ";
                                    while (string2.equals(" ")) {
                                        string2 = stringTokenizer.nextToken();
                                    }
                                    while (string3.equals(" ")) {
                                        string3 = stringTokenizer.nextToken();
                                    }
                                    if (!string2.equals("null")) {
                                        f = Float.parseFloat(string2);
                                    }
                                    if (!string3.equals("null")) {
                                        f2 = Float.parseFloat(string3);
                                    }
                                    rectangle = new Rectangle((int)f, (int)f2, 10, 10);
                                }
                                String string = stringBuffer.toString();
                                hashMap2.put("Page", string);
                                hashMap2.put("Position", rectangle);
                                hashMap.put("Dest", hashMap2);
                                formObject.setAaction(hashMap);
                                continue;
                            }
                            if (!object10.equals("M")) continue;
                        }
                        break block80;
                    }
                    if (!object.equals("/Widget")) break block85;
                    super.parseStream(formObject);
                    super.decodeStream(formObject);
                    break block80;
                }
                if (!object.equals("/Highlight")) break block86;
                LogWriter.writeFormLog("{AnnotStream.parseStream} Highlight command NOT IMPLEMENTED", false);
                break block80;
            }
            if (!object.equals("/Stamp")) break block80;
            formObject.setType(16);
            this.createOrderedCommandArray();
            for (int i = 0; i < this.commands.length; ++i) {
                Object object12 = this.commands[i];
                Object object13 = this.currentPdfFile.resolveToMapOrString(object12, this.currentField.get(object12));
                if (object12.equals("Type")) {
                    if (!object13.equals("/Annot")) continue;
                    continue;
                }
                if (object12.equals("Subtype")) continue;
                if (object12.equals("Rect")) {
                    this.createBoundsRectangle((String)object13, formObject);
                    continue;
                }
                if (object12.equals("Popup")) {
                    formObject.setActionFlag(1);
                    formObject.setPopupObj(object13);
                    continue;
                }
                if (object12.equals("C")) {
                    this.commandC(formObject, object13);
                    continue;
                }
                if (object12.equals("M")) continue;
                if (object12.equals("F")) {
                    this.workOutCharachteristic((String)object13, formObject);
                    continue;
                }
                if (object12.equals("T")) {
                    formObject.setPopupTitle((String)object13);
                    continue;
                }
                if (object12.equals("Subj") || object12.equals("Name")) continue;
                if (object12.equals("NM")) {
                    this.commandNM(formObject, object13);
                    continue;
                }
                if (object12.equals("CreationDate")) continue;
                if (object12.equals("AP")) {
                    this.commandAP((Map)object13, formObject);
                    continue;
                }
                if (object12.equals("Rotate")) {
                    formObject.setRotation(Integer.parseInt((String)object13));
                    continue;
                }
                if (!object12.equals("BS")) continue;
                formObject.setBorder(object13);
            }
        }
    }

    private void commandBorder(Object object) {
        if (this.currentField.containsKey("BS")) {
            return;
        }
        object = Strip.removeArrayDeleminators((String)object);
        StringTokenizer stringTokenizer = new StringTokenizer((String)object);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        try {
            f = Float.parseFloat(stringTokenizer.nextToken());
            f2 = Float.parseFloat(stringTokenizer.nextToken());
            f3 = Float.parseFloat(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            LogWriter.writeFormLog("Border in annot.parsestream Link NOT numbers", false);
            return;
        }
        if (f3 == 0.0f) {
            return;
        }
        if (f == 0.0f && f2 == 0.0f) {
            LogWriter.writeFormLog("{AnnotStream.commandBorder} squared border NOT IMPLEMENTED", false);
        } else {
            LogWriter.writeFormLog("{AnnotStream.commandBorder} create rounded rectangle border NOT IMPLEMENTED", false);
        }
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().startsWith("[")) {
            LogWriter.writeFormLog("{AnnotStream.commandBorder} dash array NOT IMPLEMENTED", false);
        }
    }

    private void createOrderedCommandArray() {
        Iterator iterator = this.currentField.keySet().iterator();
        this.keySize = this.currentField.keySet().size();
        this.commands = new Object[this.keySize];
        int n = this.keySize - 1;
        int n2 = 0;
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k.equals("AP")) {
                this.commands[n] = k;
                --n;
                continue;
            }
            this.commands[n2] = k;
            ++n2;
        }
    }

    private void commandRC(Object object, FormObject formObject) {
    }

    private boolean commandC(FormObject formObject, Object object) {
        Color color = this.generateColorFromString((String)object);
        if (color != null) {
            formObject.setCColor(color);
            return true;
        }
        return false;
    }

    private boolean commandContents(FormObject formObject, Object object) {
        if (object instanceof String) {
            formObject.setContents((String)object);
            return true;
        }
        LogWriter.writeFormLog("{stream} Contents command is NON String field=" + object, false);
        return false;
    }

    protected void decodeStream(FormObject formObject) {
        for (int i = 0; i < this.keySize; ++i) {
            Object object = this.commands[i];
            Object object2 = this.currentPdfFile.resolveToMapOrString(object, this.currentField.get(object));
            boolean bl = this.decodeFormCommand(object, object2, formObject);
            if (!bl) continue;
            this.decodeAnnotCommand(object, object2, formObject);
        }
    }

    protected boolean decodeAnnotCommand(Object object, Object object2, FormObject formObject) {
        boolean bl = false;
        if (object.equals("InkList")) {
            PdfShape pdfShape = new PdfShape();
            Rectangle rectangle = formObject.getBoundingRectangle();
            String string = Strip.removeArrayDeleminators((String)object2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ", true);
            boolean bl2 = false;
            String string2 = null;
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("[")) {
                    bl2 = true;
                    continue;
                }
                if (string4.equals("]") || string4.equals(" ")) continue;
                if (string2 == null) {
                    string2 = string4;
                    continue;
                }
                string3 = string4;
                if (bl2) {
                    pdfShape.moveTo(Float.parseFloat(string2) - (float)rectangle.x, Float.parseFloat(string3) - (float)rectangle.y);
                    bl2 = false;
                } else {
                    pdfShape.lineTo(Float.parseFloat(string2) - (float)rectangle.x, Float.parseFloat(string3) - (float)rectangle.y);
                }
                string2 = null;
            }
            GraphicsState graphicsState = formObject.getGraphicsState();
            Shape shape = pdfShape.generateShapeFromPath(null, graphicsState.CTM, false, null, false, null, graphicsState.getLineWidth(), 0.0f);
            Stroke stroke = graphicsState.getStroke();
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setStroke(stroke);
            graphics2D.setColor(Color.red);
            graphics2D.scale(1.0, -1.0);
            graphics2D.translate(0, -bufferedImage.getHeight());
            graphics2D.draw(shape);
            graphics2D.dispose();
            formObject.setNormalAppOff(bufferedImage, null);
        } else if (object.equals("RD")) {
            StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators((String)object2));
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            float f4 = Float.parseFloat(stringTokenizer.nextToken());
            formObject.setInternalBounds(f, f2, f3, f4);
        } else {
            bl = true;
        }
        return bl;
    }

    private void commandRD(Object object, FormObject formObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators((String)object));
        float f = Float.parseFloat(stringTokenizer.nextToken());
        float f2 = Float.parseFloat(stringTokenizer.nextToken());
        float f3 = Float.parseFloat(stringTokenizer.nextToken());
        float f4 = Float.parseFloat(stringTokenizer.nextToken());
        formObject.setInternalBounds(f, f2, f3, f4);
    }

    private void commandInkList(Object object, FormObject formObject) {
        PdfShape pdfShape = new PdfShape();
        Rectangle rectangle = formObject.getBoundingRectangle();
        String string = Strip.removeArrayDeleminators((String)object);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ", true);
        int n = 0;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("[")) {
                ++n;
                bl = true;
                continue;
            }
            if (string4.equals("]")) {
                --n;
                continue;
            }
            if (string4.equals(" ")) continue;
            if (string2 == null) {
                string2 = string4;
                continue;
            }
            string3 = string4;
            if (bl) {
                pdfShape.moveTo(Float.parseFloat(string2) - (float)rectangle.x, Float.parseFloat(string3) - (float)rectangle.y);
                bl = false;
            } else {
                pdfShape.lineTo(Float.parseFloat(string2) - (float)rectangle.x, Float.parseFloat(string3) - (float)rectangle.y);
            }
            string2 = null;
        }
        GraphicsState graphicsState = formObject.getGraphicsState();
        Shape shape = pdfShape.generateShapeFromPath(null, graphicsState.CTM, false, null, false, null, graphicsState.getLineWidth(), 0.0f);
        Stroke stroke = graphicsState.getStroke();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setStroke(stroke);
        graphics2D.setColor(Color.red);
        graphics2D.scale(1.0, -1.0);
        graphics2D.translate(0, -bufferedImage.getHeight());
        graphics2D.draw(shape);
        graphics2D.dispose();
        formObject.setNormalAppOff(bufferedImage, null);
    }
}

