/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.PdfPageObject;
import org.jpedal.render.DynamicVectorRenderer;

public final class MultiDisplay
extends SingleDisplay
implements Display {
    private Thread worker = null;
    private Object customSwingHandle = null;
    private int pageUsedForTransform;

    public MultiDisplay(int n, int n2, DynamicVectorRenderer dynamicVectorRenderer, int n3, Object object) {
        super(n, n2, dynamicVectorRenderer);
        this.customSwingHandle = object;
        this.displayView = n3;
        if (dynamicVectorRenderer != null) {
            this.currentPageViews.put(new Integer(n), dynamicVectorRenderer);
        }
    }

    public final void decodeOtherPages(int n, int n2) {
        this.pageNumber = n;
        if (!this.isInitialised) {
            return;
        }
        this.setPageOffsets(n2, this.pageNumber);
        this.calcDisplayedRange();
        if (this.worker == null || !this.running) {
            this.running = true;
            while (this.thumbnailsRunning) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.worker = new Thread(){

                public void run() {
                    try {
                        MultiDisplay.this.decodeOtherPages();
                        MultiDisplay.this.running = false;
                    }
                    catch (Exception exception) {
                        MultiDisplay.this.running = false;
                    }
                    catch (Error error) {
                        MultiDisplay.this.running = false;
                    }
                }
            };
            this.worker.start();
        }
    }

    private void decodeOtherPages() {
        Object object;
        this.isGeneratingOtherPages = true;
        int n = this.startViewPage;
        int n2 = this.startViewPage;
        int n3 = this.endViewPage + 1;
        this.resetPageCaches(this.startViewPage, this.endViewPage + 1);
        while (this.isGeneratingOtherPages) {
            if (n2 != this.startViewPage && n3 != this.endViewPage) {
                n = this.startViewPage;
                n3 = this.endViewPage + 1;
                if (n == 0) {
                    // empty if block
                }
                n2 = ++n;
                this.resetPageCaches(n2, n3);
            }
            if (n == n3) break;
            if (this.currentPageViews.get(new Integer(n)) == null && (object = (String)this.pdf.pagesReferences.get(new Integer(n))) != null) {
                Object object2;
                PdfPageObject pdfPageObject = new PdfPageObject((String)object);
                this.pdf.readObjectForPage(pdfPageObject, (String)object, n, true);
                PdfObject pdfObject = ((PdfObject)pdfPageObject).getDictionary(2004251818);
                Integer n4 = new Integer(n);
                Object v = this.currentPageViews.get(n4);
                if (v == null && this.isGeneratingOtherPages) {
                    object2 = null;
                    object2 = ObjectStore.getCachedPage(n4);
                    if (object2 != null) {
                        ((DynamicVectorRenderer)object2).setObjectStoreRef(this.pdf.objectStoreRef);
                        this.currentPageViews.put(new Integer(n), object2);
                    } else {
                        object2 = new DynamicVectorRenderer(n, this.pdf.objectStoreRef, false);
                        if (this.isGeneratingOtherPages) {
                            this.getPageView(pdfObject, pdfPageObject, (DynamicVectorRenderer)object2, n);
                        }
                        this.currentPageViews.put(new Integer(n), object2);
                        ObjectStore.cachePage(n4, (DynamicVectorRenderer)object2);
                    }
                    if (this.thumbnails != null && this.thumbnails.isShownOnscreen()) {
                        this.thumbnails.addDisplayedPageAsThumbnail(n, (DynamicVectorRenderer)object2);
                    }
                }
                object2 = new Runnable(){

                    public void run() {
                        MultiDisplay.this.pdf.repaint();
                    }
                };
                SwingUtilities.invokeLater((Runnable)object2);
            }
            ++n;
        }
        object = new Runnable(){

            public void run() {
                if (MultiDisplay.this.thumbnails != null && MultiDisplay.this.thumbnails.isShownOnscreen()) {
                    MultiDisplay.this.thumbnails.generateOtherVisibleThumbnails(MultiDisplay.this.pdf.pageNumber);
                }
            }
        };
        SwingUtilities.invokeLater((Runnable)object);
    }

    public final void initRenderer(Rectangle[] rectangleArray, Graphics2D graphics2D, Border border, int n) {
        this.myBorder = border;
        this.rawAf = graphics2D.getTransform();
        this.rawClip = graphics2D.getClip();
        this.areas = null;
        this.g2 = graphics2D;
        this.indent = n;
        this.pagesDrawn.clear();
        this.setPageOffsets(this.pageCount, this.pageNumber);
        this.calcDisplayedRange();
        this.setPageSize(this.pageUsedForTransform, this.scaling);
    }

    private void resetPageCaches(int n, int n2) {
        Serializable serializable;
        Iterator iterator = this.cachedPageViews.keySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            serializable = (Integer)iterator.next();
            int n3 = (Integer)serializable;
            if (n3 < n || n3 > n2 || (v = this.cachedPageViews.get(serializable)) == null) continue;
            this.currentPageViews.put(serializable, v);
        }
        iterator = this.currentPageViews.keySet().iterator();
        serializable = new HashMap();
        while (iterator.hasNext()) {
            Integer n4 = (Integer)iterator.next();
            int n5 = n4;
            if (n5 >= n && n5 <= n2) continue;
            Object v = this.currentPageViews.get(n4);
            if (v != null) {
                this.cachedPageViews.put(n4, v);
            }
            serializable.put(n4, "x");
        }
        iterator = serializable.keySet().iterator();
        while (iterator.hasNext()) {
            this.currentPageViews.remove(iterator.next());
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void calcDisplayedRange() {
        block14: {
            block13: {
                if (this.displayView == 1) {
                    return;
                }
                this.getDisplayedRectangle();
                if (this.displayView != 3) break block13;
                if (this.pageCount == 2) {
                    this.startViewPage = 1;
                    this.endViewPage = 2;
                } else {
                    this.startViewPage = this.pageNumber;
                    if (this.startViewPage == 1) {
                        this.endViewPage = 1;
                    } else if ((this.startViewPage & 1) != 1) {
                        this.startViewPage = this.pageNumber;
                        this.endViewPage = this.pageNumber + 1;
                    } else {
                        this.startViewPage = this.pageNumber - 1;
                        this.endViewPage = this.pageNumber;
                    }
                }
                break block14;
            }
            this.pdf.pageNumber = var1_1 = this.updatePageDisplayed();
            if (var1_1 != -1 && this.customSwingHandle != null) {
                ((GUIFactory)this.customSwingHandle).setPage(var1_1);
            }
            for (var4_2 = 1; var4_2 < this.pageCount + 1; ++var4_2) {
                var2_3 = this.rx < this.xReached[var4_2] + this.pageW[var4_2] && this.rw > this.xReached[var4_2];
                v0 = var3_4 = this.ry < this.yReached[var4_2] + this.pageH[var4_2] && this.rh + this.ry > this.yReached[var4_2];
                if (!var2_3 || !var3_4) continue;
                this.startViewPage = var4_2;
                var4_2 = this.pageCount;
            }
            this.endViewPage = this.pageCount;
            for (var4_2 = this.startViewPage; var4_2 < this.pageCount + 1; ++var4_2) {
                v1 = var2_3 = this.rx < this.xReached[var4_2] + this.pageW[var4_2] && this.rw > this.xReached[var4_2];
                if (this.ry >= this.yReached[var4_2] + this.pageH[var4_2]) ** GOTO lbl-1000
                if (this.rh + this.ry + this.insetH + 10 > this.yReached[var4_2]) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = var3_4 = false;
                }
                if (this.displayView != 4 && this.displayView != 2 && var2_3 || var3_4) continue;
                this.endViewPage = var4_2 - 1;
                var4_2 = this.pageCount;
            }
        }
        if (this.displayView != 3 && this.startViewPage > 1) {
            --this.startViewPage;
        }
    }

    private int updatePageDisplayed() {
        int n;
        block15: {
            block16: {
                n = -1;
                if (this.displayView != 2) break block16;
                for (int i = 1; i < this.pageCount; ++i) {
                    if (this.yReached[i] + this.insetH - this.ry + this.pageH[i] < 0) continue;
                    if (this.ry > this.yReached[i] + this.insetH) {
                        int n2 = this.yReached[i] + this.insetH - this.ry + this.pageH[i];
                        int n3 = this.rh - this.yReached[i + 1];
                        if (n3 > this.pageH[i + 1]) {
                            n3 = this.pageH[i + 1];
                        }
                        n = n2 >= n3 ? i : i + 1;
                    } else {
                        n = i;
                    }
                    break block15;
                }
                break block15;
            }
            if (this.displayView != 4) break block15;
            if (this.yReached[1] + this.insetH - this.ry + this.pageH[1] >= 0) {
                if (this.pageCount > 1) {
                    if (this.ry > this.yReached[1] + this.insetH) {
                        int n4 = this.yReached[1] + this.insetH - this.ry + this.pageH[1];
                        int n5 = this.rh - this.yReached[2];
                        if (n5 > this.pageH[1]) {
                            n5 = this.pageH[1];
                        }
                        n = n4 >= n5 ? 1 : 2;
                    } else {
                        n = 1;
                    }
                } else {
                    n = 1;
                }
            } else {
                for (int i = 2; i < this.pageCount; i += 2) {
                    if (this.yReached[i] + this.insetH - this.ry + this.pageH[i] < 0) continue;
                    if (this.ry > this.yReached[i]) {
                        int n6 = this.yReached[i] + this.insetH - this.ry + this.pageH[i];
                        int n7 = i + 2 >= this.pageCount ? 0 : this.rh - this.yReached[i + 2];
                        if (n7 > this.pageH[i]) {
                            n7 = this.pageH[i];
                        }
                        n = n6 >= n7 ? i : i + 2;
                    } else {
                        n = i;
                    }
                    break;
                }
            }
        }
        return n;
    }

    private void drawOtherPages(AffineTransform affineTransform, AffineTransform affineTransform2, Graphics2D graphics2D, Rectangle rectangle, float f, boolean bl) {
        int n = 1;
        int n2 = this.pageCount;
        n = this.startViewPage;
        n2 = this.endViewPage;
        if (n > n2) {
            return;
        }
        if (this.displayView != 2 && this.pageCount == 2) {
            ++n2;
        }
        AffineTransform affineTransform3 = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        for (int i = n; i < n2 + 1 && i <= this.pageCount; ++i) {
            int n3;
            double d;
            int n4 = this.pageData.getRotation(i);
            if (bl && this.accleratedPagesAlreadyDrawn.get(new Integer(i)) != null) continue;
            DynamicVectorRenderer dynamicVectorRenderer = (DynamicVectorRenderer)this.currentPageViews.get(new Integer(i));
            int n5 = this.pageData.getScaledCropBoxX(i);
            int n6 = this.pageData.getScaledCropBoxY(i);
            double d2 = n5;
            double d3 = n6;
            double d4 = this.pageData.getCropBoxHeight(i);
            if (dynamicVectorRenderer == null) continue;
            graphics2D.setTransform(affineTransform);
            if (!bl) {
                graphics2D.setClip(this.pdf.getVisibleRect());
            }
            graphics2D.setTransform(affineTransform3);
            int n7 = (int)((float)this.xReached[i] / f);
            int n8 = (int)((float)this.yReached[i] / f);
            graphics2D.translate(n7 - n5, -n6 - n8);
            int n9 = 0;
            int n10 = 0;
            if (this.displayView == 2) {
                n9 = n4 == 0 || n4 == 180 ? (int)(((float)this.currentOffset.widestPageNR - (float)this.pageW[i] / f) / 2.0f) : (int)(((float)this.currentOffset.widestPageR - (float)this.pageW[i] / f) / 2.0f);
            }
            if (n4 == this.pageData.getRotation(this.pageUsedForTransform)) {
                if (this.displayRotation == 0 || this.displayRotation == 180) {
                    graphics2D.translate(0.0, (float)(this.pageH[this.pageUsedForTransform] - this.pageH[i]) / f);
                } else {
                    graphics2D.translate(0.0, (float)(-(this.pageH[this.pageUsedForTransform] - this.pageH[i])) / f);
                }
            }
            if ((n4 += this.displayRotation) >= 360) {
                n4 -= 360;
            }
            if (n4 == 180) {
                AffineTransform affineTransform4 = graphics2D.getTransform();
                double d5 = affineTransform4.getTranslateX() / (double)f;
                d = affineTransform4.getTranslateY() / (double)f;
                graphics2D.translate(-d5, -d);
                graphics2D.rotate(Math.PI);
                graphics2D.translate(-d5 - (double)((float)this.pageW[i] / f) - (double)n9, (double)(-((float)this.pageH[i] / f)) - d);
                graphics2D.translate(-(2 * n5), -(2 * n6));
            } else if (n4 == 270) {
                AffineTransform affineTransform5 = graphics2D.getTransform();
                double d6 = affineTransform5.getTranslateX() / (double)f;
                d = affineTransform5.getTranslateY() / (double)f;
                graphics2D.translate(-d6, d);
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(-d, -d6 - (double)((float)this.pageW[i] / f));
                int n11 = (int)((float)(this.pageW[i] - this.pageH[i]) / (f * 2.0f));
                graphics2D.translate(n11 * 2 + n10, n9);
                graphics2D.translate(0, -(2 * n5));
                int n12 = this.pageData.getScaledCropBoxY(this.pageUsedForTransform);
                graphics2D.translate(0, -(2 * n12));
            } else if (n4 == 90) {
                AffineTransform affineTransform6 = graphics2D.getTransform();
                double d7 = affineTransform6.getTranslateX() / (double)f;
                d = affineTransform6.getTranslateY() / (double)f;
                graphics2D.translate(-d7, d);
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.translate(d - (double)((float)this.pageW[i] / f), d7);
                graphics2D.translate(n10, n9);
                graphics2D.translate(-(2 * n6), 0);
            } else {
                graphics2D.translate(n9, n10);
            }
            dynamicVectorRenderer.setScalingValues(d2, d4 + d3, f);
            int n13 = (int)((float)this.pageW[i] / f);
            int n14 = (int)((float)this.pageH[i] / f);
            if (n4 == 90 || n4 == 270) {
                n3 = n13;
                n13 = n14;
                n14 = n3;
            }
            if (n4 == 90 || n4 == 270) {
                n3 = n5;
                n5 = n6;
                n6 = n3;
            }
            graphics2D.clip(new Rectangle(n5, n6, n13, n14));
            dynamicVectorRenderer.paint(graphics2D, this.areas, affineTransform2, rectangle, false, true);
            this.pagesDrawn.put(new Integer(i), "x");
            if (bl) {
                this.accleratedPagesAlreadyDrawn.put(new Integer(i), "x");
            }
            graphics2D.setTransform(affineTransform3);
            graphics2D.setClip(shape);
        }
    }

    public final void drawBorder() {
        int n = this.startViewPage;
        int n2 = this.endViewPage;
        if (n == 0) {
            return;
        }
        if (this.displayView == 2 || this.displayView == 4) {
            n = 1;
            n2 = this.pageCount;
        }
        if (this.rawAf != null) {
            this.g2.setTransform(this.rawAf);
        }
        this.g2.setClip(this.rawClip);
        if (this.displayView != 3 && n > 1) {
            --n;
            if (this.pageCount == 2) {
                ++n2;
            }
        }
        int n3 = 1;
        if (this.displayView != 2 && n3 & true) {
            --n3;
        }
        this.g2.translate(-this.xReached[n3] + this.insetW, -this.yReached[n3] + this.insetH);
        for (int i = n; i < n2 + 1 && i != this.xReached.length; ++i) {
            AffineTransform affineTransform = null;
            if (this.displayView == 2) {
                affineTransform = this.g2.getTransform();
                int n4 = 0;
                n4 = this.displayRotation == 0 || this.displayRotation == 180 ? (int)(((float)this.currentOffset.widestPageNR * this.scaling - (float)this.pageW[i]) / 2.0f) : (int)(((float)this.currentOffset.widestPageR * this.scaling - (float)this.pageW[i]) / 2.0f);
                this.g2.translate(n4, 0);
            } else if ((this.displayView == 4 || this.displayView == 3) && this.pageCount > 1) {
                affineTransform = this.g2.getTransform();
            }
            if (this.pagesDrawn.get(new Integer(i)) == null && this.accleratedPagesAlreadyDrawn.get(new Integer(i)) == null) {
                try {
                    this.g2.setColor(Color.white);
                    this.g2.fillRect(this.xReached[i], this.yReached[i], this.pageW[i], this.pageH[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.accleratedPagesAlreadyDrawn.get(new Integer(i)) == null) {
                // empty if block
            }
            if (PdfDecoder.CURRENT_BORDER_STYLE == 1 && this.pageW[i] > 0 && this.pageH[i] > 0 && this.myBorder != null) {
                this.myBorder.paintBorder(this.pdf, this.g2, this.xReached[i] - 1, this.yReached[i] - 1, this.pageW[i] + 2, this.pageH[i] + 2);
            }
            if (affineTransform == null) continue;
            this.g2.setTransform(affineTransform);
        }
    }

    public final Rectangle drawPage(AffineTransform affineTransform, AffineTransform affineTransform2, int n) {
        if (affineTransform2 != null) {
            if ((float)this.displayRotation != this.oldRotation) {
                this.setPageOffsets(this.pageCount, this.pageNumber);
                this.useAcceleration = true;
            }
            this.pageUsedForTransform = n;
            Rectangle rectangle = null;
            if (!this.isAccelerated()) {
                this.calcVisibleArea(this.topH, this.topW);
            }
            this.g2.transform(affineTransform2);
            if (DynamicVectorRenderer.debugPaint) {
                System.err.println("accelerate or redraw");
            }
            boolean bl = false;
            if (this.useAcceleration && !this.overRideAcceleration && this.scaling < 2.0f) {
                bl = this.testAcceleratedRendering();
            }
            if (bl) {
                Graphics2D graphics2D = (Graphics2D)this.backBuffer.getGraphics();
                if (this.screenNeedsRedrawing) {
                    graphics2D.setColor(this.pdf.getBackground());
                    graphics2D.fill(new Rectangle(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight()));
                    this.screenNeedsRedrawing = false;
                }
                if (this.isInitialised && this.xReached != null) {
                    graphics2D.setTransform(affineTransform2);
                    this.setDisplacementOnG2(graphics2D);
                    this.drawOtherPages(this.rawAf, affineTransform, graphics2D, rectangle, this.scaling, true);
                }
                graphics2D.dispose();
                if (this.backBuffer != null) {
                    AffineTransform affineTransform3 = this.g2.getTransform();
                    this.g2.setTransform(this.rawAf);
                    this.g2.setClip(this.rawClip);
                    this.g2.setTransform(this.rawAf);
                    this.g2.drawImage(this.backBuffer, this.insetW, this.insetH, this.pdf);
                    this.g2.setTransform(affineTransform3);
                }
            } else {
                if (DynamicVectorRenderer.debugPaint) {
                    System.err.println("standard paint called ");
                }
                this.accleratedPagesAlreadyDrawn.clear();
                this.currentDisplay.setOptimsePainting(false);
                this.drawOtherPages(this.rawAf, affineTransform, this.g2, rectangle, this.scaling, false);
            }
            this.oldScaling = this.scaling;
            this.oldRotation = this.displayRotation;
        }
        return null;
    }
}

