/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.tests;

import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class XOMTestCase
extends TestCase {
    public XOMTestCase(String string) {
        super(string);
    }

    public static void assertEquals(Text text, Text text2) {
        XOMTestCase.assertEquals(null, text, text2);
    }

    public static void assertEquals(String string, Text text, Text text2) {
        if (text2 == text) {
            return;
        }
        XOMTestCase.nullCheck(string, text, text2);
        XOMTestCase.assertEquals(string, text.getValue(), text2.getValue());
    }

    private static void nullCheck(String string, Node node, Node node2) {
        if (node == null) {
            throw new ComparisonFailure(string, null, node2.toXML());
        }
        if (node2 == null) {
            throw new ComparisonFailure(string, node.toXML(), null);
        }
    }

    public static void assertEquals(Attribute attribute, Attribute attribute2) {
        XOMTestCase.assertEquals(null, attribute, attribute2);
    }

    public static void assertEquals(String string, Attribute attribute, Attribute attribute2) {
        if (attribute2 == attribute) {
            return;
        }
        XOMTestCase.nullCheck(string, attribute, attribute2);
        String string2 = attribute.getValue();
        String string3 = attribute2.getValue();
        if ("xml:base".equals(attribute.getQualifiedName())) {
            if (string2.equals(string3)) {
                return;
            }
            if (string2.startsWith("../")) {
                XOMTestCase.assertTrue(string, string3.endsWith(string2.substring(2)));
            } else {
                XOMTestCase.assertTrue(string, string2.endsWith('/' + string3) || string3.endsWith('/' + string2));
            }
        } else {
            XOMTestCase.assertEquals(string, string2, string3);
            XOMTestCase.assertEquals(string, attribute.getLocalName(), attribute2.getLocalName());
            XOMTestCase.assertEquals(string, attribute.getQualifiedName(), attribute2.getQualifiedName());
            XOMTestCase.assertEquals(string, attribute.getNamespaceURI(), attribute2.getNamespaceURI());
        }
    }

    public static void assertEquals(DocType docType, DocType docType2) {
        XOMTestCase.assertEquals(null, docType, docType2);
    }

    public static void assertEquals(String string, DocType docType, DocType docType2) {
        if (docType2 == docType) {
            return;
        }
        XOMTestCase.nullCheck(string, docType, docType2);
        XOMTestCase.assertEquals(string, docType.getPublicID(), docType2.getPublicID());
        XOMTestCase.assertEquals(string, docType.getSystemID(), docType2.getSystemID());
        XOMTestCase.assertEquals(string, docType.getRootElementName(), docType2.getRootElementName());
    }

    public static void assertEquals(Element element, Element element2) {
        XOMTestCase.assertEquals(null, element, element2);
    }

    public static void assertEquals(String string, Element element, Element element2) {
        Object object;
        Object object2;
        int n;
        if (element2 == element) {
            return;
        }
        XOMTestCase.nullCheck(string, element, element2);
        XOMTestCase.assertEquals(string, element.getLocalName(), element2.getLocalName());
        XOMTestCase.assertEquals(string, element.getQualifiedName(), element2.getQualifiedName());
        XOMTestCase.assertEquals(string, element.getNamespaceURI(), element2.getNamespaceURI());
        XOMTestCase.assertEquals(string, element.getAttributeCount(), element2.getAttributeCount());
        for (n = 0; n < element.getAttributeCount(); ++n) {
            object2 = element.getAttribute(n);
            object = element2.getAttribute(((Attribute)object2).getLocalName(), ((Attribute)object2).getNamespaceURI());
            XOMTestCase.assertNotNull(string, object);
            XOMTestCase.assertEquals(string, (Attribute)object2, (Attribute)object);
        }
        for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
            object2 = element.getNamespacePrefix(n);
            object = element.getNamespaceURI((String)object2);
            XOMTestCase.assertNotNull(string, element2.getNamespaceURI((String)object2));
            XOMTestCase.assertEquals(string, (String)object, element2.getNamespaceURI((String)object2));
        }
        for (n = 0; n < element2.getNamespaceDeclarationCount(); ++n) {
            object2 = element2.getNamespacePrefix(n);
            object = element2.getNamespaceURI((String)object2);
            XOMTestCase.assertNotNull(string, element.getNamespaceURI((String)object2));
            XOMTestCase.assertEquals(string, (String)object, element.getNamespaceURI((String)object2));
        }
        if (element.getChildCount() != element2.getChildCount()) {
            XOMTestCase.combineTextNodes(element);
            XOMTestCase.combineTextNodes(element2);
        }
        XOMTestCase.assertEquals(string, element.getChildCount(), element2.getChildCount());
        for (n = 0; n < element.getChildCount(); ++n) {
            object2 = element.getChild(n);
            object = element2.getChild(n);
            XOMTestCase.assertEquals(string, (Node)object2, (Node)object);
        }
    }

    private static void combineTextNodes(Element element) {
        for (int i = 0; i < element.getChildCount() - 1; ++i) {
            Node node;
            Node node2 = element.getChild(i);
            if (!(node2 instanceof Text) || !((node = element.getChild(i + 1)) instanceof Text)) continue;
            Text text = new Text(node2.getValue() + node.getValue());
            element.replaceChild(node2, text);
            element.removeChild(node);
            --i;
        }
    }

    public static void assertEquals(Document document, Document document2) {
        XOMTestCase.assertEquals(null, document, document2);
    }

    public static void assertEquals(String string, Document document, Document document2) {
        if (document2 == document) {
            return;
        }
        XOMTestCase.nullCheck(string, document, document2);
        XOMTestCase.assertEquals(string, document.getChildCount(), document2.getChildCount());
        for (int i = 0; i < document2.getChildCount(); ++i) {
            Node node = document.getChild(i);
            Node node2 = document2.getChild(i);
            XOMTestCase.assertEquals(string, node, node2);
        }
    }

    public static void assertEquals(Comment comment, Comment comment2) {
        XOMTestCase.assertEquals(null, comment, comment2);
    }

    public static void assertEquals(String string, Comment comment, Comment comment2) {
        if (comment2 == comment) {
            return;
        }
        XOMTestCase.nullCheck(string, comment, comment2);
        XOMTestCase.assertEquals(string, comment.getValue(), comment2.getValue());
    }

    public static void assertEquals(ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        XOMTestCase.assertEquals(null, processingInstruction, processingInstruction2);
    }

    public static void assertEquals(String string, ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        if (processingInstruction2 == processingInstruction) {
            return;
        }
        XOMTestCase.nullCheck(string, processingInstruction, processingInstruction2);
        XOMTestCase.assertEquals(string, processingInstruction.getValue(), processingInstruction2.getValue());
        XOMTestCase.assertEquals(string, processingInstruction.getTarget(), processingInstruction2.getTarget());
    }

    public static void assertEquals(Node node, Node node2) {
        XOMTestCase.assertEquals(null, node, node2);
    }

    public static void assertEquals(String string, Node node, Node node2) {
        block9: {
            if (node2 == node) {
                return;
            }
            XOMTestCase.nullCheck(string, node, node2);
            try {
                if (node instanceof Document) {
                    XOMTestCase.assertEquals(string, (Document)node, (Document)node2);
                    break block9;
                }
                if (node instanceof Element) {
                    XOMTestCase.assertEquals(string, (Element)node, (Element)node2);
                    break block9;
                }
                if (node instanceof Text) {
                    XOMTestCase.assertEquals(string, (Text)node, (Text)node2);
                    break block9;
                }
                if (node instanceof DocType) {
                    XOMTestCase.assertEquals(string, (DocType)node, (DocType)node2);
                    break block9;
                }
                if (node instanceof Comment) {
                    XOMTestCase.assertEquals(string, (Comment)node, (Comment)node2);
                    break block9;
                }
                if (node instanceof ProcessingInstruction) {
                    XOMTestCase.assertEquals(string, (ProcessingInstruction)node, (ProcessingInstruction)node2);
                    break block9;
                }
                throw new IllegalArgumentException("Unexpected node type " + node.getClass().getName());
            }
            catch (ClassCastException classCastException) {
                XOMTestCase.fail(string + "; Mismatched node types: " + node.getClass().getName() + " != " + node2.getClass().getName());
            }
        }
    }
}

