/*
 * Decompiled with CFR 0.152.
 */
package eurobits.efactura.util;

import jfactory.exchange.ResultInfo;

public class CifNif {
    public static final int ES_NIF = 0;
    public static final int ES_CIF = 1;
    private static final String[] tablaLetras = new String[]{"T", "R", "W", "A", "G", "M", "Y", "F", "P", "D", "X", "B", "N", "J", "Z", "S", "Q", "V", "H", "L", "C", "K", "E"};
    private static final String ORIGEN_NIF_ESPA = "NIF Espa\u00f1ol";
    private static final String ORIGEN_NIF_MENOR14 = "NIF Menor de 14 a\u00f1os";
    private static final String ORIGEN_NIF_ESPA_NO_RES = "NIF Espa\u00f1ol No Residente";
    private static final String ORIGEN_NIF_EXT_CON_NIE = "NIF Extranjero con NIE";
    private static final String ORIGEN_NIF_EXT_SIN_NIE = "NIF Extranjero sin NIE";
    private static final String ORIGEN_CIF_NACIONAL = "CIF Nacional";
    private static final String ORIGEN_CIF_EXT = "CIF Extranjero";
    private static final String ORIGEN_CIF_ADM_EST = "CIF Organismo Administracion Estado";
    private static final String ORIGEN_CIF_ADM_AUT = "CIF Organismo Adiministracion Local o Auton\u00f3mica";
    private static final String ORIGEN_CIF_FIC = "CIF Ficticio";
    private static final String ORIGEN_CIF_No_RES = "CIF No Residente";
    private static final int TAM_NIF_CIF = 9;
    private String _cifNif = null;
    private String _primerApellido = null;
    private String _anagrama = null;
    private String _origen = null;
    private int _type;

    public CifNif(String cifNif) {
        this._cifNif = cifNif.toUpperCase();
        this._anagrama = null;
        this._primerApellido = null;
    }

    public CifNif(String cifNif, String anagrama, String primerApellido) {
        this._cifNif = cifNif.toUpperCase();
        this._anagrama = anagrama;
        this._primerApellido = primerApellido;
    }

    public static boolean isValidNIF(String str) {
        if (str.length() == 9 && CifNif._isNumber(str.substring(0, 8))) {
            int numero = Integer.parseInt(str.substring(0, 8));
            int indiceTabla = numero % 23;
            return tablaLetras[indiceTabla].endsWith(str.substring(8, 9));
        }
        return false;
    }

    public static boolean isValidCIFNIF(String str) {
        if (str.length() == 9) {
            CifNif cifNif = new CifNif(str);
            return cifNif._isValidCIF(str) || cifNif._isValidNIF(str);
        }
        return false;
    }

    public static String getAnagrama(String NIF, String primerApellido) {
        CifNif cifNif = new CifNif(NIF, null, primerApellido);
        return cifNif._generaAnagrama();
    }

    public static String getLetter(String str) {
        try {
            if (str.length() == 8 || str.length() == 7) {
                int numero = Integer.parseInt(str);
                int indiceTabla = numero % 23;
                return tablaLetras[indiceTabla];
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ResultInfo validate() {
        ResultInfo rs = new ResultInfo();
        this._type = 1;
        int longitudCadena = this._cifNif.length();
        if (longitudCadena != 9) {
            rs.setError(true);
            rs.setMessage("Identificacion fiscal tiene un numero de caracteres invalido");
            return rs;
        }
        if (!this._isValidCIF(this._cifNif)) {
            if (this._isValidNIF(this._cifNif)) {
                this._type = 0;
                if (this._primerApellido != null) {
                    int longitudPrimerApellido = this._primerApellido.length();
                    if (longitudPrimerApellido < 3) {
                        for (int i = longitudPrimerApellido; i < 3; ++i) {
                            this._primerApellido = this._primerApellido + " ";
                        }
                    }
                    this._primerApellido = this._primerApellido.toUpperCase();
                }
                if (this._anagrama != null && !this._anagrama.trim().equals("") && !this._esAnagramaValido(this._cifNif, this._anagrama, this._primerApellido)) {
                    rs.setError(true);
                    rs.setMessage("Anagrama no valido");
                }
            } else {
                rs.setError(true);
                rs.setMessage("Numero de identificacion fiscal no valido");
            }
        }
        return rs;
    }

    public int getType() {
        if (this._origen == null) {
            this.validate();
        }
        return this._type;
    }

    public String getOrigen() {
        if (this._origen == null) {
            this.validate();
        }
        return this._origen;
    }

    public String getAnagrama() {
        if (this._origen == null) {
            this.validate();
        }
        if (this._type == 0 && this._primerApellido != null) {
            return CifNif.getAnagrama(this._cifNif, this._primerApellido);
        }
        return null;
    }

    public String getCIF() {
        return this._cifNif;
    }

    private boolean _isValidNIF(String NIF) {
        String numeroNIF = null;
        String letraNIF = null;
        boolean esNIFValido = false;
        numeroNIF = NIF.substring(0, NIF.length() - 1);
        char primerCaracterNumeroNIF = numeroNIF.charAt(0);
        String restoNumeroNIF = numeroNIF.substring(1);
        letraNIF = NIF.substring(NIF.length() - 1);
        if (Character.isLetterOrDigit(primerCaracterNumeroNIF) && CifNif._isNumber(restoNumeroNIF) && Character.isLetter(letraNIF.charAt(0))) {
            switch (primerCaracterNumeroNIF) {
                case 'K': {
                    esNIFValido = this._compruebaLetraNIF(restoNumeroNIF, letraNIF);
                    if (esNIFValido) {
                        this._origen = ORIGEN_NIF_MENOR14;
                    }
                    return esNIFValido;
                }
                case 'L': {
                    esNIFValido = this._compruebaLetraNIF(restoNumeroNIF, letraNIF);
                    if (esNIFValido) {
                        this._origen = ORIGEN_NIF_ESPA_NO_RES;
                    }
                    return esNIFValido;
                }
                case 'M': {
                    esNIFValido = this._compruebaLetraNIF(restoNumeroNIF, letraNIF);
                    if (esNIFValido) {
                        this._origen = ORIGEN_NIF_EXT_SIN_NIE;
                    }
                    return esNIFValido;
                }
                case 'X': {
                    esNIFValido = this._compruebaLetraNIF(restoNumeroNIF, letraNIF);
                    if (esNIFValido) {
                        this._origen = ORIGEN_NIF_EXT_CON_NIE;
                    }
                    return esNIFValido;
                }
                case 'Y': {
                    esNIFValido = this._compruebaLetraNIF("1" + restoNumeroNIF, letraNIF);
                    if (esNIFValido) {
                        this._origen = ORIGEN_NIF_EXT_CON_NIE;
                    }
                    return esNIFValido;
                }
                case 'Z': {
                    esNIFValido = this._compruebaLetraNIF("2" + restoNumeroNIF, letraNIF);
                    if (esNIFValido) {
                        this._origen = ORIGEN_NIF_EXT_CON_NIE;
                    }
                    return esNIFValido;
                }
            }
            if (CifNif._isNumber(numeroNIF)) {
                esNIFValido = this._compruebaLetraNIF(numeroNIF, letraNIF);
            }
            if (esNIFValido) {
                this._origen = ORIGEN_NIF_ESPA;
            }
            return esNIFValido;
        }
        return esNIFValido;
    }

    private boolean _isValidCIF(String CIF) {
        boolean esCIFValido = false;
        String letraCIF = null;
        String numeroCIF = null;
        String controlCIF = null;
        letraCIF = CIF.substring(0, 1);
        esCIFValido = this._isValidCIFNacional(letraCIF, numeroCIF = CIF.substring(1, CIF.length() - 1), controlCIF = CIF.substring(CIF.length() - 1, CIF.length()));
        if (esCIFValido) {
            this._origen = ORIGEN_CIF_NACIONAL;
        } else {
            esCIFValido = this._isValidCIFNoNacional(letraCIF, numeroCIF, controlCIF);
        }
        return esCIFValido;
    }

    private boolean _isValidCIFNacional(String letraCIF, String numeroCIF, String controlCIF) {
        boolean resultadoComprobacion = false;
        boolean esCIFNacional = true;
        char letra = letraCIF.charAt(0);
        char digitoControl = controlCIF.charAt(0);
        if (!Character.isDigit(digitoControl)) {
            resultadoComprobacion = false;
            return resultadoComprobacion;
        }
        resultadoComprobacion = (letra >= 'A' && letra <= 'J' || letra == 'U' || letra == 'V') && controlCIF.equals(this._dameControlCIF(numeroCIF, esCIFNacional));
        return resultadoComprobacion;
    }

    private boolean _isValidCIFNoNacional(String letraCIF, String numeroCIF, String controlCIF) {
        boolean resultadoComprobacion = false;
        boolean esCIFNacional = false;
        char letra = letraCIF.charAt(0);
        if (controlCIF.equals(this._dameControlCIF(numeroCIF, esCIFNacional))) {
            if (letra >= 'A' && letra <= 'J') {
                this._origen = ORIGEN_CIF_EXT;
                resultadoComprobacion = true;
            } else if (letra == 'S') {
                this._origen = ORIGEN_CIF_ADM_EST;
                resultadoComprobacion = true;
            } else if (letra == 'P' || letra == 'Q') {
                this._origen = ORIGEN_CIF_ADM_AUT;
                resultadoComprobacion = true;
            } else if (letra == 'U') {
                this._origen = ORIGEN_CIF_FIC;
                resultadoComprobacion = true;
            } else if (letra == 'N') {
                this._origen = ORIGEN_CIF_No_RES;
                resultadoComprobacion = true;
            } else if (letra == 'W') {
                this._origen = ORIGEN_CIF_No_RES;
                resultadoComprobacion = true;
            } else if (letra == 'R') {
                this._origen = ORIGEN_CIF_ADM_AUT;
                resultadoComprobacion = true;
            }
        } else {
            resultadoComprobacion = false;
        }
        return resultadoComprobacion;
    }

    private String _dameControlCIF(String numeroCIF, boolean esCIFNacional) {
        int codigoControl;
        String codigoControlResultante = null;
        try {
            int numero1 = Integer.parseInt(numeroCIF.substring(0, 1)) * 2;
            int numero2 = Integer.parseInt(numeroCIF.substring(1, 2));
            int numero3 = Integer.parseInt(numeroCIF.substring(2, 3)) * 2;
            int numero4 = Integer.parseInt(numeroCIF.substring(3, 4));
            int numero5 = Integer.parseInt(numeroCIF.substring(4, 5)) * 2;
            int numero6 = Integer.parseInt(numeroCIF.substring(5, 6));
            int numero7 = Integer.parseInt(numeroCIF.substring(6)) * 2;
            int numero1transformado = this._transformaAMenorDe10(numero1);
            int numero3transformado = this._transformaAMenorDe10(numero3);
            int numero5transformado = this._transformaAMenorDe10(numero5);
            int numero7transformado = this._transformaAMenorDe10(numero7);
            int sumaTotal = numero1transformado + numero2 + numero3transformado + numero4 + numero5transformado + numero6 + numero7transformado;
            int moduloResultadoTotal = sumaTotal % 10;
            codigoControl = 10 - moduloResultadoTotal;
        }
        catch (NumberFormatException nfe) {
            codigoControlResultante = null;
            return codigoControlResultante;
        }
        if (codigoControl == 10) {
            codigoControl = 0;
        }
        if (esCIFNacional) {
            codigoControlResultante = String.valueOf(codigoControl);
        } else {
            switch (codigoControl) {
                case 1: {
                    codigoControlResultante = "A";
                    break;
                }
                case 2: {
                    codigoControlResultante = "B";
                    break;
                }
                case 3: {
                    codigoControlResultante = "C";
                    break;
                }
                case 4: {
                    codigoControlResultante = "D";
                    break;
                }
                case 5: {
                    codigoControlResultante = "E";
                    break;
                }
                case 6: {
                    codigoControlResultante = "F";
                    break;
                }
                case 7: {
                    codigoControlResultante = "G";
                    break;
                }
                case 8: {
                    codigoControlResultante = "H";
                    break;
                }
                case 9: {
                    codigoControlResultante = "I";
                    break;
                }
                case 0: {
                    codigoControlResultante = "J";
                    break;
                }
                default: {
                    codigoControlResultante = "*";
                }
            }
        }
        return codigoControlResultante;
    }

    private int _transformaAMenorDe10(int numero) {
        int numeroTransformado = 0;
        if (numero < 10) {
            return numero;
        }
        numeroTransformado = numero % 10 + numero / 10;
        return numeroTransformado;
    }

    private String _generaAnagrama() {
        String cadenaControl = null;
        int indiceTabla = 0;
        int numeroControl = 0;
        int suma = 0;
        String anagrama = "";
        if (this._isValidNIF(this._cifNif)) {
            cadenaControl = this._dameCadenaControl(this._cifNif, this._primerApellido);
            numeroControl = this._dameNumeroControlAnagrama(cadenaControl);
            String nif = this._cifNif;
            if (!this._origen.equals(ORIGEN_NIF_ESPA)) {
                nif = nif.substring(1);
            }
            suma = this._sumaIdentificacionNumeroControl(nif, numeroControl);
            indiceTabla = suma % 23;
            anagrama = this._primerApellido.substring(0, 3) + tablaLetras[indiceTabla];
        }
        return anagrama;
    }

    private boolean _esAnagramaValido(String NIF, String anagrama, String primerApellido) {
        String anagramaGenerado = null;
        boolean esAnagramaValido = false;
        if (anagrama != null && primerApellido != null) {
            anagramaGenerado = this._generaAnagrama();
            esAnagramaValido = anagrama.equalsIgnoreCase(anagramaGenerado);
        }
        return esAnagramaValido;
    }

    private String _dameCadenaControl(String NIF, String primerApellido) {
        String cadenaControl = null;
        char primerCaracterNIF = NIF.charAt(0);
        if (Character.isDigit(primerCaracterNIF)) {
            cadenaControl = primerApellido.length() >= 3 ? " " + primerApellido.substring(0, 3) : " " + primerApellido;
        } else if (primerCaracterNIF == 'X' || primerCaracterNIF == 'K' || primerCaracterNIF == 'L' || primerCaracterNIF == 'M') {
            cadenaControl = primerApellido.length() >= 3 ? primerCaracterNIF + primerApellido.substring(0, 3) : primerCaracterNIF + primerApellido;
        }
        return cadenaControl;
    }

    private int _dameNumeroControlAnagrama(String cadena) {
        int retorno = 0;
        double suma = 0.0;
        int i = 0;
        double j = 0.0;
        double k = 0.0;
        int n = 0;
        String letra = "";
        String[] tablaAbecedario = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "\u00d1", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        for (n = cadena.length(); n > 0; --n) {
            letra = cadena.substring(n - 1, n);
            j += 1.0;
            for (i = 0; i <= 26; ++i) {
                k += 1.0;
                if (!letra.equalsIgnoreCase(tablaAbecedario[i])) continue;
                suma += (double)(i + 1) * Math.pow(10.0, 2.0 * (j - 1.0));
                i = 26;
            }
        }
        Double numero = new Double(suma);
        retorno = numero.intValue();
        return retorno;
    }

    private int _sumaIdentificacionNumeroControl(String NIF, int indiceTabla) {
        String numeroNIF = NIF.substring(0, NIF.length() - 1);
        int suma = Integer.parseInt(numeroNIF) + indiceTabla;
        return suma;
    }

    private static boolean _isNumber(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean _compruebaLetraNIF(String numeroNIF, String letraNIF) {
        return letraNIF.equalsIgnoreCase(CifNif.getLetter(numeroNIF));
    }

    public static void main(String[] args) {
        String s;
        String apellido;
        CifNif elCifNif;
        int i;
        String[] pruebas = new String[]{"25470736F", "00000000T", "11111111H", "677545cx", "22222222k", "fghgyyasd", "b82917220"};
        System.err.println("*********** CifNif*********INI");
        System.err.println("  *********** Uso de instancias del objeto:");
        System.err.println();
        for (i = 0; i < pruebas.length; ++i) {
            elCifNif = new CifNif(pruebas[i], null, null);
            System.err.println("     **** El CIF: " + pruebas[i] + " validate: " + elCifNif.validate() + " getType: " + elCifNif.getType() + " getOrigen: " + elCifNif.getOrigen());
        }
        System.err.println();
        elCifNif = new CifNif("25470736f", "INFB", "Infante");
        System.err.println("     **** El CIF: " + elCifNif.getCIF() + " anagrama: " + elCifNif.getAnagrama() + " validate: " + elCifNif.validate() + " getType: " + elCifNif.getType() + " getOrigen: " + elCifNif.getOrigen());
        elCifNif = new CifNif("25475237T", null, "Ripoll");
        System.err.println("     **** El CIF: " + elCifNif.getCIF() + " anagrama: " + elCifNif.getAnagrama() + " validate: " + elCifNif.validate() + " getType: " + elCifNif.getType() + " getOrigen: " + elCifNif.getOrigen());
        elCifNif = new CifNif("b82917220", null, null);
        System.err.println("     **** El CIF: " + elCifNif.getCIF() + " anagrama: " + elCifNif.getAnagrama() + " validate: " + elCifNif.validate() + " getType: " + elCifNif.getType() + " getOrigen: " + elCifNif.getOrigen());
        elCifNif = new CifNif("11111111H", "adsas", null);
        System.err.println("     **** El CIF: " + elCifNif.getCIF() + " anagrama: " + elCifNif.getAnagrama() + " validate: " + elCifNif.validate() + " getType: " + elCifNif.getType() + " getOrigen: " + elCifNif.getOrigen());
        System.err.println();
        System.err.println("  *********** Uso de los metodos estaticos:");
        System.err.println();
        for (i = 0; i < pruebas.length; ++i) {
            String s2 = pruebas[i].substring(0, pruebas[i].length() - 1);
            System.err.println("      **** El num: " + s2 + " getLetter: " + CifNif.getLetter(s2));
        }
        System.err.println();
        for (i = 0; i < pruebas.length; ++i) {
            apellido = "Infante";
            s = pruebas[i];
            System.err.println("      **** El NIF " + s + " getAnagrama: " + CifNif.getAnagrama(s, apellido));
        }
        System.err.println();
        for (i = 0; i < pruebas.length; ++i) {
            apellido = "Infante";
            s = pruebas[i];
            System.err.println("      **** El NIF " + s + " isValidNIF: " + CifNif.isValidNIF(s));
        }
        System.err.println();
        System.err.println("*********** CifNif*********FIN");
        System.err.println();
        System.err.println("Cif Errado " + CifNif.isValidCIFNIF("0759713A"));
    }
}

