/*
 * Decompiled with CFR 0.152.
 */
package eurobits.efactura.server.util;

import eurobits.efactura.server.util.Propiedades;
import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;
import jfactory.util.Log;
import jfactory.util.LogEntry;
import jfactory.util.Text;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLog
implements Log,
Serializable {
    private static final Logger loggerSLF4J = LoggerFactory.getLogger(ServiceLog.class);
    private String nombreAplicacion = null;
    private static final String SEPARADOR = " ";
    public static final int TRACE = 20;
    public static final int DEBUG = 30;
    public static final int WARN = 15;
    public static final int ERROR = 10;
    public static final int FATAL = 5;

    public ServiceLog(Propiedades prop, String nombreAplicacion) {
        this.nombreAplicacion = nombreAplicacion;
    }

    private void log(String threadName, String sesionID, String aplicacion, String codigoBanco, Object objetoInvocante, String metodo, Object mensaje, int nivel) {
        loggerSLF4J.trace((String)mensaje);
    }

    protected StringBuffer getMethodName(Object objetoInvocante, Object nombreMetodo) {
        String nombreClase = "";
        StringBuffer res = new StringBuffer(64);
        nombreClase = objetoInvocante.getClass().getName();
        if ("java.lang.String".equals(nombreClase)) {
            nombreClase = (String)objetoInvocante;
        }
        StringTokenizer st = new StringTokenizer(nombreClase, ".", false);
        String token = nombreClase;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
        }
        nombreClase = token;
        res.append(nombreClase);
        if (!"".equals(nombreMetodo)) {
            res.append(".").append(nombreMetodo.toString()).append("()");
        }
        return res;
    }

    private Priority formatPriority(int nivel) {
        Priority log4jLevel = Priority.INFO;
        switch (nivel) {
            case 30: {
                log4jLevel = Priority.DEBUG;
                break;
            }
            case 20: {
                log4jLevel = Priority.INFO;
                break;
            }
            case 15: {
                log4jLevel = Priority.WARN;
                break;
            }
            case 10: {
                log4jLevel = Priority.ERROR;
                break;
            }
            case 5: {
                log4jLevel = Priority.FATAL;
            }
        }
        return log4jLevel;
    }

    public void writeTrace(int nivel, String codBanco, Object objetoInvocante, String nombreMetodo, Object mensaje) {
        this.log(this.getThreadName(), this.getSessionId(), this.nombreAplicacion, codBanco, objetoInvocante, nombreMetodo, mensaje, nivel);
    }

    public void writeTrace(int nivel, Object objetoInvocante, String nombreMetodo, Object mensaje) {
        this.log(this.getThreadName(), this.getSessionId(), this.nombreAplicacion, this.getSessionEntity(), objetoInvocante, nombreMetodo, mensaje, nivel);
    }

    public void writeTrace(Object mensaje) {
        this.log(this.getThreadName(), this.getSessionId(), this.nombreAplicacion, this.getSessionEntity(), "", "", mensaje, this.getLevel());
    }

    public void closeStreams() {
    }

    public int getLevel() {
        int level = 10000;
        switch (level) {
            case 10000: {
                return 30;
            }
            case 20000: {
                return 20;
            }
            case 30000: {
                return 15;
            }
            case 40000: {
                return 10;
            }
            case 50000: {
                return 5;
            }
        }
        return 20;
    }

    public void openStreams() {
    }

    public void setProperties(Properties propiedades) {
    }

    public void writeLog(Object mensaje) {
        this.writeTrace(mensaje);
    }

    public void writeLogEntry(LogEntry logEntry) {
        Object objetoInvocante = logEntry.getInvokingObject();
        String nombreMetodo = logEntry.getMethodName();
        Object mensaje = logEntry.getMessage();
        int nivel = logEntry.getLevel();
        String tipoLog = logEntry.getTypeLog();
        if (objetoInvocante != null && nombreMetodo != null) {
            if (tipoLog.equals("TRACE")) {
                this.writeTrace(nivel, objetoInvocante, nombreMetodo, mensaje);
            } else {
                this.writeLog(mensaje);
            }
        } else if (tipoLog.equals("TRACE")) {
            this.writeTrace(mensaje);
        } else {
            this.writeLog(mensaje);
        }
    }

    public void writeRawLog(Object mensaje) {
        this.writeTrace(mensaje);
    }

    public void writeRawTrace(Object mensaje) {
        this.writeTrace(mensaje);
    }

    public void writeTraza(int nivel, Object ObjetoInvocante, String nombreMetodo, Object mensaje) {
        this.writeTrace(nivel, ObjetoInvocante, nombreMetodo, mensaje);
    }

    public void writeTraza(Object mensaje) {
        this.writeTrace(mensaje);
    }

    private String getThreadName() {
        return Text.changeSize((String)Thread.currentThread().getName(), (int)4, (char)'_', (boolean)false);
    }

    private String getSessionId() {
        String strSessionId = null;
        Object sessionId = null;
        try {
            sessionId = THREAD_LOCAL_SESSION_ID.get();
        }
        catch (Throwable t) {
            sessionId = null;
        }
        strSessionId = sessionId == null ? "[no session]" : ((strSessionId = (String)sessionId).length() > 16 ? strSessionId.substring(0, 13) + "..." : Text.changeSize((String)strSessionId, (int)16, (char)'_'));
        return strSessionId;
    }

    private String getSessionEntity() {
        String sesion = null;
        Object sessionEn = null;
        try {
            sessionEn = MDC.get("codBanco");
        }
        catch (Throwable t) {
            sessionEn = null;
        }
        sesion = sessionEn == null ? "null" : (String)sessionEn;
        return sesion;
    }
}

