/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class TinyProgressBarUI
extends BasicProgressBarUI {
    static HashMap cache = new HashMap();
    private static final Dimension PREFERRED_YQ_HORIZONTAL = new Dimension(146, 7);
    private static final Dimension PREFERRED_YQ_VERTICAL = new Dimension(7, 146);
    private static final Dimension PREFERRED_99_HORIZONTAL = new Dimension(146, 6);
    private static final Dimension PREFERRED_99_VERTICAL = new Dimension(6, 146);

    protected Dimension getPreferredInnerHorizontal() {
        if (Theme.derivedStyle[Theme.style] == 2) {
            return PREFERRED_YQ_HORIZONTAL;
        }
        return PREFERRED_99_HORIZONTAL;
    }

    protected Dimension getPreferredInnerVertical() {
        if (Theme.derivedStyle[Theme.style] == 2) {
            return PREFERRED_YQ_VERTICAL;
        }
        return PREFERRED_99_VERTICAL;
    }

    public static ComponentUI createUI(JComponent c) {
        return new TinyProgressBarUI();
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (this.progressBar.getOrientation() == 0) {
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            switch (Theme.derivedStyle[Theme.style]) {
                case 0: {
                    this.drawTinyHorzProgress(g, b.left, b.top, barRectWidth, barRectHeight, amountFull);
                    break;
                }
                case 1: {
                    this.drawWinHorzProgress(g, b.left, b.top, barRectWidth, barRectHeight, amountFull);
                    break;
                }
                case 2: {
                    this.drawXpHorzProgress(g, b.left, b.top, barRectWidth, barRectHeight, amountFull);
                }
            }
            if (this.progressBar.isStringPainted()) {
                g.setFont(c.getFont());
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        } else {
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            switch (Theme.derivedStyle[Theme.style]) {
                case 0: {
                    this.drawTinyVertProgress(g, b.left, b.top, barRectWidth, barRectHeight, amountFull);
                    break;
                }
                case 1: {
                    this.drawWinVertProgress(g, b.left, b.top, barRectWidth, barRectHeight, amountFull);
                    break;
                }
                case 2: {
                    this.drawXpVertProgress(g, b.left, b.top, barRectWidth, barRectHeight, amountFull);
                }
            }
            if (this.progressBar.isStringPainted()) {
                g.setFont(c.getFont());
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        }
    }

    private void drawTinyHorzProgress(Graphics g, int x, int y, int barRectWidth, int barRectHeight, int amountFull) {
    }

    private void drawWinHorzProgress(Graphics g, int x, int y, int w, int h, int amountFull) {
        g.translate(x, y);
        g.setColor(Theme.progressTrackColor[Theme.style].getColor());
        g.fillRect(1, 1, w - 1, h - 1);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int mx = 0;
        while (mx < amountFull) {
            if (mx + 6 > w) {
                g.fillRect(mx, 0, w - mx, h);
            } else {
                g.fillRect(mx, 0, 6, h);
            }
            mx += 8;
        }
        g.translate(-x, -y);
    }

    private void drawXpHorzProgress(Graphics g, int x, int y, int w, int h, int amountFull) {
        ProgressKey key;
        Object value;
        g.translate(x, y);
        if (!this.progressBar.isOpaque()) {
            g.setColor(this.progressBar.getBackground());
            g.fillRect(0, 0, w, h);
        }
        if ((value = cache.get(key = new ProgressKey(this.progressBar.getForeground(), true, h))) == null) {
            BufferedImage img = new BufferedImage(6, h, 2);
            Graphics imgGraphics = ((Image)img).getGraphics();
            Color c = this.progressBar.getForeground();
            Color c2 = ColorRoutines.lighten(c, 15);
            Color c3 = ColorRoutines.lighten(c, 35);
            Color c4 = ColorRoutines.lighten(c, 60);
            imgGraphics.setColor(c4);
            imgGraphics.drawLine(0, 0, 5, 0);
            imgGraphics.drawLine(0, h - 1, 5, h - 1);
            imgGraphics.setColor(c3);
            imgGraphics.drawLine(0, 1, 5, 1);
            imgGraphics.drawLine(0, h - 2, 5, h - 2);
            imgGraphics.setColor(c2);
            imgGraphics.drawLine(0, 2, 5, 2);
            imgGraphics.drawLine(0, h - 3, 5, h - 3);
            imgGraphics.setColor(c);
            imgGraphics.fillRect(0, 3, 6, h - 6);
            imgGraphics.dispose();
            cache.put(key, img);
            value = img;
        }
        int mx = 0;
        while (mx < amountFull) {
            if (mx + 6 > w) {
                g.drawImage((Image)value, mx, 0, w - mx, h, this.progressBar);
            } else {
                g.drawImage((Image)value, mx, 0, this.progressBar);
            }
            mx += 8;
        }
        g.translate(-x, -y);
    }

    private void drawTinyVertProgress(Graphics g, int x, int y, int barRectWidth, int barRectHeight, int amountFull) {
    }

    private void drawWinVertProgress(Graphics g, int x, int y, int w, int h, int amountFull) {
        g.translate(x, y);
        g.setColor(Theme.progressTrackColor[Theme.style].getColor());
        g.fillRect(1, 1, w - 1, h - 1);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int my = 0;
        while (my < amountFull) {
            if (my + 6 > h) {
                g.fillRect(0, 0, w, h - my);
            } else {
                g.fillRect(0, h - my - 6, w, 6);
            }
            my += 8;
        }
        g.translate(-x, -y);
    }

    private void drawXpVertProgress(Graphics g, int x, int y, int w, int h, int amountFull) {
        ProgressKey key;
        Object value;
        g.translate(x, y);
        if (!this.progressBar.isOpaque()) {
            g.setColor(this.progressBar.getBackground());
            g.fillRect(0, 0, w, h);
        }
        if ((value = cache.get(key = new ProgressKey(this.progressBar.getForeground(), false, w))) == null) {
            BufferedImage img = new BufferedImage(w, 6, 2);
            Graphics imgGraphics = ((Image)img).getGraphics();
            Color c = this.progressBar.getForeground();
            Color c2 = ColorRoutines.lighten(c, 15);
            Color c3 = ColorRoutines.lighten(c, 35);
            Color c4 = ColorRoutines.lighten(c, 60);
            imgGraphics.setColor(c4);
            imgGraphics.drawLine(0, 0, 0, 5);
            imgGraphics.drawLine(w - 1, 0, w - 1, 5);
            imgGraphics.setColor(c3);
            imgGraphics.drawLine(1, 0, 1, 5);
            imgGraphics.drawLine(w - 2, 0, w - 2, 5);
            imgGraphics.setColor(c2);
            imgGraphics.drawLine(2, 0, 2, 5);
            imgGraphics.drawLine(w - 3, 0, w - 3, 5);
            imgGraphics.setColor(c);
            imgGraphics.fillRect(3, 0, w - 6, 6);
            imgGraphics.dispose();
            cache.put(key, img);
            value = img;
        }
        int my = 0;
        while (my < amountFull) {
            if (my + 6 > h) {
                g.drawImage((Image)value, 0, 0, w, h - my, this.progressBar);
            } else {
                g.drawImage((Image)value, 0, h - my - 6, this.progressBar);
            }
            my += 8;
        }
        g.translate(-x, -y);
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Rectangle boxRect = new Rectangle();
        try {
            boxRect = this.getBox(boxRect);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.progressBar.getOrientation() == 0) {
            switch (Theme.derivedStyle[Theme.style]) {
                case 0: {
                    this.drawTinyHorzProgress(g, b.left, b.top, barRectWidth, barRectHeight, boxRect);
                    break;
                }
                case 1: {
                    this.drawWinHorzProgress(g, b.left, b.top, barRectWidth, barRectHeight, boxRect);
                    break;
                }
                case 2: {
                    this.drawXpHorzProgress(g, b.left, b.top, barRectWidth, barRectHeight, boxRect);
                }
            }
        } else {
            switch (Theme.derivedStyle[Theme.style]) {
                case 0: {
                    this.drawTinyVertProgress(g, b.left, b.top, barRectWidth, barRectHeight, boxRect);
                    break;
                }
                case 1: {
                    this.drawWinVertProgress(g, b.left, b.top, barRectWidth, barRectHeight, boxRect);
                    break;
                }
                case 2: {
                    this.drawXpVertProgress(g, b.left, b.top, barRectWidth, barRectHeight, boxRect);
                }
            }
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, boxRect.x, boxRect.width, b);
            } else {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, boxRect.y, boxRect.height, b);
            }
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, height);
            g.drawString(progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, width, amountFull);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }

    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        Rectangle boxRect = new Rectangle();
        try {
            boxRect = this.getBox(boxRect);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.progressBar.getOrientation() == 0) {
            if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                if (this.progressBar.isIndeterminate()) {
                    this.paintString(g, x, y, width, height, boxRect.x, boxRect.width, b);
                } else {
                    this.paintString(g, x, y, width, height, x, amountFull, b);
                }
            } else {
                this.paintString(g, x, y, width, height, x + width - amountFull, amountFull, b);
            }
        } else if (this.progressBar.isIndeterminate()) {
            this.paintString(g, x, y, width, height, boxRect.y, boxRect.height, b);
        } else {
            this.paintString(g, x, y, width, height, y + height - amountFull, amountFull, b);
        }
    }

    private void drawTinyHorzProgress(Graphics g, int x, int y, int barRectWidth, int barRectHeight, Rectangle boxRect) {
    }

    private void drawWinHorzProgress(Graphics g, int x, int y, int w, int h, Rectangle boxRect) {
        g.setColor(Theme.progressTrackColor[Theme.style].getColor());
        g.fillRect(x + 1, y + 1, w - 1, h - 1);
        g.translate(boxRect.x, boxRect.y);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int mx = 0;
        while (mx + 6 < boxRect.width) {
            g.fillRect(mx, 0, 6, h);
            mx += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    private void drawXpHorzProgress(Graphics g, int x, int y, int w, int h, Rectangle boxRect) {
        if (!this.progressBar.isOpaque()) {
            g.setColor(this.progressBar.getBackground());
            g.fillRect(x, y, w, h);
        }
        g.translate(boxRect.x, boxRect.y);
        ProgressKey key = new ProgressKey(this.progressBar.getForeground(), true, h);
        Object value = cache.get(key);
        if (value == null) {
            BufferedImage img = new BufferedImage(6, h, 2);
            Graphics imgGraphics = ((Image)img).getGraphics();
            Color c = this.progressBar.getForeground();
            Color c2 = ColorRoutines.lighten(c, 15);
            Color c3 = ColorRoutines.lighten(c, 35);
            Color c4 = ColorRoutines.lighten(c, 60);
            imgGraphics.setColor(c4);
            imgGraphics.drawLine(0, 0, 5, 0);
            imgGraphics.drawLine(0, h - 1, 5, h - 1);
            imgGraphics.setColor(c3);
            imgGraphics.drawLine(0, 1, 5, 1);
            imgGraphics.drawLine(0, h - 2, 5, h - 2);
            imgGraphics.setColor(c2);
            imgGraphics.drawLine(0, 2, 5, 2);
            imgGraphics.drawLine(0, h - 3, 5, h - 3);
            imgGraphics.setColor(c);
            imgGraphics.fillRect(0, 3, 6, h - 6);
            imgGraphics.dispose();
            cache.put(key, img);
            value = img;
        }
        int mx = 0;
        while (mx + 6 < boxRect.width) {
            g.drawImage((Image)value, mx, 0, this.progressBar);
            mx += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    private void drawTinyVertProgress(Graphics g, int x, int y, int w, int h, Rectangle boxRect) {
    }

    private void drawWinVertProgress(Graphics g, int x, int y, int w, int h, Rectangle boxRect) {
        g.setColor(Theme.progressTrackColor[Theme.style].getColor());
        g.fillRect(x + 1, y + 1, w - 1, h - 1);
        g.translate(boxRect.x, boxRect.y);
        g.setColor(Theme.progressColor[Theme.style].getColor());
        int my = 0;
        while (my + 6 < boxRect.height) {
            g.fillRect(0, my, w, 6);
            my += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    private void drawXpVertProgress(Graphics g, int x, int y, int w, int h, Rectangle boxRect) {
        if (!this.progressBar.isOpaque()) {
            g.setColor(this.progressBar.getBackground());
            g.fillRect(x, y, w, h);
        }
        g.translate(boxRect.x, boxRect.y);
        ProgressKey key = new ProgressKey(this.progressBar.getForeground(), false, w);
        Object value = cache.get(key);
        if (value == null) {
            BufferedImage img = new BufferedImage(w, 6, 2);
            Graphics imgGraphics = ((Image)img).getGraphics();
            Color c = this.progressBar.getForeground();
            Color c2 = ColorRoutines.lighten(c, 15);
            Color c3 = ColorRoutines.lighten(c, 35);
            Color c4 = ColorRoutines.lighten(c, 60);
            imgGraphics.setColor(c4);
            imgGraphics.drawLine(0, 0, 0, 5);
            imgGraphics.drawLine(w - 1, 0, w - 1, 5);
            imgGraphics.setColor(c3);
            imgGraphics.drawLine(1, 0, 1, 5);
            imgGraphics.drawLine(w - 2, 0, w - 2, 5);
            imgGraphics.setColor(c2);
            imgGraphics.drawLine(2, 0, 2, 5);
            imgGraphics.drawLine(w - 3, 0, w - 3, 5);
            imgGraphics.setColor(c);
            imgGraphics.fillRect(3, 0, w - 6, 6);
            imgGraphics.dispose();
            cache.put(key, img);
            value = img;
        }
        int my = 0;
        while (my + 6 < boxRect.height) {
            g.drawImage((Image)value, 0, my, this.progressBar);
            my += 8;
        }
        g.translate(-boxRect.x, -boxRect.y);
    }

    protected Color getSelectionForeground() {
        return Theme.progressSelectForeColor[Theme.style].getColor();
    }

    protected Color getSelectionBackground() {
        return Theme.progressSelectBackColor[Theme.style].getColor();
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
    }

    static class ProgressKey {
        private Color c;
        private boolean horizontal;
        private int size;

        ProgressKey(Color c, boolean horizontal, int size) {
            this.c = c;
            this.horizontal = horizontal;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ProgressKey)) {
                return false;
            }
            ProgressKey other = (ProgressKey)o;
            return this.size == other.size && this.horizontal == other.horizontal && this.c.equals(other.c);
        }

        public int hashCode() {
            return this.c.hashCode() * (this.horizontal ? 1 : 2) * this.size;
        }
    }
}

