/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.ConstantTimer;
import com.clarkware.junitperf.LoadTest;
import com.clarkware.junitperf.MockTest;
import com.clarkware.junitperf.MockTestWithState;
import com.clarkware.junitperf.TestFactory;
import com.clarkware.junitperf.TimedTest;
import junit.extensions.RepeatedTest;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LoadTestTest
extends TestCase {
    private TestSuite _successSuite = new TestSuite();
    private TestSuite _rogueThreadSuite;
    private TestSuite _failureSuite = new TestSuite();
    private TestSuite _errorSuite;
    public static final long tolerance = 100L;
    static /* synthetic */ Class class$com$clarkware$junitperf$MockTestWithState;
    static /* synthetic */ Class class$com$clarkware$junitperf$LoadTestTest;

    public LoadTestTest(String string) {
        super(string);
        this._rogueThreadSuite = new TestSuite();
        this._errorSuite = new TestSuite();
        this._successSuite.addTest(new MockTest("testSuccess"));
        this._successSuite.addTest(new MockTest("testSuccess"));
        this._rogueThreadSuite.addTest(new MockTest("testRogueThread"));
        this._failureSuite.addTest(new MockTest("testFailure"));
        this._errorSuite.addTest(new MockTest("testError"));
    }

    public void testOneUser() {
        LoadTest loadTest = new LoadTest(this._successSuite, 1);
        Assert.assertEquals(2, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(2, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testOneUserRogueThread() {
        LoadTest loadTest = new LoadTest(this._rogueThreadSuite, 1);
        Assert.assertEquals(1, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testMultiUser() {
        LoadTest loadTest = new LoadTest(this._successSuite, 3);
        Assert.assertEquals(6, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(6, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testMultiUserWithIterations() {
        LoadTest loadTest = new LoadTest((Test)this._successSuite, 3, 10);
        Assert.assertEquals(60, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(60, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testMultiUserWithRepeatedTest() {
        RepeatedTest repeatedTest = new RepeatedTest(this._successSuite, 10);
        LoadTest loadTest = new LoadTest(repeatedTest, 3);
        Assert.assertEquals(60, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(60, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testMultiUserWithDelay() {
        LoadTest loadTest = new LoadTest((Test)this._successSuite, 3, new ConstantTimer(0L));
        Assert.assertEquals(6, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(6, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testMultiUserWithFailure() {
        LoadTest loadTest = new LoadTest(this._failureSuite, 3);
        Assert.assertEquals(3, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(3, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(3, testResult.failureCount());
    }

    public void testMultiUserWithError() {
        LoadTest loadTest = new LoadTest(this._errorSuite, 3);
        Assert.assertEquals(3, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(3, testResult.runCount());
        Assert.assertEquals(3, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testMultiUserWithStop() {
        LoadTest loadTest = new LoadTest(this._failureSuite, 2);
        Assert.assertEquals(2, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        testResult.stop();
        loadTest.run(testResult);
        Assert.assertEquals(0, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testNonPositiveUser() {
        try {
            LoadTest loadTest = new LoadTest(this._successSuite, 0);
            Assert.fail("Should throw an IllegalArgumentException");
            LoadTest loadTest2 = new LoadTest(this._successSuite, -1);
            Assert.fail("Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void testNullTimer() {
        try {
            LoadTest loadTest = new LoadTest((Test)this._successSuite, 1, null);
            Assert.fail("Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void testAtomic2SecondResponse() {
        MockTest mockTest = new MockTest("testAtomic2SecondResponseWithWorkerThread");
        LoadTest loadTest = new LoadTest(mockTest, 1);
        TimedTest timedTest = new TimedTest(loadTest, 1100L);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public void testAtomic2SecondResponseEnforceTestAtomicity() {
        MockTest mockTest = new MockTest("testAtomic2SecondResponseWithWorkerThread");
        LoadTest loadTest = new LoadTest(mockTest, 1);
        loadTest.setEnforceTestAtomicity(true);
        TimedTest timedTest = new TimedTest(loadTest, 1100L);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testNonAtomic2SecondResponse() {
        MockTest mockTest = new MockTest("testNonAtomic2SecondResponseWithWorkerThread");
        LoadTest loadTest = new LoadTest(mockTest, 1);
        TimedTest timedTest = new TimedTest(loadTest, 1100L);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testNonAtomic2SecondResponseEnforceTestAtomicity() {
        MockTest mockTest = new MockTest("testNonAtomic2SecondResponseWithWorkerThread");
        LoadTest loadTest = new LoadTest(mockTest, 1);
        loadTest.setEnforceTestAtomicity(true);
        TimedTest timedTest = new TimedTest(loadTest, 1100L);
        Assert.assertEquals(1, timedTest.countTestCases());
        TestResult testResult = new TestResult();
        timedTest.run(testResult);
        Assert.assertEquals(1, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(1, testResult.failureCount());
    }

    public void testTestStateConsistencyFailure() {
        MockTestWithState mockTestWithState = new MockTestWithState("testInvariant");
        LoadTest loadTest = new LoadTest((Test)mockTestWithState, 10, 2);
        loadTest.setEnforceTestAtomicity(true);
        Assert.assertEquals(20, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(20, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertTrue(testResult.failureCount() > 0);
    }

    public void testTestStateConsistencyWithTestFactory() {
        TestFactory testFactory = new TestFactory(class$com$clarkware$junitperf$MockTestWithState == null ? (class$com$clarkware$junitperf$MockTestWithState = LoadTestTest.class$("com.clarkware.junitperf.MockTestWithState")) : class$com$clarkware$junitperf$MockTestWithState);
        LoadTest loadTest = new LoadTest((Test)testFactory, 10, 2);
        loadTest.setEnforceTestAtomicity(true);
        Assert.assertEquals(20, loadTest.countTestCases());
        TestResult testResult = new TestResult();
        loadTest.run(testResult);
        Assert.assertEquals(20, testResult.runCount());
        Assert.assertEquals(0, testResult.errorCount());
        Assert.assertEquals(0, testResult.failureCount());
    }

    public static Test suite() {
        return new TestSuite(class$com$clarkware$junitperf$LoadTestTest == null ? (class$com$clarkware$junitperf$LoadTestTest = LoadTestTest.class$("com.clarkware.junitperf.LoadTestTest")) : class$com$clarkware$junitperf$LoadTestTest);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(LoadTestTest.suite());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

