/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.ConstantTimer;
import com.clarkware.junitperf.ThreadBarrier;
import com.clarkware.junitperf.ThreadedTest;
import com.clarkware.junitperf.ThreadedTestGroup;
import com.clarkware.junitperf.Timer;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import junit.framework.TestResult;

public class LoadTest
implements Test {
    private final int _users;
    private final Timer _timer;
    private final ThreadedTest _test;
    private final ThreadedTestGroup _group;
    private final ThreadBarrier _barrier;
    private boolean _enforceTestAtomicity;

    public LoadTest(Test test, int n) {
        this(test, n, new ConstantTimer(0L));
    }

    public LoadTest(Test test, int n, int n2) {
        this(test, n, n2, new ConstantTimer(0L));
    }

    public LoadTest(Test test, int n, int n2, Timer timer) {
        this((Test)new RepeatedTest(test, n2), n, timer);
    }

    public LoadTest(Test test, int n, Timer timer) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of users must be > 0");
        }
        if (timer == null) {
            throw new IllegalArgumentException("Delay timer is null");
        }
        if (test == null) {
            throw new IllegalArgumentException("Decorated test is null");
        }
        this._users = n;
        this._timer = timer;
        this.setEnforceTestAtomicity(false);
        this._barrier = new ThreadBarrier(n);
        this._group = new ThreadedTestGroup(this);
        this._test = new ThreadedTest(test, this._group, this._barrier);
    }

    public void setEnforceTestAtomicity(boolean bl) {
        this._enforceTestAtomicity = bl;
    }

    public int countTestCases() {
        return this._test.countTestCases() * this._users;
    }

    public void run(TestResult testResult) {
        this._group.setTestResult(testResult);
        int n = 0;
        while (n < this._users) {
            if (testResult.shouldStop()) {
                this._barrier.cancelThreads(this._users - n);
                break;
            }
            this._test.run(testResult);
            try {
                Thread.sleep(this.getDelay());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        this.waitForTestCompletion();
        this.cleanup();
    }

    protected void waitForTestCompletion() {
        if (this._enforceTestAtomicity) {
            this.waitForAllThreadsToComplete();
        } else {
            this.waitForThreadedTestThreadsToComplete();
        }
    }

    protected void waitForThreadedTestThreadsToComplete() {
        while (!this._barrier.isReached()) {
            this.sleep(50L);
        }
    }

    protected void waitForAllThreadsToComplete() {
        while (this._group.activeCount() > 0) {
            this.sleep(50L);
        }
    }

    protected void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void cleanup() {
        try {
            this._group.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        if (this._enforceTestAtomicity) {
            return "LoadTest (ATOMIC): " + this._test.toString();
        }
        return "LoadTest (NON-ATOMIC): " + this._test.toString();
    }

    protected long getDelay() {
        return this._timer.getDelay();
    }
}

