/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.jsse;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TxX509TrustManager
implements X509TrustManager {
    protected static final String checkerClass = "sun.security.validator.EndEntityChecker";
    protected static final String checkerMethod = "checkRemainingExtensions";
    protected X509TrustManager sunX509TrustManager;

    public TxX509TrustManager(TrustManagerFactory trustManagerFactory) {
        this.sunX509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.sunX509TrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            this.sunX509TrustManager.checkClientTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            this.handleCertificateException(certificateException);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            this.sunX509TrustManager.checkServerTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            this.handleCertificateException(certificateException);
        }
    }

    protected void handleCertificateException(CertificateException certificateException) throws CertificateException {
        String string = certificateException.getMessage();
        if (string != null) {
            StackTraceElement[] stackTraceElementArray = certificateException.getStackTrace();
            boolean bl = false;
            for (int i = 0; i < stackTraceElementArray.length && !bl; ++i) {
                String string2 = stackTraceElementArray[i].getClassName();
                String string3 = stackTraceElementArray[i].getMethodName();
                bl = string2.equals(checkerClass) && string3.equals(checkerMethod);
            }
            if (!bl) {
                throw certificateException;
            }
        } else {
            throw certificateException;
        }
    }
}

