/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.zain.signupdate.ws.handler.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;

public class CryptoImpl
implements Crypto {
    private KeyStore keystore;
    private String keystorePassword;

    public CryptoImpl(String keystorePath, String keystorePassword, String keystoreType) {
        this.keystore = this.getKeystore(keystorePath, keystorePassword, keystoreType);
        this.keystorePassword = keystorePassword;
    }

    private KeyStore getKeystore(String keystorePath, String keystorePassword, String keystoreType) {
        if (keystorePath == null) {
            return null;
        }
        FileInputStream inputStream = null;
        KeyStore keyStore = null;
        try {
            try {
                inputStream = new FileInputStream(keystorePath);
                String type = keystoreType == null ? "JKS" : keystoreType;
                char[] password = keystorePassword != null ? keystorePassword.toCharArray() : null;
                keyStore = KeyStore.getInstance(type);
                keyStore.load(inputStream, password);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error al cargar el Keystore", e);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (Exception exception) {}
        }
        return keyStore;
    }

    public String getAliasForX509Cert(Certificate certificate) throws WSSecurityException {
        return null;
    }

    public String getAliasForX509Cert(String issuer) throws WSSecurityException {
        return null;
    }

    public String getAliasForX509Cert(byte[] subjectKeyIdentifier) throws WSSecurityException {
        return null;
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws WSSecurityException {
        return null;
    }

    public String getAliasForX509CertThumb(byte[] thumb) throws WSSecurityException {
        return null;
    }

    public String[] getAliasesForDN(String subjectDN) throws WSSecurityException {
        return null;
    }

    public byte[] getCertificateData(boolean reverse, X509Certificate[] x509CertificateArray) throws WSSecurityException {
        return null;
    }

    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        return null;
    }

    public X509Certificate[] getCertificates(String alias) throws WSSecurityException {
        try {
            ArrayList<X509Certificate> x509CertificateList = new ArrayList<X509Certificate>(3);
            Enumeration<String> aliases = this.keystore.aliases();
            while (aliases.hasMoreElements()) {
                String value = aliases.nextElement();
                Certificate certificate = this.keystore.getCertificate(value);
                x509CertificateList.add((X509Certificate)certificate);
            }
            return x509CertificateList.toArray(new X509Certificate[x509CertificateList.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error al cargar los certificados", e);
        }
    }

    public String getDefaultX509Alias() {
        return null;
    }

    public KeyStore getKeyStore() {
        return null;
    }

    public PrivateKey getPrivateKey(String alias, String password) throws Exception {
        Enumeration<String> aliases = this.keystore.aliases();
        char[] clazzPassword = this.keystorePassword.toCharArray();
        while (aliases.hasMoreElements()) {
            String value = aliases.nextElement();
            if (!this.keystore.isKeyEntry(value)) continue;
            return (PrivateKey)this.keystore.getKey(value, clazzPassword);
        }
        return null;
    }

    public byte[] getSKIBytesFromCert(X509Certificate x509Certificate) throws WSSecurityException {
        return null;
    }

    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        return null;
    }

    public X509Certificate loadCertificate(InputStream inputStream) throws WSSecurityException {
        return null;
    }

    public boolean validateCertPath(X509Certificate[] x509CertificateArray) throws WSSecurityException {
        return false;
    }
}

