/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.zain.signupdate.ws.handler;

import com.izenpe.zain.signupdate.ws.handler.WSSHeader;
import com.izenpe.zain.signupdate.wss.UsernameTokenHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.soap.SOAPException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WssUsernameTokenHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            ((SOAPPart)msgContext.getRequestMessage().getSOAPPart()).setCurrentMessage((Object)this.createUserNameToken(msgContext), 3);
        }
        catch (Exception e) {
            throw new RuntimeException("Ha ocurrido una excepcion al crear la cabecera WS-Security", e);
        }
    }

    private SOAPEnvelope createUserNameToken(MessageContext msgContext) throws SOAPException, Exception {
        UsernameTokenHeader smartHeader = WSSHeader.getUsernameTokenHeader();
        Message msg = msgContext.getCurrentMessage();
        Document soapEnvelopeRequest = ((SOAPEnvelope)msg.getSOAPPart().getEnvelope()).getAsDocument();
        WSSecHeader wsSecHeader = new WSSecHeader();
        wsSecHeader.setMustUnderstand(false);
        WSSecUsernameToken wsSecUsernameToken = new WSSecUsernameToken();
        wsSecUsernameToken.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        wsSecUsernameToken.addCreated();
        if (smartHeader.getUsername() == null || "".equals(smartHeader.getUsername())) {
            throw new RuntimeException("null username");
        }
        if (smartHeader.getPassword() == null || "".equals(smartHeader.getPassword())) {
            throw new RuntimeException("null password");
        }
        wsSecUsernameToken.setUserInfo(smartHeader.getUsername(), smartHeader.getPassword());
        wsSecHeader.insertSecurityHeader(soapEnvelopeRequest);
        Document soapEnvelopeRequestUserNameToken = wsSecUsernameToken.build(soapEnvelopeRequest, wsSecHeader);
        Element element = soapEnvelopeRequestUserNameToken.getDocumentElement();
        DOMSource source = new DOMSource(element);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        TransformerFactory.newInstance().newTransformer().transform(source, streamResult);
        String secSOAPReq = new String(baos.toByteArray());
        Message axisMessage = this.getAxisMessage(secSOAPReq, msgContext);
        SOAPEnvelope soapEnvelope = axisMessage.getSOAPEnvelope();
        return soapEnvelope;
    }

    private Message getAxisMessage(String soapEnvelope, MessageContext msgContext) {
        ByteArrayInputStream inStream = new ByteArrayInputStream(soapEnvelope.getBytes());
        Message axisMessage = new Message((Object)inStream);
        axisMessage.setMessageContext(msgContext);
        return axisMessage;
    }
}

