/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.zain.signupdate.ws;

import com.izenpe.zain.client.SignUpdateConfig;
import com.izenpe.zain.signupdate.ws.SignUpdateWSI;
import com.izenpe.zain.signupdate.ws.SignUpdateWSLocator;
import com.izenpe.zain.signupdate.wss.UsernameTokenHeader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Properties;
import javax.xml.rpc.ServiceException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.XMLStringProvider;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignRequest;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.VerifyResponse;

public class ClientWS
implements SignUpdateWSI {
    private static final String PLANTILLA_SSL_WSDD;
    private static final String PLANTILLA_WSS_WSDD;
    private static final String TRUSTSTORE_TYPE = "JKS";
    private static final Properties PROPERTIES;
    private String endPoint;
    private UsernameTokenHeader header;

    static {
        try {
            PLANTILLA_SSL_WSDD = ClientWS.toString(ClientWS.class.getClassLoader().getResourceAsStream("ssl-client-config.wsdd"));
            PLANTILLA_WSS_WSDD = ClientWS.toString(ClientWS.class.getClassLoader().getResourceAsStream("wss-client-config.wsdd"));
        }
        catch (Exception e) {
            throw new RuntimeException("Error al cargar las plantillas de configuracion de Axis", e);
        }
        PROPERTIES = ClientWS.initProperties();
    }

    private static Properties initProperties() {
        SignUpdateConfig config = SignUpdateConfig.getCurrent();
        if (config == null) {
            Properties properties = new Properties();
            try {
                Class<ClientWS> clazz = ClientWS.class;
                ClassLoader classLoader = clazz.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream("smartwrapper.properties");
                properties.load(inputStream);
                inputStream.close();
            }
            catch (Exception e) {
                SignUpdateConfig.removeCurrent();
                throw new RuntimeException("No se pueden leer el fichero de propiedades");
            }
            return properties;
        }
        return null;
    }

    public ClientWS(String endPoint, UsernameTokenHeader header) {
        this.endPoint = endPoint;
        this.header = header;
    }

    private SignUpdateWSI getSignUpdateWSI(SignRequest signRequest) throws IOException, ServiceException {
        EngineConfiguration engine = null;
        engine = this.header != null ? this.getWssEngineConfig() : this.getSslEngineConfig();
        SignUpdateWSLocator signUpdateWSLocator = new SignUpdateWSLocator(engine);
        signUpdateWSLocator.setSignUpdateWSPortEndpointAddress(this.endPoint);
        SignUpdateWSI signUpdateWSPort = signUpdateWSLocator.getSignUpdateWSPort();
        return signUpdateWSPort;
    }

    @Override
    public VerifyResponse signUpdateXL(SignRequest signRequest) throws RemoteException {
        SignUpdateWSI signUpdateWSI = null;
        try {
            signUpdateWSI = this.getSignUpdateWSI(signRequest);
        }
        catch (Exception e) {
            throw new RuntimeException("Error en la operacion 'signUpdateXL'", e);
        }
        return signUpdateWSI.signUpdateXL(signRequest);
    }

    private EngineConfiguration getSslEngineConfig() throws IOException {
        String proxyPassword;
        SignUpdateConfig config = SignUpdateConfig.getCurrent();
        String truststoreActive = config == null ? PROPERTIES.getProperty("Truststore.active") : Boolean.toString(config.isTruststoreActive());
        String truststorePath = config == null ? PROPERTIES.getProperty("Truststore.path") : config.getTruststorePath();
        String truststorePass = config == null ? PROPERTIES.getProperty("Truststore.password") : config.getTruststorePassword();
        String keystoreActive = config == null ? PROPERTIES.getProperty("Keystore.active") : Boolean.toString(config.isKeystoreActive());
        String keystorePath = config == null ? PROPERTIES.getProperty("Keystore.path") : config.getKeystorePath();
        String keystorePass = config == null ? PROPERTIES.getProperty("Keystore.password") : config.getKeystorePassword();
        String keyStoreType = config == null ? PROPERTIES.getProperty("Keystore.type") : config.getKeystoreType();
        String proxyActive = config == null ? PROPERTIES.getProperty("Proxy.active") : Boolean.toString(config.isProxyActive());
        String proxyHost = config == null ? PROPERTIES.getProperty("Proxy.host") : config.getProxyHost();
        String proxyPort = config == null ? PROPERTIES.getProperty("Proxy.port") : config.getProxyPort();
        String proxyUser = config == null ? PROPERTIES.getProperty("Proxy.username") : config.getProxyUsername();
        String string = proxyPassword = config == null ? PROPERTIES.getProperty("Proxy.password") : config.getProxyPassword();
        String timeout = config == null ? PROPERTIES.getProperty("Timeout") : (config.getTimeout() == null ? "999999" : config.getTimeout());
        String requestActive = config == null ? PROPERTIES.getProperty("req-log.active") : Boolean.toString(config.isRequestLogActive());
        String requestPath = config == null ? PROPERTIES.getProperty("req-log.savePath") : config.getRequestLogSavePath();
        String responseActive = config == null ? PROPERTIES.getProperty("res-log.active") : Boolean.toString(config.isResponseLogActive());
        String responsePath = config == null ? PROPERTIES.getProperty("res-log.savePath") : config.getResponseLogSavePath();
        String wsdd = MessageFormat.format(PLANTILLA_SSL_WSDD, truststoreActive, truststorePath, truststorePass, TRUSTSTORE_TYPE, keystoreActive, keystorePath, keystorePass, keyStoreType, proxyActive, proxyHost, proxyPort, proxyUser, proxyPassword, timeout, requestActive, requestPath, responseActive, responsePath);
        return new XMLStringProvider(wsdd);
    }

    private EngineConfiguration getWssEngineConfig() throws IOException {
        String proxyPassword;
        SignUpdateConfig config = SignUpdateConfig.getCurrent();
        String truststoreActive = config == null ? PROPERTIES.getProperty("Truststore.active") : Boolean.toString(config.isTruststoreActive());
        String truststorePath = config == null ? PROPERTIES.getProperty("Truststore.path") : config.getTruststorePath();
        String truststorePass = config == null ? PROPERTIES.getProperty("Truststore.password") : config.getTruststorePassword();
        String proxyActive = config == null ? PROPERTIES.getProperty("Proxy.active") : Boolean.toString(config.isProxyActive());
        String proxyHost = config == null ? PROPERTIES.getProperty("Proxy.host") : config.getProxyHost();
        String proxyPort = config == null ? PROPERTIES.getProperty("Proxy.port") : config.getProxyPort();
        String proxyUser = config == null ? PROPERTIES.getProperty("Proxy.username") : config.getProxyUsername();
        String string = proxyPassword = config == null ? PROPERTIES.getProperty("Proxy.password") : config.getProxyPassword();
        String timeout = config == null ? PROPERTIES.getProperty("Timeout") : (config.getTimeout() == null ? "999999" : config.getTimeout());
        String requestActive = config == null ? PROPERTIES.getProperty("req-log.active") : Boolean.toString(config.isRequestLogActive());
        String requestPath = config == null ? PROPERTIES.getProperty("req-log.savePath") : config.getRequestLogSavePath();
        String responseActive = config == null ? PROPERTIES.getProperty("res-log.active") : Boolean.toString(config.isResponseLogActive());
        String responsePath = config == null ? PROPERTIES.getProperty("res-log.savePath") : config.getResponseLogSavePath();
        String wsdd = MessageFormat.format(PLANTILLA_WSS_WSDD, truststoreActive, truststorePath, truststorePass, TRUSTSTORE_TYPE, proxyActive, proxyHost, proxyPort, proxyUser, proxyPassword, timeout, requestActive, requestPath, responseActive, responsePath);
        return new XMLStringProvider(wsdd);
    }

    public static String toString(InputStream is) throws IOException {
        InputStreamReader fileReader = new InputStreamReader(is);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String currentLine = bufferedReader.readLine();
        StringBuffer sb = new StringBuffer();
        while (currentLine != null) {
            sb.append(currentLine);
            currentLine = bufferedReader.readLine();
        }
        return sb.toString();
    }
}

