/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.zain.signupdate;

import assertion._0._1.SAML.tc.names.oasis.NameIdentifierType;
import com.izenpe.zain.signupdate.SignupdateResponse;
import com.izenpe.zain.signupdate.constants.Language;
import com.izenpe.zain.signupdate.constants.SignaturePlacement;
import com.izenpe.zain.signupdate.constants.SignatureProfile;
import com.izenpe.zain.signupdate.constants.XPathPosition;
import com.izenpe.zain.signupdate.utils.KeySelectorUtils;
import com.izenpe.zain.signupdate.utils.OptionalInputsUtils;
import com.izenpe.zain.signupdate.utils.SignRequestUtils;
import com.izenpe.zain.signupdate.ws.ClientWS;
import com.izenpe.zain.signupdate.ws.handler.WSSHeader;
import com.izenpe.zain.signupdate.wss.UsernameTokenHeader;
import com.safelayer.www.TWS.ArchiveTimeStampValues;
import com.safelayer.www.TWS.Base64Binary;
import com.safelayer.www.TWS.CanonicalizationMethod;
import com.safelayer.www.TWS.CertificateListType;
import com.safelayer.www.TWS.CertificateType;
import com.safelayer.www.TWS.CertificateValuesType;
import com.safelayer.www.TWS.ExcludeChainCertificates;
import com.safelayer.www.TWS.ExtendedSignaturePlacement;
import com.safelayer.www.TWS.KeySelector;
import com.safelayer.www.TWS.NewArchiveTimeStampValues;
import com.safelayer.www.TWS.NewXType1TimeStampValues;
import com.safelayer.www.TWS.Policies;
import com.safelayer.www.TWS.PropertyType;
import com.safelayer.www.TWS.SignatureFormType;
import com.safelayer.www.TWS.SignatureResultType;
import com.safelayer.www.TWS.TimeStampValueType;
import com.safelayer.www.TWS.TimeStampValues;
import com.safelayer.www.TWS.XType1TimeStampValues;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.AnyType;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Base64Data;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Base64Signature;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Document;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.DocumentWithSignature;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.EnvelopingSignature;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.InputDocuments;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.InternationalStringType;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalOutputs;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Properties;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.PropertiesType;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Property;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Result;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignRequest;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignatureObject;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.TstInfo;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.UpdatedSignature;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.VerifyResponse;
import org.w3c.dom.Element;

public final class SignupdateRequestSender
extends WSSHeader {
    private static final String DEFAULT_KEY_USAGE = "digitalSignature";
    private static final String DEFAULT_KEY_NAME = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
    private static final String PROPERTY_PDF_ATTRIBUTES = "urn:safelayer:tws:dss:1.0:property:pdfattributes";
    private static final String PROPERTY_POLICIES = "urn:safelayer:tws:dss:1.0:property:policies";
    private String endPoint = null;
    private Language language = null;
    private String inputRefUri = "urn:detached";
    private String signPropertyPolicy = null;
    private byte[] signatureDocumentBytes = null;
    private SignaturePlacement signaturePlacement = null;
    private SignatureProfile signatureProfile = null;
    private String xmlEnvelopeXPath = null;
    private String zainSigner = null;
    private XPathPosition xPathPosition = null;
    private String pdfTemplate = null;

    public static SignupdateRequestSender getSender() {
        return new SignupdateRequestSender();
    }

    private SignupdateRequestSender() {
    }

    public SignupdateRequestSender setEndpoint(String endPoint) {
        this.endPoint = endPoint;
        return this;
    }

    public SignupdateRequestSender setLanguage(Language language) {
        this.language = language;
        return this;
    }

    public SignupdateRequestSender setInputRefUri(String inputRefUri) {
        this.inputRefUri = inputRefUri;
        return this;
    }

    public SignupdateRequestSender setSignPropertyPolicy(String signPropertyPolicy) {
        this.signPropertyPolicy = signPropertyPolicy;
        return this;
    }

    public SignupdateRequestSender setSignatureDocumentBytes(byte[] signatureDocumentBytes) {
        this.signatureDocumentBytes = signatureDocumentBytes;
        return this;
    }

    public SignupdateRequestSender setSignaturePlacement(SignaturePlacement signaturePlacement) {
        this.signaturePlacement = signaturePlacement;
        return this;
    }

    public SignupdateRequestSender setSignatureProfile(SignatureProfile signatureProfile) {
        this.signatureProfile = signatureProfile;
        return this;
    }

    public SignupdateRequestSender setXmlEnvelopedXPathPosition(String xmlEnvelopeXPath, XPathPosition xPathPosition) {
        this.xmlEnvelopeXPath = xmlEnvelopeXPath;
        this.xPathPosition = xPathPosition;
        return this;
    }

    public SignupdateRequestSender setZainSigner(String zainSigner) {
        this.zainSigner = zainSigner;
        return this;
    }

    public SignupdateRequestSender setPdfTemplate(String pdfTemplate) {
        this.pdfTemplate = pdfTemplate;
        return this;
    }

    public SignupdateRequestSender setUsernameTokenHeader(UsernameTokenHeader header) {
        WSSHeader.header = header;
        return this;
    }

    public SignupdateResponse sendRequest() {
        SignRequest signRequest = this.createSignRequest();
        ClientWS clienteWS = new ClientWS(this.endPoint, WSSHeader.header);
        try {
            VerifyResponse verifyResponse = clienteWS.signUpdateXL(signRequest);
            String profile = signRequest.getProfile().toString();
            SignupdateResponse signupdateResponse = this.parseVerifyResponse(profile, verifyResponse);
            return signupdateResponse;
        }
        catch (RemoteException e) {
            throw new RuntimeException("Error al realizar la llamada al servicio Web", e);
        }
    }

    private SignRequest createSignRequest() {
        if (this.signatureProfile == null) {
            throw new IllegalArgumentException("null signature profile");
        }
        switch (this.signatureProfile) {
            case CMSPKCS7: {
                return this.cmspkcs7SignRequest();
            }
            case PADES: {
                return this.padesSignRequest();
            }
            case XADES: {
                return this.xadesSignRequest();
            }
            case XADES_EPES: {
                return this.xadesEpesSignRequest();
            }
        }
        throw new IllegalArgumentException("invalid signature profile: " + (Object)((Object)this.signatureProfile));
    }

    private SignRequest cmspkcs7SignRequest() {
        SignRequest signRequest = new SignRequest();
        OptionalInputs optionalInputs = SignRequestUtils.getInstance().getOptionalInputs(signRequest);
        InputDocuments inputDocuments = SignRequestUtils.getInstance().getInputDocuments(signRequest);
        if (this.signatureProfile == null) {
            throw new IllegalArgumentException("null signature profile");
        }
        try {
            signRequest.setProfile(new URI(this.signatureProfile.getValue()));
        }
        catch (URI.MalformedURIException e) {
            throw new IllegalArgumentException("profile malformed");
        }
        try {
            optionalInputs.setSignatureType(new URI(SignatureType.CADES.getValue()));
        }
        catch (URI.MalformedURIException e) {
            // empty catch block
        }
        optionalInputs.setSignatureForm(SignatureFormType.value2);
        optionalInputs.setEnvelopingSignature(new EnvelopingSignature());
        if (this.signPropertyPolicy != null) {
            throw new IllegalArgumentException("parameter 'signPropertyPolicy' not supported");
        }
        if (this.pdfTemplate != null) {
            throw new IllegalArgumentException("parameter 'pdfTemplate' not supported");
        }
        if (this.language == null) {
            throw new IllegalArgumentException("null language");
        }
        optionalInputs.setLanguage(new org.apache.axis.types.Language(this.language.getValue()));
        Document document = new Document();
        Base64Data base64Data = new Base64Data();
        base64Data.set_value(this.signatureDocumentBytes);
        document.setBase64Data(base64Data);
        inputDocuments.setDocument(document);
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector oasisKeySelector = OptionalInputsUtils.getInstance().getKeySelector(optionalInputs);
        KeySelector safelayerKeySelector = KeySelectorUtils.getInstance().getKeySelector(oasisKeySelector);
        String keyUsage = safelayerKeySelector.getKeyUsage();
        if (keyUsage == null) {
            safelayerKeySelector.setKeyUsage(DEFAULT_KEY_USAGE);
        }
        if (this.zainSigner != null) {
            NameIdentifierType nameIdentifierType = new NameIdentifierType();
            try {
                nameIdentifierType.setFormat(new URI(DEFAULT_KEY_NAME));
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            nameIdentifierType.set_value(this.zainSigner);
            safelayerKeySelector.setName(nameIdentifierType);
        }
        return signRequest;
    }

    private SignRequest padesSignRequest() {
        SignRequest signRequest = new SignRequest();
        OptionalInputs optionalInputs = SignRequestUtils.getInstance().getOptionalInputs(signRequest);
        InputDocuments inputDocuments = SignRequestUtils.getInstance().getInputDocuments(signRequest);
        if (this.signatureProfile == null) {
            throw new IllegalArgumentException("null signature profile");
        }
        try {
            signRequest.setProfile(new URI(this.signatureProfile.getValue()));
        }
        catch (URI.MalformedURIException e) {
            throw new IllegalArgumentException("profile malformed");
        }
        optionalInputs.setEnvelopingSignature(null);
        optionalInputs.setExcludeChainCertificates(null);
        try {
            optionalInputs.setSignatureType(new URI(SignatureType.PADES_PART3.getValue()));
        }
        catch (URI.MalformedURIException e) {
            // empty catch block
        }
        optionalInputs.setSignatureForm(SignatureFormType.value2);
        if (this.signPropertyPolicy != null) {
            throw new IllegalArgumentException("parameter 'signPropertyPolicy' not supported");
        }
        if (this.language == null) {
            throw new IllegalArgumentException("null language");
        }
        optionalInputs.setLanguage(new org.apache.axis.types.Language(this.language.getValue()));
        if (this.pdfTemplate != null) {
            try {
                Properties props = new Properties();
                PropertiesType signedProp = new PropertiesType();
                Property prop = new Property();
                prop.setIdentifier(new URI(PROPERTY_PDF_ATTRIBUTES));
                FileInputStream plantillaPdf = new FileInputStream(this.pdfTemplate);
                org.w3c.dom.Document document = XMLUtils.newDocument((InputStream)plantillaPdf);
                MessageElement messageElement = new MessageElement(document.getDocumentElement());
                AnyType XMLData = new AnyType(new MessageElement[]{messageElement});
                prop.setValue(XMLData);
                signedProp.setProperty(new Property[]{prop});
                props.setSignedProperties(signedProp);
                optionalInputs.setProperties(props);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("pdfTemplate error");
            }
        }
        Document document = new Document();
        Base64Data base64Data = new Base64Data();
        base64Data.set_value(this.signatureDocumentBytes);
        base64Data.setMimeType("application/pdf");
        document.setBase64Data(base64Data);
        inputDocuments.setDocument(document);
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector oasisKeySelector = OptionalInputsUtils.getInstance().getKeySelector(optionalInputs);
        KeySelector safelayerKeySelector = KeySelectorUtils.getInstance().getKeySelector(oasisKeySelector);
        String keyUsage = safelayerKeySelector.getKeyUsage();
        if (keyUsage == null) {
            safelayerKeySelector.setKeyUsage(DEFAULT_KEY_USAGE);
        }
        if (this.zainSigner != null) {
            NameIdentifierType nameIdentifierType = new NameIdentifierType();
            try {
                nameIdentifierType.setFormat(new URI(DEFAULT_KEY_NAME));
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            nameIdentifierType.set_value(this.zainSigner);
            safelayerKeySelector.setName(nameIdentifierType);
        }
        return signRequest;
    }

    private SignRequest xadesSignRequest() {
        SignRequest signRequest = new SignRequest();
        OptionalInputs optionalInputs = SignRequestUtils.getInstance().getOptionalInputs(signRequest);
        InputDocuments inputDocuments = SignRequestUtils.getInstance().getInputDocuments(signRequest);
        if (this.signatureProfile == null) {
            throw new IllegalArgumentException("null signature profile");
        }
        try {
            signRequest.setProfile(new URI(this.signatureProfile.getValue()));
        }
        catch (URI.MalformedURIException e) {
            throw new IllegalArgumentException("profile malformed");
        }
        if (this.signaturePlacement == null) {
            throw new IllegalArgumentException("Null signature placement");
        }
        switch (this.signaturePlacement) {
            case DETACHED: {
                optionalInputs.setSignaturePlacement(null);
                optionalInputs.setEnvelopingSignature(null);
                break;
            }
            case ENVELOPED: {
                if (this.xPathPosition == null) {
                    throw new IllegalArgumentException("Null XPath position");
                }
                switch (this.xPathPosition) {
                    case AFTER: {
                        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignaturePlacement signaturePlacement = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignaturePlacement();
                        signaturePlacement.setXPathAfter(this.xmlEnvelopeXPath);
                        optionalInputs.setSignaturePlacement(signaturePlacement);
                        break;
                    }
                    case BEFORE: {
                        ExtendedSignaturePlacement extendedSignaturePlacement = new ExtendedSignaturePlacement();
                        extendedSignaturePlacement.setXPathBefore(this.xmlEnvelopeXPath);
                        optionalInputs.setExtendedSignaturePlacement(extendedSignaturePlacement);
                        break;
                    }
                    case FIRST_CHILD: {
                        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignaturePlacement signaturePlacement = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignaturePlacement();
                        signaturePlacement.setXPathFirstChildOf(this.xmlEnvelopeXPath);
                        optionalInputs.setSignaturePlacement(signaturePlacement);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal Xpath position: " + (Object)((Object)this.xPathPosition));
                    }
                }
                optionalInputs.setEnvelopingSignature(null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid signature placement: " + (Object)((Object)this.signaturePlacement));
            }
        }
        optionalInputs.setCanonicalizationMethod(CanonicalizationMethod.value3);
        optionalInputs.setSimpleXMLDSig(null);
        optionalInputs.setIncludeDataObjectFormat(null);
        optionalInputs.setReturnBase64XML((Object)"");
        optionalInputs.setCounterSignature(null);
        optionalInputs.setExcludeChainCertificates(new ExcludeChainCertificates());
        try {
            optionalInputs.setSignatureType(new URI(SignatureType.XADES.getValue()));
        }
        catch (URI.MalformedURIException signaturePlacement) {
            // empty catch block
        }
        optionalInputs.setSignatureForm(SignatureFormType.value2);
        if (this.pdfTemplate != null) {
            throw new IllegalArgumentException("parameter 'pdfTemplate' not supported");
        }
        if (this.language == null) {
            throw new IllegalArgumentException("null language");
        }
        optionalInputs.setLanguage(new org.apache.axis.types.Language(this.language.getValue()));
        Document document = new Document();
        if (SignaturePlacement.DETACHED.equals((Object)this.signaturePlacement)) {
            Base64Data base64Data = new Base64Data();
            base64Data.set_value(this.signatureDocumentBytes);
            document.setBase64Data(base64Data);
            document.setRefURI(this.inputRefUri);
        } else if (SignaturePlacement.ENVELOPED.equals((Object)this.signaturePlacement)) {
            document.setBase64XML(this.signatureDocumentBytes);
        }
        inputDocuments.setDocument(document);
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector oasisKeySelector = OptionalInputsUtils.getInstance().getKeySelector(optionalInputs);
        KeySelector safelayerKeySelector = KeySelectorUtils.getInstance().getKeySelector(oasisKeySelector);
        String keyUsage = safelayerKeySelector.getKeyUsage();
        if (keyUsage == null) {
            safelayerKeySelector.setKeyUsage(DEFAULT_KEY_USAGE);
        }
        if (this.zainSigner != null) {
            NameIdentifierType nameIdentifierType = new NameIdentifierType();
            try {
                nameIdentifierType.setFormat(new URI(DEFAULT_KEY_NAME));
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            nameIdentifierType.set_value(this.zainSigner);
            safelayerKeySelector.setName(nameIdentifierType);
        }
        return signRequest;
    }

    private SignRequest xadesEpesSignRequest() {
        SignRequest signRequest = new SignRequest();
        OptionalInputs optionalInputs = SignRequestUtils.getInstance().getOptionalInputs(signRequest);
        InputDocuments inputDocuments = SignRequestUtils.getInstance().getInputDocuments(signRequest);
        if (this.signatureProfile == null) {
            throw new IllegalArgumentException("null signature profile");
        }
        try {
            signRequest.setProfile(new URI(this.signatureProfile.getValue()));
        }
        catch (URI.MalformedURIException e) {
            throw new IllegalArgumentException("profile malformed");
        }
        if (this.signaturePlacement == null) {
            throw new IllegalArgumentException("Null signature placement");
        }
        switch (this.signaturePlacement) {
            case DETACHED: {
                optionalInputs.setSignaturePlacement(null);
                optionalInputs.setEnvelopingSignature(null);
                break;
            }
            case ENVELOPED: {
                if (this.xPathPosition == null) {
                    throw new IllegalArgumentException("Null XPath position");
                }
                switch (this.xPathPosition) {
                    case AFTER: {
                        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignaturePlacement signaturePlacement = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignaturePlacement();
                        signaturePlacement.setXPathAfter(this.xmlEnvelopeXPath);
                        optionalInputs.setSignaturePlacement(signaturePlacement);
                        break;
                    }
                    case BEFORE: {
                        ExtendedSignaturePlacement extendedSignaturePlacement = new ExtendedSignaturePlacement();
                        extendedSignaturePlacement.setXPathBefore(this.xmlEnvelopeXPath);
                        optionalInputs.setExtendedSignaturePlacement(extendedSignaturePlacement);
                        break;
                    }
                    case FIRST_CHILD: {
                        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignaturePlacement signaturePlacement = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignaturePlacement();
                        signaturePlacement.setXPathFirstChildOf(this.xmlEnvelopeXPath);
                        optionalInputs.setSignaturePlacement(signaturePlacement);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal Xpath position: " + (Object)((Object)this.xPathPosition));
                    }
                }
                optionalInputs.setEnvelopingSignature(null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid signature placement: " + (Object)((Object)this.signaturePlacement));
            }
        }
        optionalInputs.setCanonicalizationMethod(CanonicalizationMethod.value3);
        optionalInputs.setSimpleXMLDSig(null);
        optionalInputs.setIncludeDataObjectFormat(null);
        optionalInputs.setReturnBase64XML((Object)"");
        optionalInputs.setCounterSignature(null);
        optionalInputs.setExcludeChainCertificates(new ExcludeChainCertificates());
        try {
            optionalInputs.setSignatureType(new URI(SignatureType.XADES.getValue()));
        }
        catch (URI.MalformedURIException signaturePlacement) {
            // empty catch block
        }
        optionalInputs.setSignatureForm(SignatureFormType.value2);
        if (this.signPropertyPolicy != null) {
            try {
                Properties props = new Properties();
                PropertiesType signedProp = new PropertiesType();
                Property prop = new Property();
                prop.setIdentifier(new URI(PROPERTY_POLICIES));
                PropertyType policy = new PropertyType();
                policy.setUri(this.signPropertyPolicy);
                Policies policies = new Policies();
                policies.setPolicy(new PropertyType[]{policy});
                AnyType anyType = new AnyType(new MessageElement[]{new MessageElement(new QName("http://www.safelayer.com/TWS", ">Policies"), (Object)policies)});
                prop.setValue(anyType);
                signedProp.setProperty(new Property[]{prop});
                props.setSignedProperties(signedProp);
                optionalInputs.setProperties(props);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("signPropertyPolicy error");
            }
        }
        if (this.pdfTemplate != null) {
            throw new IllegalArgumentException("parameter 'pdfTemplate' not supported");
        }
        if (this.language == null) {
            throw new IllegalArgumentException("null language");
        }
        optionalInputs.setLanguage(new org.apache.axis.types.Language(this.language.getValue()));
        Document document = new Document();
        if (SignaturePlacement.DETACHED.equals((Object)this.signaturePlacement)) {
            Base64Data base64Data = new Base64Data();
            base64Data.set_value(this.signatureDocumentBytes);
            document.setBase64Data(base64Data);
            document.setRefURI(this.inputRefUri);
        } else if (SignaturePlacement.ENVELOPED.equals((Object)this.signaturePlacement)) {
            document.setBase64XML(this.signatureDocumentBytes);
        }
        inputDocuments.setDocument(document);
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector oasisKeySelector = OptionalInputsUtils.getInstance().getKeySelector(optionalInputs);
        KeySelector safelayerKeySelector = KeySelectorUtils.getInstance().getKeySelector(oasisKeySelector);
        String keyUsage = safelayerKeySelector.getKeyUsage();
        if (keyUsage == null) {
            safelayerKeySelector.setKeyUsage(DEFAULT_KEY_USAGE);
        }
        if (this.zainSigner != null) {
            NameIdentifierType nameIdentifierType = new NameIdentifierType();
            try {
                nameIdentifierType.setFormat(new URI(DEFAULT_KEY_NAME));
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            nameIdentifierType.set_value(this.zainSigner);
            safelayerKeySelector.setName(nameIdentifierType);
        }
        return signRequest;
    }

    private SignupdateResponse parseVerifyResponse(String profile, VerifyResponse verifyResponse) {
        SignupdateResponse signupdateResponse = new SignupdateResponse();
        try {
            Result result = verifyResponse.getResult();
            OptionalOutputs optionalOutputs = verifyResponse.getOptionalOutputs();
            this.processResult(signupdateResponse, result);
            if (signupdateResponse.isValid()) {
                this.processSignature(signupdateResponse, profile, verifyResponse);
                this.processCertificate(signupdateResponse, optionalOutputs);
                this.processTimestamp(signupdateResponse, optionalOutputs);
                this.processOptionalOutputs(signupdateResponse, optionalOutputs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signupdateResponse;
    }

    private void processResult(SignupdateResponse signupdateResponse, Result result) {
        String resultMajor = result == null ? null : result.getResultMajor().toString();
        String resultMinor = result == null ? null : result.getResultMinor().toString();
        InternationalStringType resultMessage = result == null ? null : result.getResultMessage();
        String resultMessageValue = resultMessage == null ? null : resultMessage.get_value();
        signupdateResponse.setResultMajor(resultMajor);
        signupdateResponse.setResultMinor(resultMinor);
        signupdateResponse.setResultMessage(resultMessageValue);
    }

    private void processSignature(SignupdateResponse signupdateResponse, String profile, VerifyResponse verifyResponse) throws Exception {
        if (SignatureProfile.PADES.getValue().equals(profile)) {
            OptionalOutputs optionalOutputs = verifyResponse == null ? null : verifyResponse.getOptionalOutputs();
            DocumentWithSignature documentWithSignature = optionalOutputs == null ? null : optionalOutputs.getDocumentWithSignature();
            AnyType xmlData = documentWithSignature == null ? null : documentWithSignature.getXMLData();
            MessageElement[] anyXmlData = xmlData == null ? null : xmlData.get_any();
            MessageElement base64Data = anyXmlData == null || anyXmlData.length == 0 ? null : anyXmlData[0];
            byte[] buff = base64Data == null ? null : Base64.decode((String)base64Data.getValue());
            signupdateResponse.setSignature(buff);
        } else if (SignatureProfile.CMSPKCS7.getValue().equals(profile)) {
            OptionalOutputs optionalOutputs = verifyResponse == null ? null : verifyResponse.getOptionalOutputs();
            UpdatedSignature updatedSignature = optionalOutputs == null ? null : optionalOutputs.getUpdatedSignature();
            SignatureObject signatureObject = updatedSignature == null ? null : updatedSignature.getSignatureObject();
            Base64Signature base64Signature = signatureObject == null ? null : signatureObject.getBase64Signature();
            byte[] value = base64Signature == null ? null : base64Signature.get_value();
            signupdateResponse.setSignature(value);
        } else if (SignatureProfile.XADES.getValue().equals(profile)) {
            UpdatedSignature updatedSignature;
            OptionalOutputs optionalOutputs = verifyResponse == null ? null : verifyResponse.getOptionalOutputs();
            UpdatedSignature updatedSignature2 = updatedSignature = optionalOutputs == null ? null : optionalOutputs.getUpdatedSignature();
            if (updatedSignature != null) {
                SignatureObject signatureObject = updatedSignature == null ? null : updatedSignature.getSignatureObject();
                Base64Binary base64xmlSignature = signatureObject == null ? null : signatureObject.getBase64XMLSignature();
                byte[] value = base64xmlSignature == null ? null : base64xmlSignature.get_value();
                signupdateResponse.setSignature(value);
            } else {
                DocumentWithSignature documentWithSignature = optionalOutputs == null ? null : optionalOutputs.getDocumentWithSignature();
                byte[] value = documentWithSignature == null ? null : documentWithSignature.getBase64XML();
                signupdateResponse.setSignature(value);
            }
        }
    }

    private Element getCertificateValue(OptionalOutputs optionalOutputs) {
        CertificateValuesType certificateValues = optionalOutputs == null ? null : optionalOutputs.getCertificateValues();
        CertificateListType certificates = certificateValues == null ? null : certificateValues.getCertificateList();
        CertificateType[] certificateList = certificates == null ? null : certificates.getCertificate();
        CertificateType certificateType = certificateList == null ? null : certificateList[0];
        MessageElement anyCertificateType = certificateType == null ? null : certificateType.get_any()[0];
        return anyCertificateType;
    }

    private org.w3c.dom.Document parseCertificate(Element certificate) throws Exception {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndenting(false);
        outputFormat.setOmitXMLDeclaration(true);
        outputFormat.setEncoding("UTF-8");
        XMLSerializer xmlSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
        xmlSerializer.setNamespaces(true);
        DOMSerializer domSerializer = xmlSerializer.asDOMSerializer();
        domSerializer.serialize(certificate);
        String certificateString = this.replaceAll(stringWriter.toString());
        byte[] certificateBytes = certificateString.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateBytes);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        org.w3c.dom.Document document = documentBuilder.parse(inputStream);
        return document;
    }

    private void processCertificate(SignupdateResponse signupdateResponse, OptionalOutputs optionalOutputs) throws Exception {
        Element certificateValue = null;
        org.w3c.dom.Document[] certificates = null;
        if (optionalOutputs.getMultiSignatureResult() == null) {
            certificateValue = this.getCertificateValue(optionalOutputs);
            certificates = new org.w3c.dom.Document[]{this.parseCertificate(certificateValue)};
        } else {
            SignatureResultType[] signatureResult = optionalOutputs.getMultiSignatureResult().getSignatureResult();
            certificates = new org.w3c.dom.Document[signatureResult.length];
            int i = 0;
            while (i < signatureResult.length) {
                certificateValue = this.getCertificateValue(signatureResult[i].getOptionalOutputs());
                certificates[i] = this.parseCertificate(certificateValue);
                ++i;
            }
        }
        signupdateResponse.setCertificates(certificates);
    }

    private void processTimestamp(SignupdateResponse signupdateResponse, OptionalOutputs optionalOutputs) {
        TimeStampValueType timeStampValueType = this.getTimeStampValue(optionalOutputs);
        TstInfo tstInfo = timeStampValueType == null ? null : timeStampValueType.getTstInfo();
        Calendar creationTime = tstInfo == null ? null : tstInfo.getCreationTime();
        Date date = creationTime == null ? null : creationTime.getTime();
        signupdateResponse.setTimestampDate(date);
    }

    private TimeStampValueType getTimestamp(OptionalOutputs optionalOutputs) {
        TimeStampValueType[] newXType1TimeStampList;
        TimeStampValueType[] newArchiveTimeStampList;
        NewArchiveTimeStampValues newArchiveTimeStampValues = optionalOutputs.getNewArchiveTimeStampValues();
        TimeStampValueType[] timeStampValueTypeArray = newArchiveTimeStampList = newArchiveTimeStampValues == null ? null : newArchiveTimeStampValues.getNewArchiveTimeStampValue();
        if (newArchiveTimeStampList != null && newArchiveTimeStampList.length > 0) {
            return newArchiveTimeStampList[0];
        }
        ArchiveTimeStampValues archiveTimeStampValues = optionalOutputs.getArchiveTimeStampValues();
        if (archiveTimeStampValues != null) {
            return archiveTimeStampValues.getArchiveTimeStampValue(0);
        }
        NewXType1TimeStampValues newXType1TimeStampValues = optionalOutputs.getNewXType1TimeStampValues();
        TimeStampValueType[] timeStampValueTypeArray2 = newXType1TimeStampList = newXType1TimeStampValues == null ? null : newXType1TimeStampValues.getNewXType1TimeStampValue();
        if (newXType1TimeStampList != null && newXType1TimeStampList.length > 0) {
            return newXType1TimeStampList[0];
        }
        XType1TimeStampValues xType1TimeStampValues = optionalOutputs.getXType1TimeStampValues();
        if (xType1TimeStampValues != null) {
            return xType1TimeStampValues.getXType1TimeStampValue(0);
        }
        TimeStampValues timeStampValues = optionalOutputs.getTimeStampValues();
        if (timeStampValues != null) {
            return timeStampValues.getTimeStampValue(0);
        }
        return null;
    }

    private TimeStampValueType getTimeStampValue(OptionalOutputs optionalOutputs) {
        if (optionalOutputs == null) {
            return null;
        }
        TimeStampValueType timestamp = null;
        if (optionalOutputs.getMultiSignatureResult() == null) {
            timestamp = this.getTimestamp(optionalOutputs);
        } else {
            SignatureResultType[] signatureResult;
            SignatureResultType[] signatureResultTypeArray = signatureResult = optionalOutputs.getMultiSignatureResult().getSignatureResult();
            int n = signatureResult.length;
            int n2 = 0;
            while (n2 < n) {
                SignatureResultType signatureResultType = signatureResultTypeArray[n2];
                timestamp = this.getTimestamp(signatureResultType.getOptionalOutputs());
                ++n2;
            }
        }
        return timestamp;
    }

    private void processOptionalOutputs(SignupdateResponse signupdateResponse, OptionalOutputs optionalOutputs) {
        signupdateResponse.setOptionalOutputs(optionalOutputs);
    }

    private String replaceAll(String cadena) {
        cadena = cadena.replaceAll("\u00e1", "a");
        cadena = cadena.replaceAll("\u00e9", "e");
        cadena = cadena.replaceAll("\u00ed", "i");
        cadena = cadena.replaceAll("\u00f3", "o");
        cadena = cadena.replaceAll("\u00fa", "u");
        cadena = cadena.replaceAll("\u00c1", "A");
        cadena = cadena.replaceAll("\u00c9", "E");
        cadena = cadena.replaceAll("\u00cd", "I");
        cadena = cadena.replaceAll("\u00d3", "O");
        cadena = cadena.replaceAll("\u00da", "U");
        return cadena;
    }

    private static enum SignatureType {
        CADES("urn:etsi:ts:101733"),
        CERTIFICATE("urn:safelayer:tws:dss:1.0:profiles:names:certificate"),
        CMS("urn:ietf:rfc:3369"),
        DEFAULT("urn:ietf:rfc:3369"),
        PADES_PART2("urn:etsi:ts:102778:part2"),
        PDF("urn:ietf:rfc:3369:pdf"),
        PADES_PART3("urn:etsi:ts:102778:part3"),
        PKCS1("urn:ietf:rfc:3447"),
        PKCS7("urn:ietf:rfc:2315"),
        SMIME2("urn:ietf:rfc:2315"),
        SMIME3("urn:ietf:rfc:3369"),
        SMIME3_ADES("urn:etsi:ts:101733"),
        XADES("urn:etsi:ts:101903"),
        XMLDSIG("urn:etsi:ts:3275");

        private String value = null;

        private SignatureType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

