/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.zain.client.axis;

import com.izenpe.zain.client.axis.Base64UnPackFilter;
import com.izenpe.zain.client.axis.TagInfo;
import com.izenpe.zain.client.axis.TxAxisClientException;
import com.izenpe.zain.client.axis.TxHttpTransport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.log4j.Logger;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class TxLoggerHandler
extends BasicHandler {
    private Transformer transformer;
    private XMLReader reader;
    private Random random;
    private Logger log = Logger.getLogger((String)TxLoggerHandler.class.getName());

    public TxLoggerHandler() throws Exception {
        long start = System.currentTimeMillis();
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        long end = System.currentTimeMillis();
        this.log.debug((Object)("Create SAX stuff :" + (end - start)));
        this.random = new Random();
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            this.options = this.getOptions();
            String active = (String)this.options.get("active");
            if (active == null || !"false".equals(active)) {
                Message msg = msgContext.getCurrentMessage();
                byte[] compactBytes = msg.getSOAPPartAsBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(compactBytes);
                Date d = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSS");
                StringBuffer nameBuffer = new StringBuffer();
                nameBuffer.append(sdf.format(d));
                nameBuffer.append("-");
                nameBuffer.append("WsLogger");
                this.name = nameBuffer.toString();
                String savePath = (String)this.options.get(TxHttpTransport.getParam("savePath", null));
                boolean overwrite = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("overwrite", null)));
                nameBuffer = new StringBuffer();
                if (savePath != null && savePath.length() > 0) {
                    File dir = new File(savePath);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    nameBuffer.append(savePath);
                    nameBuffer.append(File.separator);
                }
                nameBuffer.append(this.name);
                nameBuffer.append(".xml");
                File file = new File(nameBuffer.toString());
                if (file.canRead() && !overwrite) {
                    throw new TxAxisClientException("LogFileAlreadyExists");
                }
                FileOutputStream fos = new FileOutputStream(file);
                this.handleMessage(bais, fos, nameBuffer);
            }
        }
        catch (Exception ex) {
            throw new AxisFault("TxLoggerError", (Throwable)ex);
        }
    }

    private void handleMessage(InputStream input, OutputStream output, StringBuffer nameBuffer) throws Exception {
        long start = System.currentTimeMillis();
        Base64UnPackFilter filter = new Base64UnPackFilter(this.reader);
        String path = (String)this.options.get(TxHttpTransport.getParam("loadPath", null));
        filter.setLoadPath(path);
        String tags = (String)this.options.get(TxHttpTransport.getParam("tags", null));
        filter.setTags(this.genHashTableOfTags(tags));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        factory.setNamespaceAware(true);
        DOMSource sourcexml = new DOMSource(builder.parse(input));
        StreamResult resultxml = new StreamResult(new File(nameBuffer.toString()).getAbsolutePath());
        this.transformer.transform(sourcexml, resultxml);
        output.close();
        input.close();
        long end = System.currentTimeMillis();
        this.log.debug((Object)("TotalParseLog :" + (end - start)));
    }

    private Map genHashTableOfTags(String tags) throws Exception {
        HashMap<String, TagInfo> result = new HashMap<String, TagInfo>();
        String currentAsB64 = null;
        boolean asB64 = false;
        StringTokenizer tokenizer = new StringTokenizer(tags);
        while (tokenizer.hasMoreElements()) {
            String currentName = (String)tokenizer.nextElement();
            currentAsB64 = (String)this.options.get(TxHttpTransport.getParam("asBase64", currentName));
            if (currentAsB64 != null) {
                asB64 = JavaUtils.isTrue((String)currentAsB64);
            }
            TagInfo tag = new TagInfo();
            tag.setHandleAsBase64(asB64);
            result.put(currentName, tag);
        }
        return result;
    }
}

