/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.zain.client.axis;

import com.izenpe.zain.client.axis.Base64PackFilter;
import com.izenpe.zain.client.axis.Base64UnPackFilter;
import com.izenpe.zain.client.axis.SendSoapHttpStream;
import com.izenpe.zain.client.axis.TagInfo;
import com.izenpe.zain.client.axis.TxAxisClientException;
import com.izenpe.zain.client.axis.TxHttpTransport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.MimeHeaders;
import org.apache.axis.utils.JavaUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class TxHttpSender
extends BasicHandler {
    private final Transformer transformer;
    private final XMLReader reader;
    private final Logger log = Logger.getLogger((String)TxHttpSender.class.getName());

    public TxHttpSender() throws Exception {
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        Socket socket = null;
        try {
            this.options = this.getOptions();
            if (this.options == null) {
                SimpleTargetedChain transport = (SimpleTargetedChain)msgContext.getAxisEngine().getConfig().getTransport(new QName("", msgContext.getTransportName()));
                this.options = transport.getOptions();
            }
            Message msg = msgContext.getRequestMessage();
            String soapAction = msgContext.getSOAPActionURI();
            if (soapAction == null) {
                soapAction = "";
            }
            javax.xml.soap.MimeHeaders headersReceived = msg.getMimeHeaders();
            SendSoapHttpStream http = new SendSoapHttpStream();
            this.configureHttp(http, msgContext);
            http.init();
            socket = http.getSocket();
            HashMap<String, String> headersIn = new HashMap<String, String>();
            Iterator it = headersReceived.getAllHeaders();
            while (it.hasNext()) {
                MimeHeader currentHeader = (MimeHeader)it.next();
                headersIn.put(currentHeader.getName().toLowerCase(), currentHeader.getValue());
            }
            headersIn.put("SOAPAction".toLowerCase(), soapAction);
            OutputStream writeSocketStream = http.initChunkedTransfer(socket, headersIn, null, "POST");
            byte[] compactBytes = msg.getSOAPPartAsBytes();
            ByteArrayInputStream bais = new ByteArrayInputStream(compactBytes);
            this.handleRequest(bais, writeSocketStream);
            int httpStatus = SendSoapHttpStream.initProcessResponse(socket);
            if (!SendSoapHttpStream.isSuccesfulStatus(httpStatus) && !SendSoapHttpStream.isInternalErrorStatus(httpStatus)) {
                throw new TxAxisClientException("HttpResponseNotExpected");
            }
            HashMap responseHeaders = new HashMap();
            InputStream readSocketStream = SendSoapHttpStream.getTransferInputStream(socket, responseHeaders);
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            this.handleResponse(readSocketStream, fos);
            byte[] responseIn = fos.toByteArray();
            socket.close();
            MimeHeaders mimeResponse = new MimeHeaders();
            for (String currentHead : responseHeaders.keySet()) {
                mimeResponse.addHeader(currentHead, (String)responseHeaders.get(currentHead));
            }
            Message msgResponse = new Message((Object)responseIn, false, (javax.xml.soap.MimeHeaders)mimeResponse);
            msgResponse.setMessageType("response");
            msgContext.setResponseMessage(msgResponse);
        }
        catch (Exception ex) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AxisFault("TxHttpSenderError", (Throwable)ex);
        }
    }

    private void configureHttp(SendSoapHttpStream http, MessageContext msgContext) throws Exception {
        String targetURL = msgContext.getStrProp("transport.url");
        http.setUrl(targetURL);
        int timeout = msgContext.getTimeout();
        String timeoutStr = (String)this.options.get(TxHttpTransport.getParam("Timeout", null));
        if (timeoutStr != null) {
            timeout = Integer.parseInt(timeoutStr);
        }
        http.setTimeout(timeout);
        boolean useTrust = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("active", "Truststore")));
        http.setUseTrustStore(useTrust);
        String path = (String)this.options.get(TxHttpTransport.getParam("path", "Truststore"));
        String pwd = (String)this.options.get(TxHttpTransport.getParam("password", "Truststore"));
        http.setTrustPath(path);
        http.setTrustPwd(pwd);
        boolean useKey = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("active", "Keystore")));
        http.setUseKeystore(useKey);
        String pathKey = (String)this.options.get(TxHttpTransport.getParam("path", "Keystore"));
        String pwdKey = (String)this.options.get(TxHttpTransport.getParam("password", "Keystore"));
        String typeKey = (String)this.options.get(TxHttpTransport.getParam("type", "Keystore"));
        http.setKeyPath(pathKey);
        http.setKeyPwd(pwdKey);
        http.setKeyType(typeKey);
        boolean useProxy = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("active", "Proxy")));
        http.setProxy(useProxy);
        String host = (String)this.options.get(TxHttpTransport.getParam("host", "Proxy"));
        String port = (String)this.options.get(TxHttpTransport.getParam("port", "Proxy"));
        String proxyUser = (String)this.options.get(TxHttpTransport.getParam("username", "Proxy"));
        String proxyPwd = (String)this.options.get(TxHttpTransport.getParam("password", "Proxy"));
        http.setProxyHost(host);
        http.setProxyPort(port);
        if (proxyUser != null && proxyPwd != null) {
            http.setProxyUserInfo(String.valueOf(proxyUser) + ":" + proxyPwd);
        }
        boolean allowCriticalExts = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("allowCriticalExts", "Ssl")));
        http.setAllowCriticalExtensions(allowCriticalExts);
        boolean useNoValidation = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("noValidation", "Ssl")));
        http.setUseNoValidation(useNoValidation);
        String algorithm = (String)this.options.get(TxHttpTransport.getParam("validation", "Ssl"));
        http.setValidationAlg(algorithm);
    }

    private Map genHashTableOfTags(String tags, boolean isRequest) throws Exception {
        HashMap<String, TagInfo> result = new HashMap<String, TagInfo>();
        String currentAsB64 = null;
        boolean asB64 = false;
        StringTokenizer tokenizer = new StringTokenizer(tags);
        while (tokenizer.hasMoreElements()) {
            String currentName = (String)tokenizer.nextElement();
            currentAsB64 = isRequest ? (String)this.options.get(TxHttpTransport.getReqParam("asBase64", currentName)) : (String)this.options.get(TxHttpTransport.getRespParam("asBase64", currentName));
            if (currentAsB64 != null) {
                asB64 = JavaUtils.isTrue((String)currentAsB64);
            }
            TagInfo tag = new TagInfo();
            tag.setHandleAsBase64(asB64);
            result.put(currentName, tag);
        }
        return result;
    }

    private void handleRequest(InputStream input, OutputStream output) throws Exception {
        long start = System.currentTimeMillis();
        Base64UnPackFilter filter = new Base64UnPackFilter(this.reader);
        String path = (String)this.options.get(TxHttpTransport.getReqParam("loadPath", null));
        filter.setLoadPath(path);
        String tags = (String)this.options.get(TxHttpTransport.getReqParam("tags", null));
        filter.setTags(this.genHashTableOfTags(tags, true));
        SAXSource source = new SAXSource(filter, new InputSource(input));
        this.transformer.transform(source, new StreamResult(output));
        output.close();
        input.close();
        long end = System.currentTimeMillis();
        this.log.debug((Object)("TotalParseReq :" + (end - start)));
    }

    private void handleResponse(InputStream input, OutputStream output) throws Exception {
        long start = System.currentTimeMillis();
        Base64PackFilter filter = new Base64PackFilter(this.reader);
        String path = (String)this.options.get(TxHttpTransport.getRespParam("savePath", null));
        filter.setSavePath(path);
        String tags = (String)this.options.get(TxHttpTransport.getRespParam("tags", null));
        filter.setTags(this.genHashTableOfTags(tags, false));
        boolean useRandom = JavaUtils.isTrue(this.options.get(TxHttpTransport.getRespParam("useRandomId", null)));
        filter.setUseRandomId(useRandom);
        filter.setAtrReqId("RequestID");
        boolean overwrite = JavaUtils.isTrue(this.options.get(TxHttpTransport.getRespParam("overwrite", null)));
        filter.setOverwrite(overwrite);
        SAXSource source = new SAXSource(filter, new InputSource(input));
        this.transformer.transform(source, new StreamResult(output));
        output.close();
        input.close();
        long end = System.currentTimeMillis();
        this.log.debug((Object)("TotalParseResponse :" + (end - start)));
    }
}

