/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.zain.client.axis;

import com.izenpe.zain.client.axis.SendSoapHttp;
import com.izenpe.zain.client.axis.TxAxisClientException;
import com.safelayer.trustedx.jsse.TxNoValidateTrustManagerFactory;
import com.safelayer.trustedx.jsse.TxX509TrustManagerFactory;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.StatusLine;

public final class SendSoapHttpStream
extends SendSoapHttp {
    private static final int HTTP_SC_INTERNAL_SERVER_ERROR = 500;
    private static final int HTTP_SC_OK = 200;
    private boolean allowCriticalExtensions;
    private boolean useNoValidation;

    public OutputStream initChunkedTransfer(Socket socket, Map headersIn, Map params, String method) throws Exception {
        headersIn.put(HTTPConstants.HEADER_TRANSFER_ENCODING, HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED);
        headersIn.put("Host", String.valueOf(this.getHost()) + ":" + Integer.toString(this.getPort()));
        StringBuffer header = this.generateHttpHeaderRequest(headersIn, params, null, "HTTP/1.1", method);
        OutputStream rawOut = socket.getOutputStream();
        rawOut.write(header.toString().getBytes());
        return new ChunkedOutputStream(rawOut, 16384);
    }

    public OutputStream initTransfer(Socket socket, Map headersIn, Map params, int size, String method) throws Exception {
        StringBuffer header = this.generateHttpHeaderRequest(headersIn, params, Integer.toString(size), "HTTP/1.0", method);
        DataOutputStream rawOut = new DataOutputStream(socket.getOutputStream());
        ((OutputStream)rawOut).write(header.toString().getBytes());
        return rawOut;
    }

    public OutputStream initTransfer(Socket socket, Map headersIn, Map params, String method) throws Exception {
        StringBuffer header = this.generateHttpHeaderRequest(headersIn, params, null, "HTTP/1.1", method);
        OutputStream rawOut = socket.getOutputStream();
        rawOut.write(header.toString().getBytes());
        return rawOut;
    }

    public static int initProcessResponse(Socket socket) throws Exception {
        InputStream in = socket.getInputStream();
        String s = HttpParser.readLine((InputStream)in, (String)"iso-8859-1");
        if (s != null) {
            StatusLine statusLine = new StatusLine(s);
            return statusLine.getStatusCode();
        }
        throw new TxAxisClientException("HttpConnectionError");
    }

    public static InputStream getTransferInputStream(Socket socket, Map response) throws Exception {
        HeaderElement[] encodings;
        int len;
        InputStream in = socket.getInputStream();
        Header[] headers = HttpParser.parseHeaders((InputStream)in, (String)"iso-8859-1");
        Header transfer = null;
        int i = 0;
        while (i < headers.length) {
            response.put(headers[i].getName(), headers[i].getValue());
            if (headers[i].getName().equals(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                transfer = headers[i];
            }
            ++i;
        }
        InputStream inParsed = in;
        if (transfer != null && (len = (encodings = transfer.getElements()).length) > 0 && HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equalsIgnoreCase(encodings[len - 1].getName())) {
            inParsed = new ChunkedInputStream(in);
        }
        return inParsed;
    }

    public static boolean isSuccesfulStatus(int status) {
        boolean result = status == 200;
        return result;
    }

    public static boolean isInternalErrorStatus(int status) {
        return status == 500;
    }

    public void setAllowCriticalExtensions(boolean allowCriticalExtensions) {
        this.allowCriticalExtensions = allowCriticalExtensions;
    }

    public void setUseNoValidation(boolean useNoValidation) {
        this.useNoValidation = useNoValidation;
    }

    @Override
    public void initSslContext() throws Exception {
        if (this.useNoValidation) {
            super.initSslContext((TrustManagerFactory)new TxNoValidateTrustManagerFactory(), null);
        } else if (this.allowCriticalExtensions) {
            super.initSslContext((TrustManagerFactory)new TxX509TrustManagerFactory(), null);
        } else {
            super.initSslContext();
        }
    }
}

