/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.axis;

import com.izenpe.zain.client.ZainConfig;
import com.safelayer.trustedx.client.axis.Base64UnPackFilter;
import com.safelayer.trustedx.client.axis.TagInfo;
import com.safelayer.trustedx.client.axis.TxAxisClientException;
import com.safelayer.trustedx.client.axis.TxHttpTransport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.types.HexBinary;
import org.apache.axis.utils.JavaUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TxLoggerHandler
extends BasicHandler {
    private static final long serialVersionUID = -7152624524993220762L;
    private final Transformer transformer;
    private final XMLReader reader;
    private final Random random;
    private final Logger log = Logger.getLogger((String)TxLoggerHandler.class.getName());

    public TxLoggerHandler() throws Exception {
        long start = System.currentTimeMillis();
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        long end = System.currentTimeMillis();
        this.log.debug((Object)("Create SAX stuff :" + (end - start)));
        this.random = new Random();
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            boolean active = false;
            String savePath = null;
            ZainConfig config = ZainConfig.getCurrent();
            if (config != null) {
                if (!msgContext.getPastPivot()) {
                    active = config.isRequestLogActive();
                    savePath = config.getRequestLogSavePath();
                } else {
                    active = config.isResponseLogActive();
                    savePath = config.getResponseLogSavePath();
                    ZainConfig.removeCurrent();
                }
            } else {
                this.options = this.getOptions();
                String activeStr = (String)this.options.get("active");
                active = activeStr == null || !"false".equals(activeStr);
                savePath = (String)this.options.get(TxHttpTransport.getParam("savePath", null));
            }
            if (active) {
                String suffix;
                Message msg;
                if (!msgContext.getPastPivot()) {
                    msg = msgContext.getRequestMessage();
                    suffix = "req";
                } else {
                    msg = msgContext.getResponseMessage();
                    suffix = "res";
                }
                byte[] compactBytes = msg.getSOAPPartAsBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(compactBytes);
                byte[] randBytes = new byte[10];
                this.random.nextBytes(randBytes);
                String valueReqId = HexBinary.encode((byte[])randBytes);
                StringBuffer nameBuffer = new StringBuffer();
                nameBuffer.append(valueReqId);
                nameBuffer.append("-");
                nameBuffer.append(suffix);
                this.name = nameBuffer.toString();
                boolean overwrite = JavaUtils.isTrue(this.options.get(TxHttpTransport.getParam("overwrite", null)));
                nameBuffer = new StringBuffer();
                if (savePath != null && savePath.length() > 0) {
                    nameBuffer.append(savePath);
                    nameBuffer.append(File.separator);
                }
                nameBuffer.append(this.name);
                nameBuffer.append(".xml");
                File file = new File(nameBuffer.toString());
                if (file.canRead() && !overwrite) {
                    throw new TxAxisClientException("LogFileAlreadyExists");
                }
                FileOutputStream fos = new FileOutputStream(file);
                this.handleMessage(bais, fos);
            }
        }
        catch (Exception ex) {
            ZainConfig.removeCurrent();
            throw new AxisFault("TxLoggerError", (Throwable)ex);
        }
    }

    protected void handleMessage(InputStream input, OutputStream output) throws Exception {
        long start = System.currentTimeMillis();
        Base64UnPackFilter filter = new Base64UnPackFilter(this.reader);
        String path = (String)this.options.get(TxHttpTransport.getParam("loadPath", null));
        filter.setLoadPath(path);
        String tags = (String)this.options.get(TxHttpTransport.getParam("tags", null));
        filter.setTags(this.genHashTableOfTags(tags));
        SAXSource source = new SAXSource(filter, new InputSource(input));
        this.transformer.transform(source, new StreamResult(output));
        output.close();
        input.close();
        long end = System.currentTimeMillis();
        this.log.debug((Object)("TotalParseLog :" + (end - start)));
    }

    protected Hashtable genHashTableOfTags(String tags) throws Exception {
        Hashtable<String, TagInfo> result = new Hashtable<String, TagInfo>();
        String currentAsB64 = null;
        boolean asB64 = false;
        StringTokenizer tokenizer = new StringTokenizer(tags);
        while (tokenizer.hasMoreElements()) {
            String currentName = (String)tokenizer.nextElement();
            currentAsB64 = (String)this.options.get(TxHttpTransport.getParam("asBase64", currentName));
            if (currentAsB64 != null) {
                asB64 = JavaUtils.isTrue((String)currentAsB64);
            }
            TagInfo tag = new TagInfo();
            tag.setHandleAsBase64(asB64);
            result.put(currentName, tag);
        }
        return result;
    }
}

