/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.axis;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis.encoding.Base64;

public class SendSoapHttp {
    protected static final String HEADER_CONTENT_LENGHT = "Content-Length";
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    protected static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";
    protected static final String HEADER_CONNECTION = "Connection";
    protected boolean useKeystore;
    protected boolean useTrustStore;
    protected boolean proxy;
    protected boolean useNoCheckNames;
    protected int timeout = 0;
    protected int port;
    protected String keyType;
    protected String keyPath;
    protected String keyPwd;
    protected String trustPath;
    protected String trustPwd;
    protected String proxyHost;
    protected String proxyPort;
    protected String proxyUserInfo;
    protected String urlStr;
    protected String pathStr;
    protected String host;
    protected String userInfo;
    protected String validationAlg;
    protected Hashtable queryParams;
    protected SSLContext sslContext;
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    protected void configureSSL() {
        if (this.useTrustStore) {
            System.setProperty("javax.net.ssl.trustStore", this.trustPath);
            System.setProperty("javax.net.ssl.trustStorePassword", this.trustPwd);
            System.setProperty("javax.net.debug", "all");
        }
    }

    protected void configureProxy() {
        if (this.proxy) {
            String[] parts;
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", this.proxyPort);
            if (this.proxyUserInfo != null && this.proxyUserInfo.length() > 0) {
                parts = this.proxyUserInfo.split(":");
                System.setProperty("http.proxyUser", parts[0]);
                System.setProperty("http.proxyPassword", parts[1]);
            }
            if (this.useTrustStore) {
                System.setProperty("https.proxyHost", this.proxyHost);
                System.setProperty("https.proxyPort", this.proxyPort);
                if (this.proxyUserInfo != null && this.proxyUserInfo.length() > 0) {
                    parts = this.proxyUserInfo.split(":");
                    System.setProperty("https.proxyUser", parts[0]);
                    System.setProperty("https.proxyPassword", parts[1]);
                }
            }
        }
    }

    public byte[] postJDK(byte[] b) throws Exception {
        int bytesRead;
        HttpURLConnection httpConn;
        this.configureProxy();
        this.configureSSL();
        URL url = new URL(this.urlStr);
        URLConnection conn = url.openConnection();
        conn.setRequestProperty(HEADER_CONTENT_LENGHT, String.valueOf(b.length));
        conn.setRequestProperty(HEADER_CONTENT_TYPE, "text/xml; charset=utf-8");
        conn.setRequestProperty(HEADER_CONNECTION, "Keep-Alive");
        if (this.urlStr.startsWith("https")) {
            SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            if (this.useNoCheckNames) {
                httpsConn.setHostnameVerifier(DO_NOT_VERIFY);
            }
            httpsConn.setSSLSocketFactory(sslsocketfactory);
            httpConn = httpsConn;
        } else {
            httpConn = (HttpURLConnection)conn;
        }
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        OutputStream out = httpConn.getOutputStream();
        out.write(b);
        out.close();
        ByteArrayOutputStream aux = new ByteArrayOutputStream();
        int code = httpConn.getResponseCode();
        InputStream in = code < 300 ? httpConn.getInputStream() : httpConn.getErrorStream();
        byte[] buffer = new byte[16384];
        while ((bytesRead = in.read(buffer)) != -1) {
            aux.write(buffer, 0, bytesRead);
        }
        httpConn.disconnect();
        byte[] received = aux.toByteArray();
        if (received != null) {
            return received;
        }
        throw new Exception("Empty response");
    }

    public void forceInit() throws Exception {
        this.sslContext = null;
        this.host = null;
        this.init();
    }

    public void init() throws Exception {
        this.initSslContext();
        if (this.host == null) {
            this.parseUrl();
        }
    }

    protected void initSslContext(TrustManagerFactory tmf, KeyManagerFactory kmf) throws Exception {
        TrustManagerFactory tsFactory = tmf;
        KeyManagerFactory kmFactory = kmf;
        if (this.sslContext == null) {
            KeyStore ks;
            if (this.useTrustStore) {
                if (tsFactory == null) {
                    String algorithm = TrustManagerFactory.getDefaultAlgorithm();
                    if (this.validationAlg != null && this.validationAlg.length() > 0) {
                        algorithm = this.validationAlg;
                    }
                    tsFactory = TrustManagerFactory.getInstance(algorithm);
                }
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(new FileInputStream(this.trustPath), this.trustPwd.toCharArray());
                tsFactory.init(ks);
            }
            if (this.useKeystore) {
                if (kmFactory == null) {
                    kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                }
                ks = this.keyType != null ? KeyStore.getInstance(this.keyType) : KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(new FileInputStream(this.keyPath), this.keyPwd.toCharArray());
                kmFactory.init(ks, this.keyPwd.toCharArray());
            }
            if (tsFactory != null || kmFactory != null) {
                this.sslContext = SSLContext.getInstance("TLS");
                TrustManager[] tms = tsFactory != null ? tsFactory.getTrustManagers() : null;
                this.sslContext.init(kmFactory != null ? kmFactory.getKeyManagers() : null, tms, null);
            }
        }
    }

    protected void initSslContext() throws Exception {
        this.initSslContext(null, null);
    }

    public Socket getSocket() throws Exception {
        Socket socket;
        if (this.urlStr.startsWith("https")) {
            SSLSocketFactory sslsocketfactory = this.sslContext != null ? this.sslContext.getSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
            if (this.proxy) {
                Socket tunnel = new Socket(this.proxyHost, Integer.parseInt(this.proxyPort));
                this.doTunnelHandshake(tunnel, this.host, this.port);
                socket = sslsocketfactory.createSocket(tunnel, this.host, this.port, false);
            } else {
                socket = sslsocketfactory.createSocket(this.host, this.port);
            }
        } else {
            socket = this.proxy ? new Socket(this.proxyHost, Integer.parseInt(this.proxyPort)) : new Socket(this.host, this.port);
        }
        if (this.timeout != 0) {
            socket.setSoTimeout(this.timeout);
        }
        return socket;
    }

    protected void parseUrl() throws Exception {
        URL url = new URL(this.urlStr);
        StringBuffer sb = new StringBuffer();
        this.host = url.getHost();
        this.port = url.getPort();
        String protocol = url.getProtocol();
        sb.append(protocol);
        sb.append("://");
        sb.append(this.host);
        if (this.port == -1) {
            if (protocol.equals("http")) {
                this.port = 80;
            } else if (protocol.equals("https")) {
                this.port = 443;
            }
        }
        sb.append(":");
        sb.append(this.port);
        this.pathStr = url.getPath();
        sb.append(this.pathStr);
        String userInfoUrl = url.getUserInfo();
        String string = this.userInfo = this.userInfo == null ? userInfoUrl : this.userInfo;
        if (this.pathStr.length() == 0) {
            this.pathStr = "/";
        } else {
            String queries = url.getQuery();
            if (queries != null) {
                this.queryParams = new Hashtable();
                StringTokenizer stok = new StringTokenizer(queries, "&");
                while (stok.hasMoreTokens()) {
                    String param = stok.nextToken();
                    String[] parts = param.split("=");
                    if (parts != null && parts.length == 2) {
                        this.queryParams.put(URLEncoder.encode(parts[0], "UTF-8"), URLEncoder.encode(parts[1], "UTF-8"));
                        continue;
                    }
                    sb.append(param);
                }
            }
        }
        this.urlStr = sb.toString();
    }

    protected void doTunnelHandshake(Socket tunnel, String host, int port) throws Exception {
        String replyStr;
        OutputStream out = tunnel.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out, "US-ASCII");
        writer.write("CONNECT ");
        writer.write(host);
        writer.write(":");
        writer.write(Integer.toString(port));
        writer.write(" HTTP/1.0\r\n");
        writer.write("User-Agent: JavaHTTPClient\r\n");
        if (this.proxyUserInfo != null && this.proxyUserInfo.length() > 0 && this.proxy) {
            writer.write("Proxy-Authorization: Basic " + this.internalBase64Encode(this.proxyUserInfo) + "\r\n");
        }
        writer.write("\r\n");
        writer.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (replyStr.toLowerCase().indexOf("200 connection established") == -1) {
            throw new IOException("Unable to tunnel through proxy.  Proxy returns \"" + replyStr + "\"");
        }
    }

    private String internalBase64Encode(String content) throws Exception {
        String result = Base64.encode((byte[])content.getBytes("US-ASCII"));
        return result;
    }

    protected void appendHeader(String name, String value, String length, StringBuffer headers) {
        if (name.compareToIgnoreCase(HEADER_CONTENT_LENGHT) == 0) {
            if (length == null) {
                headers.append(name + ": " + value + "\r\n");
            }
        } else if (name.compareToIgnoreCase(HEADER_AUTHORIZATION) == 0) {
            if (this.userInfo == null || this.userInfo.length() == 0) {
                headers.append(name + ": " + value + "\r\n");
            }
        } else if (name.compareToIgnoreCase(HEADER_PROXY_AUTHORIZATION) == 0) {
            if (this.proxyUserInfo == null || this.proxyUserInfo.length() == 0) {
                headers.append(name + ": " + value + "\r\n");
            }
        } else {
            headers.append(name + ": " + value + "\r\n");
        }
    }

    protected StringBuffer generateHttpHeaderRequest(Hashtable headersIn, Hashtable params, String length, String httpVersion, String method) throws Exception {
        Enumeration enumHead;
        String name = null;
        boolean contentType = false;
        boolean connection = false;
        StringBuffer urlWithParams = this.proxy ? new StringBuffer(this.urlStr) : new StringBuffer(this.pathStr);
        if (this.queryParams != null) {
            if (params == null) {
                params = new Hashtable();
            }
            params.putAll(this.queryParams);
        }
        if (params != null) {
            enumHead = params.keys();
            if (enumHead.hasMoreElements()) {
                urlWithParams.append("?");
            }
            while (enumHead.hasMoreElements()) {
                if (name != null) {
                    urlWithParams.append("&");
                }
                name = (String)enumHead.nextElement();
                String value = (String)params.get(name);
                urlWithParams.append(URLEncoder.encode(name, "UTF-8"));
                urlWithParams.append("=");
                urlWithParams.append(URLEncoder.encode(value, "UTF-8"));
            }
        }
        StringBuffer headersStr = new StringBuffer();
        headersStr.append(method);
        headersStr.append(" ");
        headersStr.append(urlWithParams.toString());
        headersStr.append(" ");
        headersStr.append(httpVersion);
        headersStr.append("\r\n");
        if (headersIn != null) {
            enumHead = headersIn.keys();
            while (enumHead.hasMoreElements()) {
                name = (String)enumHead.nextElement();
                if (name.compareToIgnoreCase(HEADER_CONTENT_TYPE) == 0) {
                    contentType = true;
                } else if (name.compareToIgnoreCase(HEADER_CONNECTION) == 0) {
                    connection = true;
                }
                this.appendHeader(name, (String)headersIn.get(name), length, headersStr);
            }
        }
        if (!contentType) {
            headersStr.append("Content-Type: text/xml; charset=utf-8\r\n");
        }
        if (!connection) {
            headersStr.append("Connection: close\r\n");
        }
        if (length != null) {
            headersStr.append("Content-Length: " + length + "\r\n");
        }
        if (this.userInfo != null && this.userInfo.length() > 0) {
            headersStr.append("Authorization: Basic " + this.internalBase64Encode(this.userInfo) + "\r\n");
        }
        if (this.proxyUserInfo != null && this.proxyUserInfo.length() > 0 && this.proxy) {
            headersStr.append("Proxy-Authorization: Basic " + this.internalBase64Encode(this.proxyUserInfo) + "\r\n");
        }
        headersStr.append("\r\n");
        return headersStr;
    }

    protected StringBuffer generatePostHeaderRequest(Hashtable headersIn, String length, String httpVersion) throws Exception {
        return this.generateHttpHeaderRequest(headersIn, null, length, httpVersion, "POST");
    }

    protected StringBuffer generatePostHeaderRequest(Hashtable headersIn, Hashtable params, String length, String httpVersion) throws Exception {
        return this.generateHttpHeaderRequest(headersIn, params, length, httpVersion, "POST");
    }

    protected StringBuffer generateGetHeaderRequest(Hashtable headersIn, Hashtable params, String length, String httpVersion) throws Exception {
        return this.generateHttpHeaderRequest(headersIn, params, null, httpVersion, "GET");
    }

    protected byte[] processHTTPResponse(byte[] httpResponse) {
        byte[] toReturn = null;
        for (int i = 0; i < httpResponse.length && toReturn == null; ++i) {
            if (httpResponse[i] != 13 || httpResponse[i + 1] != 10 || httpResponse[i + 2] != 13 || httpResponse[i + 3] != 10) continue;
            ByteArrayOutputStream allData = new ByteArrayOutputStream();
            allData.write(httpResponse, i + 4, httpResponse.length - i - 4);
            toReturn = allData.toByteArray();
        }
        return toReturn;
    }

    protected byte[] sendHttpSocket(byte[] header, byte[] inputContent) throws Exception {
        int bytesRead;
        Socket socket = this.getSocket();
        DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
        DataInputStream din = new DataInputStream(socket.getInputStream());
        dos.write(header);
        if (inputContent != null && inputContent.length > 0) {
            dos.write(inputContent);
        }
        ByteArrayOutputStream aux = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        while ((bytesRead = din.read(buffer)) != -1) {
            aux.write(buffer, 0, bytesRead);
        }
        byte[] received = aux.toByteArray();
        dos.close();
        din.close();
        socket.close();
        if (received == null) {
            throw new Exception("EmptyBodyResponse");
        }
        return received;
    }

    protected byte[] sendHttpSocket(byte[] inputHttp) throws Exception {
        return this.sendHttpSocket(inputHttp, null);
    }

    public byte[] postSocket(byte[] data, Hashtable headersIn, Hashtable params) throws Exception {
        this.init();
        StringBuffer headersBuffer = this.generatePostHeaderRequest(headersIn, params, String.valueOf(data.length), "HTTP/1.0");
        byte[] header = headersBuffer.toString().getBytes("US-ASCII");
        return this.processHTTPResponse(this.sendHttpSocket(header, data));
    }

    public byte[] postSocket(byte[] data, Hashtable headersIn) throws Exception {
        return this.postSocket(data, headersIn, null);
    }

    public byte[] post(byte[] data) throws Exception {
        return this.postSocket(data, null);
    }

    public byte[] get(Hashtable headersIn, Hashtable params) throws Exception {
        this.init();
        StringBuffer headersBuffer = this.generateGetHeaderRequest(headersIn, params, null, "HTTP/1.0");
        byte[] header = headersBuffer.toString().getBytes("US-ASCII");
        return this.processHTTPResponse(this.sendHttpSocket(header));
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUserInfo(String proxyUserInfo) {
        this.proxyUserInfo = proxyUserInfo;
    }

    public void setUrl(String url) {
        this.urlStr = url;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public void setKeyPwd(String keyPwd) {
        this.keyPwd = keyPwd;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setTrustPath(String trustPath) {
        this.trustPath = trustPath;
    }

    public void setTrustPwd(String trustPwd) {
        this.trustPwd = trustPwd;
    }

    public void setUseKeystore(boolean useKeystore) {
        this.useKeystore = useKeystore;
    }

    public void setUseTrustStore(boolean useTrustStore) {
        this.useTrustStore = useTrustStore;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setUseNoCheckNames(boolean useNoCheckNames) {
        this.useNoCheckNames = useNoCheckNames;
    }

    public void setValidationAlg(String validationAlg) {
        this.validationAlg = validationAlg;
    }
}

